/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore.loaders;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;

public class PropertiesLoader_0 {
    public static Properties load(InputStream in, String encoding) throws IOException {
        Properties props = new Properties();
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(in), encoding);
        ParseState state = ParseState.LINE_START;
        StringBuffer key = new StringBuffer();
        StringBuffer value = new StringBuffer();
        while (true) {
            int read;
            if ((read = ((Reader)reader).read()) == -1) {
                switch (state) {
                    case PROPERTY_VALUE: {
                        props.setProperty(key.toString(), value.toString());
                    }
                }
                break;
            }
            char c = (char)read;
            switch (state) {
                case LINE_START: {
                    if (c == '#') {
                        state = ParseState.COMMENT;
                        break;
                    }
                    if (PropertiesLoader_0.isWS(c) || c == '\r') {
                        state = ParseState.LINE_START;
                        break;
                    }
                    if (!PropertiesLoader_0.isKeyChar(c)) break;
                    key.append(c);
                    state = ParseState.PROPERTY_KEY;
                    break;
                }
                case PROPERTY_KEY: {
                    if (PropertiesLoader_0.isKeyChar(c)) {
                        key.append(c);
                        break;
                    }
                    if (PropertiesLoader_0.isWS(c)) {
                        state = ParseState.PROPERTY_KEY_SPACE;
                        break;
                    }
                    if (c != '=') break;
                    state = ParseState.PROPERTY_VALUE;
                    break;
                }
                case PROPERTY_KEY_SPACE: {
                    if (PropertiesLoader_0.isWS(c) || c != '=') break;
                    state = ParseState.PROPERTY_ASSIGNMENT;
                    break;
                }
                case PROPERTY_ASSIGNMENT: {
                    if (PropertiesLoader_0.isWS(c)) break;
                    if (c == '\n' || c == '\r') {
                        props.setProperty(key.toString(), value.toString());
                        key = new StringBuffer();
                        value = new StringBuffer();
                        state = ParseState.LINE_START;
                        break;
                    }
                    if (PropertiesLoader_0.isEscapeChar(c)) {
                        state = ParseState.PROPERTY_VALUE_ESCAPE;
                        break;
                    }
                    if (!PropertiesLoader_0.isPropertyValue(c)) break;
                    value.append(c);
                    state = ParseState.PROPERTY_VALUE;
                    break;
                }
                case PROPERTY_VALUE: {
                    if (PropertiesLoader_0.isEscape(c)) {
                        state = ParseState.PROPERTY_VALUE_ESCAPE;
                        break;
                    }
                    if (PropertiesLoader_0.isPropertyValue(c)) {
                        value.append(c);
                        break;
                    }
                    if (c != '\n' && c != '\r') break;
                    props.setProperty(key.toString(), value.toString());
                    key = new StringBuffer();
                    value = new StringBuffer();
                    state = ParseState.LINE_START;
                    break;
                }
                case PROPERTY_VALUE_ESCAPE: {
                    if (c == 'n') {
                        value.append('\n');
                        state = ParseState.PROPERTY_VALUE;
                        break;
                    }
                    if (c == 't') {
                        value.append('\t');
                        state = ParseState.PROPERTY_VALUE;
                        break;
                    }
                    if (c == '\n') {
                        state = ParseState.PROPERTY_ASSIGNMENT;
                        break;
                    }
                    if (c == '\r') {
                        state = ParseState.PROPERTY_VALUE_ESCAPE_CRLF;
                        break;
                    }
                    value.append(c);
                    state = ParseState.PROPERTY_VALUE;
                    break;
                }
                case PROPERTY_VALUE_ESCAPE_CRLF: {
                    if (c != '\n') break;
                    state = ParseState.PROPERTY_ASSIGNMENT;
                    break;
                }
                case COMMENT: {
                    if (c == '\r') {
                        state = ParseState.LINE_START;
                        break;
                    }
                    if (c != '\n') break;
                    state = ParseState.LINE_START;
                }
            }
        }
        return props;
    }

    static boolean isWS(char c) {
        return c == ' ' || c == '\t';
    }

    static boolean isKeyChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '.' || c == '-' || c == '_';
    }

    static boolean isEscapeChar(char c) {
        return c == '\\';
    }

    static boolean isPropertyValue(char c) {
        return c != '\r' && c != '\f' && c != '\n';
    }

    static boolean isEscape(char c) {
        return c == '\\';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ParseState {
        LINE_START,
        COMMENT,
        PROPERTY_KEY,
        PROPERTY_ASSIGNMENT,
        PROPERTY_VALUE,
        COMMENT_NEWLINE,
        PROPERTY_VALUE_NEWLINE,
        PROPERTY_VALUE_ESCAPE,
        PROPERTY_KEY_SPACE,
        PROPERTY_VALUE_ESCAPE_CRLF;

    }
}

