/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.utils.StringMatcher;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IgnoreRule
implements IIgnoreProvider.IIgnoreRule {
    protected final StringMatcher matcher;
    protected final IShareable file;
    protected final DefaultIgnoreProvider provider;
    private List<IShareable> matched = null;

    public IgnoreRule(IShareable file, DefaultIgnoreProvider provider, String pattern, boolean ignorecase, boolean ignoreWildCards) {
        this.file = file;
        this.provider = provider;
        this.matcher = new StringMatcher(pattern, ignorecase, ignoreWildCards);
    }

    public StringMatcher getMatcher() {
        return this.matcher;
    }

    public abstract boolean isGlobal();

    public boolean isLocal() {
        return !this.isGlobal();
    }

    public IShareable getFile() {
        return this.file;
    }

    public IShareable getRootShareable() {
        return ((Shareable)this.file).getParent();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IgnoreRule) {
            IgnoreRule other = (IgnoreRule)obj;
            return this.matcher.getPattern().equals(other.getMatcher().getPattern()) && this.getFile().equals(other.getFile()) && this.isGlobal() == other.isGlobal();
        }
        return false;
    }

    public int hashCode() {
        return this.matcher.getPattern().hashCode() ^ this.getFile().hashCode();
    }

    public boolean shouldBeIgnored(IPath path) {
        String filename = path.lastSegment();
        return this.matcher.match(filename);
    }

    public synchronized void forceMatched(List<IShareable> matched) {
        Assert.isTrue((boolean)this.isTrivial(), (String)"We don't currently support saving matches of patterns with wildcards");
        if (this.matched != null) {
            throw new IllegalStateException("Match list may only be set once");
        }
        this.matched = matched;
    }

    @Override
    public boolean shouldBeIgnored(IShareable shareable) {
        return this.shouldBeIgnored(shareable.getLocalFullPath());
    }

    @Override
    public abstract boolean isEffectiveBelow(IShareable var1);

    @Override
    public List<IShareable> getEffectiveFrom() {
        return Collections.singletonList(this.getRootShareable());
    }

    @Override
    public IIgnoreProvider getProvider() {
        return this.provider;
    }

    public abstract boolean isTrivial();

    public String toString() {
        return String.valueOf(this.isGlobal() ? "GLOBAL" : "LOCAL") + ":/" + this.matcher.getPattern() + "/";
    }
}

