/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.ignore.GlobalIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IDefaultIgnoreProviderEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.utils.IgnoreUtils;
import com.ibm.team.repository.client.util.IEventSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IgnoreEvent
implements IDefaultIgnoreProviderEvent {
    private final IShareable ignoreFile;
    private final String type;
    protected Collection<IShareable> changed;
    private final IIgnoreManager source;
    private final List<Object> categories;
    protected List<IShareable> roots;
    private Collection<? extends IIgnoreProvider.IIgnoreRule> rules;

    public IgnoreEvent(IIgnoreManager source, IShareable ignoreFile, List<IShareable> roots, String type, List categories, Collection<? extends IIgnoreProvider.IIgnoreRule> rules) {
        this.source = source;
        this.ignoreFile = ignoreFile;
        this.roots = roots;
        this.type = type;
        if (categories.contains(type)) {
            this.categories = categories;
        } else {
            this.categories = new ArrayList<Object>(categories.size() + 1);
            this.categories.add(type);
            this.categories.addAll(categories);
        }
        this.rules = rules;
    }

    @Override
    public String getChangeType() {
        return this.type;
    }

    @Override
    public abstract boolean isEffectiveBelow(IShareable var1);

    @Override
    public Collection<IShareable> getChanged(IProgressMonitor progress) throws FileSystemClientException {
        if ("unknown".equals(this.getChangeType())) {
            return null;
        }
        if (this.changed == null) {
            this.changed = new LinkedList<IShareable>();
            if ("ignore".equals(this.getChangeType())) {
                this.gatherNewlyIgnored(progress);
            } else if ("unignore".equals(this.getChangeType())) {
                this.gatherNewlyUnignored(progress);
            } else {
                throw new IllegalStateException(NLS.bind((String)Messages.IgnoreEvent_0, (Object)this.getChangeType()));
            }
        }
        return this.changed;
    }

    private Collection<IShareable> gatherNewlyIgnored(IProgressMonitor progress) throws FileSystemClientException {
        Assert.isTrue((boolean)"ignore".equals(this.getChangeType()));
        IgnoreUtils.findIgnoresForRules(this.rules, new IgnoreUtils.IIgnoredForRuleController(){

            public void addIgnored(IIgnoreProvider.IIgnoreRule rule, IShareable shareable) {
                IgnoreEvent.this.changed.add(shareable);
            }

            public boolean shouldSkip(IIgnoreProvider.IIgnoreRule rule, IShareable shareable) throws FileSystemClientException {
                IIgnoreManager.IIgnoreReason reason = IgnoreEvent.this.source.findIgnoreReasons(shareable, null);
                return reason != null && !reason.getRules().contains(rule);
            }
        }, progress);
        return this.changed;
    }

    private Collection<IShareable> gatherNewlyUnignored(IProgressMonitor progress) throws FileSystemClientException {
        Assert.isTrue((boolean)"unignore".equals(this.getChangeType()));
        if (this.rules == null) {
            this.changed = null;
            return null;
        }
        IgnoreUtils.findIgnoresForRules(this.rules, false, new IgnoreUtils.IIgnoredForRuleController(){

            public void addIgnored(IIgnoreProvider.IIgnoreRule rule, IShareable shareable) {
                IgnoreEvent.this.changed.add(shareable);
            }

            public boolean shouldSkip(IIgnoreProvider.IIgnoreRule rule, IShareable shareable) {
                return IgnoreEvent.this.source.shouldBeIgnored(shareable);
            }
        }, progress);
        return this.changed;
    }

    @Override
    public Collection<IShareable> getRoots() {
        return this.roots;
    }

    @Override
    public Collection<? extends IIgnoreProvider.IIgnoreRule> getRules() {
        return this.rules;
    }

    public List getCategories() {
        return this.categories;
    }

    public IEventSource getEventSource() {
        return this.source;
    }

    public String getEventType() {
        return this.type;
    }

    @Override
    public IShareable getIgnoreFile() {
        return this.ignoreFile;
    }

    public String toString() {
        StringBuffer rootString = new StringBuffer();
        for (IShareable root : this.roots) {
            if (rootString.length() > 0) {
                rootString.append(", ");
            }
            rootString.append(root.getLocalFullPath().toString());
        }
        return "IgnoreEvent(" + (this instanceof GlobalIgnoreEvent ? "GLOBAL" : "LOCAL") + ", [" + rootString + "], type:" + this.getEventType() + ")";
    }
}

