/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IRemoteVisitor;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.IVisitor;
import com.ibm.team.filesystem.client.internal.InstantiationLock;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.ReadWriteLock;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaNotifier;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.copyfileareas.IFlushOperation;
import com.ibm.team.filesystem.client.internal.copyfileareas.ILockParticipant;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyFileAreaStore
implements IFlushOperation {
    private static CopyFileAreaStore instance;
    private static HashMap<IPath, CopyFileAreaStore> localStores;
    private BatchingLock batchingLock = new BatchingLock();
    private ISharingMetadata metadata;
    private CopyFileAreaNotifier notifier = new CopyFileAreaNotifier();
    private ReadWriteLock sharingInfoLock = new ReadWriteLock();
    private IPath path;
    private static Set<ICorruptCopyFileAreaListener> listeners;
    private static final ILockParticipant NULL_PARTICIPANT;

    static {
        localStores = new HashMap();
        listeners = new HashSet<ICorruptCopyFileAreaListener>();
        NULL_PARTICIPANT = new ILockParticipant(){

            public ISchedulingRule locking(ISchedulingRule rule) {
                return rule;
            }

            public void waiting() {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCorruptionListener(ICorruptCopyFileAreaListener listener) {
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            listeners.add(listener);
            if (instance != null) {
                CopyFileAreaStore.instance.metadata.addCorruptionListener(listener);
            }
            for (CopyFileAreaStore store : localStores.values()) {
                store.metadata.addCorruptionListener(listener);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCorruptionListener(ICorruptCopyFileAreaListener listener) {
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            listeners.remove(listener);
            if (instance != null) {
                CopyFileAreaStore.instance.metadata.removeCorruptionListener(listener);
            }
            for (CopyFileAreaStore store : localStores.values()) {
                store.metadata.removeCorruptionListener(listener);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public CopyFileAreaStore(IPath path, ISharingMetadata metadataStore) {
        Assert.isNotNull((Object)path);
        Assert.isNotNull((Object)metadataStore);
        this.path = path;
        this.metadata = metadataStore;
        for (ICorruptCopyFileAreaListener listener : listeners) {
            metadataStore.addCorruptionListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CopyFileAreaStore getDefaultCopyFileArea() {
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            if (instance == null) {
                IPath instancePath = SharingManager.getInstance().getDefaultCFARoot();
                Assert.isLegal((instancePath != null ? 1 : 0) != 0);
                instance = new CopyFileAreaStore(instancePath, SharingManager.getInstance().createSharingMetadata(instancePath));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CopyFileAreaStore getCopyFileArea(IPath root) {
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            if (root.equals((Object)SharingManager.getInstance().getDefaultCFARoot())) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return CopyFileAreaStore.getDefaultCopyFileArea();
            }
            CopyFileAreaStore cfa = localStores.get(root);
            if (cfa != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return cfa;
            }
            if ((root = CopyFileAreaStore.getCanonicalPath(root)).equals((Object)SharingManager.getInstance().getDefaultCFARoot())) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return CopyFileAreaStore.getDefaultCopyFileArea();
            }
            cfa = localStores.get(root);
            if (cfa == null) {
                cfa = new CopyFileAreaStore(root, SharingManager.getInstance().createSharingMetadata(root));
                localStores.put(root, cfa);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cfa;
        }
    }

    public void addListener(ICopyFileAreaListener listener) {
        this.notifier.addListener(listener);
    }

    public void removeListener(ICopyFileAreaListener listener) {
        this.notifier.removeListener(listener);
    }

    public static ISchedulingRule getSchedulingRule(IShareable shareable) {
        IShare share = shareable.getShare();
        if (share != null) {
            ISharingDescriptor desc = share.getSharingDescriptor();
            return new ComponentLock(desc.getConnectionHandle(), desc.getComponent());
        }
        return null;
    }

    public static ISchedulingRule getSchedulingRule(ISharingDescriptor desc) {
        return new ComponentLock(desc.getConnectionHandle(), desc.getComponent());
    }

    public static ISchedulingRule getSchedulingRule(IContextHandle connection, IComponentHandle component) {
        return new ComponentLock(connection, component);
    }

    public boolean isLocked(IComponentHandle component, IContextHandle connection) {
        return this.batchingLock.isLocked(new ComponentLock(connection, component));
    }

    public ISchedulingRule lock(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) {
        return this.batchingLock.acquire(new ComponentLock(connection, component), this, NULL_PARTICIPANT, true, monitor);
    }

    public ISchedulingRule lock(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        RuleDescriptorPair pair = this.beginBatching(shareable, (IProgressMonitor)progress.newChild(99));
        if (pair.desc == null) {
            this.endBatching(pair.rule, (IProgressMonitor)progress.newChild(1));
            return null;
        }
        return pair.rule;
    }

    public void release(ISchedulingRule rule, IProgressMonitor monitor) throws FileSystemClientException {
        this.batchingLock.release(rule, monitor);
    }

    private void updateParentInfoForChange(FileItemInfo newInfo, FileItemInfo oldInfo, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        if (oldInfo != null && !oldInfo.getVersionableHandle().sameItemId((IItemHandle)newInfo.getVersionableHandle())) {
            throw new IllegalArgumentException("Infos must be for the same versionable");
        }
        if (!newInfo.isFolder() || this.metadata.getPathForShareRoot((IFolderHandle)newInfo.getVersionableHandle(), component, connection) == null) {
            if (oldInfo != null && oldInfo.getParent() != null && oldInfo.getParent().sameItemId((IItemHandle)newInfo.getParent()) && !oldInfo.getName().equals(newInfo.getName())) {
                InverseFileItemInfo oldParentInverseInfo = this.metadata.getFileItemInfo((IVersionableHandle)newInfo.getParent(), component, connection);
                LinkedHashMap<String, IVersionableHandle> children = new LinkedHashMap<String, IVersionableHandle>(oldParentInverseInfo.getRemoteChildren());
                IVersionableHandle oldChild = (IVersionableHandle)children.remove(oldInfo.getName());
                if (oldChild == null) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_0, (Object)newInfo.getName()), null));
                }
                if (!oldInfo.getVersionableHandle().sameItemId((IItemHandle)oldChild)) {
                    children.put(oldInfo.getName(), oldChild);
                }
                children.put(newInfo.getName(), newInfo.getVersionableHandle());
                InverseFileItemInfo newParentInverseInfo = new InverseFileItemInfo(oldParentInverseInfo.getVersionableHandle(), oldParentInverseInfo.getLastModification(), oldParentInverseInfo.getParent(), oldParentInverseInfo.getName(), Collections.unmodifiableMap(children), oldParentInverseInfo.getLocalParent(), oldParentInverseInfo.getLocalName(), oldParentInverseInfo.getHash(), oldParentInverseInfo.getContentLength(), oldParentInverseInfo.getOriginalLineDelimiter(), oldParentInverseInfo.getLineDelimiter(), oldParentInverseInfo.getOriginalContentType(), oldParentInverseInfo.getContentType(), oldParentInverseInfo.getStoredContentId(), oldParentInverseInfo.getStoredDeltaPredecessor(), oldParentInverseInfo.getStoredSize(), oldParentInverseInfo.getStoredEncoding(), oldParentInverseInfo.getStoredChecksum(), oldParentInverseInfo.getStoredNumLineDelimiters(), oldParentInverseInfo.isExecutable(), oldParentInverseInfo.isOriginalExecutable());
                this.metadata.setFileItemInfo((IVersionableHandle)newInfo.getParent(), component, connection, newParentInverseInfo);
            } else {
                LinkedHashMap<String, IVersionableHandle> children;
                InverseFileItemInfo oldParentInverseInfo;
                if (oldInfo != null && oldInfo.getParent() != null && !oldInfo.getParent().sameItemId((IItemHandle)newInfo.getParent()) && (oldParentInverseInfo = this.metadata.getFileItemInfo((IVersionableHandle)oldInfo.getParent(), component, connection)) != null) {
                    children = new LinkedHashMap<String, IVersionableHandle>(oldParentInverseInfo.getRemoteChildren());
                    IVersionableHandle oldChild = (IVersionableHandle)children.remove(oldInfo.getName());
                    if (oldChild == null) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_1, (Object)newInfo.getName()), null));
                    }
                    if (!oldInfo.getVersionableHandle().sameItemId((IItemHandle)oldChild)) {
                        children.put(oldInfo.getName(), oldChild);
                    }
                    InverseFileItemInfo newParentInverseInfo = new InverseFileItemInfo(oldParentInverseInfo.getVersionableHandle(), oldParentInverseInfo.getLastModification(), oldParentInverseInfo.getParent(), oldParentInverseInfo.getName(), Collections.unmodifiableMap(children), oldParentInverseInfo.getLocalParent(), oldParentInverseInfo.getLocalName(), oldParentInverseInfo.getHash(), oldParentInverseInfo.getContentLength(), oldParentInverseInfo.getOriginalLineDelimiter(), oldParentInverseInfo.getLineDelimiter(), oldParentInverseInfo.getOriginalContentType(), oldParentInverseInfo.getContentType(), oldParentInverseInfo.getStoredContentId(), oldParentInverseInfo.getStoredDeltaPredecessor(), oldParentInverseInfo.getStoredSize(), oldParentInverseInfo.getStoredEncoding(), oldParentInverseInfo.getStoredChecksum(), oldParentInverseInfo.getStoredNumLineDelimiters(), oldParentInverseInfo.isExecutable(), oldParentInverseInfo.isOriginalExecutable());
                    this.metadata.setFileItemInfo((IVersionableHandle)oldInfo.getParent(), component, connection, newParentInverseInfo);
                }
                if (!(newInfo.getParent() == null || oldInfo != null && newInfo.getParent().sameItemId((IItemHandle)oldInfo.getParent()))) {
                    oldParentInverseInfo = this.metadata.getFileItemInfo((IVersionableHandle)newInfo.getParent(), component, connection);
                    if (oldParentInverseInfo == null) {
                        this.metadata.setCorrupt(true, "Unexpected null parent", null);
                        throw new RuntimeException("Detected metadata corruption");
                    }
                    children = new LinkedHashMap<String, IVersionableHandle>(oldParentInverseInfo.getRemoteChildren());
                    children.put(newInfo.getName(), newInfo.getVersionableHandle());
                    InverseFileItemInfo newParentInverseInfo = new InverseFileItemInfo(oldParentInverseInfo.getVersionableHandle(), oldParentInverseInfo.getLastModification(), oldParentInverseInfo.getParent(), oldParentInverseInfo.getName(), Collections.unmodifiableMap(children), oldParentInverseInfo.getLocalParent(), oldParentInverseInfo.getLocalName(), oldParentInverseInfo.getHash(), oldParentInverseInfo.getContentLength(), oldParentInverseInfo.getOriginalLineDelimiter(), oldParentInverseInfo.getLineDelimiter(), oldParentInverseInfo.getOriginalContentType(), oldParentInverseInfo.getContentType(), oldParentInverseInfo.getStoredContentId(), oldParentInverseInfo.getStoredDeltaPredecessor(), oldParentInverseInfo.getStoredSize(), oldParentInverseInfo.getStoredEncoding(), oldParentInverseInfo.getStoredChecksum(), oldParentInverseInfo.getStoredNumLineDelimiters(), oldParentInverseInfo.isExecutable(), oldParentInverseInfo.isOriginalExecutable());
                    this.metadata.setFileItemInfo((IVersionableHandle)newInfo.getParent(), component, connection, newParentInverseInfo);
                }
            }
        }
    }

    private void updateParentInfoForRemoval(FileItemInfo oldInfo, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        if (!(oldInfo.getParent() == null || oldInfo.isFolder() && this.metadata.getPathForShareRoot((IFolderHandle)oldInfo.getVersionableHandle(), component, connection) != null)) {
            InverseFileItemInfo oldParentInverseInfo = this.metadata.getFileItemInfo((IVersionableHandle)oldInfo.getParent(), component, connection);
            if (oldParentInverseInfo == null) {
                return;
            }
            LinkedHashMap<String, IVersionableHandle> children = new LinkedHashMap<String, IVersionableHandle>(oldParentInverseInfo.getRemoteChildren());
            IVersionableHandle oldChild = (IVersionableHandle)children.remove(oldInfo.getName());
            if (oldChild == null) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_2, (Object)oldInfo.getName()), null));
            }
            if (!oldInfo.getVersionableHandle().sameItemId((IItemHandle)oldChild)) {
                children.put(oldInfo.getName(), oldChild);
            }
            InverseFileItemInfo newParentInverseInfo = new InverseFileItemInfo(oldParentInverseInfo.getVersionableHandle(), oldParentInverseInfo.getLastModification(), oldParentInverseInfo.getParent(), oldParentInverseInfo.getName(), Collections.unmodifiableMap(children), oldParentInverseInfo.getLocalParent(), oldParentInverseInfo.getLocalName(), oldParentInverseInfo.getHash(), oldParentInverseInfo.getContentLength(), oldParentInverseInfo.getOriginalLineDelimiter(), oldParentInverseInfo.getLineDelimiter(), oldParentInverseInfo.getOriginalContentType(), oldParentInverseInfo.getContentType(), oldParentInverseInfo.getStoredContentId(), oldParentInverseInfo.getStoredDeltaPredecessor(), oldParentInverseInfo.getStoredSize(), oldParentInverseInfo.getStoredEncoding(), oldParentInverseInfo.getStoredChecksum(), oldParentInverseInfo.getStoredNumLineDelimiters(), oldParentInverseInfo.isExecutable(), oldParentInverseInfo.isOriginalExecutable());
            this.metadata.setFileItemInfo((IVersionableHandle)oldInfo.getParent(), component, connection, newParentInverseInfo);
        }
    }

    private void updateLocalParent(IPath path, IFolderHandle newParent, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        Map childMap = this.metadata.getChildInfos(path);
        for (FileItemInfo i : childMap.values()) {
            InverseFileItemInfo oldInfo = this.metadata.getFileItemInfo(i.getVersionableHandle(), component, connection);
            if (oldInfo.getLocalParent() == null) continue;
            InverseFileItemInfo newInfo = new InverseFileItemInfo(oldInfo.getVersionableHandle(), oldInfo.getLastModification(), oldInfo.getParent(), oldInfo.getName(), oldInfo.getRemoteChildren(), newParent, oldInfo.getLocalName(), oldInfo.getHash(), oldInfo.getContentLength(), oldInfo.getOriginalLineDelimiter(), oldInfo.getLineDelimiter(), oldInfo.getOriginalContentType(), oldInfo.getContentType(), oldInfo.getStoredContentId(), oldInfo.getStoredDeltaPredecessor(), oldInfo.getStoredSize(), oldInfo.getStoredEncoding(), oldInfo.getStoredChecksum(), oldInfo.getStoredNumLineDelimiters(), oldInfo.isExecutable(), oldInfo.isOriginalExecutable());
            this.metadata.setFileItemInfo(newInfo.getVersionableHandle(), component, connection, newInfo);
        }
    }

    public FileItemInfo setItemInfo(IShareable shareable, FileItemInfo info, IProgressMonitor monitor) throws FileSystemClientException {
        FileItemInfo fileItemInfo;
        SubMonitor progress;
        block13: {
            Assert.isNotNull((Object)info);
            ISchedulingRule rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            try {
                FileItemInfo existing;
                String name;
                IFolderHandle parent;
                RuleDescriptorPair pair = this.beginBatching(shareable, (IProgressMonitor)progress.newChild(1));
                ISharingDescriptor desc = pair.desc;
                rule = pair.rule;
                FileItemInfo parentInfo = this.metadata.getFileItemInfo(shareable.getLocalFullPath().removeLastSegments(1));
                if (parentInfo == null) {
                    parent = null;
                    name = null;
                } else {
                    parent = (IFolderHandle)parentInfo.getVersionableHandle();
                    name = shareable.getLocalFullPath().lastSegment();
                }
                InverseFileItemInfo oldInfo = this.metadata.getFileItemInfo(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                if (!(oldInfo == null || parent == null || oldInfo.getLocalParent() == null || parent.sameItemId((IItemHandle)oldInfo.getLocalParent()) && name.equals(oldInfo.getLocalName()))) {
                    if (!this.isCaseSensitive() && parent.sameItemId((IItemHandle)oldInfo.getLocalParent()) && name.toUpperCase().toLowerCase().equals(oldInfo.getLocalName().toUpperCase().toLowerCase())) {
                        this.metadata.setFileItemInfo(shareable.getLocalFullPath(), null);
                    } else {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_3, (Object)shareable.getLocalFullPath().toString(), (Object)this.getLocalPathInternal(oldInfo, desc.getComponent(), desc.getConnectionHandle())), null));
                    }
                }
                if ((existing = this.metadata.setFileItemInfo(shareable.getLocalFullPath(), info)) != null && !info.getVersionableHandle().sameItemId((IItemHandle)existing.getVersionableHandle())) {
                    if (existing.getVersionableHandle().sameItemId((IItemHandle)desc.getRootFolder())) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, "Internal error: Cannot change share root item id this way", null));
                    }
                    if (existing.getVersionableHandle() instanceof IFolderHandle) {
                        this.updateLocalParent(shareable.getLocalFullPath(), (IFolderHandle)info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                    }
                    if (existing.getVersionableHandle().hasStateId()) {
                        InverseFileItemInfo existingInverse = this.metadata.getFileItemInfo(existing.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                        existingInverse = new InverseFileItemInfo(existingInverse.getVersionableHandle(), -1L, existingInverse.getParent(), existingInverse.getName(), existingInverse.getRemoteChildren(), null, null, existingInverse.getHash(), existingInverse.getContentLength(), existingInverse.getOriginalLineDelimiter(), existingInverse.getLineDelimiter(), existingInverse.getOriginalContentType(), existingInverse.getContentType(), existingInverse.getStoredContentId(), existingInverse.getStoredDeltaPredecessor(), existingInverse.getStoredSize(), existingInverse.getStoredEncoding(), existingInverse.getStoredChecksum(), existingInverse.getStoredNumLineDelimiters(), existingInverse.isOriginalExecutable(), existingInverse.isOriginalExecutable());
                        this.metadata.setFileItemInfo(existing.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), existingInverse);
                    } else {
                        this.metadata.setFileItemInfo(existing.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), null);
                    }
                }
                this.updateParentInfoForChange(info, oldInfo, desc.getComponent(), desc.getConnectionHandle());
                Map<String, Object> children = info.isFolder() ? (oldInfo != null ? oldInfo.getRemoteChildren() : Collections.EMPTY_MAP) : Collections.EMPTY_MAP;
                InverseFileItemInfo newInfo = new InverseFileItemInfo(info.getVersionableHandle(), info.getLastModification(), info.getParent(), info.getName(), children, parent, name, info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredContentId(), info.getStoredDeltaPredecessor(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredChecksum(), info.getStoredNumLineDelimiters(), parent == null ? info.isOriginalExecutable() : info.isExecutable(), info.isOriginalExecutable());
                this.metadata.setFileItemInfo(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), newInfo);
                fileItemInfo = existing;
                if (rule == null) break block13;
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
        }
        progress.done();
        return fileItemInfo;
    }

    public FileItemInfo setItemInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection, FileItemInfo info, IProgressMonitor monitor) throws FileSystemClientException {
        InverseFileItemInfo inverseFileItemInfo;
        SubMonitor progress;
        block6: {
            ISchedulingRule rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                IFolderHandle localParent;
                String localName;
                rule = this.beginBatching(new ComponentLock(connection, component), (IProgressMonitor)progress.newChild(1));
                InverseFileItemInfo oldInfo = this.metadata.getFileItemInfo(item, component, connection);
                this.updateParentInfoForChange(info, oldInfo, component, connection);
                Map<String, IVersionableHandle> children = info.isFolder() && oldInfo != null ? oldInfo.getRemoteChildren() : Collections.EMPTY_MAP;
                IPath localPath = this.getLocalPathInternal(oldInfo, component, connection);
                if (localPath != null) {
                    this.metadata.setFileItemInfo(localPath, info);
                }
                if (oldInfo != null) {
                    localName = oldInfo.getLocalName();
                    localParent = oldInfo.getLocalParent();
                } else {
                    localName = null;
                    localParent = null;
                }
                InverseFileItemInfo newInfo = new InverseFileItemInfo(info.getVersionableHandle(), info.getLastModification(), info.getParent(), info.getName(), children, localParent, localName, info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredContentId(), info.getStoredDeltaPredecessor(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredChecksum(), info.getStoredNumLineDelimiters(), localParent == null ? info.isOriginalExecutable() : info.isExecutable(), info.isOriginalExecutable());
                this.metadata.setFileItemInfo(item, component, connection, newInfo);
                progress.worked(98);
                inverseFileItemInfo = oldInfo;
                if (rule == null) break block6;
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
        }
        progress.done();
        return inverseFileItemInfo;
    }

    public Map getChildInfos(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        ISchedulingRule rule = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            RuleDescriptorPair pair = this.beginBatching(shareable, (IProgressMonitor)progress.newChild(1));
            rule = pair.rule;
            Map map = this.metadata.getChildInfos(shareable.getLocalFullPath());
            return map;
        }
        finally {
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
        }
    }

    /*
     * Unable to fully structure code
     */
    public UUID getRemoteAncestor(Set<UUID> potentialAncestors, IVersionableHandle item, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        block10: {
            block8: {
                block9: {
                    block7: {
                        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        rule = null;
                        if (!potentialAncestors.isEmpty()) break block7;
                        while (true) {
                            if (rule != null) {
                                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                            }
                            progress.done();
                            return null;
                        }
                    }
                    try {
                        if (!potentialAncestors.contains(item.getItemId())) break block8;
                        var11_8 = item.getItemId();
                        if (rule == null) break block9;
                        this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                    }
                    catch (Throwable var10_12) {
                        if (rule != null) {
                            this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                        }
                        progress.done();
                        throw var10_12;
                    }
                }
                progress.done();
                return var11_8;
            }
            rule = this.beginBatching(new ComponentLock(connection, component), (IProgressMonitor)progress.newChild(1));
            if ((info = this.metadata.getFileItemInfo(item, component, connection)) == null || info.getVersionableHandle() instanceof IFolderHandle && (rootPath = this.metadata.getPathForShareRoot((IFolderHandle)info.getVersionableHandle(), component, connection)) != null || info.getName() == null) ** continue;
            var11_9 = this.getRemoteAncestorInternal_rec(potentialAncestors, (IVersionableHandle)info.getParent(), component, connection);
            if (rule == null) break block10;
            this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return var11_9;
    }

    private UUID getRemoteAncestorInternal(Set<UUID> potentialAncestors, IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        IPath rootPath;
        if (potentialAncestors.isEmpty()) {
            return null;
        }
        if (potentialAncestors.contains(item.getItemId())) {
            return item.getItemId();
        }
        InverseFileItemInfo info = this.metadata.getFileItemInfo(item, component, connection);
        if (info == null) {
            return null;
        }
        if (info.getVersionableHandle() instanceof IFolderHandle && (rootPath = this.metadata.getPathForShareRoot((IFolderHandle)info.getVersionableHandle(), component, connection)) != null) {
            return null;
        }
        if (info.getName() == null) {
            return null;
        }
        return this.getRemoteAncestorInternal_rec(potentialAncestors, (IVersionableHandle)info.getParent(), component, connection);
    }

    private UUID getRemoteAncestorInternal_rec(Set<UUID> potentialAncestors, IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        while (!potentialAncestors.contains(item.getItemId())) {
            IPath rootPath;
            if (item instanceof IFolderHandle && (rootPath = this.metadata.getPathForShareRoot((IFolderHandle)item, component, connection)) != null) {
                return null;
            }
            InverseFileItemInfo info = this.metadata.getFileItemInfo(item, component, connection);
            if (info == null) {
                throw new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_6, (Object)info.getVersionableHandle()));
            }
            if (info.getName() == null) {
                throw new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_7, (Object)info.getVersionableHandle()));
            }
            item = info.getParent();
        }
        return item.getItemId();
    }

    /*
     * Unable to fully structure code
     */
    public IPath getRemotePathFor(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        block10: {
            block8: {
                block9: {
                    block7: {
                        rule = null;
                        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        pair = this.beginBatching(shareable, (IProgressMonitor)progress.newChild(1));
                        desc = pair.desc;
                        rule = pair.rule;
                        info = this.metadata.getFileItemInfo(shareable.getLocalFullPath());
                        if (info != null) break block7;
                        while (true) {
                            if (rule != null) {
                                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                            }
                            progress.done();
                            return null;
                        }
                    }
                    try {
                        if (!(info.getVersionableHandle() instanceof IFolderHandle) || (rootPath = this.metadata.getPathForShareRoot((IFolderHandle)info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle())) == null) break block8;
                        var10_9 = rootPath;
                        if (rule == null) break block9;
                        this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                    }
                    catch (Throwable var9_11) {
                        if (rule != null) {
                            this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                        }
                        progress.done();
                        throw var9_11;
                    }
                }
                progress.done();
                return var10_9;
            }
            if (info.getName() == null) ** continue;
            var10_10 = this.getRemotePathInternal((IVersionableHandle)info.getParent(), desc.getComponent(), desc.getConnectionHandle()).append(info.getName());
            if (rule == null) break block10;
            this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return var10_10;
    }

    /*
     * Unable to fully structure code
     */
    public IPath getRemotePathFor(IVersionableHandle item, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        block10: {
            block8: {
                block9: {
                    block7: {
                        rule = null;
                        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        rule = this.beginBatching(new ComponentLock(connection, component), (IProgressMonitor)progress.newChild(1));
                        info = this.metadata.getFileItemInfo(item, component, connection);
                        if (info != null) break block7;
                        while (true) {
                            if (rule != null) {
                                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                            }
                            progress.done();
                            return null;
                        }
                    }
                    try {
                        if (!(info.getVersionableHandle() instanceof IFolderHandle) || (rootPath = this.metadata.getPathForShareRoot((IFolderHandle)info.getVersionableHandle(), component, connection)) == null) break block8;
                        var10_9 = rootPath;
                        if (rule == null) break block9;
                        this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                    }
                    catch (Throwable var9_11) {
                        if (rule != null) {
                            this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                        }
                        progress.done();
                        throw var9_11;
                    }
                }
                progress.done();
                return var10_9;
            }
            if (info.getName() == null) ** continue;
            var10_10 = this.getRemotePathInternal((IVersionableHandle)info.getParent(), component, connection).append(info.getName());
            if (rule == null) break block10;
            this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return var10_10;
    }

    private IPath getRemotePathInternal(IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        IPath rootPath;
        if (item instanceof IFolderHandle && (rootPath = this.metadata.getPathForShareRoot((IFolderHandle)item, component, connection)) != null) {
            return rootPath;
        }
        InverseFileItemInfo info = this.metadata.getFileItemInfo(item, component, connection);
        if (info == null) {
            return null;
        }
        return this.getRemotePathInternal_rec(info, component, connection);
    }

    private IPath getRemotePathInternal_rec(FileItemInfo info, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        ArrayList<String> segments = null;
        int pathlen = 0;
        while (true) {
            IPath rootPath;
            if (info.getVersionableHandle() instanceof IFolderHandle && (rootPath = this.metadata.getPathForShareRoot((IFolderHandle)info.getVersionableHandle(), component, connection)) != null) {
                if (segments == null) {
                    return rootPath;
                }
                int max = segments.size() - 1;
                if (max == 0) {
                    return rootPath.append((String)segments.get(0));
                }
                StringBuilder buf = new StringBuilder(pathlen + max);
                buf.append((String)segments.get(max));
                int i = max - 1;
                while (i >= 0) {
                    buf.append('/');
                    buf.append((String)segments.get(i));
                    --i;
                }
                return rootPath.append(buf.toString());
            }
            String name = info.getName();
            if (name == null) {
                throw new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_8, (Object)info.getVersionableHandle()));
            }
            if (segments == null) {
                segments = new ArrayList<String>();
            }
            pathlen += name.length();
            segments.add(name);
            info = this.metadata.getFileItemInfo((IVersionableHandle)info.getParent(), component, connection);
        }
    }

    public List<IPath> getLocalPathFor(List<IVersionableHandle> items, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        ArrayList<IPath> arrayList;
        SubMonitor progress;
        block4: {
            ISchedulingRule rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                rule = this.beginBatching(new ComponentLock(connection, component), (IProgressMonitor)progress.newChild(1));
                ArrayList<IPath> result = new ArrayList<IPath>(items.size());
                SubMonitor subProgress = progress.newChild(98);
                subProgress.setWorkRemaining(items.size());
                for (IVersionableHandle item : items) {
                    result.add(this.getLocalPathInternal(item, component, connection));
                    subProgress.worked(1);
                }
                subProgress.done();
                arrayList = result;
                if (rule == null) break block4;
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
        }
        progress.done();
        return arrayList;
    }

    public IPath getLocalPathFor(IVersionableHandle item, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        IPath iPath;
        SubMonitor progress;
        block3: {
            ISchedulingRule rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                rule = this.beginBatching(new ComponentLock(connection, component), (IProgressMonitor)progress.newChild(1));
                iPath = this.getLocalPathInternal(item, component, connection);
                if (rule == null) break block3;
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
        }
        progress.done();
        return iPath;
    }

    private IPath getLocalPathInternal(IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        InverseFileItemInfo info = this.metadata.getFileItemInfo(item, component, connection);
        return this.getLocalPathInternal(info, component, connection);
    }

    private IPath getLocalPathInternal(InverseFileItemInfo info, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        IPath rootPath;
        if (info == null) {
            return null;
        }
        if (info.getVersionableHandle() instanceof IFolderHandle && (rootPath = this.metadata.getPathForShareRoot((IFolderHandle)info.getVersionableHandle(), component, connection)) != null) {
            return rootPath;
        }
        if (info.getLocalName() == null) {
            return null;
        }
        return this.getLocalPathInternal_rec(this.metadata.getFileItemInfo((IVersionableHandle)info.getLocalParent(), component, connection), component, connection).append(info.getLocalName());
    }

    private IPath getLocalPathInternal_rec(InverseFileItemInfo info, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        ArrayList<String> segments = null;
        int pathlen = 0;
        while (true) {
            IPath rootPath;
            if (info.getVersionableHandle() instanceof IFolderHandle && (rootPath = this.metadata.getPathForShareRoot((IFolderHandle)info.getVersionableHandle(), component, connection)) != null) {
                if (segments == null) {
                    return rootPath;
                }
                int max = segments.size() - 1;
                if (max == 0) {
                    return rootPath.append((String)segments.get(0));
                }
                StringBuilder buf = new StringBuilder(pathlen + max);
                buf.append((String)segments.get(max));
                int i = max - 1;
                while (i >= 0) {
                    buf.append('/');
                    buf.append((String)segments.get(i));
                    --i;
                }
                return rootPath.append(buf.toString());
            }
            String name = info.getLocalName();
            if (name == null) {
                throw new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_10, (Object)info.getVersionableHandle()));
            }
            if (segments == null) {
                segments = new ArrayList<String>();
            }
            pathlen += name.length();
            segments.add(name);
            info = this.metadata.getFileItemInfo((IVersionableHandle)info.getLocalParent(), component, connection);
        }
    }

    public InverseFileItemInfo getItemInfo(IVersionableHandle handle, IComponentHandle component, IContextHandle connection) {
        try {
            return this.metadata.getFileItemInfo(handle, component, connection);
        }
        catch (FileSystemClientException e) {
            LoggingHelper.log(e);
            return null;
        }
    }

    public IVersionableHandle getDeletedItem(IFolderHandle handle, String name, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) {
        ISchedulingRule rule = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IVersionableHandle h;
            rule = this.beginBatching(new ComponentLock(connection, component), (IProgressMonitor)progress.newChild(1));
            InverseFileItemInfo info = this.metadata.getFileItemInfo((IVersionableHandle)handle, component, connection);
            if (info != null && (h = info.getRemoteChildren().get(name)) != null && (info = this.metadata.getFileItemInfo(h, component, connection)).getLocalParent() == null) {
                IVersionableHandle iVersionableHandle = h;
                return iVersionableHandle;
            }
        }
        catch (FileSystemClientException e) {
            LoggingHelper.log(e);
        }
        finally {
            if (rule != null) {
                try {
                    this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                catch (FileSystemClientException e) {
                    LoggingHelper.log(e);
                }
            }
            progress.done();
        }
        return null;
    }

    public Collection getLocalItemPaths(final IVersionableHandle handle, IProgressMonitor monitor) throws FileSystemClientException {
        final ISchedulingRule[] rule = new ISchedulingRule[1];
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            final Collection[] locations = new Collection[1];
            ISharingMetadata.ITransaction trans = new ISharingMetadata.ITransaction(){

                public void run() throws FileSystemClientException {
                    locations[0] = CopyFileAreaStore.this.metadata.getLocations(handle);
                    if (locations[0].isEmpty()) {
                        return;
                    }
                    ISchedulingRule[] rules = new ISchedulingRule[locations[0].size()];
                    int idx = 0;
                    for (ISharingMetadata.IConnectionComponent c : locations[0]) {
                        rules[idx++] = new ComponentLock(c.getConnection(), c.getComponent());
                    }
                    ISchedulingRule schedRule = rules.length == 1 ? rules[0] : MultiRule.combine((ISchedulingRule[])rules);
                    rule[0] = CopyFileAreaStore.this.beginBatchingNoWait(schedRule);
                }
            };
            while (true) {
                this.metadata.run(trans);
                if (rule[0] != null) break;
                if (locations[0].isEmpty()) {
                    List list = Collections.EMPTY_LIST;
                    return list;
                }
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                }
            }
            progress.worked(1);
            progress.setWorkRemaining(99);
            SubMonitor subProgress = progress.newChild(98);
            subProgress.setWorkRemaining(locations[0].size());
            ArrayList<IPath> paths = new ArrayList<IPath>(locations[0].size());
            for (ISharingMetadata.IConnectionComponent c : locations[0]) {
                IPath path = this.getLocalPathInternal(handle, c.getComponent(), c.getConnection());
                if (path != null) {
                    paths.add(path);
                }
                subProgress.worked(1);
            }
            subProgress.done();
            ArrayList<IPath> arrayList = paths;
            return arrayList;
        }
        finally {
            if (rule[0] != null) {
                this.endBatching(rule[0], (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
        }
    }

    public Collection getLocalItemPaths(final IVersionableHandle handle, final IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        final ISchedulingRule[] rule = new ISchedulingRule[1];
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            final Collection[] locations = new Collection[1];
            final int[] numResults = new int[1];
            ISharingMetadata.ITransaction trans = new ISharingMetadata.ITransaction(){

                public void run() throws FileSystemClientException {
                    locations[0] = CopyFileAreaStore.this.metadata.getLocations(handle);
                    if (locations[0].isEmpty()) {
                        numResults[0] = 0;
                        return;
                    }
                    ISchedulingRule[] rules = new ISchedulingRule[locations[0].size()];
                    int idx = 0;
                    for (ISharingMetadata.IConnectionComponent c : locations[0]) {
                        if (!c.getConnection().sameItemId((IItemHandle)connection)) continue;
                        rules[idx++] = new ComponentLock(c.getConnection(), c.getComponent());
                    }
                    numResults[0] = idx;
                    if (idx == 0) {
                        return;
                    }
                    ISchedulingRule schedRule = MultiRule.combine((ISchedulingRule[])rules);
                    rule[0] = CopyFileAreaStore.this.beginBatchingNoWait(schedRule);
                }
            };
            while (true) {
                this.metadata.run(trans);
                if (rule[0] != null) break;
                if (numResults[0] == 0) {
                    List list = Collections.EMPTY_LIST;
                    return list;
                }
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                }
            }
            progress.worked(1);
            progress.setWorkRemaining(99);
            SubMonitor subProgress = progress.newChild(98);
            subProgress.setWorkRemaining(numResults[0]);
            ArrayList<IPath> paths = new ArrayList<IPath>(numResults[0]);
            for (ISharingMetadata.IConnectionComponent c : locations[0]) {
                if (!c.getConnection().sameItemId((IItemHandle)connection)) continue;
                IPath path = this.getLocalPathInternal(handle, c.getComponent(), c.getConnection());
                if (path != null) {
                    paths.add(path);
                }
                subProgress.worked(1);
            }
            subProgress.done();
            ArrayList<IPath> arrayList = paths;
            return arrayList;
        }
        finally {
            if (rule[0] != null) {
                this.endBatching(rule[0], (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
        }
    }

    public Collection getLocalItemPaths(final IVersionableHandle handle, final IComponentHandle component, IProgressMonitor monitor) throws FileSystemClientException {
        final ISchedulingRule[] rule = new ISchedulingRule[1];
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            final Collection[] locations = new Collection[1];
            final int[] numResults = new int[1];
            ISharingMetadata.ITransaction trans = new ISharingMetadata.ITransaction(){

                public void run() throws FileSystemClientException {
                    locations[0] = CopyFileAreaStore.this.metadata.getLocations(handle);
                    if (locations[0].isEmpty()) {
                        numResults[0] = 0;
                        return;
                    }
                    ISchedulingRule[] rules = new ISchedulingRule[locations[0].size()];
                    int idx = 0;
                    for (ISharingMetadata.IConnectionComponent c : locations[0]) {
                        if (!c.getComponent().sameItemId((IItemHandle)component)) continue;
                        rules[idx++] = new ComponentLock(c.getConnection(), c.getComponent());
                    }
                    numResults[0] = idx;
                    if (idx == 0) {
                        return;
                    }
                    ISchedulingRule schedRule = MultiRule.combine((ISchedulingRule[])rules);
                    rule[0] = CopyFileAreaStore.this.beginBatchingNoWait(schedRule);
                }
            };
            while (true) {
                this.metadata.run(trans);
                if (rule[0] != null) break;
                if (numResults[0] == 0) {
                    List list = Collections.EMPTY_LIST;
                    return list;
                }
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                }
            }
            progress.worked(1);
            progress.setWorkRemaining(99);
            SubMonitor subProgress = progress.newChild(98);
            subProgress.setWorkRemaining(numResults[0]);
            ArrayList<IPath> paths = new ArrayList<IPath>(numResults[0]);
            for (ISharingMetadata.IConnectionComponent c : locations[0]) {
                if (!c.getComponent().sameItemId((IItemHandle)component)) continue;
                IPath path = this.getLocalPathInternal(handle, c.getComponent(), c.getConnection());
                if (path != null) {
                    paths.add(path);
                }
                subProgress.worked(1);
            }
            subProgress.done();
            ArrayList<IPath> arrayList = paths;
            return arrayList;
        }
        finally {
            if (rule[0] != null) {
                this.endBatching(rule[0], (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
        }
    }

    public FileItemInfo getItemInfo(IPath path) {
        try {
            return this.metadata.getFileItemInfo(path);
        }
        catch (FileSystemClientException e) {
            LoggingHelper.log(e);
            return null;
        }
    }

    public void moveSharingInfo(final IPath sourcePath, final IPath destinationPath, IProgressMonitor monitor) throws FileSystemClientException {
        ISchedulingRule rule = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final ISharingDescriptor[] oldInfo = new ISharingDescriptor[1];
        final FileSystemClientException[] exception = new FileSystemClientException[1];
        try {
            rule = this.beginBatchingWithLock(null, new ILockParticipant(){

                public ISchedulingRule locking(ISchedulingRule rule) {
                    CopyFileAreaStore.this.sharingInfoLock.acquireWrite();
                    try {
                        if (CopyFileAreaStore.this.metadata.getSharingDescriptor(destinationPath) != null) {
                            throw new IllegalArgumentException("Cannot move share from " + sourcePath + " to " + destinationPath + " because destination is already shared");
                        }
                        oldInfo[0] = CopyFileAreaStore.this.metadata.getSharingDescriptor(sourcePath);
                        if (oldInfo[0] != null) {
                            ComponentLock lock = new ComponentLock(oldInfo[0].getConnectionHandle(), oldInfo[0].getComponent());
                            return lock;
                        }
                        throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.CopyFileAreaStore_11, (Object)sourcePath)));
                    }
                    catch (FileSystemClientException e) {
                        exception[0] = e;
                        return null;
                    }
                }

                public void waiting() {
                    CopyFileAreaStore.this.sharingInfoLock.release();
                }
            }, (IProgressMonitor)progress.newChild(1));
            if (exception[0] != null) {
                throw exception[0];
            }
            this.metadata.moveFileItemInfo(sourcePath, destinationPath);
            progress.worked(50);
            this.metadata.setSharingDescriptor(sourcePath, null, (IProgressMonitor)progress.newChild(24));
            this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)oldInfo[0].getRootFolder(), sourcePath, 2));
            this.metadata.setSharingDescriptor(destinationPath, oldInfo[0], (IProgressMonitor)progress.newChild(24));
            this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)oldInfo[0].getRootFolder(), destinationPath, 1));
        }
        catch (Throwable throwable) {
            this.sharingInfoLock.release();
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
            throw throwable;
        }
        this.sharingInfoLock.release();
        if (rule != null) {
            this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    public void setSharingInfo(IShareable shareable, final ISharingDescriptor info, IProgressMonitor monitor) throws FileSystemClientException {
        Assert.isNotNull((Object)info);
        ISchedulingRule rule = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final IPath sharePath = shareable.getLocalFullPath();
        final ISharingDescriptor[] oldInfo = new ISharingDescriptor[1];
        final FileSystemClientException[] exception = new FileSystemClientException[1];
        try {
            rule = this.beginBatchingWithLock(null, new ILockParticipant(){

                public ISchedulingRule locking(ISchedulingRule rule) {
                    CopyFileAreaStore.this.sharingInfoLock.acquireWrite();
                    try {
                        oldInfo[0] = CopyFileAreaStore.this.metadata.getSharingDescriptor(sharePath);
                        rule = oldInfo[0] != null ? MultiRule.combine((ISchedulingRule)new ComponentLock(info.getConnectionHandle(), info.getComponent()), (ISchedulingRule)new ComponentLock(oldInfo[0].getConnectionHandle(), oldInfo[0].getComponent())) : new ComponentLock(info.getConnectionHandle(), info.getComponent());
                        return rule;
                    }
                    catch (FileSystemClientException e) {
                        exception[0] = e;
                        return null;
                    }
                }

                public void waiting() {
                    CopyFileAreaStore.this.sharingInfoLock.release();
                }
            }, (IProgressMonitor)progress.newChild(1));
            if (exception[0] != null) {
                throw exception[0];
            }
            if (oldInfo[0] == null) {
                this.metadata.deleteFileItemInfo(sharePath, (IProgressMonitor)progress.newChild(70));
            } else if (!(oldInfo[0].getComponent().sameItemId((IItemHandle)info.getComponent()) && oldInfo[0].getConnectionHandle().sameItemId((IItemHandle)info.getConnectionHandle()) && oldInfo[0].getRootFolder().sameItemId((IItemHandle)info.getRootFolder()))) {
                if (!oldInfo[0].getRootFolder().sameItemId((IItemHandle)info.getRootFolder())) {
                    this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)oldInfo[0].getRootFolder(), sharePath, 2));
                }
                this.moveSubtreeToWC(sharePath, oldInfo[0], info, (IProgressMonitor)progress.newChild(70));
            } else {
                progress.setWorkRemaining(29);
            }
            this.metadata.setSharingDescriptor(sharePath, info, (IProgressMonitor)progress.newChild(14));
            if (!(oldInfo[0] == null || oldInfo[0].getComponent().sameItemId((IItemHandle)info.getComponent()) && oldInfo[0].getConnectionHandle().sameItemId((IItemHandle)info.getConnectionHandle()))) {
                progress.setWorkRemaining(16);
                if (!this.metadata.hasShares(oldInfo[0].getComponent(), oldInfo[0].getConnectionHandle(), (IProgressMonitor)progress.newChild(1))) {
                    LocalChangeManager.getInstance().clearPendingChanges(oldInfo[0].getConnectionHandle(), oldInfo[0].getComponent(), this.getRoot());
                }
            }
            boolean alreadyLoaded = this.metadata.componentLoaded(new LoadedConfigurationDescriptor(info.getRepositoryId(), info.getRepositoryUri(), info.getConnectionHandle(), info.getConnectionName(), info.getComponent(), info.getComponentName()), (IProgressMonitor)progress.newChild(14)) != null;
            this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)info.getRootFolder(), sharePath, 1));
            if (!alreadyLoaded) {
                this.batchingLock.addChange(new CopyFileAreaEvent(null, null, 7));
            }
        }
        catch (Throwable throwable) {
            this.sharingInfoLock.release();
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
            throw throwable;
        }
        this.sharingInfoLock.release();
        if (rule != null) {
            this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    private void moveSubtreeToWC(IPath sharePath, final ISharingDescriptor oldInfo, final ISharingDescriptor newInfo, IProgressMonitor monitor) throws FileSystemClientException {
        IPath pathToNewRootInOldComponent;
        InverseFileItemInfo newRootInfo;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.metadata.getFileItemInfo((IVersionableHandle)newInfo.getRootFolder(), newInfo.getComponent(), newInfo.getConnectionHandle()) != null) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_12, (Object[])new Object[]{sharePath, newInfo.getRootFolder().getItemId().getUuidValue(), newInfo.getConnectionName(), newInfo.getComponentName()}), null));
        }
        if (!oldInfo.getRootFolder().sameItemId((IItemHandle)newInfo.getRootFolder())) {
            newRootInfo = this.metadata.getFileItemInfo((IVersionableHandle)newInfo.getRootFolder(), oldInfo.getComponent(), oldInfo.getConnectionHandle());
            pathToNewRootInOldComponent = this.getLocalPathInternal(newRootInfo, oldInfo.getComponent(), oldInfo.getConnectionHandle());
        } else {
            newRootInfo = null;
            pathToNewRootInOldComponent = null;
        }
        final boolean[] foundNewRootInRemoteSubtree = new boolean[1];
        final InverseFileItemInfo[] oldRootInfo = new InverseFileItemInfo[1];
        if (!oldInfo.getComponent().sameItemId((IItemHandle)newInfo.getComponent()) || !oldInfo.getConnectionHandle().sameItemId((IItemHandle)newInfo.getConnectionHandle())) {
            final ArrayList exceptions = new ArrayList();
            this.metadata.accept(new IVisitor(){

                public boolean visit(IPath path, FileItemInfo entry, IProgressMonitor monitor) {
                    try {
                        if (entry.getParent() != null) {
                            InverseFileItemInfo inverse = CopyFileAreaStore.this.metadata.getFileItemInfo(entry.getVersionableHandle(), oldInfo.getComponent(), oldInfo.getConnectionHandle());
                            inverse = new InverseFileItemInfo(inverse.getVersionableHandle(), -1L, inverse.getParent(), inverse.getName(), inverse.getRemoteChildren(), null, null, inverse.getHash(), inverse.getContentLength(), inverse.getOriginalLineDelimiter(), inverse.getLineDelimiter(), inverse.getOriginalContentType(), entry.getContentType(), inverse.getStoredContentId(), inverse.getStoredDeltaPredecessor(), inverse.getStoredSize(), inverse.getStoredEncoding(), inverse.getStoredChecksum(), inverse.getStoredNumLineDelimiters(), inverse.isOriginalExecutable(), inverse.isOriginalExecutable());
                            CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), oldInfo.getComponent(), oldInfo.getConnectionHandle(), inverse);
                        }
                    }
                    catch (FileSystemClientException e) {
                        exceptions.add(e);
                    }
                    return true;
                }
            }, sharePath, Integer.MAX_VALUE, true, (IProgressMonitor)progress.newChild(25));
            if (!exceptions.isEmpty()) {
                MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaStore_21, null);
                for (FileSystemClientException ex : exceptions) {
                    multi.add(FileSystemStatus.getStatusFor((Throwable)((Object)ex)));
                }
                throw new FileSystemClientException((IStatus)multi);
            }
            this.metadata.accept(new IRemoteVisitor(){

                public boolean visit(IPath path, InverseFileItemInfo entry, IProgressMonitor monitor) {
                    try {
                        if (entry.getLocalName() != null) {
                            IPath localPath = CopyFileAreaStore.this.getLocalPathInternal(entry, oldInfo.getComponent(), oldInfo.getConnectionHandle());
                            InverseFileItemInfo newItemInfo = new InverseFileItemInfo((IVersionableHandle)entry.getVersionableHandle().getItemType().createItemHandle(UUID.generate(), null), -1L, null, null, Collections.<String, IVersionableHandle>emptyMap(), entry.getLocalParent(), entry.getLocalName(), null, -1L, null, entry.getLineDelimiter(), null, entry.getContentType(), null, null, -1L, null, -1L, -1L, entry.isExecutable(), false);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(localPath, newItemInfo);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(newItemInfo.getVersionableHandle(), oldInfo.getComponent(), oldInfo.getConnectionHandle(), newItemInfo);
                            if (entry.getVersionableHandle() instanceof IFolderHandle) {
                                CopyFileAreaStore.this.updateLocalParent(localPath, (IFolderHandle)newItemInfo.getVersionableHandle(), oldInfo.getComponent(), oldInfo.getConnectionHandle());
                            }
                        }
                    }
                    catch (FileSystemClientException e) {
                        exceptions.add(e);
                    }
                    return true;
                }
            }, (IVersionableHandle)oldInfo.getRootFolder(), oldInfo.getComponent(), oldInfo.getConnectionHandle(), Integer.MAX_VALUE, true, (IProgressMonitor)progress.newChild(20));
            if (!exceptions.isEmpty()) {
                MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaStore_22, null);
                for (FileSystemClientException ex : exceptions) {
                    multi.add(FileSystemStatus.getStatusFor((Throwable)((Object)ex)));
                }
                throw new FileSystemClientException((IStatus)multi);
            }
            this.metadata.accept(new IRemoteVisitor(){

                public boolean visit(IPath path, InverseFileItemInfo entry, IProgressMonitor monitor) {
                    try {
                        CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), oldInfo.getComponent(), oldInfo.getConnectionHandle(), null);
                        boolean isNewRoot = entry.getVersionableHandle().sameItemId((IItemHandle)newInfo.getRootFolder());
                        if (isNewRoot) {
                            foundNewRootInRemoteSubtree[0] = true;
                        }
                        InverseFileItemInfo newFI = new InverseFileItemInfo(entry.getVersionableHandle(), -1L, entry.getParent(), entry.getName(), Collections.EMPTY_MAP, null, null, entry.getHash(), entry.getContentLength(), entry.getOriginalLineDelimiter(), entry.getLineDelimiter(), entry.getOriginalContentType(), entry.getContentType(), entry.getStoredContentId(), entry.getStoredDeltaPredecessor(), entry.getStoredSize(), entry.getStoredEncoding(), entry.getStoredChecksum(), entry.getStoredNumLineDelimiters(), entry.isExecutable(), entry.isOriginalExecutable());
                        InverseFileItemInfo oldFI = CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), newFI);
                        if (oldFI == null) {
                            if (!entry.getVersionableHandle().sameItemId((IItemHandle)oldInfo.getRootFolder())) {
                                InverseFileItemInfo parentFI = CopyFileAreaStore.this.metadata.getFileItemInfo((IVersionableHandle)entry.getParent(), newInfo.getComponent(), newInfo.getConnectionHandle());
                                String name = entry.getName();
                                if (parentFI.getRemoteChildren().containsKey(name)) {
                                    do {
                                        name = String.valueOf(name) + "0";
                                    } while (parentFI.getRemoteChildren().containsKey(name));
                                    newFI = new InverseFileItemInfo(entry.getVersionableHandle(), -1L, entry.getParent(), name, Collections.EMPTY_MAP, null, null, entry.getHash(), entry.getContentLength(), entry.getOriginalLineDelimiter(), entry.getLineDelimiter(), entry.getOriginalContentType(), entry.getContentType(), entry.getStoredContentId(), entry.getStoredDeltaPredecessor(), entry.getStoredSize(), entry.getStoredEncoding(), entry.getStoredChecksum(), entry.getStoredNumLineDelimiters(), entry.isExecutable(), entry.isOriginalExecutable());
                                    CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), newFI);
                                }
                                HashMap<String, IVersionableHandle> childMap = new HashMap<String, IVersionableHandle>(parentFI.getRemoteChildren());
                                childMap.put(name, entry.getVersionableHandle());
                                parentFI = new InverseFileItemInfo(parentFI.getVersionableHandle(), parentFI.getLastModification(), parentFI.getParent(), parentFI.getName(), childMap, parentFI.getLocalParent(), parentFI.getLocalName(), parentFI.getHash(), parentFI.getContentLength(), parentFI.getOriginalLineDelimiter(), parentFI.getLineDelimiter(), parentFI.getOriginalContentType(), parentFI.getContentType(), parentFI.getStoredContentId(), parentFI.getStoredDeltaPredecessor(), parentFI.getStoredSize(), parentFI.getStoredEncoding(), parentFI.getStoredChecksum(), parentFI.getStoredNumLineDelimiters(), parentFI.isExecutable(), parentFI.isOriginalExecutable());
                                CopyFileAreaStore.this.metadata.setFileItemInfo(parentFI.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), parentFI);
                            }
                        } else {
                            CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), oldFI);
                        }
                    }
                    catch (FileSystemClientException e) {
                        exceptions.add(e);
                    }
                    return true;
                }
            }, (IVersionableHandle)oldInfo.getRootFolder(), oldInfo.getComponent(), oldInfo.getConnectionHandle(), Integer.MAX_VALUE, true, (IProgressMonitor)progress.newChild(20));
            if (!exceptions.isEmpty()) {
                MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaStore_14, null);
                for (FileSystemClientException ex : exceptions) {
                    multi.add(FileSystemStatus.getStatusFor((Throwable)((Object)ex)));
                }
                throw new FileSystemClientException((IStatus)multi);
            }
            this.metadata.accept(new IVisitor(){

                public boolean visit(IPath path, FileItemInfo entry, IProgressMonitor monitor) {
                    try {
                        InverseFileItemInfo inverse;
                        if (entry.getParent() == null && !entry.getVersionableHandle().sameItemId((IItemHandle)oldInfo.getRootFolder())) {
                            CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), oldInfo.getComponent(), oldInfo.getConnectionHandle(), null);
                        }
                        if ((inverse = CopyFileAreaStore.this.metadata.getFileItemInfo(entry.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle())) == null) {
                            FileItemInfo parentInfo = CopyFileAreaStore.this.metadata.getFileItemInfo(path.removeLastSegments(1));
                            inverse = new InverseFileItemInfo(entry.getVersionableHandle(), -1L, null, null, Collections.EMPTY_MAP, (IFolderHandle)parentInfo.getVersionableHandle(), path.lastSegment(), null, -1L, null, entry.getLineDelimiter(), null, entry.getContentType(), null, null, -1L, null, -1L, -1L, entry.isExecutable(), false);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(inverse.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), inverse);
                        } else if (inverse.getLocalParent() != null || inverse.isFolder() && CopyFileAreaStore.this.metadata.getPathForShareRoot((IFolderHandle)inverse.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle()) != null) {
                            IVersionableHandle h = (IVersionableHandle)entry.getVersionableHandle().getItemType().createItemHandle(UUID.generate(), null);
                            if (entry.getVersionableHandle().sameItemId((IItemHandle)oldInfo.getRootFolder())) {
                                inverse = new InverseFileItemInfo((IFolderHandle)h, null, null, Collections.EMPTY_MAP, null, null);
                                CopyFileAreaStore.this.metadata.setFileItemInfo(path, inverse);
                                CopyFileAreaStore.this.metadata.setFileItemInfo(inverse.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), inverse);
                                oldRootInfo[0] = inverse;
                            } else {
                                FileItemInfo parentInfo = CopyFileAreaStore.this.metadata.getFileItemInfo(path.removeLastSegments(1));
                                inverse = new InverseFileItemInfo(h, -1L, null, null, Collections.EMPTY_MAP, (IFolderHandle)parentInfo.getVersionableHandle(), path.lastSegment(), null, -1L, null, entry.getLineDelimiter(), null, entry.getContentType(), null, null, -1L, null, -1L, -1L, entry.isExecutable(), false);
                                CopyFileAreaStore.this.metadata.setFileItemInfo(path, inverse);
                                CopyFileAreaStore.this.metadata.setFileItemInfo(inverse.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), inverse);
                            }
                        } else if (!entry.getVersionableHandle().sameItemId((IItemHandle)oldInfo.getRootFolder())) {
                            FileItemInfo parentInfo = CopyFileAreaStore.this.metadata.getFileItemInfo(path.removeLastSegments(1));
                            long timeStamp = inverse.getHash() == null || entry.getHash() == null || !entry.getHash().equals((Object)inverse.getHash()) || entry.getContentLength() != inverse.getContentLength() ? -1L : entry.getLastModification();
                            inverse = new InverseFileItemInfo(inverse.getVersionableHandle(), timeStamp, inverse.getParent(), inverse.getName(), inverse.getRemoteChildren(), (IFolderHandle)parentInfo.getVersionableHandle(), path.lastSegment(), inverse.getHash(), inverse.getContentLength(), inverse.getOriginalLineDelimiter(), entry.getLineDelimiter(), inverse.getOriginalContentType(), entry.getContentType(), inverse.getStoredContentId(), inverse.getStoredDeltaPredecessor(), inverse.getStoredSize(), inverse.getStoredEncoding(), inverse.getStoredChecksum(), inverse.getStoredNumLineDelimiters(), inverse.isExecutable(), inverse.isOriginalExecutable());
                            CopyFileAreaStore.this.metadata.setFileItemInfo(path, inverse);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), inverse);
                        } else {
                            oldRootInfo[0] = inverse;
                        }
                    }
                    catch (FileSystemClientException e) {
                        exceptions.add(e);
                    }
                    return true;
                }
            }, sharePath, Integer.MAX_VALUE, true, (IProgressMonitor)progress.newChild(25));
            if (!exceptions.isEmpty()) {
                MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaStore_15, null);
                for (FileSystemClientException ex : exceptions) {
                    multi.add(FileSystemStatus.getStatusFor((Throwable)((Object)ex)));
                }
                throw new FileSystemClientException((IStatus)multi);
            }
        } else {
            foundNewRootInRemoteSubtree[0] = this.getRemoteAncestorInternal(Collections.singleton(oldInfo.getRootFolder().getItemId()), (IVersionableHandle)newInfo.getRootFolder(), newInfo.getComponent(), newInfo.getConnectionHandle()) != null;
            oldRootInfo[0] = this.metadata.getFileItemInfo((IVersionableHandle)oldInfo.getRootFolder(), newInfo.getComponent(), newInfo.getConnectionHandle());
        }
        progress.setWorkRemaining(10);
        if (!oldRootInfo[0].getVersionableHandle().sameItemId((IItemHandle)newInfo.getRootFolder())) {
            IFolderHandle localParent;
            String localName;
            HashMap<UUID, InverseFileItemInfo> itemInfos = new HashMap<UUID, InverseFileItemInfo>();
            itemInfos.put(oldRootInfo[0].getVersionableHandle().getItemId(), oldRootInfo[0]);
            if (newRootInfo != null) {
                newRootInfo = this.metadata.getFileItemInfo((IVersionableHandle)newInfo.getRootFolder(), newInfo.getComponent(), newInfo.getConnectionHandle());
            }
            if (newRootInfo != null) {
                localName = newRootInfo.getLocalName();
                localParent = newRootInfo.getLocalParent();
            } else {
                localName = null;
                localParent = null;
            }
            if (foundNewRootInRemoteSubtree[0]) {
                itemInfos.put(newRootInfo.getVersionableHandle().getItemId(), newRootInfo);
                InverseFileItemInfo oldParentInfo = this.getFileItemInfo((IVersionableHandle)newRootInfo.getParent(), newInfo.getComponent(), newInfo.getConnectionHandle(), itemInfos);
                HashMap<String, IVersionableHandle> children = new HashMap<String, IVersionableHandle>(oldParentInfo.getRemoteChildren());
                children.remove(newRootInfo.getName());
                InverseFileItemInfo newParentInfo = new InverseFileItemInfo(oldParentInfo.getVersionableHandle(), oldParentInfo.getLastModification(), oldParentInfo.getParent(), oldParentInfo.getName(), Collections.unmodifiableMap(children), oldParentInfo.getLocalParent(), oldParentInfo.getLocalName(), oldParentInfo.getHash(), oldParentInfo.getContentLength(), oldParentInfo.getOriginalLineDelimiter(), oldParentInfo.getLineDelimiter(), oldParentInfo.getOriginalContentType(), oldParentInfo.getContentType(), oldParentInfo.getStoredContentId(), oldParentInfo.getStoredDeltaPredecessor(), oldParentInfo.getStoredSize(), oldParentInfo.getStoredEncoding(), oldParentInfo.getStoredChecksum(), oldParentInfo.getStoredNumLineDelimiters(), oldParentInfo.isExecutable(), oldParentInfo.isOriginalExecutable());
                itemInfos.put(newParentInfo.getVersionableHandle().getItemId(), newParentInfo);
            } else {
                newRootInfo = new InverseFileItemInfo((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(newInfo.getRootFolder().getItemId(), UUID.generate()), null, null, Collections.EMPTY_MAP, null, null);
                itemInfos.put(newRootInfo.getVersionableHandle().getItemId(), newRootInfo);
            }
            oldRootInfo[0] = this.getFileItemInfo(oldRootInfo[0].getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), itemInfos);
            HashMap<String, IVersionableHandle> children = new HashMap<String, IVersionableHandle>(newRootInfo.getRemoteChildren());
            String name = sharePath.lastSegment();
            while (children.containsKey(name)) {
                name = String.valueOf(name) + "0";
            }
            children.put(name, oldRootInfo[0].getVersionableHandle());
            IVersionableHandle newRootHandle = newRootInfo.getVersionableHandle().hasStateId() ? newRootInfo.getVersionableHandle() : (IVersionableHandle)newRootInfo.getVersionableHandle().getItemType().createItemHandle(newRootInfo.getVersionableHandle().getItemId(), UUID.generate());
            newRootInfo = new InverseFileItemInfo(newRootHandle, newRootInfo.getLastModification(), null, null, Collections.unmodifiableMap(children), null, null, newRootInfo.getHash(), newRootInfo.getContentLength(), newRootInfo.getOriginalLineDelimiter(), newRootInfo.getLineDelimiter(), newRootInfo.getOriginalContentType(), newRootInfo.getContentType(), newRootInfo.getStoredContentId(), newRootInfo.getStoredDeltaPredecessor(), newRootInfo.getStoredSize(), newRootInfo.getStoredEncoding(), newRootInfo.getStoredChecksum(), newRootInfo.getStoredNumLineDelimiters(), newRootInfo.isExecutable(), newRootInfo.isOriginalExecutable());
            itemInfos.put(newRootInfo.getVersionableHandle().getItemId(), newRootInfo);
            oldRootInfo[0] = new InverseFileItemInfo(oldRootInfo[0].getVersionableHandle(), oldRootInfo[0].getLastModification(), newInfo.getRootFolder(), name, oldRootInfo[0].getRemoteChildren(), localParent, localName, oldRootInfo[0].getHash(), oldRootInfo[0].getContentLength(), oldRootInfo[0].getOriginalLineDelimiter(), oldRootInfo[0].getLineDelimiter(), oldRootInfo[0].getOriginalContentType(), oldRootInfo[0].getContentType(), oldRootInfo[0].getStoredContentId(), oldRootInfo[0].getStoredDeltaPredecessor(), oldRootInfo[0].getStoredSize(), oldRootInfo[0].getStoredEncoding(), oldRootInfo[0].getStoredChecksum(), oldRootInfo[0].getStoredNumLineDelimiters(), oldRootInfo[0].isExecutable(), oldRootInfo[0].isOriginalExecutable());
            itemInfos.put(oldRootInfo[0].getVersionableHandle().getItemId(), oldRootInfo[0]);
            this.metadata.setFileItemInfo(sharePath, newRootInfo);
            if (pathToNewRootInOldComponent != null && sharePath.isPrefixOf(pathToNewRootInOldComponent)) {
                this.metadata.setFileItemInfo(pathToNewRootInOldComponent, oldRootInfo[0]);
            }
            this.adjustChildrenToNewParent(sharePath, newInfo.getRootFolder(), newInfo.getComponent(), newInfo.getConnectionHandle(), itemInfos, (IProgressMonitor)progress.newChild(5));
            if (pathToNewRootInOldComponent != null && sharePath.isPrefixOf(pathToNewRootInOldComponent)) {
                this.adjustChildrenToNewParent(pathToNewRootInOldComponent, (IFolderHandle)oldRootInfo[0].getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), itemInfos, (IProgressMonitor)progress.newChild(5));
            }
            for (InverseFileItemInfo info : itemInfos.values()) {
                this.metadata.setFileItemInfo(info.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), info);
            }
        }
        progress.done();
    }

    private void adjustChildrenToNewParent(IPath parentPath, IFolderHandle newParent, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache, IProgressMonitor monitor) throws FileSystemClientException {
        Map childMap = this.metadata.getChildInfos(parentPath);
        for (FileItemInfo entry : childMap.values()) {
            InverseFileItemInfo newInfo = this.getFileItemInfo(entry.getVersionableHandle(), component, connection, cache);
            newInfo = new InverseFileItemInfo(newInfo.getVersionableHandle(), newInfo.getLastModification(), newInfo.getParent(), newInfo.getName(), newInfo.getRemoteChildren(), newParent, newInfo.getLocalName(), newInfo.getHash(), newInfo.getContentLength(), newInfo.getOriginalLineDelimiter(), newInfo.getLineDelimiter(), newInfo.getOriginalContentType(), newInfo.getContentType(), newInfo.getStoredContentId(), newInfo.getStoredDeltaPredecessor(), newInfo.getStoredSize(), newInfo.getStoredEncoding(), newInfo.getStoredChecksum(), newInfo.getStoredNumLineDelimiters(), newInfo.isExecutable(), newInfo.isOriginalExecutable());
            cache.put(newInfo.getVersionableHandle().getItemId(), newInfo);
        }
    }

    private InverseFileItemInfo getFileItemInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache) throws FileSystemClientException {
        InverseFileItemInfo result = cache.get(item.getItemId());
        if (result != null) {
            return result;
        }
        result = this.metadata.getFileItemInfo(item, component, connection);
        if (result == null) {
            return null;
        }
        cache.put(item.getItemId(), result);
        return result;
    }

    public ISharingDescriptor getSharingInfo(IPath sharePath) {
        try {
            return this.metadata.getSharingDescriptor(sharePath);
        }
        catch (FileSystemClientException e) {
            LoggingHelper.log(e);
            return null;
        }
    }

    private ISharingDescriptor findSharingDescriptor(IShareable shareable) {
        return this.getSharingInfo(shareable.getLocalFullPath().removeLastSegments(shareable.getLocalFullPath().segmentCount() - 1));
    }

    public boolean isShareRoot(IFolderHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        return this.metadata.getPathForShareRoot(item, component, connection) != null;
    }

    public void removeSharingInfo(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        ISchedulingRule rule = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final IPath sharePath = shareable.getLocalFullPath();
        final ISharingDescriptor[] info = new ISharingDescriptor[1];
        final FileSystemClientException[] exception = new FileSystemClientException[1];
        try {
            rule = this.beginBatchingWithLock(null, new ILockParticipant(){

                public ISchedulingRule locking(ISchedulingRule rule) {
                    CopyFileAreaStore.this.sharingInfoLock.acquireWrite();
                    try {
                        info[0] = CopyFileAreaStore.this.metadata.getSharingDescriptor(sharePath);
                        rule = info[0] != null ? new ComponentLock(info[0].getConnectionHandle(), info[0].getComponent()) : null;
                        return rule;
                    }
                    catch (FileSystemClientException e) {
                        exception[0] = e;
                        return null;
                    }
                }

                public void waiting() {
                    CopyFileAreaStore.this.sharingInfoLock.release();
                }
            }, (IProgressMonitor)progress.newChild(1));
            if (exception[0] != null) {
                throw exception[0];
            }
            if (info[0] != null) {
                this.metadata.setSharingDescriptor(sharePath, null, (IProgressMonitor)progress.newChild(49));
                this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)info[0].getRootFolder(), shareable.getLocalFullPath(), 2));
                if (!this.metadata.hasShares(info[0].getComponent(), info[0].getConnectionHandle(), (IProgressMonitor)progress.newChild(49))) {
                    LocalChangeManager.getInstance().clearPendingChanges(info[0].getConnectionHandle(), info[0].getComponent(), this.getRoot());
                }
            } else {
                progress.setWorkRemaining(1);
            }
        }
        finally {
            this.sharingInfoLock.release();
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
        }
    }

    private RuleDescriptorPair beginBatching(final IShareable shareable, IProgressMonitor monitor) {
        final RuleDescriptorPair result = new RuleDescriptorPair();
        try {
            result.rule = this.beginBatchingWithLock(null, new ILockParticipant(){

                public ISchedulingRule locking(ISchedulingRule rule) {
                    CopyFileAreaStore.this.sharingInfoLock.acquireRead();
                    ISharingDescriptor desc = CopyFileAreaStore.this.findSharingDescriptor(shareable);
                    if (desc != null) {
                        result.desc = desc;
                        rule = new ComponentLock(desc.getConnectionHandle(), desc.getComponent());
                    } else {
                        result.desc = null;
                        rule = null;
                    }
                    return rule;
                }

                public void waiting() {
                    CopyFileAreaStore.this.sharingInfoLock.release();
                }
            }, monitor);
        }
        finally {
            this.sharingInfoLock.release();
        }
        return result;
    }

    public ISchedulingRule beginBatching(ISchedulingRule resourceRule, IProgressMonitor monitor) {
        return this.batchingLock.acquire(resourceRule, this, NULL_PARTICIPANT, true, monitor);
    }

    public ISchedulingRule beginBatchingWithLock(ISchedulingRule resourceRule, ILockParticipant participant, IProgressMonitor monitor) {
        return this.batchingLock.acquire(resourceRule, this, participant, true, monitor);
    }

    public ISchedulingRule beginBatchingNoWait(ISchedulingRule resourceRule) {
        return this.batchingLock.acquire(resourceRule, this, NULL_PARTICIPANT, false, null);
    }

    public ReadWriteLock getSharingLock() {
        return this.sharingInfoLock;
    }

    public void endBatching(ISchedulingRule rule, IProgressMonitor monitor) throws FileSystemClientException {
        this.batchingLock.release(rule, monitor);
    }

    @Override
    public void flush(BatchingLock.ThreadInfo info, IProgressMonitor monitor) {
        this.notifier.fireEvents(info.getEvents());
    }

    public void clear() throws FileSystemClientException {
        this.metadata.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getAllCopyFileAreas() {
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            ArrayList<CopyFileAreaStore> allAreas = new ArrayList<CopyFileAreaStore>(1 + localStores.size());
            if (instance != null) {
                allAreas.add(instance);
            }
            allAreas.addAll(localStores.values());
            // ** MonitorExit[var0] (shouldn't be in output)
            return allAreas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFileAreaExists(IPath root) {
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            block7: {
                if (root.segmentCount() == 0) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return instance != null;
                }
                if (root.equals((Object)SharingManager.getInstance().getDefaultCFARoot())) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return instance != null;
                }
                if (!localStores.containsKey(root)) break block7;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            root = CopyFileAreaStore.getCanonicalPath(root);
            if (root.equals((Object)SharingManager.getInstance().getDefaultCFARoot())) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance != null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localStores.containsKey(root);
        }
    }

    public boolean isConnectionShared(IContextHandle connection) throws FileSystemClientException {
        IPath[] allSharePaths = this.metadata.allShares();
        int i = 0;
        while (i < allSharePaths.length) {
            ISharingDescriptor descriptor = this.metadata.getSharingDescriptor(allSharePaths[i]);
            if (descriptor != null && descriptor.getConnectionHandle().sameItemId((IItemHandle)connection)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void accept(IRemoteVisitor metadataVisitor, IVersionableHandle item, IComponentHandle component, IContextHandle connection, ISchedulingRule rule, int depth, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (rule != null) {
                rule = this.beginBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            this.metadata.accept(metadataVisitor, item, component, connection, depth, rule != null, (IProgressMonitor)progress.newChild(98));
        }
        finally {
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
        }
    }

    public void accept(IVisitor metadataVisitor, IShareable shareable, ISchedulingRule rule, int depth, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (rule != null) {
                rule = this.beginBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            this.metadata.accept(metadataVisitor, shareable.getLocalFullPath(), depth, rule != null, (IProgressMonitor)progress.newChild(98));
        }
        finally {
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
        }
    }

    public IPath[] allSharePaths() throws FileSystemClientException {
        return this.metadata.allShares();
    }

    public void deleteTreeInfo(IShareable shareable, boolean removeRemoteInfo, IProgressMonitor monitor) throws FileSystemClientException {
        ISchedulingRule rule = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IContextHandle connection;
            IComponentHandle component;
            RuleDescriptorPair pair = this.beginBatching(shareable, (IProgressMonitor)progress.newChild(1));
            ISharingDescriptor desc = pair.desc;
            rule = pair.rule;
            if (desc != null) {
                component = desc.getComponent();
                connection = desc.getConnectionHandle();
            } else {
                component = null;
                connection = null;
            }
            this.deleteTreeInfoInternal(shareable.getLocalFullPath(), component, connection, removeRemoteInfo, (IProgressMonitor)progress.newChild(98));
        }
        catch (Throwable throwable) {
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
            throw throwable;
        }
        if (rule != null) {
            this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    public void deleteTreeInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        InverseFileItemInfo info;
        SubMonitor progress;
        ISchedulingRule rule;
        block8: {
            block9: {
                rule = null;
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                rule = this.beginBatching(new ComponentLock(connection, component), (IProgressMonitor)progress.newChild(1));
                info = this.metadata.getFileItemInfo(item, component, connection);
                if (info != null) break block8;
                if (rule == null) break block9;
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
            return;
        }
        try {
            this.updateParentInfoForRemoval(info, component, connection);
            ArrayList<IVersionableHandle> toDelete = new ArrayList<IVersionableHandle>();
            toDelete.add(item);
            do {
                IVersionableHandle itemToDelete;
                IPath localPath;
                if ((localPath = this.getLocalPathInternal(info = this.metadata.setFileItemInfo(itemToDelete = (IVersionableHandle)toDelete.remove(toDelete.size() - 1), component, connection, null), component, connection)) != null) {
                    InverseFileItemInfo newInfo = new InverseFileItemInfo((IVersionableHandle)info.getVersionableHandle().getItemType().createItemHandle(UUID.generate(), null), -1L, null, null, Collections.EMPTY_MAP, info.getLocalParent(), info.getLocalName(), null, -1L, null, info.getLineDelimiter(), null, info.getContentType(), null, null, -1L, null, -1L, -1L, info.isExecutable(), false);
                    this.metadata.setFileItemInfo(newInfo.getVersionableHandle(), component, connection, newInfo);
                    this.metadata.setFileItemInfo(localPath, newInfo);
                    if (info.isFolder()) {
                        this.updateLocalParent(localPath, (IFolderHandle)newInfo.getVersionableHandle(), component, connection);
                    }
                }
                toDelete.addAll(info.getRemoteChildren().values());
            } while (!toDelete.isEmpty());
        }
        catch (Throwable throwable) {
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
            throw throwable;
        }
        if (rule != null) {
            this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    private void deleteTreeInfoInternal(final IPath startingPath, final IComponentHandle component, final IContextHandle connection, boolean removeRemoteInfo, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final ArrayList exceptions = new ArrayList();
        final IVersionableHandle[] root = new IVersionableHandle[1];
        this.metadata.accept(new IVisitor(){

            public boolean visit(IPath path, FileItemInfo entry, IProgressMonitor monitor) {
                if (path.equals((Object)startingPath)) {
                    root[0] = entry.getVersionableHandle();
                }
                if (component != null) {
                    try {
                        InverseFileItemInfo info = CopyFileAreaStore.this.metadata.getFileItemInfo(entry.getVersionableHandle(), component, connection);
                        if (info.getVersionableHandle().hasStateId() != entry.getVersionableHandle().hasStateId() || info.getVersionableHandle().hasStateId() && !info.getVersionableHandle().sameStateId((IItemHandle)entry.getVersionableHandle())) {
                            throw new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_18, (Object)path));
                        }
                        if (info.getVersionableHandle().hasStateId()) {
                            InverseFileItemInfo newInfo = new InverseFileItemInfo(info.getVersionableHandle(), info.getLastModification(), info.getParent(), info.getName(), info.getRemoteChildren(), null, null, info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredContentId(), info.getStoredDeltaPredecessor(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredChecksum(), info.getStoredNumLineDelimiters(), info.isOriginalExecutable(), info.isOriginalExecutable());
                            CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), component, connection, newInfo);
                        } else {
                            CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), component, connection, null);
                        }
                    }
                    catch (FileSystemClientException e) {
                        exceptions.add(e);
                    }
                }
                return true;
            }
        }, startingPath, Integer.MAX_VALUE, true, (IProgressMonitor)progress.newChild(33));
        if (component != null && removeRemoteInfo && root[0] != null && root[0].hasStateId()) {
            this.metadata.accept(new IRemoteVisitor(){

                public boolean visit(IPath path, InverseFileItemInfo entry, IProgressMonitor monitor) {
                    try {
                        if (entry.getVersionableHandle().sameItemId((IItemHandle)root[0])) {
                            CopyFileAreaStore.this.updateParentInfoForRemoval(entry, component, connection);
                        }
                        if (entry.getLocalParent() != null) {
                            InverseFileItemInfo newInfo = new InverseFileItemInfo((IVersionableHandle)entry.getVersionableHandle().getItemType().createItemHandle(UUID.generate(), null), -1L, null, null, Collections.EMPTY_MAP, entry.getLocalParent(), entry.getLocalName(), null, -1L, null, entry.getLineDelimiter(), null, entry.getContentType(), null, null, -1L, null, -1L, -1L, entry.isExecutable(), false);
                            IPath localPath = CopyFileAreaStore.this.getLocalPathInternal(entry, component, connection);
                            if (entry.getVersionableHandle() instanceof IFolderHandle) {
                                CopyFileAreaStore.this.updateLocalParent(localPath, (IFolderHandle)newInfo.getVersionableHandle(), component, connection);
                            }
                            CopyFileAreaStore.this.metadata.setFileItemInfo(localPath, newInfo);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(newInfo.getVersionableHandle(), component, connection, newInfo);
                        }
                        CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), component, connection, null);
                    }
                    catch (FileSystemClientException e) {
                        exceptions.add(e);
                    }
                    return true;
                }
            }, root[0], component, connection, Integer.MAX_VALUE, true, (IProgressMonitor)progress.newChild(34));
        } else {
            progress.setWorkRemaining(33);
        }
        this.metadata.deleteFileItemInfo(startingPath, (IProgressMonitor)progress.newChild(33));
        if (!exceptions.isEmpty()) {
            MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaStore_19, null);
            for (FileSystemClientException ex : exceptions) {
                multi.add(FileSystemStatus.getStatusFor((Throwable)((Object)ex)));
            }
            throw new FileSystemClientException((IStatus)multi);
        }
    }

    public void moveTreeInfo(IShareable source, IShareable destination, boolean remoteMove, IProgressMonitor monitor) throws FileSystemClientException {
        ISchedulingRule rule = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            RuleDescriptorPair pair = this.beginBatching(source, (IProgressMonitor)progress.newChild(1));
            ISharingDescriptor desc = pair.desc;
            rule = pair.rule;
            ISharingDescriptor destDesc = this.findSharingDescriptor(destination);
            Assert.isTrue((destDesc != null && destDesc.getConnectionHandle().sameItemId((IItemHandle)desc.getConnectionHandle()) && destDesc.getComponent().sameItemId((IItemHandle)desc.getComponent()) ? 1 : 0) != 0);
            IPath sourcePath = source.getLocalFullPath();
            IPath destinationPath = destination.getLocalFullPath();
            FileItemInfo info = this.metadata.getFileItemInfo(sourcePath);
            if (info != null) {
                String remoteName;
                IFolderHandle remoteParent;
                String name;
                IFolderHandle parent;
                FileItemInfo parentInfo = this.metadata.getFileItemInfo(destinationPath.removeLastSegments(1));
                if (parentInfo == null) {
                    parent = null;
                    name = null;
                } else {
                    parent = (IFolderHandle)parentInfo.getVersionableHandle();
                    name = destinationPath.lastSegment();
                }
                if (remoteMove) {
                    remoteParent = parent;
                    remoteName = name;
                } else {
                    remoteParent = info.getParent();
                    remoteName = info.getName();
                }
                InverseFileItemInfo oldInverseInfo = this.metadata.getFileItemInfo(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                InverseFileItemInfo newInfo = new InverseFileItemInfo(info.getVersionableHandle(), info.getLastModification(), remoteParent, remoteName, oldInverseInfo.getRemoteChildren(), parent, name, info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredContentId(), info.getStoredDeltaPredecessor(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredChecksum(), info.getStoredNumLineDelimiters(), parent == null ? info.isOriginalExecutable() : info.isExecutable(), info.isOriginalExecutable());
                this.updateParentInfoForChange(newInfo, info, desc.getComponent(), desc.getConnectionHandle());
                this.metadata.setFileItemInfo(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), newInfo);
                if (remoteMove) {
                    this.metadata.setFileItemInfo(sourcePath, newInfo);
                }
            }
            this.metadata.moveFileItemInfo(sourcePath, destination.getLocalFullPath());
        }
        catch (Throwable throwable) {
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
            throw throwable;
        }
        if (rule != null) {
            this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    public void run(ISchedulingRule rule, IOperation operation, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            rule = this.beginBatching(rule, (IProgressMonitor)progress.newChild(1));
            operation.execute((IProgressMonitor)progress.newChild(98));
        }
        finally {
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
        }
    }

    public void run(final IOperation operation, final IProgressMonitor monitor) throws FileSystemClientException {
        this.metadata.run(new ISharingMetadata.ITransaction(){

            public void run() throws FileSystemClientException {
                operation.execute(monitor);
            }
        });
    }

    public String toDebugString() {
        return this.metadata.toDebugString();
    }

    public ISharingMetadata getMetadata() {
        return this.metadata;
    }

    public void close() throws FileSystemClientException {
        this.metadata.close();
        CopyFileAreaStore.removeCopyFileArea(this.path);
    }

    public void sync() throws FileSystemClientException {
        this.metadata.close();
    }

    public IPath getRoot() {
        return this.path;
    }

    public boolean isCaseSensitive() {
        return this.metadata.isCaseSensitive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeCopyFileArea(IPath path) {
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            CopyFileAreaStore store = null;
            store = localStores.remove(path);
            if (path.equals((Object)SharingManager.getInstance().getDefaultCFARoot())) {
                Assert.isTrue((store == null ? 1 : 0) != 0);
                store = instance;
                instance = null;
            }
            for (ICorruptCopyFileAreaListener listener : listeners) {
                store.metadata.removeCorruptionListener(listener);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static IPath getCanonicalPath(IPath path) {
        try {
            return new Path(path.toFile().getCanonicalPath());
        }
        catch (IOException iOException) {
            return path;
        }
    }

    public static Object beginAvoidNotify() {
        Collection allStores = CopyFileAreaStore.getAllCopyFileAreas();
        for (CopyFileAreaStore store : allStores) {
            store.beginBatching(BatchingLock.AVOID_NOTIFICATION_RULE, null);
        }
        return allStores;
    }

    public static void endAvoidNotify(Object beginNotifyToken) throws FileSystemClientException {
        if (!(beginNotifyToken instanceof Collection)) {
            throw new IllegalArgumentException();
        }
        Collection allStores = (Collection)beginNotifyToken;
        for (Object content : allStores) {
            if (!(content instanceof CopyFileAreaStore)) {
                throw new IllegalArgumentException();
            }
            CopyFileAreaStore store = (CopyFileAreaStore)content;
            store.endBatching(BatchingLock.AVOID_NOTIFICATION_RULE, null);
        }
    }

    public void setConfigurationState(final IContextHandle connectionHandle, final IComponentHandle component, ISyncTime beforeConfigurationState, ISyncTime configurationState, IProgressMonitor monitor) throws FileSystemClientException {
        ISchedulingRule rule = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            rule = this.beginBatchingWithLock(null, new ILockParticipant(){

                public ISchedulingRule locking(ISchedulingRule rule) {
                    CopyFileAreaStore.this.sharingInfoLock.acquireWrite();
                    return new ComponentLock(connectionHandle, component);
                }

                public void waiting() {
                    CopyFileAreaStore.this.sharingInfoLock.release();
                }
            }, (IProgressMonitor)progress.newChild(1));
            Map<IPath, ISharingDescriptor> sharingDescriptors = this.metadata.getSharingDescriptors(component, connectionHandle);
            SubMonitor subProgress = progress.newChild(98);
            subProgress.setWorkRemaining(sharingDescriptors.size());
            for (Map.Entry<IPath, ISharingDescriptor> entry : sharingDescriptors.entrySet()) {
                ISharingDescriptor descriptor = entry.getValue();
                IPath sharePath = entry.getKey();
                this.updateConfigurationState(sharePath, descriptor, beforeConfigurationState, configurationState, subProgress);
            }
            subProgress.done();
        }
        finally {
            this.sharingInfoLock.release();
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
        }
    }

    private void updateConfigurationState(IPath sharePath, ISharingDescriptor sharingDescriptor, ISyncTime beforeConfigurationState, ISyncTime configurationState, SubMonitor subProgress) throws FileSystemClientException {
        SharingDescriptor descriptor = (SharingDescriptor)sharingDescriptor;
        if (beforeConfigurationState == null || beforeConfigurationState.equals(descriptor.getConfigurationState())) {
            SharingDescriptor newDescriptor = new SharingDescriptor(descriptor, configurationState);
            this.metadata.setSharingDescriptor(sharePath, newDescriptor, (IProgressMonitor)subProgress.newChild(1));
            this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)newDescriptor.getRootFolder(), sharePath, 6));
        } else if (configurationState.equals(descriptor.getConfigurationState())) {
            subProgress.worked(1);
        } else if (descriptor.isUnknownState()) {
            SharingDescriptor newDescriptor = new SharingDescriptor(descriptor, ISyncTime.TIME_NONE);
            this.metadata.setSharingDescriptor(sharePath, newDescriptor, (IProgressMonitor)subProgress.newChild(1));
            this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)newDescriptor.getRootFolder(), sharePath, 6));
        }
    }

    public void setConfigurationState(final IContextHandle connectionHandle, final IComponentHandle component, IFolderHandle shareRootItem, ISyncTime configurationState, IProgressMonitor monitor) throws FileSystemClientException {
        ISchedulingRule rule = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            SharingDescriptor descriptor;
            rule = this.beginBatchingWithLock(null, new ILockParticipant(){

                public ISchedulingRule locking(ISchedulingRule rule) {
                    CopyFileAreaStore.this.sharingInfoLock.acquireWrite();
                    return new ComponentLock(connectionHandle, component);
                }

                public void waiting() {
                    CopyFileAreaStore.this.sharingInfoLock.release();
                }
            }, (IProgressMonitor)progress.newChild(1));
            IPath sharePath = this.getLocalPathInternal((IVersionableHandle)shareRootItem, component, connectionHandle);
            if (sharePath != null && (descriptor = (SharingDescriptor)this.metadata.getSharingDescriptor(sharePath)) != null && !configurationState.equals(descriptor.getConfigurationState())) {
                SharingDescriptor newDescriptor = new SharingDescriptor(descriptor, configurationState);
                this.metadata.setSharingDescriptor(sharePath, newDescriptor, (IProgressMonitor)progress.newChild(98));
                this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)newDescriptor.getRootFolder(), sharePath, 6));
            }
            progress.setWorkRemaining(1);
        }
        finally {
            this.sharingInfoLock.release();
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
        }
    }

    public void setConfigurationState(final IContextHandle connectionHandle, final IComponentHandle component, IPath sharePath, ISyncTime beforeConfigurationState, ISyncTime configurationState, IProgressMonitor monitor) throws FileSystemClientException {
        ISchedulingRule rule = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            rule = this.beginBatchingWithLock(null, new ILockParticipant(){

                public ISchedulingRule locking(ISchedulingRule rule) {
                    CopyFileAreaStore.this.sharingInfoLock.acquireWrite();
                    return new ComponentLock(connectionHandle, component);
                }

                public void waiting() {
                    CopyFileAreaStore.this.sharingInfoLock.release();
                }
            }, (IProgressMonitor)progress.newChild(1));
            ISharingDescriptor descriptor = this.metadata.getSharingDescriptor(sharePath);
            if (descriptor != null && descriptor.getComponent().sameItemId((IItemHandle)component) && descriptor.getConnectionHandle().sameItemId((IItemHandle)connectionHandle)) {
                this.updateConfigurationState(sharePath, descriptor, beforeConfigurationState, configurationState, progress.newChild(98));
            }
            progress.setWorkRemaining(1);
        }
        finally {
            this.sharingInfoLock.release();
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
        }
    }

    public void setConfigurationState(final IContextHandle connectionHandle, final IComponentHandle component, IPath sharePath, ISyncTime configurationState, IProgressMonitor monitor) throws FileSystemClientException {
        ISchedulingRule rule = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            rule = this.beginBatchingWithLock(null, new ILockParticipant(){

                public ISchedulingRule locking(ISchedulingRule rule) {
                    CopyFileAreaStore.this.sharingInfoLock.acquireWrite();
                    return new ComponentLock(connectionHandle, component);
                }

                public void waiting() {
                    CopyFileAreaStore.this.sharingInfoLock.release();
                }
            }, (IProgressMonitor)progress.newChild(1));
            SharingDescriptor descriptor = (SharingDescriptor)this.metadata.getSharingDescriptor(sharePath);
            if (descriptor != null && descriptor.getComponent().sameItemId((IItemHandle)component) && descriptor.getConnectionHandle().sameItemId((IItemHandle)connectionHandle) && !configurationState.equals(descriptor.getConfigurationState())) {
                SharingDescriptor newDescriptor = new SharingDescriptor(descriptor, configurationState);
                this.metadata.setSharingDescriptor(sharePath, newDescriptor, (IProgressMonitor)progress.newChild(98));
                this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)newDescriptor.getRootFolder(), sharePath, 6));
            }
            progress.setWorkRemaining(1);
        }
        finally {
            this.sharingInfoLock.release();
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
        }
    }

    public void setUnknownConfigurationState(final IContextHandle connectionHandle, final IComponentHandle component, Path sharePath, IProgressMonitor monitor) throws FileSystemClientException {
        ISchedulingRule rule = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            rule = this.beginBatchingWithLock(null, new ILockParticipant(){

                public ISchedulingRule locking(ISchedulingRule rule) {
                    CopyFileAreaStore.this.sharingInfoLock.acquireWrite();
                    return new ComponentLock(connectionHandle, component);
                }

                public void waiting() {
                    CopyFileAreaStore.this.sharingInfoLock.release();
                }
            }, (IProgressMonitor)progress.newChild(1));
            SharingDescriptor descriptor = (SharingDescriptor)this.metadata.getSharingDescriptor((IPath)sharePath);
            if (descriptor != null && descriptor.getComponent().sameItemId((IItemHandle)component) && descriptor.getConnectionHandle().sameItemId((IItemHandle)connectionHandle)) {
                SharingDescriptor newDescriptor = new SharingDescriptor(descriptor, ISyncTime.TIME_NONE);
                this.metadata.setSharingDescriptor((IPath)sharePath, newDescriptor, (IProgressMonitor)progress.newChild(98));
                this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)newDescriptor.getRootFolder(), (IPath)sharePath, 6));
            }
            progress.setWorkRemaining(1);
        }
        finally {
            this.sharingInfoLock.release();
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
        }
    }

    public boolean isLoaded(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        return this.metadata.isLoaded(component, connection, monitor);
    }

    public Collection<LoadedConfigurationDescriptor> allLoadedComponents(IProgressMonitor monitor) throws FileSystemClientException {
        return this.metadata.allLoadedComponents(monitor);
    }

    public Collection<ConnectionDescriptor> allLoadedContexts(IProgressMonitor monitor) throws FileSystemClientException {
        return this.metadata.allLoadedContexts(monitor);
    }

    public void componentLoaded(LoadedConfigurationDescriptor desc, IProgressMonitor monitor) throws FileSystemClientException {
        ISchedulingRule rule = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            boolean alreadyLoaded;
            rule = this.beginBatching(new ComponentLock(desc.connectionHandle, desc.componentHandle), (IProgressMonitor)progress.newChild(1));
            boolean bl = alreadyLoaded = this.metadata.componentLoaded(desc, (IProgressMonitor)progress.newChild(98)) != null;
            if (!alreadyLoaded) {
                this.batchingLock.addChange(new CopyFileAreaEvent(null, null, 7));
            }
        }
        catch (Throwable throwable) {
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
            throw throwable;
        }
        if (rule != null) {
            this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    public void componentUnloaded(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        ISchedulingRule rule = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            boolean wasLoaded;
            rule = this.beginBatching(new ComponentLock(connection, component), (IProgressMonitor)progress.newChild(1));
            if (this.metadata.hasShares(component, connection, (IProgressMonitor)progress.newChild(49))) {
                throw new FileSystemClientException(new FileSystemStatus(Messages.CopyFileAreaStore_20));
            }
            boolean bl = wasLoaded = this.metadata.componentUnloaded(component, connection, (IProgressMonitor)progress.newChild(49)) != null;
            if (wasLoaded) {
                this.batchingLock.addChange(new CopyFileAreaEvent(null, null, 8));
            }
        }
        catch (Throwable throwable) {
            if (rule != null) {
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
            throw throwable;
        }
        if (rule != null) {
            this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    public boolean isCorrupted() {
        return this.metadata.isCorrupted();
    }

    public int getNumShares(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        int n;
        SubMonitor progress;
        block3: {
            ISchedulingRule rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                rule = this.beginBatching(new ComponentLock(connection, component), (IProgressMonitor)progress.newChild(1));
                n = this.metadata.getSharingDescriptors(component, connection).size();
                if (rule == null) break block3;
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
        }
        progress.done();
        return n;
    }

    public Collection<ISharingDescriptor> getShares(IContextHandle context, IComponentHandle component, IProgressMonitor monitor) throws FileSystemClientException {
        Collection<ISharingDescriptor> collection;
        SubMonitor progress;
        block3: {
            ISchedulingRule rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                rule = this.beginBatching(new ComponentLock(context, component), (IProgressMonitor)progress.newChild(1));
                collection = this.metadata.getSharingDescriptors(component, context).values();
                if (rule == null) break block3;
                this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    this.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
        }
        progress.done();
        return collection;
    }

    private static class ComponentLock
    implements ISchedulingRule {
        private IComponentHandle component;
        private IContextHandle connection;

        public ComponentLock(IContextHandle connectableHandle, IComponentHandle component) {
            this.component = component;
            this.connection = connectableHandle;
        }

        public boolean contains(ISchedulingRule rule) {
            if (this == rule) {
                return true;
            }
            if (rule instanceof MultiRule) {
                MultiRule multi = (MultiRule)rule;
                ISchedulingRule[] children = multi.getChildren();
                int i = 0;
                while (i < children.length) {
                    if (!this.contains(children[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (!(rule instanceof ComponentLock)) {
                return false;
            }
            ComponentLock other = (ComponentLock)rule;
            return this.component.sameItemId((IItemHandle)other.component) && this.connection.sameItemId((IItemHandle)other.connection);
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (!(rule instanceof ComponentLock)) {
                return false;
            }
            ComponentLock other = (ComponentLock)rule;
            return this.component.sameItemId((IItemHandle)other.component) && this.connection.sameItemId((IItemHandle)other.connection);
        }
    }

    public static interface IOperation {
        public void execute(IProgressMonitor var1) throws FileSystemClientException;
    }

    private static class RuleDescriptorPair {
        protected ISchedulingRule rule;
        protected ISharingDescriptor desc;

        private RuleDescriptorPair() {
        }
    }
}

