/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CopyFileAreaNotifier
extends Job {
    private static final int SCHEDULING_DELAY = 1000;
    private List collectedEvents = new ArrayList();
    private ListenerList listeners = new ListenerList();
    private volatile long latestRequest;

    public CopyFileAreaNotifier() {
        super(Messages.CopyFileAreaNotifier_0);
        this.setSystem(true);
        this.setPriority(30);
    }

    public void addListener(ICopyFileAreaListener listener) {
        this.listeners.add((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvents(ICopyFileAreaEvent[] events) {
        if (events.length == 0) {
            return;
        }
        CopyFileAreaNotifier copyFileAreaNotifier = this;
        synchronized (copyFileAreaNotifier) {
            this.collectedEvents.addAll((Collection)Arrays.asList(events));
        }
        this.latestRequest = System.currentTimeMillis();
        this.schedule(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        ICopyFileAreaEvent[] events;
        if (System.currentTimeMillis() - this.latestRequest < 1000L) {
            this.schedule(1000L);
            return Status.CANCEL_STATUS;
        }
        final MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaNotifier_1, null);
        Object[] allListeners = this.listeners.getListeners();
        CopyFileAreaNotifier copyFileAreaNotifier = this;
        synchronized (copyFileAreaNotifier) {
            events = this.collectedEvents.toArray(new ICopyFileAreaEvent[this.collectedEvents.size()]);
            this.collectedEvents.clear();
        }
        if (events.length == 0) {
            return Status.OK_STATUS;
        }
        int i = 0;
        while (i < allListeners.length) {
            final ICopyFileAreaListener listener = (ICopyFileAreaListener)allListeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    result.add(FileSystemStatus.getStatusFor(4, "com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaNotifier_2, exception));
                }

                public void run() throws Exception {
                    listener.change(events);
                }
            });
            ++i;
        }
        return result.isOK() ? Status.OK_STATUS : result;
    }

    public void removeListener(ICopyFileAreaListener listener) {
        this.listeners.remove((Object)listener);
    }
}

