/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IMetadataChangeTracker;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.InstantiationLock;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataChangeTracker;
import com.ibm.team.filesystem.client.internal.RestoreVersionableOperation;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ShareableFile;
import com.ibm.team.filesystem.client.internal.SharingMetadata2;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.filesystem.client.internal.load.LocalFileSystemUpdateMutator;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.NoOpChange;
import com.ibm.team.filesystem.client.internal.operations.LocalFileSystemVerifySharesOperation;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharingManager
implements ISharingManager {
    public static final UUID UNKNOWN_CONFIGURATION_STATE_UUID = UUID.valueOf((String)"_R9t0ULhfEduBzK-rvZth-A");
    public static final UUID NEW_CONFIGURATION_STATE_UUID = UUID.valueOf((String)"_EHcPcCUoEdyQ476u2X18-Q");
    private static final ThreadLocal changeMonitoring = new ThreadLocal(){

        protected Object initialValue() {
            return new Integer(0);
        }
    };
    private static SharingManager instance;
    public static final String PT_SHARING_MANAGER = "sharingManager";
    private static final String SCM_PRIVATE = ".jazz3";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharingManager getInstance() {
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client", PT_SHARING_MANAGER);
            if (configs.length > 1) {
                LoggingHelper.error("com.ibm.team.filesystem.client", "Only one sharing manager implementation can be registered", null);
            } else if (configs.length == 1) {
                try {
                    instance = (SharingManager)configs[0].createExecutableExtension("class");
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return instance;
                }
                catch (CoreException e) {
                    LoggingHelper.log(e);
                }
            }
            instance = new SharingManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected SharingManager() {
        instance = this;
    }

    public Share getShare(IShareable shareable) {
        return this.getShare(shareable.getRoot(), shareable.getLocalFullPath());
    }

    public Share getShare(IPath cfaRoot, IPath path) {
        ISharingDescriptor sharingDescriptor = null;
        path = path.removeLastSegments(path.segmentCount() - 1);
        CopyFileAreaStore copyFileArea = CopyFileAreaStore.getCopyFileArea(cfaRoot);
        sharingDescriptor = copyFileArea.getSharingInfo(path);
        if (sharingDescriptor == null) {
            return null;
        }
        return this.createShare(sharingDescriptor, path, copyFileArea);
    }

    public Share getShare(CopyFileAreaStore cfa, String shareName) {
        Assert.isNotNull((Object)cfa);
        Path sharePath = new Path(shareName);
        ISharingDescriptor sharingDescriptor = cfa.getSharingInfo((IPath)sharePath);
        if (sharingDescriptor == null) {
            return null;
        }
        return this.createShare(sharingDescriptor, (IPath)sharePath, cfa);
    }

    public FileItemInfo getItemInfo(IShareable shareable) {
        return CopyFileAreaStore.getCopyFileArea(shareable.getRoot()).getItemInfo(shareable.getLocalFullPath());
    }

    public void setItemInfo(IShareable shareable, FileItemInfo info, IProgressMonitor monitor) throws FileSystemClientException {
        CopyFileAreaStore.getCopyFileArea(shareable.getRoot()).setItemInfo(shareable, info, monitor);
    }

    public static ISchedulingRule getSchedulingRule(IShareable shareable) {
        return CopyFileAreaStore.getSchedulingRule(shareable);
    }

    public ISchedulingRule getExternalSchedulingRule(IShareable shareable) {
        return null;
    }

    public IShare share(Shareable shareable, ISharingDescriptor descriptor, boolean overwrite, boolean loadChanges, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IPath sharePath = shareable.getLocalFullPath();
        if (!shareable.getFileStorage().isFolder()) {
            throw new IllegalArgumentException(sharePath + " cannot be shared. Only Folders can be shared");
        }
        if (!descriptor.getRootFolder().hasStateId()) {
            throw new IllegalArgumentException(sharePath + " cannot be shared. Root folder has no state id");
        }
        Share existing = this.getShare(shareable);
        if (existing != null) {
            if (overwrite) {
                this.forget(shareable, (IProgressMonitor)progress.newChild(50));
            } else {
                FileSystemStatus status = existing.getSharingDescriptor() != null && descriptor.getConnectionHandle().sameItemId((IItemHandle)existing.getSharingDescriptor().getConnectionHandle()) ? new FileSystemStatus(4, 334, NLS.bind((String)Messages.SharingManager_0, (Object[])new Object[]{sharePath})) : new FileSystemStatus(4, 366, NLS.bind((String)Messages.SharingManager_1, (Object[])new Object[]{sharePath}));
                throw new FileSystemClientException(status);
            }
        }
        progress.setWorkRemaining(loadChanges ? 300 : 100);
        CopyFileAreaStore copyFileArea = CopyFileAreaStore.getCopyFileArea(shareable.getRoot());
        copyFileArea.setSharingInfo(shareable, descriptor, (IProgressMonitor)progress.newChild(50));
        copyFileArea.setItemInfo(shareable, new FileItemInfo(descriptor.getRootFolder(), null, null), (IProgressMonitor)progress.newChild(50));
        Share share = this.createShare(descriptor, sharePath, copyFileArea);
        if (loadChanges && this.isChangeMonitoringEnabled()) {
            LocalChangeManager.getInstance().loadChanges(share, (IProgressMonitor)progress.newChild(200));
        }
        progress.done();
        return share;
    }

    @Override
    public IShare[] allShares(IPath root) throws FileSystemClientException {
        return this.getAllShares(CopyFileAreaStore.getCopyFileArea(root));
    }

    public IShare[] allShares(CopyFileAreaStore cfa) throws FileSystemClientException {
        return this.getAllShares(cfa);
    }

    @Override
    public IShare[] allShares() throws FileSystemClientException {
        return this.getAllShares(CopyFileAreaStore.getDefaultCopyFileArea());
    }

    private IShare[] getAllShares(CopyFileAreaStore cfa) throws FileSystemClientException {
        IPath[] sharePaths = cfa.allSharePaths();
        ArrayList<Share> result = new ArrayList<Share>(sharePaths.length);
        int i = 0;
        while (i < sharePaths.length) {
            ISharingDescriptor descriptor = cfa.getSharingInfo(sharePaths[i]);
            if (descriptor != null) {
                result.add(this.createShare(descriptor, sharePaths[i], cfa));
            }
            ++i;
        }
        return result.toArray(new IShare[result.size()]);
    }

    protected Share createShare(ISharingDescriptor descriptor, IPath sharePath, CopyFileAreaStore cfa) {
        return new Share(descriptor, sharePath, cfa);
    }

    public boolean isShared(IShareable shareable) {
        return this.getShare(shareable) != null;
    }

    public int getState(IShareable shareable) {
        IVersionableHandle versionable;
        int mask = 0;
        Shareable shareableImpl = (Shareable)shareable;
        if (shareableImpl.isLocal()) {
            mask |= 8;
        }
        if (!this.isShared(shareable)) {
            return mask;
        }
        mask |= 1;
        IFileStorage fileStorage = shareableImpl.getFileStorage();
        FileItemInfo itemInfo = null;
        itemInfo = CopyFileAreaStore.getCopyFileArea(shareable.getRoot()).getItemInfo(fileStorage.getFullPath());
        if (itemInfo != null && itemInfo.isFolder() == shareableImpl.getFileStorage().isFolder() && (versionable = itemInfo.getVersionableHandle()).hasStateId()) {
            mask |= 2;
            if (!itemInfo.isFolder() && (itemInfo.getLastModification() == -1L || fileStorage.getModificationStamp() != itemInfo.getLastModification() || itemInfo.getOriginalLineDelimiter() != itemInfo.getLineDelimiter() || itemInfo.getOriginalContentType() == null && itemInfo.getContentType() != null || itemInfo.getOriginalContentType() != null && !itemInfo.getOriginalContentType().equals(itemInfo.getContentType()) || itemInfo.isOriginalExecutable() != fileStorage.isExecutable())) {
                mask |= 4;
            }
        }
        return mask;
    }

    public void clear() throws FileSystemClientException {
        Collection copyFileAreas = CopyFileAreaStore.getAllCopyFileAreas();
        Iterator iCopyFileAreas = copyFileAreas.iterator();
        while (iCopyFileAreas.hasNext()) {
            ((CopyFileAreaStore)iCopyFileAreas.next()).clear();
        }
    }

    public void shutDown() throws FileSystemClientException {
        Collection allCFA = CopyFileAreaStore.getAllCopyFileAreas();
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        for (CopyFileAreaStore cfa : allCFA) {
            try {
                cfa.close();
            }
            catch (Exception e) {
                errors.add(FileSystemStatus.getStatusFor(e));
            }
        }
        int size = errors.size();
        if (size != 0) {
            throw new FileSystemClientException((IStatus)new MultiStatus("com.ibm.team.filesystem.client", 0, errors.toArray(new IStatus[size]), Messages.SharingManager_2, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void conditionalShutDown() throws FileSystemClientException {
        SharingManager myInstance = null;
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            if (instance != null) {
                myInstance = SharingManager.getInstance();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (myInstance != null) {
                myInstance.shutDown();
            }
            return;
        }
    }

    @Override
    public void addListener(IPath copyFileAreaRoot, ICopyFileAreaListener listener) {
        CopyFileAreaStore.getCopyFileArea(copyFileAreaRoot).addListener(listener);
    }

    @Override
    public void addListener(ICopyFileAreaListener listener) {
        CopyFileAreaStore.getDefaultCopyFileArea().addListener(listener);
    }

    @Override
    public void removeListener(IPath copyFileAreaRoot, ICopyFileAreaListener listener) {
        CopyFileAreaStore.getCopyFileArea(copyFileAreaRoot).removeListener(listener);
    }

    @Override
    public void removeListener(ICopyFileAreaListener listener) {
        CopyFileAreaStore.getDefaultCopyFileArea().removeListener(listener);
    }

    public void forget(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        IShare share = shareable.getShare();
        boolean unshare = share != null && share.getPath().equals((Object)shareable.getLocalFullPath());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(unshare ? 100 : 50));
        CopyFileAreaStore.getCopyFileArea(shareable.getRoot()).deleteTreeInfo(shareable, true, (IProgressMonitor)progress.newChild(50));
        if (unshare) {
            CopyFileAreaStore.getCopyFileArea(shareable.getRoot()).removeSharingInfo(shareable, (IProgressMonitor)progress.newChild(50));
        }
        progress.done();
    }

    @Override
    public boolean isConnectionShared(IPath copyFileAreaRoot, IContextHandle connection) throws FileSystemClientException {
        return CopyFileAreaStore.getCopyFileArea(copyFileAreaRoot).isConnectionShared(connection);
    }

    @Override
    public boolean isConnectionShared(IContextHandle connection) throws FileSystemClientException {
        return CopyFileAreaStore.getDefaultCopyFileArea().isConnectionShared(connection);
    }

    public ITeamRepository getRepository(IShare share) {
        ISharingDescriptor desc = share.getSharingDescriptor();
        return RepositoryUtils.getTeamRepository(desc.getRepositoryUri(), desc.getRepositoryId());
    }

    public void disableChangeMonitoring() {
        changeMonitoring.set(new Integer((Integer)changeMonitoring.get() + 1));
    }

    public void enableChangeMonitoring() {
        int level = (Integer)changeMonitoring.get();
        if (level == 0) {
            throw new IllegalStateException();
        }
        changeMonitoring.set(new Integer(level - 1));
    }

    public boolean isChangeMonitoringEnabled() {
        return (Integer)changeMonitoring.get() == 0;
    }

    public ISharingMetadata createSharingMetadata(IPath root) {
        Assert.isLegal((root != null ? 1 : 0) != 0);
        IPath metadataPath = this.getMetadataPathForRoot(root);
        return new MetadataChangeTracker(new SharingMetadata2(root, metadataPath), root, metadataPath);
    }

    public IPath getMetadataPathForRoot(IPath root) {
        return root.append(SCM_PRIVATE);
    }

    public IMetadataChangeTracker getChangeTracker(CopyFileAreaStore cfa) {
        return (IMetadataChangeTracker)((Object)cfa.getMetadata());
    }

    public CopyFileAreaStore findCopyFileArea(IPath cfaPath) {
        return CopyFileAreaStore.getCopyFileArea(cfaPath);
    }

    @Override
    public ILocalChangeManager getLocalChangeManager() {
        return LocalChangeManager.getInstance();
    }

    public ILocalChange getChange(Shareable shareable) {
        boolean isShared;
        IShare share = shareable.getShare();
        boolean bl = isShared = share != null;
        if (!isShared) {
            return NoOpChange.NO_OP;
        }
        if (shareable.shouldBeIgnored()) {
            return null;
        }
        ISharingDescriptor descriptor = share.getSharingDescriptor();
        ILocalChange pendingChange = LocalChangeManager.getInstance().getPendingChange(descriptor.getConnectionHandle(), descriptor.getComponent(), shareable);
        return pendingChange == null ? NoOpChange.NO_OP : pendingChange;
    }

    public boolean shouldIgnore(CopyFileAreaStore cfa, IPath path, boolean folder) {
        return false;
    }

    public final void doSilentChange(CoreRunnable runnable) throws CoreException {
        SharingManager.getInstance().disableChangeMonitoring();
        try {
            runnable.run();
        }
        finally {
            SharingManager.getInstance().enableChangeMonitoring();
        }
    }

    @Override
    public IPath getDefaultCFARoot() {
        return null;
    }

    @Override
    public List findShareables(IPath copyFileAreaRoot, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemClientException {
        if (versionable == null) {
            throw new IllegalArgumentException();
        }
        if (copyFileAreaRoot == null) {
            throw new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection paths = CopyFileAreaStore.getCopyFileArea(copyFileAreaRoot).getLocalItemPaths(versionable, (IProgressMonitor)progress.newChild(100));
        List shareables = this.getShareablesForPaths(copyFileAreaRoot, paths);
        progress.done();
        return shareables;
    }

    @Override
    public List findShareables(IPath copyFileAreaRoot, IVersionableHandle versionable, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        if (versionable == null) {
            throw new IllegalArgumentException();
        }
        if (copyFileAreaRoot == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection paths = CopyFileAreaStore.getCopyFileArea(copyFileAreaRoot).getLocalItemPaths(versionable, connection, (IProgressMonitor)progress.newChild(100));
        List shareables = this.getShareablesForPaths(copyFileAreaRoot, paths);
        progress.done();
        return shareables;
    }

    @Override
    public List findShareables(IPath copyFileAreaRoot, IVersionableHandle versionable, IComponentHandle component, IProgressMonitor monitor) throws FileSystemClientException {
        if (versionable == null) {
            throw new IllegalArgumentException();
        }
        if (copyFileAreaRoot == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection paths = CopyFileAreaStore.getCopyFileArea(copyFileAreaRoot).getLocalItemPaths(versionable, component, (IProgressMonitor)progress.newChild(100));
        List shareables = this.getShareablesForPaths(copyFileAreaRoot, paths);
        progress.done();
        return shareables;
    }

    protected List getShareablesForPaths(IPath copyFileAreaRoot, Collection<IPath> paths) {
        if (copyFileAreaRoot.equals((Object)this.getDefaultCFARoot())) {
            throw new IllegalStateException();
        }
        ArrayList<ShareableFile> shareables = new ArrayList<ShareableFile>(paths.size());
        File rootFile = copyFileAreaRoot.toFile();
        for (IPath path : paths) {
            File file = new File(rootFile, path.toString());
            if (!file.exists()) continue;
            shareables.add(new ShareableFile(copyFileAreaRoot, file));
        }
        return shareables;
    }

    @Override
    public IShareable findShareable(IPath copyFileAreaRoot, IPath path, boolean isFolderHint) {
        if (copyFileAreaRoot.equals((Object)this.getDefaultCFARoot())) {
            throw new IllegalStateException();
        }
        File rootFile = copyFileAreaRoot.toFile();
        File file = new File(rootFile, path.toString());
        return new ShareableFile(copyFileAreaRoot, file);
    }

    @Override
    public IShareable findShareable(IPath copyFileAreaRoot, IVersionableHandle versionable, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        if (versionable == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (copyFileAreaRoot == null) {
            throw new IllegalArgumentException();
        }
        if (copyFileAreaRoot.equals((Object)this.getDefaultCFARoot())) {
            throw new IllegalStateException();
        }
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IPath path = CopyFileAreaStore.getCopyFileArea(copyFileAreaRoot).getLocalPathFor(versionable, component, connection, (IProgressMonitor)progress.newChild(100));
        progress.done();
        if (path == null) {
            return null;
        }
        File file = new File(copyFileAreaRoot.toFile(), path.toString());
        if (!file.exists()) {
            return null;
        }
        return new ShareableFile(copyFileAreaRoot, file);
    }

    public UpdateMutator getUpdateMutator(IConnection connection, Collection<IComponentStateSummary> componentStatesBeforeUpdate, Collection<IComponentStateSummary> componentStatesAfterUpdate, FileAreaUpdateReport updates, IPath root) throws TeamRepositoryException {
        return new LocalFileSystemUpdateMutator(connection, componentStatesBeforeUpdate, componentStatesAfterUpdate, updates, root, (DilemmaHandler)UpdateDilemmaHandler.getDefault());
    }

    public IIgnoreManager getIgnoreManager() {
        return IgnoreManager.getInstance();
    }

    public VerifySharesOperation getVerifySharesOperation(IPath copyFileAreaRoot, OutOfSyncDilemmaHandler problemHandler) {
        return new LocalFileSystemVerifySharesOperation(copyFileAreaRoot, problemHandler);
    }

    public void addListener(ICorruptCopyFileAreaListener listener) {
        CopyFileAreaStore.addCorruptionListener(listener);
    }

    public void removeListener(ICorruptCopyFileAreaListener listener) {
        CopyFileAreaStore.removeCorruptionListener(listener);
    }

    public List<IShareable> getRootShareables(IPath copyFileAreaRoot) {
        if (copyFileAreaRoot.equals((Object)this.getDefaultCFARoot())) {
            throw new IllegalStateException();
        }
        File rootFile = copyFileAreaRoot.toFile();
        File[] children = rootFile.listFiles();
        if (children == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IShareable> shareables = new ArrayList<IShareable>();
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            shareables.add(new ShareableFile(copyFileAreaRoot, child));
            ++n2;
        }
        return shareables;
    }

    public ISchedulingRule getTrackingRule(IPath cfaRoot) {
        if (cfaRoot.equals((Object)this.getDefaultCFARoot())) {
            throw new IllegalStateException();
        }
        return null;
    }

    @Override
    public String getMetadataRootName() {
        return SCM_PRIVATE;
    }

    public void runWithinFileSystemLock(IRunnableWithProgress runnableWithProgress, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        runnableWithProgress.run(monitor);
    }

    @Override
    public int getNumShares(IPath root, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        return CopyFileAreaStore.getCopyFileArea(root).getNumShares(component, connection, monitor);
    }

    @Override
    public int getNumShares(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        return CopyFileAreaStore.getDefaultCopyFileArea().getNumShares(component, connection, monitor);
    }

    @Override
    public Collection<ISharingDescriptor> getShares(IPath copyFileAreaRoot, IContextHandle context, IComponentHandle component, IProgressMonitor monitor) throws FileSystemClientException {
        return CopyFileAreaStore.getCopyFileArea(copyFileAreaRoot).getShares(context, component, monitor);
    }

    @Override
    public List<IPath> getPathRelativeToShares(IPath copyFileAreaRoot, IContextHandle context, IComponentHandle component, List<List<INameItemPair>> ancestorReports, IProgressMonitor progress) throws FileSystemClientException {
        CopyFileAreaStore cfa = CopyFileAreaStore.getCopyFileArea(copyFileAreaRoot);
        Collection<ISharingDescriptor> shares = cfa.getShares(context, component, progress);
        HashSet<UUID> shareRoots = new HashSet<UUID>();
        for (ISharingDescriptor share : shares) {
            shareRoots.add(share.getRootFolder().getItemId());
        }
        ArrayList<IPath> result = new ArrayList<IPath>();
        for (List<INameItemPair> ancestorReport : ancestorReports) {
            boolean shareRootFound = false;
            IPath path = null;
            if (!shareRoots.isEmpty()) {
                for (INameItemPair pair : ancestorReport) {
                    if (shareRootFound) {
                        path = path.append(pair.getName());
                        continue;
                    }
                    if (!shareRoots.contains(pair.getItem().getItemId())) continue;
                    shareRootFound = true;
                    path = new Path(pair.getName());
                }
            }
            result.add(path);
        }
        return result;
    }

    @Override
    public void restoreFile(IShareable file, InputStream in, IVersionableHandle handle, IProgressMonitor monitor) throws FileSystemClientException, IOException {
        RestoreVersionableOperation.restoreFile(file, in, handle, monitor);
    }

    @Override
    public void restoreFolder(IShareable folder, IFolderHandle handle, IProgressMonitor monitor) throws FileSystemClientException {
        RestoreVersionableOperation.restoreFolder(folder, handle, monitor);
    }

    public static interface CoreRunnable {
        public void run() throws CoreException;
    }
}

