/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class ShareableFile
extends Shareable
implements IShareable {
    private final File file;
    private final IPath root;
    private final IPath fullPath;

    public ShareableFile(IPath copyFileAreaRoot, File file) {
        this.root = copyFileAreaRoot;
        this.file = file;
        String stringPath = file.getPath();
        try {
            stringPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            LoggingHelper.error("com.ibm.team.filesystem.client", NLS.bind((String)Messages.ShareableFile_0, (Object[])new Object[]{stringPath}), e);
        }
        this.fullPath = new Path(stringPath).removeFirstSegments(this.root.segmentCount()).setDevice(null).makeAbsolute();
    }

    public ShareableFile(IPath copyFileAreaRoot, IPath path) {
        this(copyFileAreaRoot, copyFileAreaRoot.append(path).toFile());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShareableFile)) {
            return false;
        }
        return this.root.equals((Object)((ShareableFile)obj).root) && this.file.equals(((ShareableFile)obj).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public IFileStorage getFileStorage() {
        return new LocalFileStorage(this.root, this.file);
    }

    public IPath getLocalFullPath() {
        return this.fullPath;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(File.class)) {
            return this.file;
        }
        return null;
    }

    public IPath getRoot() {
        return this.root;
    }

    public Shareable getShareableFor(IPath path, boolean isFolder) {
        return new ShareableFile(this.root, path);
    }

    public void visit(IShareableVisitor visitor, int depth, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.file.exists() && this.file.isDirectory() && depth != 0) {
            File[] children = this.file.listFiles();
            progress.setWorkRemaining(children.length);
            int i = 0;
            while (i < children.length) {
                SubMonitor subProgress = progress.newChild(1);
                subProgress.setWorkRemaining(100);
                ShareableFile shareable = new ShareableFile(this.root, children[i]);
                boolean visitChildren = visitor.visit(shareable, (IProgressMonitor)subProgress.newChild(5));
                if (visitChildren) {
                    shareable.visit(visitor, depth - 1, (IProgressMonitor)subProgress.newChild(95));
                }
                ++i;
            }
        }
    }

    public boolean isLocal() {
        return this.file.exists();
    }

    public String toString() {
        return NLS.bind((String)Messages.ShareableFile_1, (Object[])new Object[]{this.file});
    }

    public File getFile() {
        return this.file;
    }
}

