/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.repository.common.LogFactory;

public class ReadWriteLock {
    private final LockStatus status = new LockStatus();
    private final ThreadLocal threadStatus = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new LockStatus();
        }
    };

    public void acquireRead() {
        this.acquireRead(true);
    }

    public boolean tryAcquireRead() {
        return this.acquireRead(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean acquireRead(boolean doWait) {
        LockStatus lockStatus = this.status;
        synchronized (lockStatus) {
            LockStatus threadStatus = this.getThreadLockStatus();
            boolean interrupted = false;
            while (this.status.writes != 0 && this.status.writes != threadStatus.writes) {
                if (!doWait) {
                    return false;
                }
                try {
                    this.status.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    LogFactory.getLog((String)ReadWriteLock.class.getName()).warn((Object)"We were interrupted", (Throwable)e);
                }
            }
            ++this.status.reads;
            ++threadStatus.reads;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
    }

    public void acquireWrite() {
        this.acquireWrite(true);
    }

    public boolean tryAcquireWrite() {
        return this.acquireWrite(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean acquireWrite(boolean doWait) {
        LockStatus lockStatus = this.status;
        synchronized (lockStatus) {
            LockStatus threadStatus = this.getThreadLockStatus();
            boolean interrupted = false;
            while (true) {
                if (this.status.writes == 0) {
                    if (this.status.reads == 0) break;
                    if (threadStatus.reads > 0) {
                        throw new IllegalStateException("nesting of write lock inside read lock is illegal");
                    }
                } else {
                    if (this.status.writes == threadStatus.writes) break;
                    if (!doWait) {
                        return false;
                    }
                }
                try {
                    this.status.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    LogFactory.getLog((String)ReadWriteLock.class.getName()).warn((Object)"We were interrupted", (Throwable)e);
                }
            }
            ++this.status.writes;
            ++threadStatus.writes;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release() {
        boolean available;
        LockStatus lockStatus = this.status;
        synchronized (lockStatus) {
            LockStatus threadStatus = this.getThreadLockStatus();
            if (this.status.reads > 0) {
                if (threadStatus.reads == 0) {
                    throw new IllegalStateException("releasing read lock outside of locking thread is illegal");
                }
                --this.status.reads;
                --threadStatus.reads;
            } else if (this.status.writes > 0) {
                if (threadStatus.writes == 0) {
                    throw new IllegalStateException("releasing write lock outside of locking thread is illegal");
                }
                --this.status.writes;
                --threadStatus.writes;
            } else {
                throw new IllegalStateException("releasing an unlocked lock is illegal");
            }
            available = this.locks() == 0;
            this.status.notifyAll();
        }
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reads() {
        LockStatus lockStatus = this.status;
        synchronized (lockStatus) {
            return this.status.reads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writes() {
        LockStatus lockStatus = this.status;
        synchronized (lockStatus) {
            return this.status.writes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int locks() {
        LockStatus lockStatus = this.status;
        synchronized (lockStatus) {
            return this.status.reads + this.status.writes;
        }
    }

    public int threadReads() {
        return this.getThreadLockStatus().reads;
    }

    public int threadWrites() {
        return this.getThreadLockStatus().writes;
    }

    public int threadLocks() {
        return this.getThreadLockStatus().reads + this.getThreadLockStatus().writes;
    }

    private LockStatus getThreadLockStatus() {
        return (LockStatus)this.threadStatus.get();
    }

    public String toString() {
        return "reads: " + this.threadReads() + "/" + this.reads() + " - writes: " + this.threadWrites() + "/" + this.writes();
    }

    private static class LockStatus {
        public int reads = 0;
        public int writes = 0;

        private LockStatus() {
        }
    }
}

