/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.ReadWriteLock;
import com.ibm.team.repository.common.internal.content.util.BTreeHeap;
import com.ibm.team.repository.common.internal.content.util.PersistentBTreeHeap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class PersistentHeapManager {
    private static final int MAX_OPEN_HEAPS = 20;
    private Map<AutoClosingPersistentFileHeap, AutoClosingPersistentFileHeap> openHeaps = new LinkedHashMap<AutoClosingPersistentFileHeap, AutoClosingPersistentFileHeap>(16, 0.75f, true);

    protected PersistentBTreeHeap getPersistentFileHeap(File f) throws IOException {
        return new AutoClosingPersistentFileHeap(f);
    }

    private void addOpenHeap(AutoClosingPersistentFileHeap h) throws IOException {
        this.openHeaps.put(h, h);
        if (this.openHeaps.size() > 20) {
            Iterator<AutoClosingPersistentFileHeap> i = this.openHeaps.keySet().iterator();
            i.next().closeDescriptor();
            i.remove();
        }
    }

    class AutoClosingPersistentFileHeap
    extends PersistentBTreeHeap {
        boolean closed;
        ReadWriteLock openLock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AutoClosingPersistentFileHeap(File f) throws IOException {
            super(f);
            boolean success = false;
            try {
                this.openLock = new ReadWriteLock();
                Map map = PersistentHeapManager.this.openHeaps;
                synchronized (map) {
                    PersistentHeapManager.this.addOpenHeap(this);
                }
                success = true;
            }
            catch (Throwable throwable) {
                if (!success) {
                    try {
                        this.raf.getFile().close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (!success) {
                try {
                    this.raf.getFile().close();
                }
                catch (IOException iOException) {}
            }
        }

        public void closeDescriptor() throws IOException {
            this.openLock.acquireWrite();
            try {
                this.raf.getFile().close();
                this.closed = true;
            }
            finally {
                this.openLock.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            super.close();
            Map map = PersistentHeapManager.this.openHeaps;
            synchronized (map) {
                PersistentHeapManager.this.openHeaps.remove((Object)this);
            }
        }

        public void clear() throws IOException {
            this.openAndAcquireLock();
            try {
                super.clear();
            }
            finally {
                this.openLock.release();
            }
        }

        public long allocate(long paramSize) throws IOException {
            this.openAndAcquireLock();
            try {
                long l = super.allocate(paramSize);
                return l;
            }
            finally {
                this.openLock.release();
            }
        }

        public void persist() throws IOException {
            this.openAndAcquireLock();
            try {
                super.persist();
            }
            finally {
                this.openLock.release();
            }
        }

        public void free(long paramOffset) throws IOException {
            this.openAndAcquireLock();
            try {
                super.free(paramOffset);
            }
            finally {
                this.openLock.release();
            }
        }

        public InputStream getInputStream(long offset) {
            return new AutoClosingHeapInputStream(offset);
        }

        public OutputStream getOutputStream(long offset) {
            return new AutoClosingHeapOutputStream(offset);
        }

        public boolean delete() {
            return this.raf.getFn().delete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void openAndAcquireLock() throws IOException {
            Map map = PersistentHeapManager.this.openHeaps;
            synchronized (map) {
                if (this.closed && !((PersistentBTreeHeap)this).closed) {
                    PersistentHeapManager.this.addOpenHeap(this);
                    this.raf.reopen();
                    this.closed = false;
                }
                this.openLock.acquireWrite();
            }
        }

        protected class AutoClosingHeapInputStream
        extends BTreeHeap.FileHeapInputStream {
            public AutoClosingHeapInputStream(long offset) {
                super((BTreeHeap)AutoClosingPersistentFileHeap.this, offset);
            }

            public int read() throws IOException {
                AutoClosingPersistentFileHeap.this.openAndAcquireLock();
                try {
                    int n = super.read();
                    return n;
                }
                finally {
                    AutoClosingPersistentFileHeap.this.openLock.release();
                }
            }

            public int read(byte[] b, int off, int len) throws IOException {
                AutoClosingPersistentFileHeap.this.openAndAcquireLock();
                try {
                    int n = super.read(b, off, len);
                    return n;
                }
                finally {
                    AutoClosingPersistentFileHeap.this.openLock.release();
                }
            }

            public long skip(long n) throws IOException {
                AutoClosingPersistentFileHeap.this.openAndAcquireLock();
                try {
                    long l = super.skip(n);
                    return l;
                }
                finally {
                    AutoClosingPersistentFileHeap.this.openLock.release();
                }
            }
        }

        protected class AutoClosingHeapOutputStream
        extends BTreeHeap.FileHeapOutputStream {
            public AutoClosingHeapOutputStream(long offset) {
                super((BTreeHeap)AutoClosingPersistentFileHeap.this, offset);
            }

            public void write(int b) throws IOException {
                AutoClosingPersistentFileHeap.this.openAndAcquireLock();
                try {
                    super.write(b);
                }
                finally {
                    AutoClosingPersistentFileHeap.this.openLock.release();
                }
            }

            public void write(byte[] b, int off, int len) throws IOException {
                AutoClosingPersistentFileHeap.this.openAndAcquireLock();
                try {
                    super.write(b, off, len);
                }
                finally {
                    AutoClosingPersistentFileHeap.this.openLock.release();
                }
            }
        }
    }
}

