/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.DiskBackedMapManager;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.ICorruptible;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IMetadataChangeTracker;
import com.ibm.team.filesystem.client.internal.IRemoteVisitor;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.IVisitor;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LocalChangeInfo;
import com.ibm.team.filesystem.client.internal.LockableMap;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.filesystem.client.internal.ReadWriteLock;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Store;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.localchanges.IVersionableTree;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PersistentBusyFlag;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.content.util.DBHMException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataChangeTracker
implements ISharingMetadata,
IMetadataChangeTracker {
    private static final String SCM_CHANGED_INFOS_PREFIX = ".changedinfos";
    private static final String SCM_CHANGED_INFOS_SUFFIX = ".dat";
    private static final int METADATA_VERSION = 1;
    protected ISharingMetadata delegate;
    protected IPath cfaRoot;
    protected IPath basePath;
    protected PersistentHeapManager heapMgr;
    protected ChangeDiskBackedMapManager mapMgr;
    protected ReadWriteLock globalLock;

    private void setCorrupt(DBHMException e) {
        this.setCorrupt(true, e.getMessage(), e.getCause());
    }

    public MetadataChangeTracker(ISharingMetadata delegate, IPath copyFileAreaRoot, IPath metadataRoot) {
        this.delegate = delegate;
        this.cfaRoot = copyFileAreaRoot;
        this.basePath = metadataRoot;
        this.heapMgr = new PersistentHeapManager();
        this.globalLock = new ReadWriteLock();
        this.mapMgr = new ChangeDiskBackedMapManager(this.globalLock, delegate.getPersistentMetadataFlag(), this);
    }

    @Override
    public void accept(IVisitor visitor, IPath base, int depth, boolean mutable, IProgressMonitor monitor) throws FileSystemClientException {
        if (mutable) {
            this.globalLock.acquireWrite();
        } else {
            this.globalLock.acquireRead();
        }
        try {
            this.delegate.accept(visitor, base, depth, mutable, monitor);
        }
        finally {
            this.globalLock.release();
        }
    }

    @Override
    public void accept(IRemoteVisitor visitor, IVersionableHandle base, IComponentHandle component, IContextHandle connection, int depth, boolean mutable, IProgressMonitor monitor) throws FileSystemClientException {
        if (mutable) {
            this.globalLock.acquireWrite();
        } else {
            this.globalLock.acquireRead();
        }
        try {
            this.delegate.accept(visitor, base, component, connection, depth, mutable, monitor);
        }
        finally {
            this.globalLock.release();
        }
    }

    @Override
    public IPath[] allShares() throws FileSystemClientException {
        return this.delegate.allShares();
    }

    @Override
    public void clear() throws FileSystemClientException {
        this.globalLock.acquireWrite();
        try {
            this.mapMgr.closeAll();
            this.delegate.clear();
        }
        finally {
            this.globalLock.release();
        }
    }

    @Override
    public void close() throws FileSystemClientException {
        this.delegate.close();
        this.globalLock.acquireWrite();
        try {
            this.mapMgr.closeAll();
        }
        finally {
            this.globalLock.release();
        }
    }

    private void notifyTracker(IComponentHandle component, IContextHandle connection) {
        LocalChangeTracker tracker = LocalChangeManager.getInstance().findTracker(connection, component, this.cfaRoot);
        if (tracker != null) {
            tracker.metadataChanged();
        }
    }

    @Override
    public FileItemInfo deleteFileItemInfo(IPath path, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Path sharePath = new Path(path.segment(0));
        ISharingDescriptor desc = this.getSharingDescriptor((IPath)sharePath);
        if (desc != null) {
            final LockableMap<ChangeKey, LocalChangeInfo> map = this.getMapFor(desc.getComponent(), desc.getConnectionHandle());
            try {
                try {
                    this.delegate.accept(new IVisitor(){

                        public boolean visit(IPath path, FileItemInfo entry, IProgressMonitor monitor) {
                            if (!entry.isFolder()) {
                                ChangeKey key = new ChangeKey(entry.getVersionableHandle());
                                LocalChangeInfo info = (LocalChangeInfo)map.entries().remove(key);
                                if (info != null && info.inverseMapChanged()) {
                                    map.entries().put(key, new LocalChangeInfo(true, false));
                                }
                            }
                            return true;
                        }
                    }, path, Integer.MAX_VALUE, false, (IProgressMonitor)progress.newChild(50));
                }
                catch (DBHMException e) {
                    this.setCorrupt(true, "Failed to delete item info", e.getCause());
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.MetadataChangeTracker_2, e.getCause()));
                }
            }
            finally {
                this.releaseMap(map);
            }
        }
        progress.setWorkRemaining(50);
        return this.delegate.deleteFileItemInfo(path, (IProgressMonitor)progress.newChild(50));
    }

    @Override
    public boolean isCaseSensitive() {
        return this.delegate.isCaseSensitive();
    }

    @Override
    public Map getChildInfos(IPath path) throws FileSystemClientException {
        return this.delegate.getChildInfos(path);
    }

    @Override
    public FileItemInfo getFileItemInfo(IPath path) throws FileSystemClientException {
        return this.delegate.getFileItemInfo(path);
    }

    @Override
    public InverseFileItemInfo getFileItemInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        return this.delegate.getFileItemInfo(item, component, connection);
    }

    @Override
    public Collection getLocations(IVersionableHandle item) throws FileSystemClientException {
        return this.delegate.getLocations(item);
    }

    @Override
    public IPath getPathForShareRoot(IFolderHandle root, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        return this.delegate.getPathForShareRoot(root, component, connection);
    }

    @Override
    public ISharingDescriptor getSharingDescriptor(IPath sharePath) throws FileSystemClientException {
        return this.delegate.getSharingDescriptor(sharePath);
    }

    @Override
    public FileItemInfo moveFileItemInfo(IPath sourcePath, IPath destinationPath) throws FileSystemClientException {
        return this.delegate.moveFileItemInfo(sourcePath, destinationPath);
    }

    @Override
    public void run(ISharingMetadata.ITransaction transaction) throws FileSystemClientException {
        this.globalLock.acquireWrite();
        try {
            this.delegate.run(transaction);
        }
        finally {
            this.globalLock.release();
        }
    }

    private IFileStorage getStorage(IPath path, ISharingDescriptor desc, IPath sharePath, boolean isFolder) {
        Share share = SharingManager.getInstance().createShare(desc, sharePath, CopyFileAreaStore.getCopyFileArea(this.cfaRoot));
        Shareable shareable = (Shareable)share.getShareable(path, isFolder);
        return shareable.getFileStorage();
    }

    private boolean isIgnored(IPath path, ISharingDescriptor desc, IPath sharePath) {
        SharingManager mgr = SharingManager.getInstance();
        Share share = mgr.createShare(desc, sharePath, CopyFileAreaStore.getCopyFileArea(this.cfaRoot));
        IShareable shareable = share.getShareable(path, false);
        mgr.disableChangeMonitoring();
        try {
            boolean bl = shareable.shouldBeIgnored();
            return bl;
        }
        finally {
            mgr.enableChangeMonitoring();
        }
    }

    @Override
    public void setContentChanged(IVersionableHandle item, IPath path, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        ChangeKey key = new ChangeKey(item);
        LockableMap<ChangeKey, LocalChangeInfo> map = this.getMapFor(component, connection);
        try {
            try {
                LocalChangeInfo oldChangeInfo = map.entries().get(key);
                boolean isPathChanged = oldChangeInfo == null ? false : oldChangeInfo.inverseMapChanged();
                map.entries().put(key, new LocalChangeInfo(isPathChanged, true));
                this.notifyTracker(component, connection);
            }
            catch (DBHMException e) {
                this.setCorrupt(true, "Could not tag content as changed", e.getCause());
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.MetadataChangeTracker_3, e.getCause()));
            }
        }
        finally {
            this.releaseMap(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IVersionableTree.IChangeType> getLocalChanges(IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        LockableMap<ChangeKey, LocalChangeInfo> map = this.getMapFor(component, connection, false);
        HashMap<UUID, InverseFileItemInfo> infoMap = new HashMap<UUID, InverseFileItemInfo>();
        try {
            ArrayList<IVersionableTree.IChangeType> infos;
            Map<ChangeKey, LocalChangeInfo> map2 = map.entries();
            synchronized (map2) {
                infos = new ArrayList<IVersionableTree.IChangeType>(map.entries().size());
                block18: for (Map.Entry<ChangeKey, LocalChangeInfo> e : map.entries().entrySet()) {
                    IPath currentMovedFromPath;
                    IPath originalPath;
                    IPath currentPath;
                    InverseFileItemInfo parentInfo;
                    IVersionableHandle item = e.getKey().item;
                    LocalChangeInfo changeInfo = e.getValue();
                    InverseFileItemInfo itemInfo = this.getInverseInfo(item, component, connection, infoMap);
                    int changeType = !changeInfo.inverseMapChanged() ? 0 : (itemInfo.getParent() == null ? 4 : (itemInfo.getLocalParent() == null ? (this.getPathForShareRoot(itemInfo.getParent(), component, connection) == null ? ((parentInfo = this.getInverseInfo((IVersionableHandle)itemInfo.getParent(), component, connection, infoMap)).getLocalParent() == null ? 2 : 1) : 1) : (this.noPathChange(itemInfo, component, connection) ? 0 : 3)));
                    ISharingDescriptor currentDesc = null;
                    Path currentSharePath = null;
                    switch (changeType) {
                        case 2: {
                            currentPath = null;
                            originalPath = null;
                            currentMovedFromPath = null;
                            break;
                        }
                        case 1: {
                            currentPath = this.computeDeletionPath(item, component, connection, infoMap);
                            originalPath = this.computeRemotePath(item, component, connection, infoMap);
                            currentMovedFromPath = null;
                            break;
                        }
                        case 0: {
                            currentPath = this.computeLocalPath(item, component, connection, infoMap);
                            originalPath = this.computeRemotePath(item, component, connection, infoMap);
                            currentMovedFromPath = null;
                            break;
                        }
                        case 4: {
                            currentPath = this.computeLocalPath(item, component, connection, infoMap);
                            originalPath = null;
                            currentMovedFromPath = null;
                            break;
                        }
                        case 3: {
                            Path sharePath;
                            ISharingDescriptor origPathDesc;
                            currentPath = this.computeLocalPath(item, component, connection, infoMap);
                            currentMovedFromPath = this.computeDeletionPath((IVersionableHandle)itemInfo.getParent(), component, connection, infoMap).append(itemInfo.getName());
                            currentSharePath = new Path(currentPath.segment(0));
                            currentDesc = this.getSharingDescriptor((IPath)currentSharePath);
                            boolean targetIgnored = this.isIgnored(currentPath, currentDesc, (IPath)currentSharePath);
                            if (currentPath.segment(0).equals(currentMovedFromPath.segment(0))) {
                                origPathDesc = currentDesc;
                                sharePath = currentSharePath;
                            } else {
                                sharePath = new Path(currentMovedFromPath.segment(0));
                                origPathDesc = this.getSharingDescriptor((IPath)sharePath);
                            }
                            boolean sourceIgnored = this.isIgnored(currentMovedFromPath, origPathDesc, (IPath)sharePath);
                            if (sourceIgnored && targetIgnored) continue block18;
                            if (sourceIgnored && !targetIgnored) {
                                changeType = 4;
                                originalPath = null;
                                currentMovedFromPath = null;
                                break;
                            }
                            if (!sourceIgnored && targetIgnored) {
                                changeType = 1;
                                originalPath = this.computeRemotePath(item, component, connection, infoMap);
                                currentPath = this.computeDeletionPath((IVersionableHandle)itemInfo.getParent(), component, connection, infoMap).append(itemInfo.getName());
                                currentMovedFromPath = null;
                                break;
                            }
                            Assert.isTrue((!sourceIgnored && !targetIgnored ? 1 : 0) != 0);
                            originalPath = this.computeRemotePath(item, component, connection, infoMap);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    IFolderHandle localParent = itemInfo.getLocalParent();
                    IFolderHandle remoteParent = itemInfo.getParent();
                    if (localParent != null) {
                        InverseFileItemInfo localParentInfo = this.getInverseInfo((IVersionableHandle)itemInfo.getLocalParent(), component, connection, infoMap);
                        localParent = (IFolderHandle)localParentInfo.getVersionableHandle();
                    }
                    if (remoteParent != null) {
                        InverseFileItemInfo remoteParentInfo = this.getInverseInfo((IVersionableHandle)itemInfo.getParent(), component, connection, infoMap);
                        remoteParent = (IFolderHandle)remoteParentInfo.getVersionableHandle();
                    }
                    boolean isContentChanged = !itemInfo.isFolder() && (itemInfo.getOriginalLineDelimiter() != itemInfo.getLineDelimiter() || itemInfo.getOriginalContentType() == null && itemInfo.getContentType() != null || itemInfo.getOriginalContentType() != null && !itemInfo.getOriginalContentType().equals(itemInfo.getContentType()) || itemInfo.getLastModification() == -1L);
                    boolean isFlagChange = false;
                    if ((changeType == 0 || changeType == 3) && !itemInfo.isFolder() && changeInfo.isForwardMapChanged()) {
                        if (currentSharePath == null) {
                            currentSharePath = new Path(currentPath.segment(0));
                            currentDesc = this.getSharingDescriptor((IPath)currentSharePath);
                        }
                        IFileStorage storage = this.getStorage(currentPath, currentDesc, (IPath)currentSharePath, false);
                        SharingManager.getInstance().disableChangeMonitoring();
                        try {
                            if (!isContentChanged) {
                                boolean bl = isContentChanged = itemInfo.getLastModification() != storage.getModificationStamp();
                            }
                            isFlagChange = storage.supportsExecBit() ? storage.isExecutable() ^ itemInfo.isOriginalExecutable() : itemInfo.isExecutable() ^ itemInfo.isOriginalExecutable();
                        }
                        finally {
                            SharingManager.getInstance().enableChangeMonitoring();
                        }
                    }
                    infos.add(new ChangeType(itemInfo.getVersionableHandle(), changeType, localParent, remoteParent, currentPath, originalPath, currentMovedFromPath, isContentChanged, isFlagChange));
                }
            }
            ArrayList<IVersionableTree.IChangeType> arrayList = infos;
            return arrayList;
        }
        catch (DBHMException e) {
            this.setCorrupt(true, "Failure during getLocalChanges()", e.getCause());
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.MetadataChangeTracker_4, e.getCause()));
        }
        finally {
            this.releaseMap(map);
        }
    }

    private IPath computeLocalPath(IVersionableHandle item, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache) throws FileSystemClientException {
        ArrayList<String> segments = null;
        int pathlen = 0;
        while (true) {
            IPath rootPath;
            if (item instanceof IFolderHandle && (rootPath = this.delegate.getPathForShareRoot((IFolderHandle)item, component, connection)) != null) {
                if (segments == null) {
                    return rootPath;
                }
                int max = segments.size() - 1;
                if (max == 0) {
                    return rootPath.append((String)segments.get(0));
                }
                StringBuffer buf = new StringBuffer(pathlen + max);
                buf.append((String)segments.get(max));
                int i = max - 1;
                while (i >= 0) {
                    buf.append('/');
                    buf.append((String)segments.get(i));
                    --i;
                }
                return rootPath.append(buf.toString());
            }
            InverseFileItemInfo info = this.getInverseInfo(item, component, connection, cache);
            String name = info.getLocalName();
            if (name == null) {
                this.setCorrupt(true, "Could not resolve path via getInverseInfo() for " + (item == null ? "null item" : item.getItemId().getUuidValue()), null);
                throw new IllegalStateException("Path to " + info.getVersionableHandle() + " does not resolve");
            }
            if (segments == null) {
                segments = new ArrayList<String>();
            }
            pathlen += name.length();
            segments.add(name);
            item = info.getLocalParent();
        }
    }

    private IPath computeRemotePath(IVersionableHandle item, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache) throws FileSystemClientException {
        ArrayList<String> segments = null;
        int pathlen = 0;
        while (true) {
            IPath rootPath;
            if (item instanceof IFolderHandle && (rootPath = this.delegate.getPathForShareRoot((IFolderHandle)item, component, connection)) != null) {
                if (segments == null) {
                    return rootPath;
                }
                int max = segments.size() - 1;
                if (max == 0) {
                    return rootPath.append((String)segments.get(0));
                }
                StringBuffer buf = new StringBuffer(pathlen + max);
                buf.append((String)segments.get(max));
                int i = max - 1;
                while (i >= 0) {
                    buf.append('/');
                    buf.append((String)segments.get(i));
                    --i;
                }
                return rootPath.append(buf.toString());
            }
            InverseFileItemInfo info = this.getInverseInfo(item, component, connection, cache);
            String name = info.getName();
            if (name == null) {
                throw new IllegalStateException("Path to " + info.getVersionableHandle() + " does not resolve");
            }
            if (segments == null) {
                segments = new ArrayList<String>();
            }
            pathlen += name.length();
            segments.add(name);
            item = info.getParent();
        }
    }

    private IPath computeDeletionPath(IVersionableHandle item, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache) throws FileSystemClientException {
        ArrayList<String> segments = null;
        int pathlen = 0;
        boolean computingRemote = true;
        while (true) {
            IPath rootPath;
            if (item instanceof IFolderHandle && (rootPath = this.delegate.getPathForShareRoot((IFolderHandle)item, component, connection)) != null) {
                if (segments == null) {
                    return rootPath;
                }
                int max = segments.size() - 1;
                if (max == 0) {
                    return rootPath.append((String)segments.get(0));
                }
                StringBuffer buf = new StringBuffer(pathlen + max);
                buf.append((String)segments.get(max));
                int i = max - 1;
                while (i >= 0) {
                    buf.append('/');
                    buf.append((String)segments.get(i));
                    --i;
                }
                return rootPath.append(buf.toString());
            }
            InverseFileItemInfo info = this.getInverseInfo(item, component, connection, cache);
            String name = info.getLocalName();
            if (computingRemote) {
                if (name != null) {
                    computingRemote = false;
                } else {
                    name = info.getName();
                }
            }
            if (name == null) {
                throw new IllegalStateException("Path to " + info.getVersionableHandle() + " does not resolve");
            }
            if (segments == null) {
                segments = new ArrayList<String>();
            }
            pathlen += name.length();
            segments.add(name);
            item = computingRemote ? info.getParent() : info.getLocalParent();
        }
    }

    private InverseFileItemInfo getInverseInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache) throws FileSystemClientException {
        InverseFileItemInfo info = cache.get(item.getItemId());
        if (info != null) {
            return info;
        }
        info = this.delegate.getFileItemInfo(item, component, connection);
        cache.put(item.getItemId(), info);
        return info;
    }

    @Override
    public FileItemInfo setFileItemInfo(IPath path, FileItemInfo itemInfo) throws FileSystemClientException {
        FileItemInfo oldInfo;
        block23: {
            boolean isInterestingOld;
            oldInfo = this.delegate.setFileItemInfo(path, itemInfo);
            boolean isInterestingNew = itemInfo != null && !itemInfo.isFolder();
            boolean bl = isInterestingOld = oldInfo != null && !oldInfo.isFolder() && (itemInfo == null || !itemInfo.getVersionableHandle().sameItemId((IItemHandle)oldInfo.getVersionableHandle()));
            if (isInterestingNew || isInterestingOld) {
                try {
                    boolean canCompareStamps;
                    Path sharePath = new Path(path.segment(0));
                    ISharingDescriptor desc = this.getSharingDescriptor((IPath)sharePath);
                    long modStamp = -1L;
                    long lastMod = isInterestingNew ? itemInfo.getLastModification() : -1L;
                    IFileStorage storage = this.getStorage(path, desc, (IPath)sharePath, false);
                    if (lastMod != -1L) {
                        SharingManager mgr = SharingManager.getInstance();
                        mgr.disableChangeMonitoring();
                        try {
                            modStamp = storage.getModificationStamp();
                        }
                        finally {
                            mgr.enableChangeMonitoring();
                        }
                    }
                    boolean bl2 = canCompareStamps = isInterestingNew && (lastMod == -1L || modStamp != -1L);
                    if (!canCompareStamps && !isInterestingOld) break block23;
                    LockableMap<ChangeKey, LocalChangeInfo> map = this.getMapFor(desc.getComponent(), desc.getConnectionHandle());
                    try {
                        boolean isPathChanged;
                        LocalChangeInfo oldChangeInfo;
                        ChangeKey key;
                        if (canCompareStamps) {
                            boolean isContentChanged;
                            key = new ChangeKey(itemInfo.getVersionableHandle());
                            oldChangeInfo = map.entries().get(key);
                            isPathChanged = oldChangeInfo == null ? false : oldChangeInfo.inverseMapChanged();
                            boolean bl3 = isContentChanged = !itemInfo.isFolder() && (lastMod == -1L || lastMod != modStamp);
                            if (!isContentChanged) {
                                SharingManager mgr = SharingManager.getInstance();
                                mgr.disableChangeMonitoring();
                                try {
                                    isContentChanged = storage.supportsExecBit() ? storage.isExecutable() ^ itemInfo.isOriginalExecutable() : itemInfo.isExecutable() ^ itemInfo.isOriginalExecutable();
                                }
                                finally {
                                    mgr.enableChangeMonitoring();
                                }
                            }
                            if (!isContentChanged && !isPathChanged) {
                                if (oldChangeInfo != null) {
                                    map.entries().remove(key);
                                    this.notifyTracker(desc.getComponent(), desc.getConnectionHandle());
                                }
                            } else {
                                map.entries().put(key, new LocalChangeInfo(isPathChanged, isContentChanged));
                                this.notifyTracker(desc.getComponent(), desc.getConnectionHandle());
                            }
                        }
                        if (isInterestingOld) {
                            key = new ChangeKey(oldInfo.getVersionableHandle());
                            oldChangeInfo = map.entries().get(key);
                            isPathChanged = oldChangeInfo == null ? false : oldChangeInfo.inverseMapChanged();
                            if (!isPathChanged) {
                                if (oldChangeInfo != null) {
                                    map.entries().remove(key);
                                    this.notifyTracker(desc.getComponent(), desc.getConnectionHandle());
                                }
                            } else {
                                map.entries().put(key, new LocalChangeInfo(isPathChanged, false));
                                this.notifyTracker(desc.getComponent(), desc.getConnectionHandle());
                            }
                        }
                    }
                    finally {
                        this.releaseMap(map);
                    }
                }
                catch (DBHMException e) {
                    this.setCorrupt(true, "Failure when setting item info", e.getCause());
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.MetadataChangeTracker_5, e.getCause()));
                }
            }
        }
        return oldInfo;
    }

    private static boolean isUnchanged(String oldStr, String newStr) {
        if (oldStr == newStr) {
            return true;
        }
        if (oldStr == null || newStr == null) {
            return false;
        }
        return oldStr.equals(newStr);
    }

    private static boolean isUnchanged(IVersionableHandle oldHandle, IVersionableHandle newHandle, boolean compareState) {
        if (oldHandle == newHandle) {
            return true;
        }
        if (oldHandle == null || newHandle == null) {
            return false;
        }
        if (compareState && !MetadataChangeTracker.isUnchanged(oldHandle.getStateId(), newHandle.getStateId())) {
            return false;
        }
        return oldHandle.sameItemId((IItemHandle)newHandle);
    }

    private static boolean isUnchanged(UUID oldState, UUID newState) {
        if (oldState == newState) {
            return true;
        }
        if (oldState == null || newState == null) {
            return false;
        }
        return oldState.equals((Object)newState);
    }

    private boolean itemPathUnchanged(InverseFileItemInfo info1, InverseFileItemInfo info2) {
        if (info1 == info2) {
            return true;
        }
        if (info1 == null || info2 == null) {
            return false;
        }
        return MetadataChangeTracker.isUnchanged((IVersionableHandle)info1.getParent(), (IVersionableHandle)info2.getParent(), false) && MetadataChangeTracker.isUnchanged(info1.getName(), info2.getName()) && MetadataChangeTracker.isUnchanged((IVersionableHandle)info1.getLocalParent(), (IVersionableHandle)info2.getLocalParent(), false) && MetadataChangeTracker.isUnchanged(info1.getLocalName(), info2.getLocalName());
    }

    private boolean noPathNoPropertyChange(InverseFileItemInfo info, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        if (info == null) {
            return true;
        }
        if (info.isFolder() && this.getPathForShareRoot((IFolderHandle)info.getVersionableHandle(), component, connection) != null) {
            return true;
        }
        if (info.getOriginalLineDelimiter() == info.getLineDelimiter() && (info.getOriginalContentType() == null && info.getOriginalContentType() == info.getContentType() || info.getOriginalContentType() != null && info.getOriginalContentType().equals(info.getContentType()))) {
            return MetadataChangeTracker.isUnchanged(info.getLocalName(), info.getName()) && MetadataChangeTracker.isUnchanged((IVersionableHandle)info.getLocalParent(), (IVersionableHandle)info.getParent(), false);
        }
        return false;
    }

    private boolean noPathChange(InverseFileItemInfo info, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        if (info == null) {
            return true;
        }
        if (info.isFolder() && this.getPathForShareRoot((IFolderHandle)info.getVersionableHandle(), component, connection) != null) {
            return true;
        }
        return MetadataChangeTracker.isUnchanged(info.getLocalName(), info.getName()) && MetadataChangeTracker.isUnchanged((IVersionableHandle)info.getLocalParent(), (IVersionableHandle)info.getParent(), false);
    }

    private LockableMap<ChangeKey, LocalChangeInfo> getMapFor(IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        return this.getMapFor(component, connection, true);
    }

    private LockableMap<ChangeKey, LocalChangeInfo> getMapFor(IComponentHandle component, IContextHandle connection, boolean exclusive) throws FileSystemClientException {
        Path path = new Path(SCM_CHANGED_INFOS_PREFIX + component.getItemId().getUuidValue() + "_" + connection.getItemId().getUuidValue() + SCM_CHANGED_INFOS_SUFFIX);
        try {
            return this.mapMgr.loadMap((IPath)path, exclusive, (IPath)path);
        }
        catch (DBHMException e) {
            this.setCorrupt(true, "Failed to get map for " + path.toString(), e.getCause());
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.DiskBackedMapManager_0, e.getCause()));
        }
    }

    private void releaseMap(LockableMap<ChangeKey, LocalChangeInfo> map) throws FileSystemClientException {
        this.mapMgr.releaseMap(map);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InverseFileItemInfo setFileItemInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection, InverseFileItemInfo newInfo) throws FileSystemClientException {
        if (newInfo != null && !item.sameItemId((IItemHandle)newInfo.getVersionableHandle())) {
            throw new IllegalArgumentException();
        }
        InverseFileItemInfo oldInfo = this.delegate.setFileItemInfo(item, component, connection, newInfo);
        boolean noPathDelimiterChangeNewInfo = this.noPathNoPropertyChange(newInfo, component, connection);
        if (newInfo == null || this.noPathNoPropertyChange(oldInfo, component, connection) != noPathDelimiterChangeNewInfo) {
            try {
                ChangeKey key = new ChangeKey(item);
                LockableMap<ChangeKey, LocalChangeInfo> map = this.getMapFor(component, connection);
                try {
                    LocalChangeInfo oldChangeInfo = map.entries().get(key);
                    if (newInfo == null) {
                        if (oldChangeInfo == null) return oldInfo;
                        if (oldChangeInfo.isForwardMapChanged()) {
                            map.entries().put(key, new LocalChangeInfo(false, true));
                        } else {
                            map.entries().remove(key);
                        }
                        this.notifyTracker(component, connection);
                        return oldInfo;
                    }
                    boolean isContentChanged = oldChangeInfo == null ? false : oldChangeInfo.isForwardMapChanged();
                    if (noPathDelimiterChangeNewInfo && !isContentChanged) {
                        if (oldChangeInfo == null) return oldInfo;
                        map.entries().remove(key);
                        this.notifyTracker(component, connection);
                        return oldInfo;
                    }
                    map.entries().put(key, new LocalChangeInfo(!noPathDelimiterChangeNewInfo, isContentChanged));
                    this.notifyTracker(component, connection);
                    return oldInfo;
                }
                finally {
                    this.releaseMap(map);
                }
            }
            catch (DBHMException e) {
                this.setCorrupt(true, "Failure when setting item info", e.getCause());
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.MetadataChangeTracker_6, e.getCause()));
            }
        } else {
            if (this.itemPathUnchanged(newInfo, oldInfo)) return oldInfo;
            this.notifyTracker(component, connection);
        }
        return oldInfo;
    }

    @Override
    public ISharingDescriptor setSharingDescriptor(IPath sharePath, ISharingDescriptor descriptor, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ISharingDescriptor oldDesc = this.delegate.setSharingDescriptor(sharePath, descriptor, (IProgressMonitor)progress.newChild(50));
        if (oldDesc != null) {
            if (descriptor == null || !oldDesc.getConnectionHandle().sameItemId((IItemHandle)descriptor.getConnectionHandle()) || !oldDesc.getComponent().sameItemId((IItemHandle)descriptor.getComponent())) {
                final LockableMap<ChangeKey, LocalChangeInfo> oldMap = this.getMapFor(oldDesc.getComponent(), oldDesc.getConnectionHandle());
                try {
                    try {
                        final LockableMap<ChangeKey, LocalChangeInfo> newMap = descriptor != null ? this.getMapFor(descriptor.getComponent(), descriptor.getConnectionHandle()) : null;
                        try {
                            this.delegate.accept(new IVisitor(){

                                public boolean visit(IPath path, FileItemInfo entry, IProgressMonitor monitor) {
                                    if (!entry.isFolder()) {
                                        ChangeKey key = new ChangeKey(entry.getVersionableHandle());
                                        LocalChangeInfo info = (LocalChangeInfo)oldMap.entries().remove(key);
                                        if (info != null) {
                                            if (info.isForwardMapChanged()) {
                                                LocalChangeInfo newInfo = (LocalChangeInfo)newMap.entries().get(key);
                                                newInfo = newInfo == null ? new LocalChangeInfo(false, true) : new LocalChangeInfo(newInfo.inverseMapChanged(), true);
                                                newMap.entries().put(key, newInfo);
                                            }
                                            if (info.inverseMapChanged()) {
                                                oldMap.entries().put(key, new LocalChangeInfo(true, false));
                                            }
                                        }
                                    }
                                    return true;
                                }
                            }, sharePath, Integer.MAX_VALUE, false, (IProgressMonitor)progress.newChild(50));
                        }
                        finally {
                            if (newMap != null) {
                                this.releaseMap(newMap);
                            }
                        }
                    }
                    catch (DBHMException e) {
                        this.setCorrupt(true, null, e.getCause());
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.MetadataChangeTracker_7, e.getCause()));
                    }
                }
                finally {
                    this.releaseMap(oldMap);
                }
            }
            this.notifyTracker(oldDesc.getComponent(), oldDesc.getConnectionHandle());
        }
        if (descriptor != null) {
            this.notifyTracker(descriptor.getComponent(), descriptor.getConnectionHandle());
        }
        return oldDesc;
    }

    @Override
    public String toDebugString() {
        return this.delegate.toDebugString();
    }

    @Override
    public Map<IPath, ISharingDescriptor> getSharingDescriptors(IComponentHandle component, IContextHandle connectionHandle) throws FileSystemClientException {
        return this.delegate.getSharingDescriptors(component, connectionHandle);
    }

    @Override
    public Collection<LoadedConfigurationDescriptor> allLoadedComponents(IProgressMonitor monitor) throws FileSystemClientException {
        return this.delegate.allLoadedComponents(monitor);
    }

    @Override
    public Collection<ConnectionDescriptor> allLoadedContexts(IProgressMonitor monitor) throws FileSystemClientException {
        return this.delegate.allLoadedContexts(monitor);
    }

    @Override
    public LoadedConfigurationDescriptor componentLoaded(LoadedConfigurationDescriptor desc, IProgressMonitor monitor) throws FileSystemClientException {
        return this.delegate.componentLoaded(desc, monitor);
    }

    @Override
    public LoadedConfigurationDescriptor componentUnloaded(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        return this.delegate.componentUnloaded(component, connection, monitor);
    }

    @Override
    public boolean hasShares(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        return this.delegate.hasShares(component, connection, monitor);
    }

    @Override
    public boolean isLoaded(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        return this.delegate.isLoaded(component, connection, monitor);
    }

    @Override
    public PersistentBusyFlag getPersistentMetadataFlag() {
        return this.delegate.getPersistentMetadataFlag();
    }

    @Override
    public void addCorruptionListener(ICorruptCopyFileAreaListener listener) {
        this.delegate.addCorruptionListener(listener);
    }

    @Override
    public void removeCorruptionListener(ICorruptCopyFileAreaListener listener) {
        this.delegate.removeCorruptionListener(listener);
    }

    @Override
    public void setCorrupt(boolean value, String debugText, Throwable reason) {
        this.delegate.setCorrupt(value, debugText, reason);
    }

    @Override
    public boolean isCorrupted() {
        return this.delegate.isCorrupted();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChangeDiskBackedMapManager
    extends DiskBackedMapManager<ChangeKey, LocalChangeInfo> {
        public ChangeDiskBackedMapManager(ReadWriteLock lock, PersistentBusyFlag flag, ICorruptible corruptible) {
            super(lock, flag, corruptible);
        }

        @Override
        protected LockableMap<ChangeKey, LocalChangeInfo> getLockableMap(IPath path, IPath realPath) {
            return new ChangeMap(path);
        }
    }

    protected static class ChangeKey {
        protected IVersionableHandle item;

        public ChangeKey(IVersionableHandle item) {
            if (item == null) {
                throw new NullPointerException();
            }
            this.item = item;
        }

        public int hashCode() {
            return this.item.getItemId().getUuidValue().hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChangeKey)) {
                return false;
            }
            ChangeKey other = (ChangeKey)o;
            return this.item.sameItemId((IItemHandle)other.item);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChangeMap
    extends LockableMap<ChangeKey, LocalChangeInfo> {
        public ChangeMap(IPath path) {
            super(path, MetadataChangeTracker.this.basePath.append(path).toFile());
        }

        @Override
        protected void initEntries() {
            try {
                this.entries = new ChangedDescriptorsStore(MetadataChangeTracker.this.basePath.append(this.getPath()).toFile(), MetadataChangeTracker.this.heapMgr);
            }
            catch (DBHMException e) {
                MetadataChangeTracker.this.setCorrupt(e);
                throw e;
            }
        }
    }

    protected static class ChangeType
    implements IVersionableTree.IChangeType {
        private IVersionableHandle item;
        private int changeType;
        private IFolderHandle currentParent;
        private IFolderHandle previousParent;
        private IPath currentPath;
        private IPath originalPath;
        private IPath currentMovedFromPath;
        private boolean isContentChange;
        private boolean isFlagChange;

        public ChangeType(IVersionableHandle item, int changeType, IFolderHandle currentParent, IFolderHandle previousParent, IPath currentPath, IPath originalpath, IPath currentMovedFromPath, boolean isContentChange, boolean isFlagChange) {
            this.item = item;
            this.changeType = changeType;
            this.currentParent = currentParent;
            this.previousParent = previousParent;
            this.currentPath = currentPath;
            this.originalPath = originalpath;
            this.currentMovedFromPath = currentMovedFromPath;
            this.isContentChange = isContentChange;
            this.isFlagChange = isFlagChange;
        }

        public IFolderHandle getCurrentParent() {
            return this.currentParent;
        }

        public IPath getCurrentPath() {
            return this.currentPath;
        }

        public IPath getOriginalPath() {
            return this.originalPath;
        }

        public IVersionableHandle getItem() {
            return this.item;
        }

        public IFolderHandle getPreviousParent() {
            return this.previousParent;
        }

        public int getType() {
            return this.changeType;
        }

        public boolean isContentChange() {
            return this.isContentChange;
        }

        public boolean isFlagChange() {
            return this.isFlagChange;
        }

        public IPath getCurrentMovedFromPath() {
            return this.currentMovedFromPath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ChangedDescriptorsStore
    extends Store<ChangeKey, LocalChangeInfo> {
        private static final int KEY_TAG = 0;
        private static final int VALUE_TAG = 1;

        public ChangedDescriptorsStore(File file, PersistentHeapManager mgr) {
            super(file, mgr);
        }

        private long persistStream(ByteArrayOutputStream out) throws IOException {
            long offset = this.heap.allocate((long)out.size());
            out.writeTo(this.heap.getOutputStream(offset));
            return offset;
        }

        protected long writeObject(Object o, int flags) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(out);
            if (o instanceof ChangeKey) {
                ChangeKey key = (ChangeKey)o;
                dos.write(0);
                dos.writeBoolean(key.item instanceof IFolderHandle);
                dos.writeUTF(key.item.getItemId().getUuidValue());
                return this.persistStream(out);
            }
            LocalChangeInfo info = (LocalChangeInfo)o;
            dos.write(1);
            dos.writeInt(1);
            boolean isPathChanged = info.inverseMapChanged();
            dos.writeBoolean(isPathChanged);
            boolean isContentChanged = info.isForwardMapChanged();
            dos.writeBoolean(isContentChanged);
            return this.persistStream(out);
        }

        protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
            DataInputStream dis = new DataInputStream(in);
            int tag = dis.read();
            switch (tag) {
                case -1: {
                    throw new EOFException();
                }
                case 0: {
                    boolean isFolder = dis.readBoolean();
                    UUID id = UUID.valueOf((String)dis.readUTF());
                    IVersionableHandle item = (IVersionableHandle)(isFolder ? IFolder.ITEM_TYPE : IFileItem.ITEM_TYPE).createItemHandle(id, null);
                    return new ChangeKey(item);
                }
                case 1: {
                    int version = dis.readInt();
                    if (version != 1) {
                        throw new StreamCorruptedException(NLS.bind((String)Messages.MetadataChangeTracker_0, (Object[])new Object[]{version, 1}));
                    }
                    boolean isPathChanged = dis.readBoolean();
                    boolean isContentChanged = dis.readBoolean();
                    return new LocalChangeInfo(isPathChanged, isContentChanged);
                }
            }
            throw new StreamCorruptedException(NLS.bind((String)Messages.MetadataChangeTracker_1, (Object[])new Object[]{tag}));
        }
    }
}

