/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.filesystem.client.internal.SharingMetadata2;
import com.ibm.team.filesystem.client.internal.Store;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadedComponentsStore
extends Store<ISharingMetadata.IConnectionComponent, LoadedConfigurationDescriptor> {
    private static final int METADATA_VERSION_M6D1 = 0;

    public LoadedComponentsStore(PersistentHeapManager mgr, File file) {
        super(file, mgr);
    }

    protected long persistStream(ByteArrayOutputStream out) throws IOException {
        long offset = this.heap.allocate((long)out.size());
        out.writeTo(this.heap.getOutputStream(offset));
        return offset;
    }

    protected long writeObject(Object o, int flags) throws IOException {
        boolean isKey = (flags & 1) != 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(out);
        dos.writeInt(0);
        if (isKey) {
            SharingMetadata2.ConnectionComponent cc = (SharingMetadata2.ConnectionComponent)o;
            IContextHandle connection = cc.getConnection();
            IComponentHandle component = cc.getComponent();
            dos.writeUTF(component.getItemId().getUuidValue());
            dos.writeUTF(connection.getItemType().getName());
            dos.writeUTF(connection.getItemType().getNamespaceURI());
            dos.writeUTF(connection.getItemId().getUuidValue());
        } else {
            LoadedConfigurationDescriptor cd = (LoadedConfigurationDescriptor)o;
            IContextHandle connection = cd.connectionHandle;
            String connectionName = cd.connectionName;
            String componentName = cd.componentName;
            IComponentHandle component = cd.componentHandle;
            String uri = cd.uri;
            UUID id = cd.id;
            dos.writeUTF(component.getItemId().getUuidValue());
            dos.writeUTF(connection.getItemType().getName());
            dos.writeUTF(connection.getItemType().getNamespaceURI());
            dos.writeUTF(connection.getItemId().getUuidValue());
            dos.writeUTF(uri);
            dos.writeUTF(id.getUuidValue());
            dos.writeUTF(connectionName);
            dos.writeUTF(componentName);
        }
        return this.persistStream(out);
    }

    protected Object readObject(long offset, int flags) throws IOException, ClassNotFoundException {
        String componentName;
        String connectionName;
        boolean isKey = (flags & 1) != 0;
        BufferedInputStream in = new BufferedInputStream(this.heap.getInputStream(offset));
        DataInputStream dis = new DataInputStream(in);
        dis.mark(4);
        int version = dis.readInt();
        if (version != 0) {
            dis.reset();
        }
        if (isKey) {
            UUID id = UUID.valueOf((String)dis.readUTF());
            IComponentHandle component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(id, null);
            String name = dis.readUTF();
            String uri = dis.readUTF();
            IItemType type = IItemType.IRegistry.INSTANCE.getItemType(name, uri);
            id = UUID.valueOf((String)dis.readUTF());
            IContextHandle connection = (IContextHandle)type.createItemHandle(id, null);
            return new SharingMetadata2.ConnectionComponent(connection, component);
        }
        UUID id = UUID.valueOf((String)dis.readUTF());
        IComponentHandle component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(id, null);
        String name = dis.readUTF();
        String uri = dis.readUTF();
        IItemType type = IItemType.IRegistry.INSTANCE.getItemType(name, uri);
        id = UUID.valueOf((String)dis.readUTF());
        IContextHandle connection = (IContextHandle)type.createItemHandle(id, null);
        uri = dis.readUTF();
        id = UUID.valueOf((String)dis.readUTF());
        if (version == 0) {
            connectionName = dis.readUTF();
            componentName = dis.readUTF();
        } else {
            connectionName = Messages.LoadedComponentsStore_0;
            componentName = Messages.LoadedComponentsStore_1;
        }
        return new LoadedConfigurationDescriptor(id, uri, connection, connectionName, component, componentName);
    }
}

