/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemView;
import com.ibm.team.filesystem.client.internal.operations.LocalFileSystemAcceptOperation;
import com.ibm.team.filesystem.client.internal.operations.LocalFileSystemLoadOperation;
import com.ibm.team.filesystem.client.internal.operations.LocalFileSystemVerifySharesOperation;
import com.ibm.team.filesystem.client.operations.AcceptDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAcceptOperation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.internal.ScmClientLibraryContext;
import org.eclipse.core.runtime.IPath;

public class FileSystemManager
implements IFileSystemManager {
    private final IClientLibraryContext context;

    public FileSystemManager(IClientLibraryContext context) {
        this.context = new ScmClientLibraryContext(context);
    }

    public FileSystemServiceProxy getFileSystemService() {
        return new FileSystemServiceProxy(this.context);
    }

    public IFileSystemView getFileSystemView(IConnection connection) {
        return new FileSystemView(new FileSystemServiceProxy(this.context), connection);
    }

    public IAcceptOperation getLocalFileSystemAcceptOperation(IPath localRoot, AcceptDilemmaHandler dilemmaHandler) {
        ThreadCheck.checkLongOpsAllowed();
        if (localRoot == null || !localRoot.toFile().exists()) {
            throw new IllegalArgumentException();
        }
        return new LocalFileSystemAcceptOperation(localRoot, dilemmaHandler);
    }

    public IVerifyInSyncOperation getLocalFileSystemVerifyInSyncOperation(IPath localRoot, OutOfSyncDilemmaHandler dilemmaHandler) {
        if (localRoot == null || !localRoot.toFile().exists()) {
            throw new IllegalArgumentException();
        }
        return new LocalFileSystemVerifySharesOperation(localRoot, dilemmaHandler);
    }

    public ILoadOperation getLocalFileSystemLoadOperation(IPath localRoot, int options, LoadDilemmaHandler dilemmaHandler) {
        if (localRoot == null || !localRoot.toFile().exists()) {
            throw new IllegalArgumentException();
        }
        if (options != 0 && options != 1 && options != 2) {
            throw new IllegalArgumentException();
        }
        LocalFileSystemLoadOperation op = new LocalFileSystemLoadOperation(localRoot, this.getLoadOperationFlags(options), dilemmaHandler);
        return op;
    }

    private int getLoadOperationFlags(int options) {
        int operationFlags = 0;
        if ((options & 1) == 1) {
            operationFlags = 1;
        } else if ((options & 2) == 2) {
            operationFlags = 2;
        }
        return operationFlags;
    }
}

