/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.repository.common.utils.HashCode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class FileStorage
implements IFileStorage {
    public static final boolean PLATFORM_SUPPORTS_EXEC_BIT = !System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");

    public boolean isContentChangedFrom(long lastModified, long size, IShareable shareable, InputStream in, IProgressMonitor monitor) throws FileSystemClientException {
        try {
            HashCode newHash;
            if (in == null) {
                throw new IllegalArgumentException("in may not be null");
            }
            if (shareable == null) {
                shareable = this.getShareable();
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (lastModified != -1L && lastModified == this.getModificationStamp()) {
                return false;
            }
            FileItemInfo oldInfo = SharingManager.getInstance().getItemInfo(shareable);
            if (oldInfo == null || oldInfo.getHash() == null || size != oldInfo.getContentLength()) {
                return true;
            }
            progress.beginTask(Messages.FileStorage_0, 100);
            try {
                newHash = HashCode.createHashCode((InputStream)in);
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.FileStorage_1, (Throwable)e));
            }
            boolean isSame = newHash.equals((Object)oldInfo.getHash());
            progress.done();
            boolean bl = !isSame;
            return bl;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                LoggingHelper.error("com.ibm.team.filesystem.client", Messages.FileStorage_2, e);
            }
        }
    }

    public boolean supportsExecBit() {
        return PLATFORM_SUPPORTS_EXEC_BIT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setExecutable(boolean exec, IProgressMonitor monitor) {
        Shareable shareable = this.getShareable();
        CopyFileAreaStore cfa = CopyFileAreaStore.getCopyFileArea(shareable.getRoot());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            ISchedulingRule rule = cfa.lock(shareable, (IProgressMonitor)progress.newChild(25));
            if (rule == null) {
                return false;
            }
            try {
                FileItemInfo info = cfa.getItemInfo(this.getFullPath());
                if (info == null) {
                    return false;
                }
                if (exec == info.isExecutable()) return true;
                info = new FileItemInfo(info.getVersionableHandle(), info.getLastModification(), info.getParent(), info.getName(), info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredContentId(), info.getStoredDeltaPredecessor(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredChecksum(), info.getStoredNumLineDelimiters(), exec, info.isOriginalExecutable());
                cfa.setItemInfo(shareable, info, (IProgressMonitor)progress.newChild(50));
                return true;
            }
            finally {
                cfa.release(rule, (IProgressMonitor)progress.newChild(25));
            }
        }
        catch (Exception e) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(e));
            return false;
        }
    }

    public boolean isExecutable() {
        FileItemInfo info = SharingManager.getInstance().getItemInfo(this.getShareable());
        return info == null ? false : info.isExecutable();
    }
}

