/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collision
implements ICollision {
    private final IShareable shareable;
    private final ArrayList<ILoadLocation> locations;
    private final boolean alreadyExists;
    private ILoadLocation loadLocation;
    private Object lock = new Object();
    private IFileSystemStatus status;

    public Collision(IShareable shareable, ILoadLocation loadLocation, boolean alreadyExists) {
        this.shareable = shareable;
        this.locations = new ArrayList();
        this.locations.add(loadLocation);
        this.alreadyExists = alreadyExists;
    }

    @Override
    public IShareable getShareable() {
        return this.shareable;
    }

    @Override
    public IFileSystemStatus getStatus() {
        if (this.status == null) {
            ISharingDescriptor descriptor;
            String name = this.shareable.getLocalFullPath().makeRelative().toString();
            IShare share = this.shareable.getShare();
            if (share != null) {
                ILocalChange[] changes;
                descriptor = share.getSharingDescriptor();
                if (share != null) {
                    name = String.valueOf(name) + " [" + descriptor.getConnectionName() + " - " + descriptor.getComponentName() + "]";
                }
                if ((changes = FileSystemCore.getSharingManager().getLocalChangeManager().getPendingChanges(new IShare[]{share})).length > 0) {
                    name = NLS.bind((String)Messages.Collision_0, (Object[])new Object[]{name, changes.length});
                }
            }
            if (this.alreadyExists) {
                if (share == null || share.getSharingDescriptor() == null) {
                    this.status = new FileSystemStatus(2, 333, NLS.bind((String)Messages.Collision_1, (Object[])new Object[]{name}));
                } else {
                    descriptor = share.getSharingDescriptor();
                    ConfigurationDescriptor shareConfig = new ConfigurationDescriptor(descriptor.getRepositoryId(), descriptor.getRepositoryUri(), descriptor.getConnectionHandle(), descriptor.getComponent());
                    for (ILoadLocation location : this.locations) {
                        if (!shareConfig.equals(((LoadLocation)location).getDescriptor())) continue;
                        this.status = new FileSystemStatus(2, 334, NLS.bind((String)Messages.Collision_2, (Object[])new Object[]{name}));
                        break;
                    }
                    if (this.status == null) {
                        this.status = new FileSystemStatus(4, 366, NLS.bind((String)Messages.Collision_3, (Object[])new Object[]{name}));
                    }
                }
            } else {
                this.status = this.locations.size() > 1 ? new FileSystemStatus(2, 204, NLS.bind((String)Messages.Collision_4, (Object[])new Object[]{name})) : new FileSystemStatus(2, 204, name);
            }
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILoadLocation getLoadLocation() {
        Object object = this.lock;
        synchronized (object) {
            return this.loadLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ILoadLocation> getLocations() {
        Object object = this.lock;
        synchronized (object) {
            return this.locations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoadLocation(ILoadLocation location) {
        Object object = this.lock;
        synchronized (object) {
            this.loadLocation = location;
        }
    }

    @Override
    public boolean collidedWithExistingContent() {
        return this.alreadyExists;
    }
}

