/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.repository.client.ITeamRepository;

public class FileSystemCore {
    public static final String ID = "com.ibm.team.filesystem.client";
    private static boolean isShutDown = false;

    public static ISharingManager getSharingManager() {
        return SharingManager.getInstance();
    }

    public static IFileSystemManager getFileSystemManager(ITeamRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException();
        }
        return (IFileSystemManager)repository.getClientLibrary(IFileSystemManager.class);
    }

    public static void startUp() {
        isShutDown = false;
    }

    public static void shutDown() throws FileSystemClientException {
        isShutDown = true;
        SharingManager.conditionalShutDown();
    }

    public static boolean isShutDown() {
        return isShutDown;
    }

    private FileSystemCore() {
    }
}

