/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.http;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LengthLimitedOutputStream
extends FilterOutputStream {
    protected boolean errorOccured;
    protected long lengthRemaining;

    public LengthLimitedOutputStream(OutputStream out, long length) {
        super(out);
        this.lengthRemaining = length;
    }

    public long getLengthRemaining() {
        return this.lengthRemaining;
    }

    public void close() throws IOException {
        if (this.lengthRemaining != 0L && !this.errorOccured) {
            throw new IOException("Wrote too few bytes");
        }
    }

    public void flush() throws IOException {
        this.errorOccured = true;
        this.out.flush();
        this.errorOccured = false;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.errorOccured = true;
        if ((long)len > this.lengthRemaining) {
            throw new IOException("Attempting to write too many bytes");
        }
        this.out.write(b, off, len);
        this.lengthRemaining -= (long)len;
        this.errorOccured = false;
    }

    public void write(int b) throws IOException {
        this.errorOccured = true;
        if (this.lengthRemaining == 0L) {
            throw new IOException("Attempting to write too many bytes");
        }
        this.out.write(b);
        --this.lengthRemaining;
        this.errorOccured = false;
    }
}

