/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.http;

import com.ibm.team.filesystem.client.internal.http.HttpConnection;
import com.ibm.team.filesystem.client.internal.http.HttpUtil;
import com.ibm.team.filesystem.client.internal.http.constants.HttpMethod;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest {
    protected final HttpConnection connection;
    protected HttpMethod method;
    protected int protocolMajor;
    protected int protocolMinor;
    protected final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    protected URI uri;
    protected InputStream body;
    protected volatile boolean finishedReading;

    public HttpRequest(HttpConnection connection) {
        this.connection = connection;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public int getMajorVersion() {
        return this.protocolMajor;
    }

    public int getMinorVersion() {
        return this.protocolMinor;
    }

    public List<String> getHeader(String key) {
        key = key.toLowerCase(Locale.ENGLISH);
        return this.headers.get(key);
    }

    public String getFirstHeader(String key) {
        List<String> result = this.getHeader(key);
        if (result == null) {
            return null;
        }
        return result.get(0);
    }

    public URI getRequestURI() {
        return this.uri;
    }

    public InputStream getRequestBody() {
        return this.body;
    }

    protected void setFinishedReading() {
        this.finishedReading = true;
        this.connection.requestFinished();
    }

    public void addHeader(String key, String value) {
        List<String> values = this.headers.get(key = key.toLowerCase(Locale.ENGLISH));
        if (values == null) {
            values = new ArrayList<String>();
            this.headers.put(key, values);
        }
        values.add(value);
    }

    public String[] getPathSegments() {
        return HttpUtil.getPathSegments(this.getRequestURI().getPath());
    }
}

