/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.daemon;

import com.ibm.team.filesystem.client.daemon.IHttpServer;
import com.ibm.team.filesystem.client.daemon.IJSONReceiver;
import com.ibm.team.filesystem.client.daemon.IServerController;
import com.ibm.team.filesystem.client.daemon.IServiceDescription;
import com.ibm.team.filesystem.client.daemon.JSONMethod;
import com.ibm.team.filesystem.client.daemon.Parameters;
import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import com.ibm.team.filesystem.client.internal.http.HttpContext;
import com.ibm.team.filesystem.client.internal.http.HttpHandler;
import com.ibm.team.filesystem.client.internal.http.HttpRequest;
import com.ibm.team.filesystem.client.internal.http.HttpResponse;
import com.ibm.team.filesystem.client.internal.http.HttpServer;
import com.ibm.team.filesystem.client.internal.http.constants.HttpMethod;
import com.ibm.team.filesystem.client.internal.http.constants.ResponseCode;
import com.ibm.team.filesystem.client.internal.marshalling.ParameterWrapperDeserializer;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestMarshallingException;
import com.ibm.team.filesystem.client.restproxy.notification.HttpProgressReporter;
import com.ibm.team.filesystem.client.restproxy.notification.IServerNotificationChannel;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.impl.WebServicesMarshaller;
import com.ibm.team.repository.common.serialize.ISerializer2;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.utils.UnsynchronizedByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.RegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONHandler
extends HttpHandler {
    private static final Log log = LogFactory.getLog((String)JSONHandler.class.getName());
    public static final String SERVICE_PREFIX = "service";
    protected final Map<String, JSONMethod> methods = new HashMap<String, JSONMethod>();
    protected final Map<String, IServiceDescription> services = new HashMap<String, IServiceDescription>();
    protected FSDaemon fsd;
    protected HttpServer server;
    IServerController controller = new IServerController(){

        public void shutdown() throws IOException {
            JSONHandler.this.server.shutdown();
        }
    };
    private final ParameterWrapperDeserializer deserializer;
    private final HashMap<String, IConfigurationElement> lazyExtensionPoints = new HashMap();

    public JSONHandler() {
        this.deserializer = new ParameterWrapperDeserializer();
    }

    @Override
    public void registered(FSDaemon fsd, HttpServer httpServer, Collection<HttpContext> httpContext) {
        this.fsd = fsd;
        this.server = httpServer;
        this.loadHandlers();
    }

    protected void loadHandlers() {
        IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client.daemon", "restservice");
        HashMap<String, IConfigurationElement> ids = new HashMap<String, IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            String id = config.getAttribute("id");
            if (ids.containsKey(id)) {
                log.error((Object)("Multiple definitions for extension com.ibm.team.filesystem.client.daemon.restservice id=\"" + id + "\" (using entry contributed by \"" + ((IConfigurationElement)ids.get(id)).getContributor().getName() + "\", discarding entry contributed by \"" + config.getContributor().getName() + "\")"));
            } else {
                ids.put(id, config);
                if (JSONHandler.isLazyConfig(config)) {
                    this.lazyExtensionPoints.put(id, config);
                } else {
                    this.installService(id, config);
                }
                String version = config.getAttribute("version");
                this.services.put(id, new ServiceDescription(id, version));
            }
            ++n2;
        }
    }

    private void installService(String id, IConfigurationElement config) {
        Object receiver;
        try {
            receiver = config.createExecutableExtension("class");
        }
        catch (CoreException coreException) {
            log.error((Object)("Could not instantiate class " + id + " from plugin " + config.getContributor().getName() + " for extension point " + "com.ibm.team.filesystem.client.daemon" + ".restservice"));
            return;
        }
        if (!this.addReceiverMethods(receiver, id)) {
            log.error((Object)("Failed to install methods for " + id + " from plugin " + config.getContributor().getName()));
            return;
        }
        if (receiver instanceof IJSONReceiver) {
            ((IJSONReceiver)receiver).setController(this.controller, this);
        }
    }

    private static boolean isLazyConfig(IConfigurationElement config) {
        String val = config.getAttribute("lazy_start");
        if (val == null) {
            return true;
        }
        return !"false".equals(val.trim().toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean addReceiverMethods(Object receiver, String path) {
        Method[] methods;
        Method[] methodArray = methods = receiver.getClass().getMethods();
        synchronized (methods) {
            Method[] methodArray2 = methods;
            int n = methods.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return true;
                }
                Method m = methodArray2[n2];
                Class<?>[] params = m.getParameterTypes();
                if (params.length <= 2 && !(params.length != 1 ? params.length == 2 && (!IParameterWrapper.class.isAssignableFrom(params[0]) || params.length == 2 && params[1] != IProgressMonitor.class && params[1] != IProgressMonitorWithBlocking.class) : !IParameterWrapper.class.isAssignableFrom(params[0]) && params[0] != IProgressMonitor.class && params[0] != IProgressMonitorWithBlocking.class)) {
                    if (m.getName().startsWith(HttpMethod.GET.toString().toLowerCase(Locale.ENGLISH)) || m.getName().startsWith(HttpMethod.POST.toString().toLowerCase(Locale.ENGLISH))) {
                        String key = String.valueOf(path) + "." + m.getName();
                        if (this.methods.containsKey(key)) {
                            log.error((Object)("Multiple definitions of " + key));
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                            return false;
                        }
                        JSONMethod jm = new JSONMethod(receiver, m);
                        this.methods.put(key, jm);
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public void handle(HttpRequest rq, HttpResponse rp) throws IOException {
        Object result;
        Object[] params;
        JSONMethod m = this.getMethod(rq.getMethod(), rq.getPathSegments());
        if (m == null) {
            this.sendErrorResponse(rp, ResponseCode.NOT_FOUND.getCode(), "Unknown service: " + rq.getRequestURI().getRawPath());
            return;
        }
        Parameters parm = this.buildParameters(rq, rp);
        try {
            params = this.demarshallParameters(parm, m, rq, rp);
        }
        catch (RestMarshallingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.sendErrorResponse(rp, ResponseCode.BAD_REQUEST.getCode(), ResponseCode.BAD_REQUEST.getDefaultText(), e);
            return;
        }
        try {
            try {
                result = m.getMethod().invoke(m.getReceiver(), params);
            }
            finally {
                if (params.length != 0 && params[params.length - 1] instanceof HttpProgressReporter) {
                    HttpProgressReporter r = (HttpProgressReporter)params[params.length - 1];
                    r.finish();
                }
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof TeamRepositoryException || e.getCause() instanceof IllegalArgumentException) {
                log.info((Object)e.getMessage(), (Throwable)e);
            } else {
                log.error((Object)e.getCause().getMessage(), e.getCause());
            }
            this.sendErrorResponse(rp, ResponseCode.INTERNAL_SERVER_ERROR.getCode(), ResponseCode.INTERNAL_SERVER_ERROR.getDefaultText(), e.getCause());
            return;
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.sendErrorResponse(rp, ResponseCode.INTERNAL_SERVER_ERROR.getCode(), ResponseCode.INTERNAL_SERVER_ERROR.getDefaultText());
            return;
        }
        UnsynchronizedByteArrayOutputStream bOut = new UnsynchronizedByteArrayOutputStream();
        WebServicesMarshaller webServicesMarshaller = (WebServicesMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.WEB_SERVICES_LITERAL);
        try {
            webServicesMarshaller.marshalServiceResponse(m.getMethod().getName(), m.getMethod().getDeclaringClass().getName(), m.getReturnType(), result, 1, (OutputStream)bOut, Charset.forName("UTF-8"));
        }
        catch (MarshallingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.sendErrorResponse(rp, ResponseCode.INTERNAL_SERVER_ERROR.getCode(), ResponseCode.INTERNAL_SERVER_ERROR.getDefaultText());
            return;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.sendErrorResponse(rp, ResponseCode.INTERNAL_SERVER_ERROR.getCode(), "Failed to marshal response", new RestMarshallingException("Failed to marshal response", e));
            return;
        }
        rp.setCode(ResponseCode.OK.getCode(), ResponseCode.OK.getDefaultText());
        rp.writeHeader("Content-Type", "text/json; charset=utf-8");
        int size = bOut.size();
        rp.writeHeader("Content-Length", Integer.toString(size));
        OutputStream out = rp.getResponseStream();
        out.write(bOut.getBuffer(), 0, size);
        out.close();
    }

    private String findProgressKey(HttpRequest rq) {
        return rq.getFirstHeader("X-Request-Progress");
    }

    private Object[] demarshallParameters(Parameters parm, JSONMethod m, HttpRequest rq, HttpResponse resp) {
        HttpProgressReporter progress = null;
        String key = this.findProgressKey(rq);
        if (m.takesProgress() && key != null) {
            progress = new HttpProgressReporter(this.findProgressKey(rq), this.fsd.getNotificationChannel(), resp);
        }
        if (m.getParameterType() == null) {
            if (m.takesProgress()) {
                return new Object[]{progress};
            }
            return new Object[0];
        }
        IParameterWrapper wrapper = this.deserializer.deserialize(m.getReceiver().getClass().getClassLoader(), parm, m.getParameterType());
        if (m.takesProgress()) {
            return new Object[]{wrapper, progress};
        }
        return new Object[]{wrapper};
    }

    protected String normalizeServicePath(HttpMethod method, String[] path) {
        if (path.length < 1) {
            return null;
        }
        if (!SERVICE_PREFIX.equals(path[0])) {
            return null;
        }
        String[] myPath = new String[path.length - 1];
        System.arraycopy(path, 1, myPath, 0, path.length - 2);
        myPath[myPath.length - 1] = String.valueOf(method.name().toLowerCase(Locale.ENGLISH)) + path[path.length - 1];
        StringBuffer buf = new StringBuffer();
        String[] stringArray = myPath;
        int n = myPath.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(s);
            ++n2;
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONMethod getMethod(HttpMethod method, String[] path) {
        Map<String, JSONMethod> map;
        String key;
        block13: {
            JSONMethod result;
            key = this.normalizeServicePath(method, path);
            map = this.methods;
            synchronized (map) {
                result = this.methods.get(key);
            }
            if (result != null) {
                return result;
            }
            map = this.lazyExtensionPoints;
            synchronized (map) {
                int lastDot;
                block12: {
                    if (this.lazyExtensionPoints.size() <= 0) break block13;
                    lastDot = key.lastIndexOf(".");
                    if (lastDot != -1) break block12;
                    return null;
                }
                String id = key.substring(0, lastDot);
                IConfigurationElement config = this.lazyExtensionPoints.remove(id);
                if (config != null) {
                    this.installService(id, config);
                }
            }
        }
        map = this.methods;
        synchronized (map) {
            return this.methods.get(key);
        }
    }

    protected Parameters buildParameters(HttpRequest rq, HttpResponse rp) throws IOException {
        String encoding;
        Parameters p = new Parameters();
        this.addParametersFromQuery(rq.getRequestURI().getRawQuery(), p);
        if (rq.getMethod() == HttpMethod.POST && "application/x-www-form-urlencoded".equals(encoding = rq.getFirstHeader("Content-Type"))) {
            int c;
            InputStream in = rq.getRequestBody();
            String length = rq.getFirstHeader("Content-Length");
            int len = 32;
            if (length != null) {
                len = Integer.valueOf(length);
            }
            StringBuilder b = new StringBuilder(len);
            while ((c = in.read()) != -1) {
                b.append((char)c);
            }
            this.addParametersFromQuery(b.toString(), p);
        }
        return p;
    }

    protected void addParametersFromQuery(String q, Parameters p) throws IOException {
        if (q != null) {
            int end;
            int len = q.length();
            int start = 0;
            do {
                String pair;
                int keyEnd;
                if ((end = q.indexOf(38, start)) == -1) {
                    end = len;
                }
                if ((keyEnd = (pair = q.substring(start, end)).indexOf(61)) == -1) {
                    p.put(URLDecoder.decode(pair, "UTF-8"), null);
                } else {
                    String key = pair.substring(0, keyEnd);
                    String value = pair.substring(keyEnd + 1);
                    key = URLDecoder.decode(key, "UTF-8");
                    value = URLDecoder.decode(value, "UTF-8");
                    p.put(key, value);
                }
                start = end + 1;
            } while (end != len);
        }
    }

    protected void sendErrorResponse(HttpResponse r, int code, String text) throws IOException {
        r.setCode(code, text);
    }

    protected void sendErrorResponse(HttpResponse r, int code, String text, Throwable e) throws IOException {
        ISerializer2 serializer = ISerializer2.FACTORY.newInstance(HttpUtil.MediaType.JSON, "", false, null);
        UnsynchronizedByteArrayOutputStream bOut = new UnsynchronizedByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)bOut, Charset.forName("UTF-8"));
        try {
            serializer.serializeException(e, Integer.valueOf(code), (Writer)w);
        }
        catch (Exception ex) {
            log.error((Object)"Failed to serialize exception", (Throwable)ex);
            this.sendErrorResponse(r, code, text);
            return;
        }
        w.close();
        r.setCode(code, text);
        r.writeHeader("Content-Type", "application/vnd.ibm.jazz-json-stacktrace-1.0; charset=utf-8");
        int size = bOut.size();
        r.writeHeader("Content-Length", Integer.toString(size));
        r.getResponseStream().write(bOut.getBuffer(), 0, size);
    }

    public IServerNotificationChannel getNotificationChannel() {
        return this.fsd.getNotificationChannel();
    }

    public IHttpServer getHttpServer() {
        return this.fsd.getHttpServer();
    }

    public FSDaemon getFSDaemon() {
        return this.fsd;
    }

    public Map<String, IServiceDescription> getServiceDescriptions() {
        return this.services;
    }

    private static class ServiceDescription
    implements IServiceDescription {
        final String id;
        final String version;

        public ServiceDescription(String id, String version) {
            this.id = id;
            this.version = version;
        }

        public String getServiceId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

