/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.dashboard;

import com.ibm.team.feed.core.internal.ChannelManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.ui.internal.FeedUIPlugin;
import com.ibm.team.jface.itemview.ItemViewUIConfigurer;
import com.ibm.team.jface.itemview.NotifyingFilterSet;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;

class FeedSectionState {
    private final ItemViewUIConfigurer fConfigurer;
    private final NotifyingFilterSet fPreferredFilterIds;
    private boolean fEnableMarkReadOnHover;
    private boolean fEnableMarkReadOnFocus;
    private int fMarkReadAfter;
    private String fPreferredSorterId;
    private ChannelManager fChannelManager;
    private final ListenerList fListeners;
    private boolean fEnableMarkReadOnSlideout;

    public FeedSectionState(ItemViewUIConfigurer configurer) {
        this.fConfigurer = configurer;
        this.fPreferredFilterIds = new NotifyingFilterSet();
        this.fChannelManager = new ChannelManager();
        this.fEnableMarkReadOnHover = false;
        this.fEnableMarkReadOnFocus = false;
        this.fEnableMarkReadOnSlideout = false;
        this.fMarkReadAfter = 2000;
        this.fListeners = new ListenerList();
    }

    public FeedSectionState(FeedSectionState state) {
        this.fConfigurer = state.getConfigurer();
        this.fChannelManager = new ChannelManager();
        HashSet selectedChannelUrls = state.getChannelManager().getSelectedChannelUrls();
        for (String selectedChannelUrl : selectedChannelUrls) {
            this.fChannelManager.selectChannel(selectedChannelUrl);
        }
        this.fPreferredSorterId = state.getPreferredSorterId();
        this.fEnableMarkReadOnFocus = state.isEnableMarkReadOnFocus();
        this.fEnableMarkReadOnHover = state.isEnableMarkReadOnHover();
        this.fEnableMarkReadOnSlideout = state.isEnableMarkReadOnSlideout();
        this.fMarkReadAfter = state.getMarkReadAfter();
        this.fPreferredFilterIds = new NotifyingFilterSet();
        for (String id : state.getPreferredFilterIds()) {
            this.fPreferredFilterIds.add((Object)id);
        }
        this.fListeners = new ListenerList();
    }

    public Set getPreferredFilterIds() {
        return this.fPreferredFilterIds;
    }

    public boolean isEnableMarkReadOnHover() {
        return this.fEnableMarkReadOnHover;
    }

    public void setEnableMarkReadOnHover(boolean enableMarkReadOnHover) {
        this.fEnableMarkReadOnHover = enableMarkReadOnHover;
        this.fireEnableMarkReadOnHoverChanged();
    }

    public boolean isEnableMarkReadOnFocus() {
        return this.fEnableMarkReadOnFocus;
    }

    public void setEnableMarkReadOnFocus(boolean enableMarkReadOnFocus) {
        this.fEnableMarkReadOnFocus = enableMarkReadOnFocus;
        this.fireEnableMarkReadOnFocusChanged();
    }

    public void setEnableMarkReadOnSlideout(boolean enableMarkReadOnSlideout) {
        this.fEnableMarkReadOnSlideout = enableMarkReadOnSlideout;
    }

    public boolean isEnableMarkReadOnSlideout() {
        return this.fEnableMarkReadOnSlideout;
    }

    public int getMarkReadAfter() {
        return this.fMarkReadAfter;
    }

    public void setMarkReadAfter(int markReadAfter) {
        this.fMarkReadAfter = markReadAfter;
        this.fireMarkReadAfterChanged();
    }

    public String getPreferredSorterId() {
        return this.fPreferredSorterId;
    }

    public void setPreferredSorterId(String preferredSorterId) {
        this.fPreferredSorterId = preferredSorterId;
        this.firePreferredSorterIdChanged();
    }

    public ItemViewUIConfigurer getConfigurer() {
        return this.fConfigurer;
    }

    public ChannelManager getChannelManager() {
        return this.fChannelManager;
    }

    public void setChannelManager(ChannelManager channelManager) {
        this.fChannelManager = channelManager;
    }

    public void addFilterSelectionChangedListener(NotifyingFilterSet.IFilterSelectionChangedListener listener) {
        this.fPreferredFilterIds.addFilterSelectionChangedListener(listener);
    }

    public void removeFilterSelectionChangedListener(NotifyingFilterSet.IFilterSelectionChangedListener listener) {
        this.fPreferredFilterIds.removeFilterSelectionChangeListener(listener);
    }

    public void addFeedSectionStateListener(FeedSectionStateListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeFeedSectionStateListener(FeedSectionStateListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void changeChannelSelection(Channel channel, boolean isSelected) {
        if (isSelected) {
            this.fChannelManager.selectChannel(channel);
        } else {
            this.fChannelManager.deselectChannel(channel);
        }
        this.fireChannelSelectionChanged(channel, isSelected);
    }

    private void firePreferredSorterIdChanged() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                FeedUIPlugin.getDefault().log(new Status(4, "com.ibm.team.feed.ui", "Error while fireing preferred sorter id changed", exception));
            }

            public void run() throws Exception {
                Object[] listeners;
                Object[] objectArray = listeners = FeedSectionState.this.fListeners.getListeners();
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    FeedSectionStateListener listener = (FeedSectionStateListener)object;
                    listener.preferredSorterIdChanged(FeedSectionState.this.fPreferredSorterId);
                    ++n2;
                }
            }
        });
    }

    private void fireEnableMarkReadOnHoverChanged() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                FeedUIPlugin.getDefault().log(new Status(4, "com.ibm.team.feed.ui", "Error while firing enable mark read on hover changed", exception));
            }

            public void run() throws Exception {
                Object[] listeners;
                Object[] objectArray = listeners = FeedSectionState.this.fListeners.getListeners();
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    FeedSectionStateListener listener = (FeedSectionStateListener)object;
                    listener.enableMarkReadOnHoverChanged(FeedSectionState.this.fEnableMarkReadOnHover);
                    ++n2;
                }
            }
        });
    }

    private void fireEnableMarkReadOnFocusChanged() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                FeedUIPlugin.getDefault().log(new Status(4, "com.ibm.team.feed.ui", "Error while firing enable mark read on focus changed", exception));
            }

            public void run() throws Exception {
                Object[] listeners;
                Object[] objectArray = listeners = FeedSectionState.this.fListeners.getListeners();
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    FeedSectionStateListener listener = (FeedSectionStateListener)object;
                    listener.enableMarkReadOnFocusChanged(FeedSectionState.this.fEnableMarkReadOnFocus);
                    ++n2;
                }
            }
        });
    }

    private void fireMarkReadAfterChanged() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                FeedUIPlugin.getDefault().log(new Status(4, "com.ibm.team.feed.ui", "Error while firing mark read after changed", exception));
            }

            public void run() throws Exception {
                Object[] listeners;
                Object[] objectArray = listeners = FeedSectionState.this.fListeners.getListeners();
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    FeedSectionStateListener listener = (FeedSectionStateListener)object;
                    listener.markReadAfterChanged(FeedSectionState.this.fMarkReadAfter);
                    ++n2;
                }
            }
        });
    }

    private void fireChannelSelectionChanged(final Channel channel, final boolean selected) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                FeedUIPlugin.getDefault().log(new Status(4, "com.ibm.team.feed.ui", "Error while firing channel selection changed", exception));
            }

            public void run() throws Exception {
                Object[] listeners;
                Object[] objectArray = listeners = FeedSectionState.this.fListeners.getListeners();
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    FeedSectionStateListener listener = (FeedSectionStateListener)object;
                    listener.channelSelectionChanged(channel, selected);
                    ++n2;
                }
            }
        });
    }

    public static class FeedSectionStateListener {
        public void preferredSorterIdChanged(String newState) {
        }

        public void enableMarkReadOnHoverChanged(boolean newState) {
        }

        public void enableMarkReadOnFocusChanged(boolean newState) {
        }

        public void markReadAfterChanged(int newState) {
        }

        public void channelSelectionChanged(Channel channel, boolean selected) {
        }
    }
}

