/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.dashboard;

import com.ibm.team.feed.core.ChannelAdapter;
import com.ibm.team.feed.core.ChannelEvent;
import com.ibm.team.feed.core.ClientFeedUtils;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.IChannelListener;
import com.ibm.team.feed.core.INewsListener;
import com.ibm.team.feed.core.INewsManagerListener;
import com.ibm.team.feed.core.NewsEvent;
import com.ibm.team.feed.core.internal.ChannelManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.EditFeedAction;
import com.ibm.team.feed.ui.internal.FeedUIPlugin;
import com.ibm.team.feed.ui.internal.HelpContextIds;
import com.ibm.team.feed.ui.internal.OpenFeedsAggregatedAction;
import com.ibm.team.feed.ui.internal.OpenNewsAction;
import com.ibm.team.feed.ui.internal.dashboard.FeedSectionConfigurationDialog;
import com.ibm.team.feed.ui.internal.dashboard.FeedSectionState;
import com.ibm.team.feed.ui.internal.dashboard.Messages;
import com.ibm.team.feed.ui.internal.dashboard.NewsContentProvider;
import com.ibm.team.feed.ui.internal.dashboard.NewsLabelProvider;
import com.ibm.team.feed.ui.internal.dashboard.NewsModel;
import com.ibm.team.feed.ui.internal.dashboard.NewsTableViewer;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.NoScrollbarsTable;
import com.ibm.team.jface.dashboard.ISectionListener;
import com.ibm.team.jface.dashboard.ISectionSite;
import com.ibm.team.jface.dashboard.Section;
import com.ibm.team.jface.dashboard.SectionLabel;
import com.ibm.team.jface.internal.ItemViewAdvisorManager;
import com.ibm.team.jface.internal.dashboard.views.SectionPart;
import com.ibm.team.jface.itemview.ItemViewerFilter;
import com.ibm.team.jface.itemview.ItemViewerSorter;
import com.ibm.team.jface.itemview.NotifyingFilterSet;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;

public class FeedSection
extends Section
implements ISectionListener {
    private static final String EVENT_LOG_ID = "com.ibm.magnolia.rss.ui.eventSection";
    private static final String PREF_SELECTED_CHANNELS = "PREF_SELECTED_CHANNELS";
    private static final String PREF_MARK_READ_ON_SLIDEOUT_TOOLTIP = "PREF_MARK_READ_ON_SLIDEOUT_TOOLTIP";
    private static final String PREF_MARK_READ_ON_HOVER_TOOLTIP = "PREF_MARK_READ_ON_HOVER_TOOLTIP";
    private static final String PREF_MARK_READ_ON_FOCUS_TOOLTIP = "PREF_MARK_READ_ON_FOCUS_TOOLTIP";
    private static final String PREF_MARK_READ_AFTER = "PREF_MARK_READ_AFTER";
    private static final String PREF_SORTER_ID = "PREF_SORTER_ID";
    private static final String MEMENTO_FILTERS = "MEMENTO_FILTERS";
    private static final String PREF_FILTER_ID = "PREF_FILTER_ID";
    private static final String PARAM_FEED_CATEGORY = "feedCategory";
    private static final String PARAM_ITEM_LABEL = "itemLabel";
    private String fItemLabel = Messages.getString("FeedSection.NEWS");
    private NoScrollbarsTable fCustomScrollTable;
    private boolean fIsExpanded;
    private boolean fShowSubjectRelationShipIndicator = true;
    private INewsListener fNewsListener;
    private NewsModel fNewsModel;
    private SectionLabel fTeaserLabel;
    private NewsTableViewer fViewer;
    private boolean isMac = "carbon".equals(SWT.getPlatform());
    private INewsManagerListener fNewsManagerListener;
    private NewsContentProvider fContentProvider;
    private FeedSectionState fState;
    private StackLayout fStack;
    private Composite fEmpty;
    private Composite fContainer;
    private boolean fDisposed;
    private MenuItem fMarkAllRead;
    private ChannelAdapter fChannelListener;

    public void init(ISectionSite sectionSite, IMemento memento) {
        super.init(sectionSite, memento);
        String parameterValue = sectionSite.getParameterValue(PARAM_FEED_CATEGORY);
        this.fShowSubjectRelationShipIndicator = "com.ibm.team.feed.core.SystemFeed".equals(parameterValue);
        this.loadContributions();
        this.loadState(memento);
        this.registerListeners();
    }

    public void refreshContent() {
        if (this.fNewsModel != null) {
            this.fNewsModel.reloadAll();
        }
    }

    public void createContent(Composite parent) {
        int iconWidth;
        this.fStack = new StackLayout();
        parent.setLayout((Layout)this.fStack);
        this.fContainer = new Composite(parent, 0);
        this.fContainer.setBackground(parent.getBackground());
        this.fContainer.setLayout((Layout)new FillLayout());
        int n = iconWidth = this.fShowSubjectRelationShipIndicator ? 32 : 16;
        if (this.isMac) {
            Table newsTable = new Table(this.fContainer, 98306);
            this.fViewer = new NewsTableViewer(this.getSectionSite(), newsTable, iconWidth);
        } else {
            this.fCustomScrollTable = new NoScrollbarsTable(this.fContainer, 98306);
            this.fCustomScrollTable.getTable().setBackground(this.fContainer.getBackground());
            this.fViewer = new NewsTableViewer(this.getSectionSite(), this.fCustomScrollTable.getTable(), iconWidth);
        }
        this.hookCustomOwnerDrawn();
        this.fContentProvider = new NewsContentProvider(this.getSectionSite(), this.fState.getChannelManager());
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        if (this.fState.getConfigurer() != null) {
            List sorters = this.fState.getConfigurer().getSorters();
            for (ItemViewerSorter sorter : sorters) {
                if (!this.fState.getPreferredSorterId().equals(sorter.getId())) continue;
                this.fViewer.setSorter(sorter.getViewerSorter());
                break;
            }
        }
        if (this.fState.getConfigurer() != null) {
            List filters = this.fState.getConfigurer().getFilters();
            for (ItemViewerFilter filter : filters) {
                if (!this.fState.getPreferredFilterIds().contains(filter.getId())) continue;
                this.fViewer.addFilter(filter.getViewerFilter());
            }
        }
        this.fNewsModel = new NewsModel();
        this.fViewer.setInput(this.fNewsModel);
        this.getSectionSite().addSelectionProvider((ISelectionProvider)this.fViewer);
        TooltipSupport tooltipSupport = this.fViewer.getTooltipSupport();
        tooltipSupport.setEnableMarkReadOnFocus(this.fState.isEnableMarkReadOnFocus());
        tooltipSupport.setEnableMarkReadOnHover(this.fState.isEnableMarkReadOnHover());
        tooltipSupport.setMarkReadAfter(this.fState.getMarkReadAfter());
        this.fViewer.getSlideoutSupport().setMarkReadOnOpen(this.fState.isEnableMarkReadOnSlideout());
        this.createContextMenu(this.fViewer);
        this.hookListeners();
        this.fEmpty = new Composite(parent, 0);
        this.fEmpty.setLayout((Layout)new FillLayout());
        this.fEmpty.setBackground(parent.getBackground());
        Link link = new Link(this.fEmpty, 16384);
        link.setBackground(this.fEmpty.getBackground());
        link.setText(NLS.bind((String)Messages.getString("FeedSection.POPULATE_SECTION_CONFIGURATION_DIALOG"), (Object[])new Object[]{"config"}));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ("config".equals(e.text)) {
                    FeedSection.this.onConfigure();
                }
            }
        });
        HelpContextIds.hookHelpListener((Control)parent, "com.ibm.team.feed.ui.feed_section");
    }

    private void updateMenuEnablement(int unreadItems) {
        if (this.fMarkAllRead != null && !this.fMarkAllRead.isDisposed()) {
            this.fMarkAllRead.setEnabled(unreadItems != 0);
        }
    }

    private void updateStackLayout() {
        if (this.fStack != null && this.fViewer != null && !this.fDisposed) {
            Composite top = null;
            top = this.fState.getChannelManager().getSelectedChannelUrls().size() == 0 ? this.fEmpty : this.fContainer;
            if (top != this.fStack.topControl) {
                this.fStack.topControl = top;
                this.fStack.topControl.getParent().layout();
            }
        }
    }

    private void hookListeners() {
        this.fViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u007f' && e.stateMask == 0) {
                    FeedSection.this.deleteSelectedNewsItems();
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == ' ') {
                    e.doit = false;
                    IStructuredSelection selection = (IStructuredSelection)FeedSection.this.fViewer.getSelection();
                    GenericAggregationBin firstElement = (GenericAggregationBin)selection.getFirstElement();
                    if (firstElement != null) {
                        FeedSection.this.updateReadStateOnSelection(selection, firstElement.containsUnread());
                    }
                }
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                GenericAggregationBin bin = (GenericAggregationBin)selection.getFirstElement();
                if (bin != null) {
                    FeedSection.this.updateReadStateOnSelection((IStructuredSelection)FeedSection.this.fViewer.getSelection(), true);
                    Object mostRecent = bin.getMostRecent();
                    if (mostRecent instanceof NewsItem) {
                        new OpenNewsAction(FeedSection.this.getSectionSite(), (NewsItem)mostRecent).run();
                    }
                }
            }
        });
        this.fState.addFilterSelectionChangedListener(new NotifyingFilterSet.IFilterSelectionChangedListener(){

            public void filterSelectionChanged(Collection enabledFilters, Collection disabledFilters) {
                if (FeedSection.this.fIsExpanded && FeedSection.this.fViewer != null && !FeedSection.this.fViewer.getControl().isDisposed()) {
                    List filters;
                    for (String filterid : enabledFilters) {
                        filters = FeedSection.this.fState.getConfigurer().getFilters();
                        for (ItemViewerFilter filter : filters) {
                            if (!filter.getId().equals(filterid)) continue;
                            FeedSection.this.fViewer.addFilter(filter.getViewerFilter());
                        }
                    }
                    for (String filterid : disabledFilters) {
                        filters = FeedSection.this.fState.getConfigurer().getFilters();
                        for (ItemViewerFilter filter : filters) {
                            if (!filter.getId().equals(filterid)) continue;
                            FeedSection.this.fViewer.removeFilter(filter.getViewerFilter());
                        }
                    }
                    FeedSection.this.updateSectionHeader();
                    FeedSection.this.getSectionSite().onContentChange();
                }
            }
        });
        this.fState.addFeedSectionStateListener(new FeedSectionState.FeedSectionStateListener(){

            public void preferredSorterIdChanged(String newState) {
                List sorters = FeedSection.this.fState.getConfigurer().getSorters();
                for (ItemViewerSorter sorter : sorters) {
                    if (!sorter.getId().equals(newState)) continue;
                    FeedSection.this.fViewer.setSorter(sorter.getViewerSorter());
                    break;
                }
            }

            public void enableMarkReadOnFocusChanged(boolean newState) {
                if (FeedSection.this.fViewer != null) {
                    FeedSection.this.fViewer.getTooltipSupport().setEnableMarkReadOnFocus(newState);
                }
            }

            public void enableMarkReadOnHoverChanged(boolean newState) {
                if (FeedSection.this.fViewer != null) {
                    FeedSection.this.fViewer.getTooltipSupport().setEnableMarkReadOnHover(newState);
                }
            }

            public void markReadAfterChanged(int newState) {
                if (FeedSection.this.fViewer != null) {
                    FeedSection.this.fViewer.getTooltipSupport().setMarkReadAfter(newState);
                }
            }

            public void channelSelectionChanged(Channel channel, boolean selected) {
                FeedSection.this.inputChanged();
            }
        });
    }

    private void hookCustomOwnerDrawn() {
        NewsLabelProvider provider = new NewsLabelProvider();
        LabelProvider nooplabelProvider = new LabelProvider(){

            public String getText(Object element) {
                return Boolean.toString(((GenericAggregationBin)element).containsUnread());
            }
        };
        this.fViewer.setLabelProvider((IBaseLabelProvider)nooplabelProvider);
        Display display = this.fViewer.getControl().getDisplay();
        Table table = (Table)this.fViewer.getControl();
        Color fgGray = display.getSystemColor(16);
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources(), (Control)table);
        final TextLayout textLayout = new TextLayout((Device)display);
        table.addDisposeListener(new DisposeListener((ILabelProvider)provider){
            private final /* synthetic */ ILabelProvider val$provider;
            {
                this.val$provider = iLabelProvider;
            }

            public void widgetDisposed(DisposeEvent e) {
                textLayout.dispose();
                this.val$provider.dispose();
            }
        });
        Listener paintListener = new Listener((ILabelProvider)provider, (ResourceManager)resources, fgGray, textLayout){
            private final /* synthetic */ ILabelProvider val$provider;
            private final /* synthetic */ ResourceManager val$resources;
            private final /* synthetic */ Color val$fgGray;
            private final /* synthetic */ TextLayout val$textLayout;
            {
                this.val$provider = iLabelProvider;
                this.val$resources = resourceManager;
                this.val$fgGray = color;
                this.val$textLayout = textLayout;
            }

            public void handleEvent(Event event) {
                if (!FeedSection.this.fIsExpanded) {
                    return;
                }
                if (event.type == 40) {
                    event.detail &= 0xFFFFFFEF;
                    return;
                }
                TableItem item = (TableItem)event.item;
                Object element = item.getData();
                if (element == null) {
                    return;
                }
                Image image = this.val$provider.getImage(element);
                Image subImage = null;
                if (FeedSection.this.fShowSubjectRelationShipIndicator) {
                    NewsItem newsItem = (NewsItem)((GenericAggregationBin)element).getMostRecent();
                    String relation = ClientFeedUtils.getInstance().getRelation(newsItem);
                    subImage = JazzResources.getImageWithDefault((ResourceManager)this.val$resources, (ImageDescriptor)FeedUIPlugin.getSubjectRelationShipImageDescriptor(relation));
                }
                String text = this.val$provider.getText(element);
                Color fgc = null;
                Color fgc2 = null;
                if ((event.detail & 2) == 0) {
                    if (this.val$provider instanceof ITableColorProvider) {
                        fgc = ((ITableColorProvider)this.val$provider).getForeground(element, 0);
                    }
                    if (fgc == null && this.val$provider instanceof IColorDecorator) {
                        fgc = ((IColorDecorator)this.val$provider).decorateForeground(element);
                    }
                    if (fgc == null && this.val$provider instanceof IColorProvider) {
                        fgc = ((IColorProvider)this.val$provider).getForeground(element);
                    }
                    fgc2 = this.val$fgGray;
                } else {
                    fgc = fgc2 = event.gc.getForeground();
                }
                Font font = null;
                if (this.val$provider instanceof ITableFontProvider) {
                    font = ((ITableFontProvider)this.val$provider).getFont(element, 0);
                }
                if (font == null && this.val$provider instanceof IFontDecorator) {
                    font = ((IFontDecorator)this.val$provider).decorateFont(element);
                }
                if (font == null && this.val$provider instanceof IFontProvider) {
                    font = ((IFontProvider)this.val$provider).getFont(element);
                }
                event.gc.setFont(font);
                TextStyle normal = new TextStyle(event.gc.getFont(), fgc, null);
                TextStyle light = new TextStyle(event.gc.getFont(), fgc2, null);
                FeedSection.this.parse(this.val$textLayout, text, normal, light);
                Rectangle textLayoutBounds = this.val$textLayout.getBounds();
                switch (event.type) {
                    case 41: {
                        if (image != null) {
                            Rectangle rect = image.getBounds();
                            event.height = Math.max(event.height, rect.height + 2);
                            event.width += rect.width;
                            if (subImage != null) {
                                Rectangle rect2 = subImage.getBounds();
                                event.height = Math.max(event.height, rect2.height + 2);
                                event.width += rect2.width;
                            }
                            event.width += 4;
                        }
                        event.width += textLayoutBounds.width;
                        event.height = Math.max(event.height, textLayoutBounds.height + 2);
                        break;
                    }
                    case 42: {
                        int x = event.x;
                        if (image != null) {
                            Rectangle rect = image.getBounds();
                            int offset = Math.max(0, (event.height - rect.height) / 2);
                            event.gc.drawImage(image, x, event.y + offset);
                            x += rect.width;
                            if (subImage != null) {
                                Rectangle rect2 = subImage.getBounds();
                                int offset2 = Math.max(0, (event.height - rect2.height) / 2);
                                event.gc.drawImage(subImage, x, event.y + offset2);
                                x += rect2.width;
                            }
                            x += 4;
                        }
                        int offset = Math.max(0, (event.height - textLayoutBounds.height) / 2);
                        this.val$textLayout.draw(event.gc, x, event.y + offset);
                    }
                }
            }
        };
        table.addListener(41, paintListener);
        table.addListener(42, paintListener);
        table.addListener(40, paintListener);
    }

    private void parse(TextLayout textLayout, String text, TextStyle normal, TextStyle light) {
        if (text == null || text.length() == 0) {
            textLayout.setText("");
            textLayout.setStyle(normal, 0, 0);
            return;
        }
        StringBuffer sb = new StringBuffer();
        int l = text.length();
        int i = 0;
        while (i < l) {
            char c = text.charAt(i);
            if (c == '<') {
                if (text.indexOf("<light>", i) == i) {
                    i += "<light>".length() - 1;
                } else if (text.indexOf("</light>", i) == i) {
                    i += "</light>".length() - 1;
                } else {
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        textLayout.setText(sb.toString());
        int current = 0;
        int start = 0;
        TextStyle st = normal;
        i = 0;
        while (i < l) {
            char c = text.charAt(i);
            if (c == '<') {
                if (text.indexOf("<light>", i) == i) {
                    if (i > start) {
                        textLayout.setStyle(st, start, current);
                    }
                    i += "<light>".length() - 1;
                    start = current;
                    st = light;
                } else if (text.indexOf("</light>", i) == i) {
                    if (i > start) {
                        textLayout.setStyle(st, start, current);
                    }
                    i += "</light>".length() - 1;
                    start = current;
                    st = normal;
                } else {
                    ++current;
                }
            } else {
                ++current;
            }
            ++i;
        }
        if (current > start) {
            textLayout.setStyle(st, start, current);
        }
    }

    private void createContextMenu(final NewsTableViewer viewer) {
        final MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object channel;
                NewsItem newsItem;
                GenericAggregationBin bin = (GenericAggregationBin)((IStructuredSelection)viewer.getSelection()).getFirstElement();
                if (bin == null) {
                    newsItem = null;
                    HashSet urls = FeedSection.this.fState.getChannelManager().getSelectedChannelUrls();
                    channel = urls.isEmpty() ? null : FeedManager.getDefault().getChannel((String)urls.iterator().next());
                } else {
                    newsItem = (NewsItem)bin.getMostRecent();
                    channel = newsItem.getChannel();
                }
                OpenNewsAction openNewsAction = new OpenNewsAction(FeedSection.this.getSectionSite(), (IStructuredSelection)viewer.getSelection());
                menuMgr.add((IAction)openNewsAction);
                if (newsItem == null) {
                    openNewsAction.setEnabled(false);
                }
                menuMgr.add((IAction)new Action((Channel)channel){
                    private final /* synthetic */ Channel val$channel;
                    {
                        this.val$channel = channel;
                    }

                    public String getText() {
                        return Messages.getString("FeedSection.OPEN_FEED");
                    }

                    public boolean isEnabled() {
                        return this.val$channel != null;
                    }

                    public void run() {
                        FeedSection.this.sectionOpened();
                    }
                });
                menuMgr.add((IContributionItem)new Separator());
                menuMgr.add((IAction)new Action((Channel)channel){
                    private final /* synthetic */ Channel val$channel;
                    {
                        this.val$channel = channel;
                    }

                    public String getText() {
                        if (this.val$channel != null) {
                            return NLS.bind((String)Messages.getString("FeedSection.RELOAD_FEED"), (Object[])new Object[]{this.val$channel.getTitle()});
                        }
                        return Messages.getString("FeedSection.RELOAD");
                    }

                    public boolean isEnabled() {
                        return this.val$channel != null;
                    }

                    public void run() {
                        this.val$channel.setExplicitRefresh(true);
                        FeedSection.this.fNewsModel.reload(this.val$channel);
                    }
                });
                menuMgr.add((IAction)new Action((Channel)channel){
                    private final /* synthetic */ Channel val$channel;
                    {
                        this.val$channel = channel;
                    }

                    public String getText() {
                        if (this.val$channel != null) {
                            return NLS.bind((String)Messages.getString("FeedSection.EDIT_FEED"), (Object[])new Object[]{this.val$channel.getTitle()});
                        }
                        return Messages.getString("FeedSection.EDIT");
                    }

                    public boolean isEnabled() {
                        return this.val$channel != null;
                    }

                    public void run() {
                        StructuredSelection sel = new StructuredSelection((Object)this.val$channel);
                        new EditFeedAction((IStructuredSelection)sel, FeedSection.this.getSectionSite().getViewSite().getShell()).run(null);
                    }
                });
                menuMgr.add((IContributionItem)new Separator());
                menuMgr.add((IAction)new Action(){
                    private boolean fMarkRead;

                    public String getText() {
                        boolean read = true;
                        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                        Iterator iterator = selection.iterator();
                        while (read && iterator.hasNext()) {
                            GenericAggregationBin bin = (GenericAggregationBin)iterator.next();
                            boolean bl = read = read && !bin.containsUnread();
                        }
                        this.fMarkRead = !read;
                        return this.fMarkRead ? Messages.getString("FeedSection.MARK_READ") : Messages.getString("FeedSection.MARK_UNREAD");
                    }

                    public boolean isEnabled() {
                        return newsItem != null;
                    }

                    public void run() {
                        FeedSection.this.updateReadStateOnSelection(this.fMarkRead);
                    }
                });
                menuMgr.add((IAction)new Action(){

                    public String getText() {
                        return Messages.getString("FeedSection.DELETE");
                    }

                    public boolean isEnabled() {
                        return newsItem != null;
                    }

                    public void run() {
                        FeedSection.this.deleteSelectedNewsItems();
                    }
                });
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        viewer.getControl().setMenu(menuMgr.createContextMenu(viewer.getControl()));
        this.getSectionSite().getViewSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    public void createTeaser(Composite parent) {
        GridLayout grid = new GridLayout(2, false);
        grid.marginHeight = 0;
        grid.marginWidth = 1;
        grid.horizontalSpacing = 1;
        grid.marginTop = 1;
        parent.setLayout((Layout)grid);
        this.fTeaserLabel = new SectionLabel(parent, 131072);
        this.fTeaserLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fTeaserLabel);
        this.fTeaserLabel.setForeground(JazzResources.getColor((ResourceManager)resourceManager, (RGB)new RGB(80, 80, 80)));
        Font f = JFaceResources.getDefaultFont();
        FontData[] defFont = f.getFontData();
        int i = 0;
        while (i < defFont.length) {
            defFont[i].setHeight(defFont[i].getHeight() - 1);
            ++i;
        }
        this.fTeaserLabel.setFont(JazzResources.getFont((ResourceManager)resourceManager, (FontDescriptor)FontDescriptor.createFrom((FontData[])defFont), (Font)f));
        Menu filterMenu = this.getSectionSite().getSectionMenu();
        this.fMarkAllRead = new MenuItem(filterMenu, 0);
        this.fMarkAllRead.setText(Messages.getString("FeedSection.MARK_ALL_READ"));
        this.fMarkAllRead.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedSection.this.markAllNewsRead();
            }
        });
        MenuItem reloadAllNews = new MenuItem(filterMenu, 0);
        reloadAllNews.setText(Messages.getString("FeedSection.RELOAD_ALL_FEEDS"));
        reloadAllNews.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FeedSection.this.fNewsModel != null) {
                    FeedSection.this.fNewsModel.reloadAll();
                }
            }
        });
        new MenuItem(filterMenu, 2);
        MenuItem configMenuItem = new MenuItem(filterMenu, 0);
        configMenuItem.setText(Messages.getString("FeedSection.CONFIGURE"));
        configMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedSection.this.onConfigure();
            }
        });
        this.updateSectionHeader();
        HelpContextIds.hookHelpListener((Control)parent.getParent(), "com.ibm.team.feed.ui.feed_section");
    }

    private void onConfigure() {
        Shell shell = this.getSectionSite().getViewSite().getShell();
        FeedSectionConfigurationDialog.show(shell, this.fState);
        if (this.fViewer != null) {
            this.fViewer.getSlideoutSupport().setMarkReadOnOpen(this.fState.isEnableMarkReadOnSlideout());
        }
    }

    private void inputChanged() {
        this.getSectionSite().getViewSite().getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        if (exception instanceof Exception) {
                            FeedUIPlugin.getDefault().log(exception.getMessage(), (Exception)exception);
                        }
                    }

                    public void run() throws Exception {
                        if (FeedSection.this.fIsExpanded) {
                            FeedSection.this.fViewer.setInput(FeedSection.this.fNewsModel);
                            FeedSection.this.fViewer.refresh();
                            FeedSection.this.getSectionSite().onContentChange();
                        }
                        FeedSection.this.updateSectionHeader();
                    }
                });
            }
        });
    }

    public void dispose() {
        this.fDisposed = true;
        this.unregisterListeners();
        if (this.fCustomScrollTable != null) {
            this.fCustomScrollTable.dispose();
        }
        if (this.fViewer != null) {
            this.fViewer.dispose();
        }
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
        }
        this.fState.getChannelManager().dispose();
    }

    protected ChannelManager getChannelManager() {
        return this.fState.getChannelManager();
    }

    public Point getDefaultContentSize() {
        if (this.fViewer != null && this.fViewer.getTable().getItemCount() > 0) {
            return new Point(-1, this.fViewer.getTable().getItemHeight() * 5 + (this.isMac ? this.fViewer.getTable().getHorizontalBar().getSize().y : 0));
        }
        return new Point(-1, -1);
    }

    public Point getMinimalContentSize() {
        if (this.fViewer != null && this.fViewer.getTable().getItemCount() > 0) {
            return new Point(-1, this.fViewer.getTable().getItemHeight() * 2 + (this.isMac ? this.fViewer.getTable().getHorizontalBar().getSize().y : 0));
        }
        return new Point(-1, -1);
    }

    public Point getPreferredContentSize(int wHint, int hHint) {
        if (this.fViewer != null && this.fViewer.getTable().getItemCount() > 0) {
            return new Point(wHint, this.fViewer.getTable().getItemCount() * this.fViewer.getTable().getItemHeight() + (this.isMac ? this.fViewer.getTable().getHorizontalBar().getSize().y : 0));
        }
        return new Point(wHint, hHint);
    }

    private void loadState(IMemento memento) {
        if (memento == null) {
            List filters = this.fState.getConfigurer().getFilters();
            for (ItemViewerFilter filter : filters) {
                if (!filter.isEnabledByDefault()) continue;
                this.fState.getPreferredFilterIds().add(filter.getId());
            }
            return;
        }
        if (memento.getString(PREF_MARK_READ_ON_FOCUS_TOOLTIP) != null) {
            this.fState.setEnableMarkReadOnFocus(Boolean.valueOf(memento.getString(PREF_MARK_READ_ON_FOCUS_TOOLTIP)));
        }
        if (memento.getString(PREF_MARK_READ_ON_HOVER_TOOLTIP) != null) {
            this.fState.setEnableMarkReadOnHover(Boolean.valueOf(memento.getString(PREF_MARK_READ_ON_HOVER_TOOLTIP)));
        }
        if (memento.getString(PREF_MARK_READ_AFTER) != null) {
            this.fState.setMarkReadAfter(Integer.valueOf(memento.getString(PREF_MARK_READ_AFTER)));
        }
        if (memento.getString(PREF_MARK_READ_ON_SLIDEOUT_TOOLTIP) != null) {
            this.fState.setEnableMarkReadOnSlideout(Boolean.valueOf(memento.getString(PREF_MARK_READ_ON_SLIDEOUT_TOOLTIP)));
        }
        if (memento.getString(PREF_SORTER_ID) != null) {
            this.fState.setPreferredSorterId(memento.getString(PREF_SORTER_ID));
        }
        IMemento[] selectedFilters = this.getSectionMemento().getChildren(MEMENTO_FILTERS);
        int i = 0;
        while (i < selectedFilters.length) {
            IMemento childMemento = selectedFilters[i];
            this.fState.getPreferredFilterIds().add(childMemento.getString(PREF_FILTER_ID));
            ++i;
        }
        IMemento[] channelFilters = memento.getChildren(PREF_SELECTED_CHANNELS);
        int i2 = 0;
        while (i2 < channelFilters.length) {
            Channel channel;
            if (channelFilters[i2].getTextData() != null && (channel = FeedManager.getDefault().getChannel(channelFilters[i2].getTextData())) != null) {
                this.fState.getChannelManager().selectChannel(channel);
            }
            ++i2;
        }
    }

    public void saveState(IMemento memento) {
        memento.putString(PREF_MARK_READ_ON_HOVER_TOOLTIP, Boolean.toString(this.fState.isEnableMarkReadOnHover()));
        memento.putString(PREF_MARK_READ_ON_SLIDEOUT_TOOLTIP, Boolean.toString(this.fState.isEnableMarkReadOnSlideout()));
        memento.putString(PREF_MARK_READ_AFTER, Integer.toString(this.fState.getMarkReadAfter()));
        memento.putString(PREF_MARK_READ_ON_FOCUS_TOOLTIP, Boolean.toString(this.fState.isEnableMarkReadOnFocus()));
        memento.putString(PREF_SORTER_ID, this.fState.getPreferredSorterId());
        if (this.fState.getPreferredFilterIds().size() > 0) {
            Iterator iter = this.fState.getPreferredFilterIds().iterator();
            while (iter.hasNext()) {
                IMemento filters = memento.createChild(MEMENTO_FILTERS);
                String filterId = (String)iter.next();
                filters.putString(PREF_FILTER_ID, filterId);
            }
        }
        for (String url : this.fState.getChannelManager().getSelectedChannelUrls()) {
            memento.createChild(PREF_SELECTED_CHANNELS).putTextData(url);
        }
    }

    private void registerListeners() {
        this.getSectionSite().addSectionListener((ISectionListener)this);
        this.fNewsManagerListener = new INewsManagerListener(){

            public void channelAdded(ChannelEvent event) {
                Channel channel = event.getChannel();
                SectionPart.SectionSite sectionSite = (SectionPart.SectionSite)FeedSection.this.getSectionSite();
                String category = sectionSite.getParameterValue(FeedSection.PARAM_FEED_CATEGORY);
                if (category != null && category.equals(channel.getCategory())) {
                    if ("com.ibm.team.feed.core.SystemFeed".equals(channel.getCategory())) {
                        if (FeedSection.EVENT_LOG_ID.equals(sectionSite.getId())) {
                            FeedSection.this.fState.changeChannelSelection(event.getChannel(), true);
                        }
                    } else {
                        FeedSection.this.fState.changeChannelSelection(event.getChannel(), true);
                    }
                }
            }

            public void channelRemoved(ChannelEvent event) {
                FeedSection.this.fState.changeChannelSelection(event.getChannel(), false);
            }
        };
        FeedManager.getDefault().addNewsManagerListener(this.fNewsManagerListener);
        this.fNewsListener = new INewsListener(){

            public void newsReceived(NewsEvent event) {
                FeedSection.this.updateSectionHeader();
            }

            public void newsRemoved(NewsEvent event) {
                FeedSection.this.updateSectionHeader();
            }

            public void newsStateChanged(NewsEvent event) {
                FeedSection.this.updateSectionHeader();
            }
        };
        this.fState.getChannelManager().setNewsListener(this.fNewsListener);
        this.fChannelListener = new ChannelAdapter(){

            public void channelStatusChanged(ChannelEvent event) {
                Channel channel = event.getChannel();
                if (FeedSection.this.fState.getChannelManager().isChannelSelected(channel)) {
                    FeedSection.this.getSectionSite().setBusy(channel.isLoading());
                }
            }
        };
        FeedManager.getDefault().addChannelListener((IChannelListener)this.fChannelListener);
    }

    private void unregisterListeners() {
        this.getSectionSite().removeSectionListener((ISectionListener)this);
        FeedManager.getDefault().removeNewsManagerListener(this.fNewsManagerListener);
        FeedManager.getDefault().removeChannelListener((IChannelListener)this.fChannelListener);
    }

    private void loadContributions() {
        this.fState = new FeedSectionState(ItemViewAdvisorManager.getConfigurer());
        this.fState.setPreferredSorterId(this.fState.getConfigurer().getDefaultSorter().getId());
        String itemLabel = this.getSectionSite().getParameterValue(PARAM_ITEM_LABEL);
        if (itemLabel != null && itemLabel.length() > 0) {
            this.fItemLabel = itemLabel;
        }
        if (this.getSectionMemento() == null) {
            String category = this.getSectionSite().getParameterValue(PARAM_FEED_CATEGORY);
            Channel[] channels = FeedManager.getDefault().getChannels();
            int i = 0;
            while (i < channels.length) {
                Channel channel = channels[i];
                if (category == null && channel.getCategory() == null || category != null && category.equals(channel.getCategory())) {
                    this.fState.getChannelManager().selectChannel(channel);
                }
                ++i;
            }
        }
    }

    public boolean isExpanded() {
        return this.fIsExpanded;
    }

    public void sectionCollapsed() {
        this.fIsExpanded = false;
        this.updateSectionHeader();
    }

    public void sectionExpanded() {
        this.fIsExpanded = true;
        this.updateSectionHeader();
    }

    public void sectionMaximized(boolean isContentClipped) {
        if (!this.isMac && isContentClipped && this.fCustomScrollTable != null && !this.fCustomScrollTable.isDisposed()) {
            this.fCustomScrollTable.showVerticalScrollBarsOnce();
        }
    }

    public void sectionResized() {
    }

    public void setFocus() {
        if (this.fIsExpanded) {
            if (this.isMac && ((Table)this.fViewer.getControl()).getSelectionCount() > 0) {
                this.fViewer.getControl().setFocus();
            } else if (this.fCustomScrollTable != null && this.fCustomScrollTable.getTable().getSelectionCount() > 0) {
                this.fCustomScrollTable.getTable().setFocus();
            }
        }
    }

    protected void setShowSubjectRelationShipIndicator(boolean showIndicator) {
        this.fShowSubjectRelationShipIndicator = showIndicator;
    }

    private void deleteSelectedNewsItems() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        ArrayList<Object> itemsToDelete = new ArrayList<Object>(selection.size());
        for (Object obj : selection) {
            if (obj instanceof GenericAggregationBin) {
                GenericAggregationBin bin = (GenericAggregationBin)obj;
                List items = bin.getItems();
                for (Object item : items) {
                    if (!(item instanceof NewsItem)) continue;
                    itemsToDelete.add((NewsItem)item);
                }
                continue;
            }
            if (!(obj instanceof NewsItem)) continue;
            itemsToDelete.add((NewsItem)obj);
        }
        ArrayList<NewsItem> itemsToDeleteFromOtherChannels = new ArrayList<NewsItem>(selection.size());
        HashSet channelUrls = this.fState.getChannelManager().getSelectedChannelUrls();
        for (String channelUrl : channelUrls) {
            Channel channel = FeedManager.getDefault().getChannel(channelUrl);
            if (channel == null) continue;
            NewsItem[] channelItems = channel.getItems();
            block3: for (NewsItem newsItem : itemsToDelete) {
                if (newsItem.getChannel() == null || newsItem.getChannel().equals((Object)channel)) continue;
                NewsItem[] newsItemArray = channelItems;
                int n = channelItems.length;
                int n2 = 0;
                while (n2 < n) {
                    NewsItem channelItem = newsItemArray[n2];
                    if (channelItem.equals((Object)newsItem)) {
                        itemsToDeleteFromOtherChannels.add(channelItem);
                        continue block3;
                    }
                    ++n2;
                }
            }
        }
        itemsToDelete.addAll(itemsToDeleteFromOtherChannels);
        FeedManager.getDefault().deleteNewsItems(itemsToDelete.toArray(new NewsItem[itemsToDelete.size()]));
    }

    private void updateReadStateOnSelection(boolean markRead) {
        this.updateReadStateOnSelection((IStructuredSelection)this.fViewer.getSelection(), markRead);
    }

    private void updateReadStateOnSelection(IStructuredSelection selection, boolean markRead) {
        ArrayList<Object> itemsToUpdate = new ArrayList<Object>();
        if (!markRead) {
            for (Object obj : selection) {
                if (!(obj instanceof GenericAggregationBin)) continue;
                itemsToUpdate.add(((GenericAggregationBin)obj).getMostRecent());
            }
        } else {
            for (Object obj : selection) {
                if (!(obj instanceof GenericAggregationBin)) continue;
                GenericAggregationBin bin = (GenericAggregationBin)obj;
                List items = bin.getItems();
                for (Object element : items) {
                    if (!(element instanceof NewsItem)) continue;
                    itemsToUpdate.add(element);
                }
            }
        }
        FeedManager.getDefault().setRead(itemsToUpdate.toArray(new NewsItem[itemsToUpdate.size()]), markRead);
    }

    private void markAllNewsRead() {
        ArrayList<NewsItem> itemsToMarkRead = new ArrayList<NewsItem>();
        HashSet channelUrls = this.fState.getChannelManager().getSelectedChannelUrls();
        for (String channelUrl : channelUrls) {
            Channel channel = FeedManager.getDefault().getChannel(channelUrl);
            if (channel == null) continue;
            NewsItem[] items = channel.getItems();
            int i = 0;
            while (i < items.length) {
                itemsToMarkRead.add(items[i]);
                ++i;
            }
        }
        FeedManager.getDefault().setRead(itemsToMarkRead.toArray(new NewsItem[itemsToMarkRead.size()]), true);
    }

    private void updateSectionHeader() {
        HashSet selectedChannelUrls = this.fState.getChannelManager().getSelectedChannelUrls();
        final int unread = FeedManager.getDefault().countUnreadNews(new ArrayList(selectedChannelUrls), true);
        if (!this.fTeaserLabel.isDisposed() && !this.fTeaserLabel.getDisplay().isDisposed()) {
            this.fTeaserLabel.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!FeedSection.this.fTeaserLabel.isDisposed() && !FeedSection.this.fTeaserLabel.getDisplay().isDisposed()) {
                        int visibleUnreadNews = unread;
                        if (FeedSection.this.fViewer != null && !FeedSection.this.fViewer.getControl().isDisposed()) {
                            visibleUnreadNews = FeedSection.this.countVisibleUnreadNews();
                        }
                        if (!FeedSection.this.fIsExpanded) {
                            if (visibleUnreadNews != 0) {
                                FeedSection.this.fTeaserLabel.setText(NLS.bind((String)Messages.getString("FeedSection.UNREAD_COUNT"), (Object[])new Object[]{visibleUnreadNews}));
                            } else {
                                FeedSection.this.fTeaserLabel.setText("");
                            }
                            FeedSection.this.getSectionSite().layoutTeaser();
                        } else {
                            if (visibleUnreadNews != 0) {
                                FeedSection.this.fTeaserLabel.setText(NLS.bind((String)Messages.getString("FeedSection.UNREAD_NEWS_INDICATOR"), (Object[])new Object[]{FeedSection.this.fItemLabel, visibleUnreadNews}));
                            } else {
                                FeedSection.this.fTeaserLabel.setText("");
                            }
                            FeedSection.this.getSectionSite().layoutTeaser();
                        }
                        FeedSection.this.updateStackLayout();
                        FeedSection.this.updateMenuEnablement(visibleUnreadNews);
                    }
                }
            });
        }
    }

    private int countVisibleUnreadNews() {
        Object[] visibleItems;
        int unreadCount = 0;
        HashSet channelUrls = this.fState.getChannelManager().getSelectedChannelUrls();
        ArrayList newsItems = new ArrayList();
        for (String channelUrl : channelUrls) {
            Channel channel = FeedManager.getDefault().getChannel(channelUrl);
            if (channel == null) continue;
            newsItems.addAll(Arrays.asList(channel.getItems()));
        }
        HashMap<String, GenericAggregationBin> bins = new HashMap<String, GenericAggregationBin>();
        for (NewsItem newsitem : newsItems) {
            GenericAggregationBin bin = (GenericAggregationBin)bins.get(newsitem.getLink());
            if (bin == null) {
                bin = new GenericAggregationBin();
                bins.put(newsitem.getLink(), bin);
            }
            bin.add((Object)newsitem);
        }
        Collection values = bins.values();
        GenericAggregationBin[] binArray = values.toArray(new GenericAggregationBin[values.size()]);
        Object[] objectArray = visibleItems = this.fViewer.getFilteredChildren(binArray);
        int n = visibleItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof NewsItem && !((NewsItem)item).isIsRead()) {
                ++unreadCount;
            } else if (item instanceof GenericAggregationBin && ((GenericAggregationBin)item).containsUnread()) {
                ++unreadCount;
            }
            ++n2;
        }
        return unreadCount;
    }

    public void sectionOpened() {
        ChannelManager cm = this.getChannelManager();
        HashSet selectedChannelUrls = cm.getSelectedChannelUrls();
        String[] channelUrls = selectedChannelUrls.toArray(new String[selectedChannelUrls.size()]);
        Channel[] channels = new Channel[channelUrls.length];
        int i = 0;
        while (i < channelUrls.length) {
            channels[i] = FeedManager.getDefault().getChannel(channelUrls[i]);
            ++i;
        }
        ISectionSite site = this.getSectionSite();
        String id = site.getName();
        String name = site.getName();
        IWorkbenchPage page = site.getViewSite().getPage();
        OpenFeedsAggregatedAction action = new OpenFeedsAggregatedAction(id, channels, page, name, this.fState.getPreferredSorterId(), this.fState.getPreferredFilterIds());
        action.run(null);
    }
}

