/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.FeedUIPlugin;
import com.ibm.team.feed.ui.internal.Messages;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.jface.itemview.MarkupItemViewInput;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class OpenFeedsAggregatedAction
implements IObjectActionDelegate {
    private String fSectionId;
    private Channel[] fFeeds;
    private IWorkbenchPage fPage;
    private String fName;
    private String fPreferredSorterId;
    private Set fPreferredFilterIds;
    private DateFormat fDateFormat = DateFormat.getDateInstance();
    private boolean fUseGlobalSettings;

    public OpenFeedsAggregatedAction() {
        this.fUseGlobalSettings = true;
    }

    public OpenFeedsAggregatedAction(String sectionId, Channel[] feeds, IWorkbenchPage page, String name, boolean useGlobalSettings) {
        this(sectionId, feeds, page, name, null, null);
        this.fUseGlobalSettings = useGlobalSettings;
    }

    public OpenFeedsAggregatedAction(String sectionId, Channel[] feeds, IWorkbenchPage page, String name, String preferredSorterId, Set preferredFilterIds) {
        this.fSectionId = sectionId;
        this.fFeeds = feeds;
        this.fPage = page;
        this.fName = name;
        this.fPreferredSorterId = preferredSorterId;
        this.fPreferredFilterIds = preferredFilterIds;
        this.fUseGlobalSettings = false;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPage = targetPart.getSite().getPage();
    }

    public void run(IAction action) {
        String id = this.fSectionId;
        if (id == null) {
            StringBuffer newId = new StringBuffer();
            int i = 0;
            while (i < this.fFeeds.length) {
                newId.append(this.fFeeds[i].hashCode());
                ++i;
            }
            id = newId.toString();
        }
        if (this.fName == null && this.fFeeds.length > 0) {
            this.fName = NLS.bind((String)Messages.OpenFeedsAggregatedAction_MERGED_FEEDS, (Object[])new Object[]{this.fFeeds[0].getTitle()});
        }
        MarkupItemViewInput input = this.fUseGlobalSettings ? new MarkupItemViewInput((Object)this.fFeeds, this.fName, id, true) : new MarkupItemViewInput((Object)this.fFeeds, this.fName, id, this.fPreferredSorterId, this.fPreferredFilterIds);
        String title = NLS.bind((String)Messages.OpenFeedsAggregatedAction_TIMELINE_NAME, (Object[])new Object[]{this.fName});
        String status = Messages.OpenFeedsAggregatedAction_NO_ITEMS_AVAILABLE;
        Date firstItemDate = null;
        Date lastItemDate = null;
        int i = 0;
        while (i < this.fFeeds.length) {
            Channel channel = this.fFeeds[i];
            NewsItem[] items = channel.getItems();
            int j = 0;
            while (j < items.length) {
                NewsItem item = items[j];
                if (firstItemDate == null || firstItemDate != null && firstItemDate.after(item.getPublishDate())) {
                    firstItemDate = item.getPublishDate();
                }
                if (lastItemDate == null || lastItemDate != null && lastItemDate.before(item.getPublishDate())) {
                    lastItemDate = item.getPublishDate();
                }
                ++j;
            }
            ++i;
        }
        if (firstItemDate != null && lastItemDate != null) {
            status = NLS.bind((String)Messages.OpenFeedsAggregatedAction_DATE_FROM_TO, (Object[])new Object[]{this.fDateFormat.format(firstItemDate), this.fDateFormat.format(lastItemDate)});
        }
        input.setTitle(title);
        input.setStatusLabel(status);
        OpenFeedsAggregatedAction.openMarkupItemStream(this.fPage, input);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            ArrayList<Object> channels = new ArrayList<Object>();
            Object[] objects = sel.toArray();
            int i = 0;
            while (i < objects.length) {
                Object object = objects[i];
                if (object instanceof Channel) {
                    channels.add(object);
                }
                ++i;
            }
            this.fFeeds = channels.toArray(new Channel[channels.size()]);
        }
    }

    private static void openMarkupItemStream(IWorkbenchPage page, MarkupItemViewInput input) {
        if (page == null) {
            page = FoundationUIUtils.getActivePage();
        }
        if (page != null) {
            IEditorPart editor = page.findEditor((IEditorInput)input);
            boolean editorPinned = page.isEditorPinned(editor);
            if (editor != null && !editorPinned && !editor.isDirty() && editor instanceof IReusableEditor) {
                ((IReusableEditor)editor).setInput((IEditorInput)input);
                try {
                    page.openEditor((IEditorInput)input, editor.getSite().getId());
                }
                catch (PartInitException e) {
                    FeedUIPlugin.getDefault().log("can't open markup item view", (Exception)((Object)e));
                }
            } else {
                try {
                    if (!editorPinned) {
                        page.openEditor((IEditorInput)input, "com.ibm.team.jface.MarkupItemView");
                    } else {
                        page.openEditor((IEditorInput)input, "com.ibm.team.jface.MarkupItemView", true, 0);
                    }
                }
                catch (PartInitException e) {
                    FeedUIPlugin.getDefault().log("can't open markup item view", (Exception)((Object)e));
                }
            }
        }
    }
}

