/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.ui.internal.Messages;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;

public class DeleteSubscriptionAction
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private Shell fParentShell;

    public DeleteSubscriptionAction(IWorkbenchSite targetSite) {
        this.fParentShell = targetSite.getShell();
    }

    public DeleteSubscriptionAction(Shell shell, IStructuredSelection selection) {
        this.fParentShell = shell;
        this.fSelection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        String message;
        boolean isSingleSelection = this.fSelection.size() <= 1;
        String title = isSingleSelection ? Messages.DeleteSubscriptionAction_DELETE_FEED : Messages.DeleteSubscriptionAction_DELETE_FEEDS;
        String string = message = isSingleSelection ? NLS.bind((String)Messages.DeleteSubscriptionAction_CONFIRM_DELETE_SINGLE, (Object[])new Object[]{((Channel)this.fSelection.getFirstElement()).getTitle()}) : Messages.DeleteSubscriptionAction_CONFIRM_DELETE_MULTI;
        if (MessageDialog.openConfirm((Shell)this.fParentShell, (String)title, (String)message.toString())) {
            for (Channel channel : this.fSelection) {
                FeedManager.getDefault().removeChannel(channel);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }
}

