/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.datawarehouse.common.internal.impl;

import com.ibm.team.datawarehouse.common.internal.DatawarehouseFactory;
import com.ibm.team.datawarehouse.common.internal.DatawarehousePackage;
import com.ibm.team.datawarehouse.common.internal.FieldAggregationKind;
import com.ibm.team.datawarehouse.common.internal.FieldDataKind;
import com.ibm.team.datawarehouse.common.internal.FieldDescriptor;
import com.ibm.team.datawarehouse.common.internal.ItemDescriptor;
import com.ibm.team.datawarehouse.common.internal.OrderByKind;
import com.ibm.team.datawarehouse.common.internal.SnapshotDescriptor;
import com.ibm.team.datawarehouse.common.internal.TableDescriptor;
import com.ibm.team.datawarehouse.common.internal.ViewDescriptor;
import com.ibm.team.datawarehouse.common.internal.impl.FieldDescriptorImpl;
import com.ibm.team.datawarehouse.common.internal.impl.ItemDescriptorImpl;
import com.ibm.team.datawarehouse.common.internal.impl.OrderByEntryImpl;
import com.ibm.team.datawarehouse.common.internal.impl.SnapshotDescriptorImpl;
import com.ibm.team.datawarehouse.common.internal.impl.TableDescriptorImpl;
import com.ibm.team.datawarehouse.common.internal.impl.ViewDescriptorImpl;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class DatawarehouseFactoryImpl
extends EFactoryImpl
implements DatawarehouseFactory {
    public static DatawarehouseFactory init() {
        try {
            DatawarehouseFactory theDatawarehouseFactory = (DatawarehouseFactory)EPackage.Registry.INSTANCE.getEFactory("com.ibm.team.datawarehouse");
            if (theDatawarehouseFactory != null) {
                return theDatawarehouseFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DatawarehouseFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return (EObject)this.createSnapshotDescriptor();
            }
            case 3: {
                return (EObject)this.createTableDescriptor();
            }
            case 5: {
                return (EObject)this.createViewDescriptor();
            }
            case 7: {
                return (EObject)this.createItemDescriptor();
            }
            case 9: {
                return (EObject)this.createFieldDescriptor();
            }
            case 11: {
                return (EObject)this.createOrderByEntry();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 12: {
                return this.createFieldDataKindFromString(eDataType, initialValue);
            }
            case 13: {
                return this.createFieldAggregationKindFromString(eDataType, initialValue);
            }
            case 14: {
                return this.createOrderByKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 12: {
                return this.convertFieldDataKindToString(eDataType, instanceValue);
            }
            case 13: {
                return this.convertFieldAggregationKindToString(eDataType, instanceValue);
            }
            case 14: {
                return this.convertOrderByKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public SnapshotDescriptor createSnapshotDescriptor() {
        SnapshotDescriptorImpl snapshotDescriptor = new SnapshotDescriptorImpl();
        return snapshotDescriptor;
    }

    public TableDescriptor createTableDescriptor() {
        TableDescriptorImpl tableDescriptor = new TableDescriptorImpl();
        return tableDescriptor;
    }

    public FieldDescriptor createFieldDescriptor() {
        FieldDescriptorImpl fieldDescriptor = new FieldDescriptorImpl();
        return fieldDescriptor;
    }

    public Map.Entry createOrderByEntry() {
        OrderByEntryImpl orderByEntry = new OrderByEntryImpl();
        return orderByEntry;
    }

    public ViewDescriptor createViewDescriptor() {
        ViewDescriptorImpl viewDescriptor = new ViewDescriptorImpl();
        return viewDescriptor;
    }

    public ItemDescriptor createItemDescriptor() {
        ItemDescriptorImpl itemDescriptor = new ItemDescriptorImpl();
        return itemDescriptor;
    }

    public FieldDataKind createFieldDataKindFromString(EDataType eDataType, String initialValue) {
        FieldDataKind result = FieldDataKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertFieldDataKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public FieldAggregationKind createFieldAggregationKindFromString(EDataType eDataType, String initialValue) {
        FieldAggregationKind result = FieldAggregationKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertFieldAggregationKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public OrderByKind createOrderByKindFromString(EDataType eDataType, String initialValue) {
        OrderByKind result = OrderByKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertOrderByKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DatawarehousePackage getDatawarehousePackage() {
        return (DatawarehousePackage)this.getEPackage();
    }

    @Deprecated
    public static DatawarehousePackage getPackage() {
        return DatawarehousePackage.eINSTANCE;
    }
}

