/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.dashboard.internal.rcp.ui.editor;

import com.ibm.icu.text.BreakIterator;
import com.ibm.team.dashboard.common.internal.dto.ConfigurationElement;
import com.ibm.team.dashboard.common.internal.service.IDashboardExtensionData;
import com.ibm.team.dashboard.internal.rcp.ui.client.IDashboardClientService;
import com.ibm.team.dashboard.internal.rcp.ui.editor.DashboardEntriesAspectEditor;
import com.ibm.team.dashboard.internal.rcp.ui.editor.DashboardImages;
import com.ibm.team.dashboard.internal.rcp.ui.editor.DashboardTemplatesAspectEditor;
import com.ibm.team.dashboard.internal.rcp.ui.editor.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.ide.ui.ProcessAspectEditor2;
import com.ibm.team.process.internal.common.model.settings.ProcessConfigurationElement;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.misc.StatusUtil;

public abstract class AbstractDashboardAspectEditor
extends ProcessAspectEditor2 {
    static final EnumChoice[] BOOLEAN_CHOICES = new EnumChoice[]{new EnumChoice("", ""), new EnumChoice(Messages.booleanTrueChoice, "true"), new EnumChoice(Messages.booleanFalseChoice, "false")};
    static final String DISABLED_LINK_COLOR_KEY = "DISABLED_LINK_COLOR";
    private ManagedForm mform;
    protected DashboardModel model;
    protected DashboardBlock block;
    protected IDashboardExtensionData extensionData = null;
    protected ElementListSelectionDialog viewletChooser;
    Action ACTION_ADD_MEMENTO_PROPERTY = new Action(){

        public void run() {
            DashboardElement element = AbstractDashboardAspectEditor.this.getCurrentElement();
            if (element instanceof MementoElement || element instanceof MementoPropertyElement) {
                MementoPropertyElement property = new MementoPropertyElement(AbstractDashboardAspectEditor.this.model, element, null);
                element.addChild(property);
                AbstractDashboardAspectEditor.this.getTreeViewer().refresh((Object)element);
                AbstractDashboardAspectEditor.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)property));
                AbstractDashboardAspectEditor.this.setDirty();
            }
        }

        public String getText() {
            return Messages.actionAddPropertyLabel;
        }

        public ImageDescriptor getImageDescriptor() {
            return DashboardImages.DESC_MEMENTO_PROPERTY_OBJ;
        }
    };
    Action ACTION_ADD_MEMENTO = new Action(){

        public void run() {
            DashboardElement element = AbstractDashboardAspectEditor.this.getCurrentElement();
            if (element instanceof MementoPropertyElement || element instanceof ViewletElement) {
                MementoElement memento = new MementoElement(AbstractDashboardAspectEditor.this.model, element, null);
                element.addChild(memento);
                AbstractDashboardAspectEditor.this.getTreeViewer().refresh((Object)element);
                AbstractDashboardAspectEditor.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)memento));
                AbstractDashboardAspectEditor.this.setDirty();
            }
        }

        public String getText() {
            return Messages.actionAddMementoLabel;
        }

        public ImageDescriptor getImageDescriptor() {
            return DashboardImages.DESC_MEMENTO_OBJ;
        }
    };
    Action ACTION_ADD_MEMENTO_PROPERTY_VALUE = new Action(){

        public void run() {
            DashboardElement element = AbstractDashboardAspectEditor.this.getCurrentElement();
            if (element instanceof MementoPropertyElement) {
                MementoPropertyElement property = (MementoPropertyElement)element;
                MementoValueElement value = new MementoValueElement(AbstractDashboardAspectEditor.this.model, property, null);
                property.addChild(value);
                AbstractDashboardAspectEditor.this.getTreeViewer().refresh((Object)property);
                AbstractDashboardAspectEditor.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)value));
                AbstractDashboardAspectEditor.this.setDirty();
            }
        }

        public String getText() {
            return Messages.actionAddValeLabel;
        }

        public ImageDescriptor getImageDescriptor() {
            return DashboardImages.DESC_MEMENTO_VALUE_OBJ;
        }
    };
    Action ACTION_ADD_VIEWLET = new Action(){

        public void run() {
            DashboardElement parent = AbstractDashboardAspectEditor.this.getCurrentElement();
            if (parent != null && parent instanceof DashboardEntriesAspectEditor.CategoryElement || parent instanceof DashboardTemplatesAspectEditor.ColumnElement) {
                ViewletElement element = new ViewletElement(AbstractDashboardAspectEditor.this.model, parent, "", !AbstractDashboardAspectEditor.this.isTemplate());
                parent.addChild(element);
                AbstractDashboardAspectEditor.this.getTreeViewer().refresh((Object)parent);
                AbstractDashboardAspectEditor.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)element));
                AbstractDashboardAspectEditor.this.setDirty();
            }
        }

        public String getText() {
            return AbstractDashboardAspectEditor.this.isTemplate() ? Messages.actionAddViewletLabel : Messages.actionAddViewletEntryLabel;
        }

        public ImageDescriptor getImageDescriptor() {
            return DashboardImages.DESC_VIEWLET_OBJ;
        }
    };
    RemoveAction ACTION_REMOVE = new RemoveAction();

    protected ConfigurationElement findViewletDefinition(String id) {
        if (id == null || this.extensionData == null) {
            return null;
        }
        List list = this.extensionData.getConfigurationElements("com.ibm.team.dashboard.common.viewlets");
        for (ConfigurationElement element : list) {
            if (!element.getName().equals("viewlet") || !((String)element.getAttributes().get("id")).equals(id)) continue;
            return element;
        }
        return null;
    }

    protected abstract DashboardModel createModel();

    protected abstract void addViewletDetailsLinks(ViewletDetailsPart var1, FormToolkit var2, Composite var3, int var4);

    protected abstract void addViewletDetailsFields(ViewletDetailsPart var1, FormToolkit var2, Composite var3, int var4);

    protected abstract int getDescriptionHeight();

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.model = this.createModel();
        this.model.init(inputAspect.getConfigurationElement());
    }

    private void loadDashboardExtensionData(final Display display) {
        Job loadingJob = new Job(Messages.AbstractDashboardAspectEditor_LoadingJobMessage){

            protected IStatus run(IProgressMonitor monitor) {
                ITeamRepository teamRepository = (ITeamRepository)AbstractDashboardAspectEditor.this.getAspect().getProcessContainerWorkingCopy().getUnderlyingProcessItem().getOrigin();
                IDashboardClientService context = (IDashboardClientService)teamRepository.getClientLibrary(IDashboardClientService.class);
                try {
                    AbstractDashboardAspectEditor.this.extensionData = context.getDashboardExtensions(null);
                }
                catch (TeamRepositoryException e) {
                    return StatusUtil.newStatus((String)Messages.AbstractDashboardAspectEditor_LoadingJobFailed, (Throwable)e);
                }
                display.asyncExec(new Runnable(){

                    public void run() {
                        AbstractDashboardAspectEditor.this.extensionDataLoaded();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        loadingJob.schedule();
    }

    protected void extensionDataLoaded() {
        IDetailsPage page;
        this.loadViewletConfigs(this.model.getElements());
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && !viewer.getTree().isDisposed()) {
            viewer.refresh(true);
        }
        if ((page = this.block.getCurrentPage()) instanceof DashboardDetailsPart) {
            ((DashboardDetailsPart)page).extensionDataLoaded();
        }
    }

    private void loadViewletConfigs(DashboardElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof ViewletElement) {
                ((ViewletElement)elements[i]).loadConfig();
            } else {
                this.loadViewletConfigs(elements[i].getChildren());
            }
            ++i;
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        FillLayout layout = new FillLayout();
        parent.setLayout((Layout)layout);
        ScrolledForm sform = toolkit.createScrolledForm(parent);
        this.mform = new ManagedForm(toolkit, sform);
        this.block = new DashboardBlock();
        GridLayout glayout = new GridLayout();
        sform.getBody().setLayout((Layout)glayout);
        this.block.createContent((IManagedForm)this.mform);
        toolkit.getColors().createColor(DISABLED_LINK_COLOR_KEY, 192, 192, 192);
        this.loadDashboardExtensionData(parent.getDisplay());
    }

    protected abstract void createMasterSection(IManagedForm var1, Composite var2);

    protected abstract void registerPages(DetailsPart var1);

    protected abstract TreeViewer getTreeViewer();

    public DashboardElement getCurrentElement() {
        IStructuredSelection ssel = (IStructuredSelection)this.getTreeViewer().getSelection();
        DashboardElement el = null;
        if (ssel.size() == 1) {
            el = (DashboardElement)ssel.getFirstElement();
        }
        return el;
    }

    public void dispose() {
        if (this.mform != null) {
            this.mform.dispose();
            this.mform = null;
        }
    }

    public boolean needsApplyAndRevertButtons() {
        return false;
    }

    protected boolean saveState(IMemento memento) {
        this.block.getCurrentPage().commit(true);
        this.model.save(memento);
        return true;
    }

    public void revert() {
        this.model.init(this.getAspect().getConfigurationElement());
        this.mform.refresh();
    }

    protected boolean isTemplate() {
        return false;
    }

    abstract class AbstractEntry {
        AbstractEntry() {
        }

        protected String wrapDescriptionText(String input) {
            BreakIterator wb = BreakIterator.getLineInstance();
            StringBuffer result = new StringBuffer();
            int wrapLoc = 0;
            wb.setText(input);
            int loc = wb.first();
            while (loc != -1) {
                if (loc - wrapLoc > 70) {
                    result.append(input.substring(wrapLoc, loc).trim());
                    if (loc != input.length()) {
                        result.append("\n");
                    }
                    wrapLoc = loc;
                }
                loc = wb.next();
            }
            result.append(input.substring(wrapLoc).trim());
            return result.toString();
        }
    }

    class BodyEntry
    extends AbstractEntry
    implements FocusListener,
    ModifyListener {
        Text text;
        DashboardElement el;
        boolean dirty;
        boolean inRefresh;

        BodyEntry() {
        }

        void refresh() {
            this.inRefresh = true;
            this.updateValue(this.el != null ? this.el.getValue() : null);
            this.dirty = false;
            this.inRefresh = false;
        }

        void commit() {
            if (!this.dirty) {
                return;
            }
            if (this.el != null) {
                this.el.setValue(this.getValue());
            }
            this.dirty = false;
        }

        void markDirty() {
            if (this.inRefresh) {
                return;
            }
            this.dirty = true;
            if (this.el != null) {
                AbstractDashboardAspectEditor.this.setDirty();
            }
        }

        String getValue() {
            String svalue = this.text.getText();
            return svalue.length() > 0 ? svalue : null;
        }

        void updateValue(String value) {
            this.text.setText(value != null ? value : "");
        }

        void setElement(DashboardElement el) {
            this.el = el;
            this.refresh();
        }

        public void createControl(FormToolkit toolkit, Composite parent, int span, boolean commitOnChange) {
            Label l = toolkit.createLabel(parent, String.valueOf(Messages.bodyTextLabel) + ":");
            l.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            l.setToolTipText(this.wrapDescriptionText(Messages.bodyTextTooltip));
            this.createText(toolkit, parent, span, commitOnChange);
            this.refresh();
        }

        protected void createText(FormToolkit toolkit, Composite parent, int span, boolean commitOnChange) {
            this.text = toolkit.createText(parent, null, 66);
            GridData gd = new GridData(768);
            gd.horizontalSpan = span;
            gd.heightHint = 64;
            gd.horizontalIndent = 5;
            this.text.setLayoutData((Object)gd);
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    BodyEntry.this.markDirty();
                }
            });
            if (commitOnChange) {
                this.text.addModifyListener((ModifyListener)this);
            } else {
                this.text.addFocusListener((FocusListener)this);
            }
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.commit();
        }

        public void modifyText(ModifyEvent e) {
            this.commit();
        }
    }

    class BooleanPropertyEntry
    extends EnumPropertyEntry {
        BooleanPropertyEntry(DashboardAttributeDef def) {
            super(def);
        }

        BooleanPropertyEntry(DashboardAttributeDef def, boolean commitOnChange, boolean refreshOnCommit) {
            super(def, commitOnChange, refreshOnCommit);
        }

        protected EnumChoice[] getChoices() {
            return BOOLEAN_CHOICES;
        }
    }

    static class DashboardAttribute {
        DashboardElement parent;
        DashboardAttributeDef def;
        Object value;

        DashboardAttribute(DashboardElement parent, DashboardAttributeDef def) {
            this.parent = parent;
            this.def = def;
        }
    }

    static class DashboardAttributeDef {
        public static final int T_STRING = 0;
        public static final int T_BOOLEAN = 1;
        public static final int T_ENUM = 2;
        public static final int T_TEXT = 3;
        String name;
        String label;
        String description;
        int type;
        EnumChoice[] choices;
        boolean editable;

        DashboardAttributeDef(int type, String name, String label, String description) {
            this(type, name, label, description, null, true);
        }

        DashboardAttributeDef(int type, String name, String label, String description, boolean editable) {
            this(type, name, label, description, null, editable);
        }

        DashboardAttributeDef(int type, String name, String label, String description, EnumChoice[] choices) {
            this(type, name, label, description, choices, true);
        }

        DashboardAttributeDef(int type, String name, String label, String description, EnumChoice[] choices, boolean editable) {
            this.name = name;
            this.type = type;
            this.label = label;
            this.choices = choices;
            this.editable = editable;
            this.description = description;
        }
    }

    class DashboardBlock
    extends MasterDetailsBlock {
        DashboardBlock() {
        }

        protected void createMasterPart(IManagedForm managedForm, Composite parent) {
            AbstractDashboardAspectEditor.this.createMasterSection(managedForm, parent);
        }

        protected void createToolBarActions(IManagedForm managedForm) {
        }

        protected void registerPages(DetailsPart detailsPart) {
            AbstractDashboardAspectEditor.this.registerPages(detailsPart);
        }

        protected IDetailsPage getCurrentPage() {
            return this.detailsPart.getCurrentPage();
        }
    }

    class DashboardContentProvider
    implements ITreeContentProvider,
    Observer {
        private Viewer viewer;

        DashboardContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return ((DashboardElement)parentElement).getChildren();
        }

        public Object getParent(Object element) {
            return ((DashboardElement)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ((DashboardElement)element).hasChildren();
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof DashboardModel) {
                return ((DashboardModel)inputElement).getElements();
            }
            if (inputElement instanceof DashboardElement) {
                return ((DashboardElement)inputElement).getChildren();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = viewer;
            if (oldInput != null && oldInput instanceof DashboardModel) {
                ((DashboardModel)oldInput).deleteObserver(this);
            }
            if (newInput != null && newInput instanceof DashboardModel) {
                ((DashboardModel)newInput).addObserver(this);
            }
        }

        public void update(Observable o, Object arg) {
            DashboardModelChangedEvent e = (DashboardModelChangedEvent)arg;
            TreeViewer tviewer = (TreeViewer)this.viewer;
            if (e.type == 1) {
                tviewer.add((Object)e.element, (Object[])e.children);
            } else if (e.type == 2) {
                tviewer.remove((Object)e.element, (Object[])e.children);
            } else {
                tviewer.update((Object)e.element, null);
            }
        }
    }

    abstract class DashboardDetailsPart
    extends AbstractFormPart
    implements IDetailsPage {
        ArrayList entries = new ArrayList();
        BodyEntry bodyEntry;
        Label message;

        protected void markDetailsPart(Control control) {
            control.setData("part", (Object)this);
        }

        protected void createSpacer(FormToolkit toolkit, Composite parent, int span) {
            Label spacer = toolkit.createLabel(parent, "");
            GridData gd = new GridData();
            gd.horizontalSpan = span;
            spacer.setLayoutData((Object)gd);
        }

        protected void addMessage(final Composite parent, FormToolkit toolkit, int span, final GridLayout layout) {
            this.message = toolkit.createLabel(parent, "", 64);
            this.message.setForeground(parent.getDisplay().getSystemColor(3));
            GridData gd = new GridData();
            gd.exclude = true;
            gd.horizontalSpan = span + 1;
            gd.widthHint = parent.getBounds().width - layout.marginWidth * 2 - layout.marginLeft - layout.marginRight;
            parent.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    ((GridData)DashboardDetailsPart.this.message.getLayoutData()).widthHint = parent.getBounds().width - layout.marginWidth * 2 - layout.marginLeft - layout.marginRight;
                    parent.layout();
                }
            });
            this.message.setLayoutData((Object)gd);
            this.message.setVisible(false);
        }

        protected void updateMessage(DashboardElement e) {
            if (AbstractDashboardAspectEditor.this.isTemplate() && this.message != null && e != null) {
                DashboardTemplatesAspectEditor.TemplateElement t = null;
                DashboardTemplatesAspectEditor.PageElement p = null;
                while (e != null) {
                    if (e instanceof DashboardTemplatesAspectEditor.TemplateElement) {
                        t = (DashboardTemplatesAspectEditor.TemplateElement)e;
                    }
                    if (e instanceof DashboardTemplatesAspectEditor.PageElement) {
                        p = (DashboardTemplatesAspectEditor.PageElement)e;
                    }
                    e = e.getParent();
                }
                boolean wasVisible = this.message.isVisible();
                boolean hasMessage = true;
                if (t != null && !t.isValid()) {
                    this.message.setText(Messages.DashboardTemplatesAspectEditor_noLicenseType);
                } else if (p != null && !p.isValid()) {
                    this.message.setText(Messages.DashboardTemplatesAspectEditor_noTabLicense);
                } else {
                    this.message.setText("");
                    hasMessage = false;
                }
                if (hasMessage) {
                    ((GridData)this.message.getLayoutData()).exclude = false;
                    this.message.setVisible(true);
                } else {
                    ((GridData)this.message.getLayoutData()).exclude = true;
                    this.message.setVisible(false);
                }
                this.messageUpdated(hasMessage);
                if (wasVisible || hasMessage) {
                    this.message.getParent().layout();
                }
            }
        }

        protected void messageUpdated(boolean hasMessage) {
        }

        public void cancelEdit() {
            this.refresh();
        }

        protected PropertyEntry createElementEntry(FormToolkit toolkit, Composite parent, DashboardAttributeDef def, int span) {
            return this.createElementEntry(toolkit, parent, def, span, false, false, false);
        }

        protected PropertyEntry createElementEntry(FormToolkit toolkit, Composite parent, DashboardAttributeDef def, int span, boolean commitOnChange, boolean addBrowseButton) {
            return this.createElementEntry(toolkit, parent, def, span, commitOnChange, addBrowseButton, false);
        }

        protected PropertyEntry createElementEntry(FormToolkit toolkit, Composite parent, DashboardAttributeDef def, int span, boolean commitOnChange, boolean addBrowseButton, boolean refreshOnCommit) {
            PropertyEntry entry = null;
            switch (def.type) {
                case 0: {
                    entry = new StringPropertyEntry(def, commitOnChange, addBrowseButton, refreshOnCommit);
                    break;
                }
                case 3: {
                    entry = new TextPropertyEntry(def, commitOnChange, addBrowseButton, refreshOnCommit);
                    break;
                }
                case 2: {
                    entry = new EnumPropertyEntry(def, commitOnChange, refreshOnCommit);
                    break;
                }
                case 1: {
                    entry = new BooleanPropertyEntry(def, commitOnChange, refreshOnCommit);
                }
            }
            if (entry != null) {
                entry.createControl(toolkit, parent, span);
                this.entries.add(entry);
            }
            return entry;
        }

        protected BodyEntry createBodyEntry(FormToolkit toolkit, Composite parent, int span) {
            return this.createBodyEntry(toolkit, parent, span, false);
        }

        protected BodyEntry createBodyEntry(FormToolkit toolkit, Composite parent, int span, boolean commitOnChange) {
            this.bodyEntry = new BodyEntry();
            this.bodyEntry.createControl(toolkit, parent, span, commitOnChange);
            return this.bodyEntry;
        }

        public void commit(boolean onSave) {
            int i = 0;
            while (i < this.entries.size()) {
                PropertyEntry entry = (PropertyEntry)this.entries.get(i);
                entry.commit();
                ++i;
            }
            if (this.bodyEntry != null) {
                this.bodyEntry.commit();
            }
            super.commit(onSave);
        }

        public void refresh() {
            int i = 0;
            while (i < this.entries.size()) {
                PropertyEntry entry = (PropertyEntry)this.entries.get(i);
                entry.refresh();
                ++i;
            }
            if (this.bodyEntry != null) {
                this.bodyEntry.refresh();
            }
            super.refresh();
        }

        public void selectionChanged(IFormPart part, ISelection selection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            this.commit(false);
            DashboardElement el = null;
            if (ssel.size() == 1) {
                el = (DashboardElement)ssel.getFirstElement();
            }
            int i = 0;
            while (i < this.entries.size()) {
                PropertyEntry entry = (PropertyEntry)this.entries.get(i);
                if (entry.preference) {
                    entry.setElement((ViewletElement)el);
                } else if (el != null) {
                    entry.setAttribute(el.getAttribute(entry.def.name));
                } else {
                    entry.setAttribute(null);
                }
                ++i;
            }
            if (this.bodyEntry != null) {
                this.bodyEntry.setElement(el);
            }
            this.updateMessage(el);
            this.refresh();
        }

        public void extensionDataLoaded() {
        }
    }

    abstract class DashboardElement {
        protected ModelElement me;
        DashboardModel model;
        DashboardElement parent;
        String value;
        ArrayList attributes;
        ArrayList children;
        boolean editable = true;

        protected DashboardElement(DashboardModel model, ModelElement me) {
            this(model, null, me);
        }

        protected DashboardElement(DashboardModel model, DashboardElement parent, ModelElement me) {
            this.model = model;
            this.me = me;
            this.parent = parent;
        }

        protected void reserveAttribute(DashboardAttributeDef def) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(new DashboardAttribute(this, def));
        }

        protected void putAttribute(String name, Object value) {
            DashboardAttribute att = this.getAttribute(name);
            if (att != null) {
                att.value = value;
            }
        }

        public void setAttribute(String name, Object value) {
            DashboardAttribute att = this.getAttribute(name);
            if (att != null) {
                att.value = value;
                this.model.fireElementChanged(this, name);
            }
        }

        public void setAttribute(DashboardAttribute att, Object value) {
            att.value = value;
            this.model.fireElementChanged(this, att);
        }

        public DashboardAttribute getAttribute(String name) {
            if (this.attributes != null) {
                int i = 0;
                while (i < this.attributes.size()) {
                    DashboardAttribute att = (DashboardAttribute)this.attributes.get(i);
                    if (att.def.name.equals(name)) {
                        return att;
                    }
                    ++i;
                }
            }
            return null;
        }

        public void setValue(String value) {
            this.value = value;
            this.model.fireElementChanged(this, "__body__");
        }

        public String getValue() {
            return this.value;
        }

        public abstract String getKey();

        public DashboardElement getParent() {
            return this.parent;
        }

        public DashboardElement[] getChildren() {
            if (this.children == null) {
                return new DashboardElement[0];
            }
            return this.children.toArray(new DashboardElement[this.children.size()]);
        }

        public void addChild(DashboardElement de) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(de);
            this.model.fireElementsAdded(this, new DashboardElement[]{de});
        }

        public void removeChild(DashboardElement de) {
            if (this.children == null) {
                return;
            }
            this.children.remove(de);
            this.model.fireElementsRemoved(this, new DashboardElement[]{de});
        }

        public void removeChildren(DashboardElement[] de) {
            if (this.children == null) {
                return;
            }
            int i = 0;
            while (i < de.length) {
                this.children.remove(de[i]);
                ++i;
            }
            this.model.fireElementsRemoved(this, de);
        }

        protected void propertyChanged(String property) {
            this.model.fireElementChanged(this, property);
        }

        public boolean hasChildren() {
            return this.children != null && this.children.size() > 0;
        }

        public void save(IMemento memento) {
            IMemento childMemento = memento.createChild(this.me == null ? this.getKey() : this.me.getName());
            this.saveSelf(childMemento);
            this.saveChildren(childMemento);
        }

        protected void saveSelf(IMemento memento) {
            if (this.value != null) {
                memento.putTextData(this.value);
            }
            if (this.attributes == null) {
                return;
            }
            int i = 0;
            while (i < this.attributes.size()) {
                DashboardAttribute da = (DashboardAttribute)this.attributes.get(i);
                if (da.value != null) {
                    if (da.def.type == 3) {
                        IMemento dchild = memento.createChild("description");
                        dchild.putTextData((String)da.value);
                    } else if (da.value instanceof Boolean) {
                        memento.putBoolean(da.def.name, ((Boolean)da.value).booleanValue());
                    } else if (da.value instanceof String && ((String)da.value).length() > 0) {
                        memento.putString(da.def.name, (String)da.value);
                    }
                }
                ++i;
            }
        }

        protected void saveChildren(IMemento memento) {
            if (this.children != null) {
                int i = 0;
                while (i < this.children.size()) {
                    DashboardElement child = (DashboardElement)this.children.get(i);
                    child.save(memento);
                    ++i;
                }
            }
        }
    }

    class DashboardLabelProvider
    extends LabelProvider {
        DashboardLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof ViewletElement) {
                ViewletElement ve = (ViewletElement)obj;
                String vname = ve.getPresentableTitle();
                if (vname != null) {
                    return String.valueOf(vname) + (ve.isEntry() ? " (" + Messages.labelViewletEntry + ")" : " (" + Messages.labelViewlet + ")");
                }
                return ve.isEntry() ? "(" + Messages.labelViewletEntry + ")" : "(" + Messages.labelViewlet + ")";
            }
            if (obj instanceof MementoElement) {
                return "(" + Messages.labelMemento + ")";
            }
            if (obj instanceof MementoPropertyElement) {
                MementoPropertyElement mpe = (MementoPropertyElement)obj;
                DashboardAttribute da = mpe.getAttribute("name");
                if (da != null && da.value != null) {
                    return da.value + " (" + Messages.labelProperty + ")";
                }
                return "(" + Messages.labelProperty + ")";
            }
            if (obj instanceof MementoValueElement) {
                return "(" + Messages.labelValue + ")";
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            if (obj instanceof ViewletElement) {
                return ((ViewletElement)obj).getImage();
            }
            return super.getImage(obj);
        }
    }

    abstract class DashboardModel
    extends Observable {
        public void save(IMemento memento) {
            memento.putString("id", this.getConfigurationDataId());
            memento.putString("xmlns", this.getConfigurationDataNamespace());
        }

        protected abstract void init(ModelElement var1);

        protected abstract String getConfigurationDataId();

        protected abstract String getConfigurationDataNamespace();

        protected void fireElementChanged(DashboardElement element, Object property) {
            DashboardModelChangedEvent event = new DashboardModelChangedEvent(element, property);
            this.setChanged();
            this.notifyObservers(event);
        }

        protected void fireElementsAdded(DashboardElement parent, DashboardElement[] elements) {
            DashboardModelChangedEvent event = new DashboardModelChangedEvent(1, parent, elements);
            this.setChanged();
            this.notifyObservers(event);
        }

        protected void fireElementsRemoved(DashboardElement parent, DashboardElement[] elements) {
            DashboardModelChangedEvent event = new DashboardModelChangedEvent(2, parent, elements);
            this.setChanged();
            this.notifyObservers(event);
        }

        abstract DashboardElement[] getElements();
    }

    class DashboardModelChangedEvent {
        static final int ADDED = 1;
        static final int REMOVED = 2;
        static final int CHANGED = 3;
        int type;
        Object property;
        DashboardElement element;
        DashboardElement[] children;

        DashboardModelChangedEvent(DashboardElement element, Object property) {
            this.type = 3;
            this.element = element;
            this.property = property;
        }

        DashboardModelChangedEvent(int type, DashboardElement element, DashboardElement[] children) {
            this.type = type;
            this.element = element;
            this.children = children;
        }
    }

    static class EnumChoice {
        String name;
        Object value;

        public EnumChoice(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }

    class EnumPropertyEntry
    extends PropertyEntry {
        Combo combo;

        EnumPropertyEntry(DashboardAttributeDef def) {
            super(def);
        }

        EnumPropertyEntry(DashboardAttributeDef def, boolean commitOnChange, boolean refreshOnCommit) {
            super(def, commitOnChange, refreshOnCommit);
        }

        Object getValue() {
            int index = this.combo.getSelectionIndex();
            if (index == -1) {
                return null;
            }
            return this.getChoices()[index].value;
        }

        void updateValue(Object value) {
            if (value != null) {
                int i = 0;
                while (i < this.getChoices().length) {
                    Object cvalue = this.getChoices()[i].value;
                    if (cvalue != null && cvalue.equals(value) || cvalue == null && value == null) {
                        this.combo.select(i);
                        return;
                    }
                    ++i;
                }
            }
            this.combo.setText("");
        }

        protected void setEditable(boolean editable) {
            this.combo.setEnabled(editable);
        }

        public void createControl(FormToolkit toolkit, Composite parent, int span) {
            Label l = toolkit.createLabel(parent, String.valueOf(this.def.label) + ":");
            l.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            if (this.def.description != null) {
                l.setToolTipText(this.wrapDescriptionText(this.def.description));
            }
            this.combo = new Combo(parent, 2052);
            GridData gd = new GridData(768);
            gd.horizontalSpan = span;
            gd.horizontalIndent = 5;
            this.combo.setLayoutData((Object)gd);
            int i = 0;
            while (i < this.getChoices().length) {
                this.combo.add(this.getChoices()[i].name);
                ++i;
            }
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EnumPropertyEntry.this.markDirty();
                }
            });
            if (this.commitOnChange) {
                this.combo.addModifyListener((ModifyListener)this);
            } else {
                this.combo.addFocusListener((FocusListener)this);
            }
            this.refresh();
        }

        protected EnumChoice[] getChoices() {
            return this.def.choices;
        }
    }

    class MementoElement
    extends DashboardElement {
        static final String MEMENTO = "memento";

        public MementoElement(DashboardModel model, DashboardElement parent, ModelElement me) {
            super(model, parent, me);
            if (me != null) {
                this.load();
            }
        }

        private void load() {
            List children = this.me.getChildElements();
            int i = 0;
            while (i < children.size()) {
                ModelElement child = (ModelElement)children.get(i);
                if (child.getName().equals("property")) {
                    MementoPropertyElement property = new MementoPropertyElement(this.model, this, child);
                    this.addChild(property);
                }
                ++i;
            }
        }

        public String getKey() {
            return MEMENTO;
        }
    }

    class MementoElementDetailsPart
    extends DashboardDetailsPart {
        Hyperlink addProperty;

        MementoElementDetailsPart() {
        }

        public void createContents(Composite parent) {
            FormToolkit toolkit = this.getManagedForm().getToolkit();
            GridLayout layout = new GridLayout();
            layout.marginTop = AbstractDashboardAspectEditor.this.getDescriptionHeight();
            parent.setLayout((Layout)layout);
            int span = 1;
            layout.numColumns = span + 1;
            this.addMessage(parent, toolkit, span, layout);
            this.addProperty = toolkit.createHyperlink(parent, Messages.mementoDetailsAddPropertyLink, 0);
            GridData gd = new GridData();
            gd.horizontalSpan = span + 1;
            this.addProperty.setLayoutData((Object)gd);
            this.addProperty.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ((MementoElementDetailsPart)MementoElementDetailsPart.this).AbstractDashboardAspectEditor.this.ACTION_ADD_MEMENTO_PROPERTY.run();
                }
            });
            toolkit.paintBordersFor(parent);
        }

        protected void messageUpdated(boolean hasMessage) {
            ((GridData)this.addProperty.getLayoutData()).verticalIndent = hasMessage ? 10 : 0;
        }
    }

    class MementoPropertyDetailsPart
    extends DashboardDetailsPart {
        BodyEntry bodyEntry;
        Hyperlink addProperty;
        Hyperlink addMemento;
        Hyperlink addValue;
        StringPropertyEntry name;

        MementoPropertyDetailsPart() {
        }

        public void createContents(Composite parent) {
            FormToolkit toolkit = this.getManagedForm().getToolkit();
            GridLayout layout = new GridLayout();
            layout.marginTop = AbstractDashboardAspectEditor.this.getDescriptionHeight();
            parent.setLayout((Layout)layout);
            int span = 1;
            layout.numColumns = span + 1;
            this.addMessage(parent, toolkit, span, layout);
            this.name = (StringPropertyEntry)this.createElementEntry(toolkit, parent, ViewletMementoPropertyDef.ATT_NAME, span, true, false);
            this.createElementEntry(toolkit, parent, ViewletMementoPropertyDef.ATT_TYPE, span);
            this.bodyEntry = this.createBodyEntry(toolkit, parent, span, true);
            this.bodyEntry.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MementoPropertyDetailsPart.this.updateFields(AbstractDashboardAspectEditor.this.getCurrentElement());
                }
            });
            this.addProperty = toolkit.createHyperlink(parent, Messages.mementoPropertyAddPropertyLink, 0);
            GridData gd = new GridData();
            gd.horizontalSpan = span + 1;
            this.addProperty.setLayoutData((Object)gd);
            this.addProperty.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ((MementoPropertyDetailsPart)MementoPropertyDetailsPart.this).AbstractDashboardAspectEditor.this.ACTION_ADD_MEMENTO_PROPERTY.run();
                }
            });
            this.addMemento = toolkit.createHyperlink(parent, Messages.mementoPropertyAddMementoLink, 0);
            gd = new GridData();
            gd.horizontalSpan = span + 1;
            this.addMemento.setLayoutData((Object)gd);
            this.addMemento.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ((MementoPropertyDetailsPart)MementoPropertyDetailsPart.this).AbstractDashboardAspectEditor.this.ACTION_ADD_MEMENTO.run();
                }
            });
            this.addValue = toolkit.createHyperlink(parent, Messages.mementoPropertyAddValueLink, 0);
            gd = new GridData();
            gd.horizontalSpan = span + 1;
            this.addValue.setLayoutData((Object)gd);
            this.addValue.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ((MementoPropertyDetailsPart)MementoPropertyDetailsPart.this).AbstractDashboardAspectEditor.this.ACTION_ADD_MEMENTO_PROPERTY_VALUE.run();
                }
            });
            toolkit.paintBordersFor(parent);
        }

        public void selectionChanged(IFormPart part, ISelection selection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            DashboardElement el = null;
            if (ssel.size() == 1) {
                el = (DashboardElement)ssel.getFirstElement();
            }
            this.updateFields(el);
            super.selectionChanged(part, selection);
        }

        private void updateFields(DashboardElement el) {
            if (el instanceof MementoPropertyElement) {
                MementoPropertyElement property = (MementoPropertyElement)el;
                this.bodyEntry.text.setEnabled(property.canAddBodyText());
                this.addProperty.setEnabled(property.canAddProperty());
                this.addMemento.setEnabled(property.canAddMemento());
                this.addValue.setEnabled(property.canAddValue());
                FormToolkit toolkit = this.getManagedForm().getToolkit();
                this.addProperty.setForeground(this.addProperty.isEnabled() ? toolkit.getHyperlinkGroup().getForeground() : toolkit.getColors().getColor(AbstractDashboardAspectEditor.DISABLED_LINK_COLOR_KEY));
                this.addMemento.setForeground(this.addMemento.isEnabled() ? toolkit.getHyperlinkGroup().getForeground() : toolkit.getColors().getColor(AbstractDashboardAspectEditor.DISABLED_LINK_COLOR_KEY));
                this.addValue.setForeground(this.addValue.isEnabled() ? toolkit.getHyperlinkGroup().getForeground() : toolkit.getColors().getColor(AbstractDashboardAspectEditor.DISABLED_LINK_COLOR_KEY));
            }
        }

        protected void messageUpdated(boolean hasMessage) {
            ((GridData)this.name.text.getLayoutData()).verticalIndent = hasMessage ? 10 : 0;
            ((GridData)this.name.label.getLayoutData()).verticalIndent = hasMessage ? 10 : 0;
        }
    }

    class MementoPropertyElement
    extends DashboardElement {
        static final String PROPERTY = "property";

        public MementoPropertyElement(DashboardModel model, DashboardElement parent, ModelElement me) {
            super(model, parent, me);
            this.reserveAttribute(ViewletMementoPropertyDef.ATT_NAME);
            this.reserveAttribute(ViewletMementoPropertyDef.ATT_TYPE);
            if (me != null) {
                this.load();
            }
        }

        private void load() {
            this.putAttribute("name", this.me.getAttribute("name"));
            this.putAttribute("type", this.me.getAttribute("type"));
            List children = this.me.getChildElements();
            int i = 0;
            while (i < children.size()) {
                ModelElement child = (ModelElement)children.get(i);
                if (child.getName().equals("value")) {
                    this.addChild(new MementoValueElement(this.model, this, child));
                } else if (child.getName().equals("memento")) {
                    this.addChild(new MementoElement(this.model, this, child));
                }
                ++i;
            }
            this.value = ((ProcessConfigurationElement)this.me).getCharacterData();
        }

        public String getKey() {
            return PROPERTY;
        }

        public boolean canAddBodyText() {
            return this.children == null || this.children.size() == 0;
        }

        public boolean canAddMemento() {
            if (this.canAddBodyText()) {
                return this.value == null || this.value.length() == 0;
            }
            return this.children.get(0) instanceof MementoElement;
        }

        public boolean canAddValue() {
            if (this.canAddBodyText()) {
                return this.value == null || this.value.length() == 0;
            }
            return this.children.get(0) instanceof MementoValueElement;
        }

        public boolean canAddProperty() {
            if (this.canAddBodyText()) {
                return this.value == null || this.value.length() == 0;
            }
            return this.children.get(0) instanceof MementoPropertyElement;
        }
    }

    class MementoValueDetailsPart
    extends DashboardDetailsPart {
        BodyEntry body;

        MementoValueDetailsPart() {
        }

        public void createContents(Composite parent) {
            FormToolkit toolkit = this.getManagedForm().getToolkit();
            GridLayout layout = new GridLayout();
            layout.marginTop = AbstractDashboardAspectEditor.this.getDescriptionHeight();
            parent.setLayout((Layout)layout);
            int span = 1;
            layout.numColumns = span + 1;
            this.addMessage(parent, toolkit, span, layout);
            this.body = this.createBodyEntry(toolkit, parent, span);
            toolkit.paintBordersFor(parent);
        }

        protected void messageUpdated(boolean hasMessage) {
            ((GridData)this.body.text.getLayoutData()).verticalIndent = hasMessage ? 10 : 0;
        }
    }

    class MementoValueElement
    extends DashboardElement {
        static final String VALUE = "value";

        public MementoValueElement(DashboardModel model, DashboardElement parent, ModelElement me) {
            super(model, parent, me);
            if (me != null) {
                this.value = ((ProcessConfigurationElement)me).getCharacterData();
            }
        }

        public String getKey() {
            return VALUE;
        }
    }

    abstract class PropertyEntry
    extends AbstractEntry
    implements FocusListener,
    ModifyListener {
        DashboardAttributeDef def;
        DashboardAttribute att;
        ViewletElement ve;
        boolean preference;
        boolean dirty;
        boolean inRefresh;
        boolean commitOnChange;
        boolean addBrowseButton;
        boolean refreshOnCommit;

        protected PropertyEntry(DashboardAttributeDef def) {
            this.def = def;
        }

        public PropertyEntry(DashboardAttributeDef def, boolean commitOnChange) {
            this(def);
            this.commitOnChange = commitOnChange;
        }

        public PropertyEntry(DashboardAttributeDef def, boolean commitOnChange, boolean addBrowseButton) {
            this(def);
            this.commitOnChange = commitOnChange;
            this.addBrowseButton = addBrowseButton;
        }

        public PropertyEntry(DashboardAttributeDef def, boolean commitOnChange, boolean addBrowseButton, boolean refreshOnCommit) {
            this(def);
            this.commitOnChange = commitOnChange;
            this.addBrowseButton = addBrowseButton;
            this.refreshOnCommit = refreshOnCommit;
        }

        void markDirty() {
            if (this.inRefresh) {
                return;
            }
            this.dirty = true;
            if (this.ve != null) {
                AbstractDashboardAspectEditor.this.setDirty();
            } else if (this.att != null) {
                AbstractDashboardAspectEditor.this.setDirty();
            }
        }

        public void refresh() {
            this.inRefresh = true;
            if (this.preference) {
                this.updateValue(this.ve != null ? this.ve.getPreference(this.def.name) : null);
            } else {
                this.updateValue(this.att != null ? this.att.value : null);
            }
            this.inRefresh = false;
        }

        void setAttribute(DashboardAttribute att) {
            this.att = att;
            this.refresh();
            this.setEditable(att != null && att.parent.editable && att.def.editable);
        }

        void setElement(ViewletElement ve) {
            this.ve = ve;
            this.refresh();
            this.dirty = false;
            this.setEditable(ve != null && ve.editable);
        }

        protected abstract void setEditable(boolean var1);

        public void commit() {
            if (!this.dirty) {
                return;
            }
            if (this.preference && this.ve != null) {
                this.ve.setPreference(this.def.name, this.getValue());
            } else if (this.att != null) {
                this.att.parent.setAttribute(this.att, this.getValue());
            }
            this.dirty = false;
            if (this.refreshOnCommit) {
                ViewletElement refreshNode;
                DashboardElement dashboardElement = this.ve == null ? (this.att == null ? AbstractDashboardAspectEditor.this.getCurrentElement() : this.att.parent) : (refreshNode = this.ve);
                if (refreshNode.getParent() != null) {
                    AbstractDashboardAspectEditor.this.getTreeViewer().refresh((Object)refreshNode.getParent());
                } else {
                    AbstractDashboardAspectEditor.this.getTreeViewer().refresh();
                }
            }
        }

        abstract Object getValue();

        abstract void updateValue(Object var1);

        public abstract void createControl(FormToolkit var1, Composite var2, int var3);

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.commit();
        }

        public void modifyText(ModifyEvent e) {
            this.commit();
        }
    }

    class RemoveAction
    extends Action {
        Class expectedClass;
        Collection root;

        RemoveAction() {
        }

        public void setExpectedClass(Class expectedClass) {
            this.expectedClass = expectedClass;
        }

        public void setRoot(Collection root) {
            this.root = root;
        }

        public void run() {
            DashboardElement element = AbstractDashboardAspectEditor.this.getCurrentElement();
            if (element != null && this.expectedClass != null && this.expectedClass.isInstance(element)) {
                DashboardElement parent = element.getParent();
                if (parent != null) {
                    parent.removeChild(element);
                    AbstractDashboardAspectEditor.this.getTreeViewer().refresh((Object)parent);
                    AbstractDashboardAspectEditor.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)parent));
                } else if (this.root != null && this.root.remove(element)) {
                    AbstractDashboardAspectEditor.this.getTreeViewer().refresh();
                    if (this.root.size() > 0) {
                        AbstractDashboardAspectEditor.this.getTreeViewer().setSelection((ISelection)new StructuredSelection(this.root.toArray()[0]));
                    }
                }
                AbstractDashboardAspectEditor.this.setDirty();
            }
            this.expectedClass = null;
            this.root = null;
        }

        public String getText() {
            return Messages.actionRemoveLabel;
        }
    }

    class StringPropertyEntry
    extends PropertyEntry {
        Label label;
        Text text;
        Button browse;

        StringPropertyEntry(DashboardAttributeDef def) {
            super(def);
        }

        public StringPropertyEntry(DashboardAttributeDef def, boolean commitOnChange, boolean addBrowseButton, boolean refreshOnCommit) {
            super(def, commitOnChange, addBrowseButton, refreshOnCommit);
        }

        Object getValue() {
            String svalue = this.text.getText();
            return svalue.length() > 0 ? svalue : null;
        }

        void updateValue(Object value) {
            this.text.setText(value != null ? value.toString() : "");
        }

        protected void setEditable(boolean editable) {
            this.text.setEditable(editable);
            this.text.setEnabled(editable);
        }

        public void createControl(FormToolkit toolkit, Composite parent, int span) {
            this.label = toolkit.createLabel(parent, String.valueOf(this.def.label) + ":");
            this.label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            if (this.def.description != null) {
                this.label.setToolTipText(this.wrapDescriptionText(this.def.description));
            }
            this.label.setLayoutData((Object)new GridData());
            this.createText(toolkit, parent, this.addBrowseButton ? span - 1 : span);
            if (this.addBrowseButton) {
                this.browse = toolkit.createButton(parent, Messages.browseButtonText, 8);
                GridData gd = new GridData();
                GC gc = new GC((Drawable)parent);
                gd.widthHint = Math.max(75, gc.textExtent((String)Messages.browseButtonText).x + 10);
                this.browse.setLayoutData((Object)gd);
            }
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StringPropertyEntry.this.markDirty();
                }
            });
            if (this.commitOnChange) {
                this.text.addModifyListener((ModifyListener)this);
            } else {
                this.text.addFocusListener((FocusListener)this);
            }
            this.refresh();
        }

        protected void createText(FormToolkit toolkit, Composite parent, int span) {
            this.text = toolkit.createText(parent, null);
            GridData gd = new GridData(768);
            gd.horizontalSpan = span;
            gd.horizontalIndent = 5;
            this.text.setLayoutData((Object)gd);
        }
    }

    class TextPropertyEntry
    extends StringPropertyEntry {
        TextPropertyEntry(DashboardAttributeDef def) {
            super(def);
        }

        public TextPropertyEntry(DashboardAttributeDef def, boolean commitOnChange, boolean addBrowseButton, boolean refreshOnCommit) {
            super(def, commitOnChange, addBrowseButton, refreshOnCommit);
        }

        protected void createText(FormToolkit toolkit, Composite parent, int span) {
            this.text = toolkit.createText(parent, null, 66);
            GridData gd = new GridData(768);
            gd.horizontalSpan = span;
            gd.heightHint = 64;
            gd.horizontalIndent = 5;
            this.text.setLayoutData((Object)gd);
        }
    }

    class ViewletChooserLabelProvider
    extends LabelProvider {
        ViewletChooserLabelProvider() {
        }

        public String getText(Object element) {
            String title;
            if (element instanceof ConfigurationElement && (title = (String)((ConfigurationElement)element).getAttributes().get("title")) != null && title.length() > 0) {
                return title;
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            ITeamRepository teamRepository;
            String repoUri;
            Image image;
            String icon;
            ConfigurationElement config;
            if (element instanceof ConfigurationElement && (config = (ConfigurationElement)element) != null && (icon = (String)config.getAttributes().get("icon")) != null && (image = DashboardImages.getServerImage(repoUri = (teamRepository = (ITeamRepository)AbstractDashboardAspectEditor.this.getAspect().getProcessContainerWorkingCopy().getUnderlyingProcessItem().getOrigin()).getRepositoryURI(), config.getInternalNamespaceIdentifier(), icon)) != null) {
                return image;
            }
            return super.getImage(element);
        }
    }

    class ViewletDetailsPart
    extends DashboardDetailsPart {
        private ConfigurationElement config;
        private ArrayList preferenceDefs;
        private CTabItem preferenceTab = null;
        private CTabFolder tabFolder;
        private StringPropertyEntry idEntry;

        public ViewletDetailsPart() {
            DashboardElement selected = AbstractDashboardAspectEditor.this.getCurrentElement();
            ViewletElement ve = null;
            if (selected instanceof ViewletElement) {
                ve = (ViewletElement)selected;
            }
            this.loadConfig(ve);
        }

        private void loadConfig(ViewletElement ve) {
            ve.loadConfig();
            this.config = ve.config;
            this.createPreferenceDefinitions();
        }

        private void createPreferenceDefinitions() {
            this.preferenceDefs = null;
            if (this.config == null) {
                return;
            }
            List children = this.config.getInternalChildren();
            if (children.size() == 0) {
                return;
            }
            this.preferenceDefs = new ArrayList();
            for (ConfigurationElement child : children) {
                String primeable;
                if (!child.getName().equals("preference-def") || "false".equalsIgnoreCase(primeable = (String)child.getAttributes().get("primeable"))) continue;
                String type = (String)child.getAttributes().get("type");
                String id = (String)child.getAttributes().get("id");
                String required = (String)child.getAttributes().get("required");
                String name = (String)child.getAttributes().get("name");
                if ("true".equalsIgnoreCase(required)) {
                    name = String.valueOf(name) + "*";
                }
                List prefChildren = child.getInternalChildren();
                String description = null;
                int j = 0;
                while (j < prefChildren.size()) {
                    ConfigurationElement descriptionEle = (ConfigurationElement)prefChildren.get(j);
                    if (descriptionEle.getName().equals("description")) {
                        description = descriptionEle.getValue();
                        break;
                    }
                    ++j;
                }
                DashboardAttributeDef def = null;
                if (type == null) {
                    type = "string";
                }
                if (type.equals("boolean")) {
                    def = new DashboardAttributeDef(1, id, name, description);
                } else if (type.equals("list")) {
                    if (prefChildren.size() == 0) continue;
                    ArrayList<EnumChoice> choices = new ArrayList<EnumChoice>();
                    choices.add(new EnumChoice("", ""));
                    int j2 = 0;
                    while (j2 < prefChildren.size()) {
                        ConfigurationElement option = (ConfigurationElement)prefChildren.get(j2);
                        if (option.getName().equals("option")) {
                            choices.add(new EnumChoice((String)option.getAttributes().get("name"), (String)option.getAttributes().get("id")));
                        }
                        ++j2;
                    }
                    def = new DashboardAttributeDef(2, id, name, description, choices.toArray(new EnumChoice[choices.size()]));
                } else {
                    def = new DashboardAttributeDef(0, id, name, description);
                }
                this.preferenceDefs.add(def);
            }
        }

        public void createContents(Composite parent) {
            final FormToolkit toolkit = this.getManagedForm().getToolkit();
            GridLayout layout = new GridLayout();
            layout.marginTop = AbstractDashboardAspectEditor.this.getDescriptionHeight();
            parent.setLayout((Layout)layout);
            this.addMessage(parent, toolkit, 0, layout);
            this.tabFolder = new CTabFolder(parent, 0x800080);
            toolkit.adapt((Control)this.tabFolder, true, true);
            GridData gd = new GridData(1808);
            this.tabFolder.setLayoutData((Object)gd);
            toolkit.getColors().initializeSectionToolBarColors();
            Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
            this.tabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{100}, true);
            this.addGeneralTab(toolkit);
            this.updatePreferenceTab(toolkit);
            this.tabFolder.setSelection(0);
            AbstractDashboardAspectEditor.this.model.addObserver(new Observer(){

                public void update(Observable o, Object arg) {
                    if (arg instanceof DashboardModelChangedEvent) {
                        DashboardModelChangedEvent event = (DashboardModelChangedEvent)arg;
                        if (event.type == 3 && event.property instanceof DashboardAttribute && event.element instanceof ViewletElement) {
                            DashboardAttribute attribute = (DashboardAttribute)event.property;
                            ViewletElement element = (ViewletElement)event.element;
                            if (attribute.def.name.equals(element.isEntry() ? "viewlet-id" : "id")) {
                                element.preferences = new Hashtable();
                                ViewletDetailsPart.this.loadConfig(element);
                                ViewletDetailsPart.this.updatePreferenceTab(toolkit);
                            }
                        }
                    }
                }
            });
            toolkit.paintBordersFor(parent);
        }

        private void addGeneralTab(FormToolkit toolkit) {
            Composite page = (Composite)this.createSubPage(toolkit, Messages.viewletDetailsGeneralTab).getControl();
            GridLayout layout = new GridLayout();
            page.setLayout((Layout)layout);
            int span = 2;
            layout.numColumns = span + 1;
            this.createGeneralViewletEntries(toolkit, page, span);
        }

        protected void createGeneralViewletEntries(FormToolkit toolkit, final Composite parent, int span) {
            this.idEntry = (StringPropertyEntry)this.createElementEntry(toolkit, parent, AbstractDashboardAspectEditor.this.isTemplate() ? ViewletElementDef.ATT_ID : ViewletElementDef.ATT_VIEWLET_ID, span, true, true, !AbstractDashboardAspectEditor.this.isTemplate());
            this.createElementEntry(toolkit, parent, ViewletElementDef.ATT_TITLE, span, true, false, !AbstractDashboardAspectEditor.this.isTemplate());
            this.createElementEntry(toolkit, parent, ViewletElementDef.ATT_ICON, span);
            AbstractDashboardAspectEditor.this.addViewletDetailsFields(this, toolkit, parent, span);
            this.createElementEntry(toolkit, parent, ViewletElementDef.ATT_TRIM, span);
            this.createElementEntry(toolkit, parent, ViewletElementDef.ATT_BACKGROUND, span);
            AbstractDashboardAspectEditor.this.addViewletDetailsLinks(this, toolkit, parent, span);
            this.idEntry.browse.setEnabled(AbstractDashboardAspectEditor.this.extensionData != null);
            this.idEntry.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((ViewletDetailsPart)ViewletDetailsPart.this).AbstractDashboardAspectEditor.this.extensionData != null) {
                        ConfigurationElement result;
                        int status;
                        if (((ViewletDetailsPart)ViewletDetailsPart.this).AbstractDashboardAspectEditor.this.viewletChooser == null) {
                            ((ViewletDetailsPart)ViewletDetailsPart.this).AbstractDashboardAspectEditor.this.viewletChooser = new ElementListSelectionDialog(parent.getShell(), (ILabelProvider)new ViewletChooserLabelProvider());
                            ((ViewletDetailsPart)ViewletDetailsPart.this).AbstractDashboardAspectEditor.this.viewletChooser.setBlockOnOpen(true);
                            ((ViewletDetailsPart)ViewletDetailsPart.this).AbstractDashboardAspectEditor.this.viewletChooser.setMultipleSelection(false);
                            ((ViewletDetailsPart)ViewletDetailsPart.this).AbstractDashboardAspectEditor.this.viewletChooser.setAllowDuplicates(false);
                            ((ViewletDetailsPart)ViewletDetailsPart.this).AbstractDashboardAspectEditor.this.viewletChooser.setMessage(Messages.viewletChooserMessage);
                            ((ViewletDetailsPart)ViewletDetailsPart.this).AbstractDashboardAspectEditor.this.viewletChooser.setImage(DashboardImages.getImage(DashboardImages.DESC_VIEWLET_CHOOSER));
                            ((ViewletDetailsPart)ViewletDetailsPart.this).AbstractDashboardAspectEditor.this.viewletChooser.setTitle(Messages.viewletChooserTitle);
                            ArrayList<ConfigurationElement> items = new ArrayList<ConfigurationElement>();
                            List elements = ((ViewletDetailsPart)ViewletDetailsPart.this).AbstractDashboardAspectEditor.this.extensionData.getConfigurationElements("com.ibm.team.dashboard.common.viewlets");
                            for (ConfigurationElement element : elements) {
                                String title = (String)element.getAttributes().get("title");
                                String id = (String)element.getAttributes().get("id");
                                if (title == null || title.length() <= 0 || id == null || id.length() <= 0) continue;
                                items.add(element);
                            }
                            ((ViewletDetailsPart)ViewletDetailsPart.this).AbstractDashboardAspectEditor.this.viewletChooser.setElements(items.toArray());
                        }
                        if ((status = ((ViewletDetailsPart)ViewletDetailsPart.this).AbstractDashboardAspectEditor.this.viewletChooser.open()) == 0 && (result = (ConfigurationElement)((ViewletDetailsPart)ViewletDetailsPart.this).AbstractDashboardAspectEditor.this.viewletChooser.getFirstResult()) != null) {
                            ((ViewletDetailsPart)ViewletDetailsPart.this).idEntry.text.setText((String)result.getAttributes().get("id"));
                        }
                    }
                }
            });
        }

        private void removePreferenceEntries() {
            ArrayList<PropertyEntry> toRemove = new ArrayList<PropertyEntry>();
            for (PropertyEntry entry : this.entries) {
                if (!entry.preference) continue;
                toRemove.add(entry);
            }
            Iterator i = toRemove.iterator();
            while (i.hasNext()) {
                this.entries.remove(i.next());
            }
        }

        private void updatePreferenceTab(FormToolkit toolkit) {
            if (this.preferenceTab != null) {
                if (this.preferenceTab.getControl() != null) {
                    this.preferenceTab.getControl().dispose();
                }
                this.removePreferenceEntries();
            }
            if (this.preferenceDefs == null || this.preferenceDefs.size() == 0) {
                if (this.preferenceTab != null) {
                    this.preferenceTab.dispose();
                    this.preferenceTab = null;
                }
                return;
            }
            if (this.preferenceTab == null) {
                this.preferenceTab = this.createSubPage(toolkit, Messages.viewletDetailsPrefsTab);
            } else {
                Composite newPage = toolkit.createComposite((Composite)this.tabFolder);
                toolkit.paintBordersFor(newPage);
                this.preferenceTab.setControl((Control)newPage);
            }
            Composite page = (Composite)this.preferenceTab.getControl();
            GridLayout layout = new GridLayout();
            page.setLayout((Layout)layout);
            int span = 1;
            layout.numColumns = span + 1;
            int i = 0;
            while (i < this.preferenceDefs.size()) {
                DashboardAttributeDef pdef = (DashboardAttributeDef)this.preferenceDefs.get(i);
                PropertyEntry entry = this.createElementEntry(toolkit, page, pdef, span);
                entry.preference = true;
                DashboardElement el = AbstractDashboardAspectEditor.this.getCurrentElement();
                if (el instanceof ViewletElement) {
                    entry.setElement((ViewletElement)el);
                }
                ++i;
            }
        }

        private CTabItem createSubPage(FormToolkit toolkit, String name) {
            Composite page = toolkit.createComposite((Composite)this.tabFolder);
            CTabItem tab = new CTabItem(this.tabFolder, 0);
            tab.setText(name);
            tab.setControl((Control)page);
            toolkit.paintBordersFor(page);
            return tab;
        }

        public void selectionChanged(IFormPart part, ISelection selection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            DashboardElement el = null;
            if (ssel.size() == 1) {
                el = (DashboardElement)ssel.getFirstElement();
            }
            if (el instanceof ViewletElement) {
                this.updateUI((ViewletElement)el);
            }
            super.selectionChanged(part, selection);
        }

        public void extensionDataLoaded() {
            DashboardElement el = AbstractDashboardAspectEditor.this.getCurrentElement();
            if (el instanceof ViewletElement) {
                this.updateUI((ViewletElement)el);
            }
        }

        private void updateUI(ViewletElement el) {
            if (this.idEntry != null) {
                this.idEntry.browse.setEnabled(AbstractDashboardAspectEditor.this.extensionData != null);
            }
            int currentTab = this.tabFolder.getSelectionIndex();
            this.getManagedForm().getForm().setRedraw(false);
            this.tabFolder.setSelection(0);
            this.loadConfig(el);
            this.updatePreferenceTab(this.getManagedForm().getToolkit());
            this.tabFolder.setSelection(currentTab);
            this.getManagedForm().getForm().setRedraw(true);
        }

        protected void messageUpdated(boolean hasMessage) {
            ((GridData)this.tabFolder.getLayoutData()).verticalIndent = hasMessage ? 10 : 0;
        }
    }

    class ViewletElement
    extends DashboardElement {
        static final String VIEWLET = "viewlet";
        static final String VIEWLET_ENTRY = "viewlet-entry";
        private boolean entry;
        ConfigurationElement config;
        private Hashtable preferences;

        public ViewletElement(DashboardModel model, DashboardElement parent, ModelElement me, boolean entry) {
            super(model, parent, me);
            this.preferences = new Hashtable();
            this.entry = entry;
            if (entry) {
                this.reserveAttribute(ViewletElementDef.ATT_VIEWLET_ID);
            } else {
                this.reserveAttribute(ViewletElementDef.ATT_ID);
            }
            this.reserveAttribute(ViewletElementDef.ATT_TITLE);
            this.reserveAttribute(ViewletElementDef.ATT_DESC);
            this.reserveAttribute(ViewletElementDef.ATT_ICON);
            this.reserveAttribute(ViewletElementDef.ATT_PROFILE);
            this.reserveAttribute(ViewletElementDef.ATT_TRIM);
            this.reserveAttribute(ViewletElementDef.ATT_BACKGROUND);
            if (me != null) {
                this.load();
            }
        }

        public ViewletElement(DashboardModel model, DashboardElement parent, String title, boolean entry) {
            this(model, parent, (ModelElement)null, entry);
            this.putAttribute("title", title);
        }

        public String getPresentableTitle() {
            DashboardAttribute da = this.getAttribute("title");
            if (da != null && da.value != null && da.value.toString().length() > 0) {
                return da.value.toString();
            }
            if (this.config != null) {
                return (String)this.config.getAttributes().get("title");
            }
            da = this.getAttribute(this.entry ? "viewlet-id" : "id");
            if (da != null && da.value != null) {
                return da.value.toString();
            }
            return null;
        }

        public Image getImage() {
            ITeamRepository teamRepository;
            String repoUri;
            Image image;
            String icon;
            if (this.config != null && (icon = (String)this.config.getAttributes().get("icon")) != null && (image = DashboardImages.getServerImage(repoUri = (teamRepository = (ITeamRepository)AbstractDashboardAspectEditor.this.getAspect().getProcessContainerWorkingCopy().getUnderlyingProcessItem().getOrigin()).getRepositoryURI(), this.config.getInternalNamespaceIdentifier(), icon)) != null) {
                return image;
            }
            return DashboardImages.getImage(DashboardImages.DESC_VIEWLET_OBJ);
        }

        public void loadConfig() {
            this.config = AbstractDashboardAspectEditor.this.findViewletDefinition((String)this.getAttribute((String)(this.entry ? "viewlet-id" : "id")).value);
        }

        private void load() {
            String value;
            this.putAttribute(this.entry ? "viewlet-id" : "id", this.me.getAttribute(this.entry ? "viewlet-id" : "id"));
            this.putAttribute("title", this.me.getAttribute("title"));
            this.putAttribute("icon", this.me.getAttribute("icon"));
            if (!this.entry && (value = this.me.getAttribute("profile")) != null) {
                this.putAttribute("profile", value.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE);
            }
            this.putAttribute("trim", this.me.getAttribute("trim"));
            this.putAttribute("background", this.me.getAttribute("background"));
            this.loadConfig();
            List children = this.me.getChildElements();
            int i = 0;
            while (i < children.size()) {
                ModelElement child = (ModelElement)children.get(i);
                if (child.getName().equals("memento")) {
                    this.addChild(new MementoElement(this.model, this, child));
                } else if (child.getName().equals("preference")) {
                    String pid = child.getAttribute("id");
                    String value2 = child.getAttribute("value");
                    if (pid != null && value2 != null) {
                        this.putPreference(pid, value2);
                    }
                } else if (child.getName().equals("description")) {
                    this.putAttribute("desc", ((ProcessConfigurationElement)child).getCharacterData());
                }
                ++i;
            }
        }

        public Object getPreference(Object key) {
            return this.preferences.get(key);
        }

        public void setPreference(Object key, Object value) {
            this.putPreference(key, value);
            this.model.fireElementChanged(this, "preference:" + key);
        }

        private void putPreference(Object key, Object value) {
            this.preferences.put(key, value);
        }

        public String getKey() {
            return this.entry ? VIEWLET_ENTRY : VIEWLET;
        }

        public boolean isEntry() {
            return this.entry;
        }

        protected void saveSelf(IMemento memento) {
            super.saveSelf(memento);
            if (this.isEntry() && this.getParent() != null) {
                memento.putString("category", (String)this.getParent().getAttribute((String)"id").value);
            }
        }

        public void preLoadSave(IMemento memento, String parentId) {
            IMemento childMemento = memento.createChild(this.me == null ? this.getKey() : this.me.getName());
            this.saveSelf(childMemento);
            this.saveChildren(childMemento);
            childMemento.putString("category", parentId);
        }

        protected void saveChildren(IMemento memento) {
            for (String id : this.preferences.keySet()) {
                String value = (String)this.preferences.get(id);
                if (value == null || value.length() == 0) continue;
                IMemento preference = memento.createChild("preference");
                preference.putString("id", id);
                preference.putString("value", value);
            }
            super.saveChildren(memento);
        }

        public boolean canAddMemento() {
            if (this.isEntry()) {
                return false;
            }
            if (this.children != null) {
                Iterator i = this.children.iterator();
                while (i.hasNext()) {
                    if (!(i.next() instanceof MementoElement)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    static class ViewletElementDef {
        static final String ID = "id";
        static final String VIEWLET_ID = "viewlet-id";
        static final String TITLE = "title";
        static final String DESC = "desc";
        static final String ICON = "icon";
        static final String PROFILE = "profile";
        static final String TRIM = "trim";
        static final String BACKGROUND = "background";
        static final DashboardAttributeDef ATT_ID = new DashboardAttributeDef(0, "id", Messages.viewletIdentifierLabel, Messages.viewletIdTooltip);
        static final DashboardAttributeDef ATT_VIEWLET_ID = new DashboardAttributeDef(0, "viewlet-id", Messages.viewletIdentifierLabel, Messages.viewletIdTooltip);
        static final DashboardAttributeDef ATT_TITLE = new DashboardAttributeDef(0, "title", Messages.viewletTitleLabel, Messages.viewletTitleTooltip);
        static final DashboardAttributeDef ATT_DESC = new DashboardAttributeDef(3, "desc", Messages.viewletDescriptionLabel, Messages.viewletDescriptionTooltip);
        static final DashboardAttributeDef ATT_ICON = new DashboardAttributeDef(0, "icon", Messages.viewletIconLabel, Messages.viewletIconTooltip);
        static final DashboardAttributeDef ATT_PROFILE = new DashboardAttributeDef(2, "profile", Messages.viewletVisibilityLabel, Messages.viewletVisibilityTooltip, new EnumChoice[]{new EnumChoice(Messages.viewletVisibilityAllChoice, null), new EnumChoice(Messages.viewletVisibilityProfilesChoice, Boolean.TRUE), new EnumChoice(Messages.viewletVisibilityOtherChoice, Boolean.FALSE)});
        static final DashboardAttributeDef ATT_TRIM = new DashboardAttributeDef(2, "trim", Messages.viewletTrimLabel, Messages.viewletTrimTooltip, new EnumChoice[]{new EnumChoice(Messages.viewletTrimGrayChoice, "gray"), new EnumChoice(Messages.viewletTrimGoldChoice, "gold"), new EnumChoice(Messages.viewletTrimGreenChoice, "green"), new EnumChoice(Messages.viewletTrimTealChoice, "teal"), new EnumChoice(Messages.viewletTrimBlueChoice, "blue"), new EnumChoice(Messages.viewletTrimPurpleChoice, "purple"), new EnumChoice(Messages.viewletTrimOrangeChoice, "orange"), new EnumChoice(Messages.viewletTrimNoneChoice, "none")});
        static final DashboardAttributeDef ATT_BACKGROUND = new DashboardAttributeDef(1, "background", Messages.viewletBackgroundLabel, Messages.viewletBackgroundTooltip);

        ViewletElementDef() {
        }
    }

    static class ViewletMementoPropertyDef {
        static final String NAME = "name";
        static final String TYPE = "type";
        static final DashboardAttributeDef ATT_NAME = new DashboardAttributeDef(0, "name", Messages.mementoPropertyNameLabel, Messages.propertyNameTooltip);
        static final DashboardAttributeDef ATT_TYPE = new DashboardAttributeDef(2, "type", Messages.mementoPropertyTypeLabel, Messages.propertyTypeTooltip, new EnumChoice[]{new EnumChoice(Messages.mementoPropertyTypeStringChoice, "xsd:string"), new EnumChoice(Messages.mementoPropertyTypeIntChoice, "int"), new EnumChoice(Messages.mementoPropertyTypeBooleanChoice, "boolean"), new EnumChoice(Messages.mementoPropertyTypeDoubleChoice, "double")});

        ViewletMementoPropertyDef() {
        }
    }

    class ViewletPageProvider
    implements IDetailsPageProvider {
        ViewletPageProvider() {
        }

        public IDetailsPage getPage(Object key) {
            if (key.equals(ViewletElement.class)) {
                return new ViewletDetailsPart();
            }
            if (key.equals(MementoPropertyElement.class)) {
                return new MementoPropertyDetailsPart();
            }
            if (key.equals(MementoValueElement.class)) {
                return new MementoValueDetailsPart();
            }
            if (key.equals(MementoElement.class)) {
                return new MementoElementDetailsPart();
            }
            return null;
        }

        public Object getPageKey(Object object) {
            return object.getClass();
        }
    }
}

