/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ui.editors.result;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditor;
import com.ibm.team.build.internal.ui.editors.result.InternalBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;

public abstract class AbstractBuildResultPage
extends InternalBuildResultPage {
    public AbstractBuildResultPage(FormEditor editor, String id, String title, String[] contributionIds, IBuildResultContext buildResultContext) {
        super((BuildResultEditor)editor, id, title, contributionIds, buildResultContext);
    }

    public abstract PageGroup getPageGroup();

    protected abstract void createPageContent(Composite var1);

    protected void doHandleBuildResultChanged(IBuildResult previousResult) {
    }

    public final void handleBuildResultChanged(IBuildResult previousResult) {
        Display display = this.getEditorSite().getShell().getDisplay();
        display.asyncExec(this.getRunnable(previousResult));
    }

    protected Runnable getRunnable(final IBuildResult previousResult) {
        return new Runnable(){

            public void run() {
                if (AbstractBuildResultPage.this.getManagedForm() != null && AbstractBuildResultPage.this.getContentContainer() != null && !AbstractBuildResultPage.this.getContentContainer().isDisposed()) {
                    AbstractBuildResultPage.this.doHandleBuildResultChanged(previousResult);
                }
            }
        };
    }

    public boolean performGlobalAction(String id) {
        return false;
    }

    public final IBuildResultContext getBuildResultContext() {
        return super.getBuildResultContext();
    }

    public final IBuildResult getBuildResult() {
        return this.getBuildResultContext().getBuildResult();
    }

    public final IBuildResultRecord getBuildResultRecord() {
        return this.getBuildResultContext().getBuildResultRecord();
    }

    protected IBuildResultContribution[] getContributions() {
        return this.getBuildResultContext().getBuildResultContributions(this.getContributionIds());
    }

    public ImageDescriptor getStatusImageDescriptor() {
        BuildStatus pageStatus = this.getPageStatus();
        ImageDescriptor descriptor = null;
        if (pageStatus.equals((Object)BuildStatus.WARNING)) {
            descriptor = BuildUIPlugin.getImageDescriptor("icons/ovr16/warn_ovr.gif");
        } else if (pageStatus.equals((Object)BuildStatus.ERROR)) {
            descriptor = BuildUIPlugin.getImageDescriptor("icons/ovr16/failed_ovr.gif");
        }
        return descriptor;
    }

    protected BuildStatus getPageStatus() {
        BuildStatus status = BuildStatus.OK;
        IBuildResultContribution[] iBuildResultContributionArray = this.getContributions();
        int n = iBuildResultContributionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultContribution contribution = iBuildResultContributionArray[n2];
            if (contribution.getStatus().equals((Object)BuildStatus.WARNING)) {
                status = BuildStatus.WARNING;
            } else if (contribution.getStatus().equals((Object)BuildStatus.ERROR)) {
                status = BuildStatus.ERROR;
                break;
            }
            ++n2;
        }
        return status;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getManagedForm().getForm(), this.getContextHelpId());
        }
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_buildresult";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PageGroup {
        SUMMARY,
        ACTIVITIES,
        COMPILATION,
        TESTS,
        ANALYSIS,
        DOWNLOADS,
        ADDITIONS,
        LAST;

    }
}

