/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.wizards.builddefinition;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.builddefinition.BuildConfigurationRegistry;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorInput;
import com.ibm.team.build.internal.ui.wizards.builddefinition.AdditionalConfigPage;
import com.ibm.team.build.internal.ui.wizards.builddefinition.BuildTemplateSelectionPage;
import com.ibm.team.build.internal.ui.wizards.builddefinition.Messages;
import com.ibm.team.build.internal.ui.wizards.builddefinition.PostBuildPage;
import com.ibm.team.build.internal.ui.wizards.builddefinition.PreBuildPage;
import com.ibm.team.build.internal.ui.wizards.builddefinition.TeamAreaSelectionPage;
import com.ibm.team.build.internal.ui.wizards.builddefinition.WizardContext;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.RepositoryCreationPage;
import com.ibm.team.process.rcp.ui.RepositorySelectionPage;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class NewBuildDefinitionWizard
extends Wizard
implements INewWizard {
    protected WizardContext fWizardContext;
    private RepositoryCreationPage fRepositoryCreationPage;
    private RepositorySelectionPage fRepositorySelectionPage;
    private TeamAreaSelectionPage fTeamAreaSelectionPage;
    private BuildTemplateSelectionPage fBuildTemplateSelectionPage;
    private PreBuildPage fPreBuildPage;
    private PostBuildPage fPostBuildPage;
    private AdditionalConfigPage fAdditionalConfigPage;

    public NewBuildDefinitionWizard() {
        this(null, null);
    }

    private NewBuildDefinitionWizard(IProjectAreaHandle projectAreaHandle, ITeamRepository teamRepository) {
        this.setWindowTitle(Messages.NewTeamBuildWizard_WIZARD_TITLE);
        this.fWizardContext = new WizardContext(this);
        this.fWizardContext.setProjectAreaHandle(projectAreaHandle);
        if (projectAreaHandle == null) {
            this.fWizardContext.setTeamRepository(teamRepository);
        } else {
            this.fWizardContext.setTeamRepository((ITeamRepository)projectAreaHandle.getOrigin());
        }
        IBuildDefinition buildDefinition = BuildItemFactory.createBuildDefinition();
        this.fWizardContext.setBuildDefinition(buildDefinition);
        this.setHelpAvailable(true);
    }

    public NewBuildDefinitionWizard(IProjectAreaHandle projectAreaHandle) {
        this(projectAreaHandle, null);
    }

    public NewBuildDefinitionWizard(ITeamRepository teamRepository) {
        this(null, teamRepository);
    }

    public boolean performFinish() {
        ConnectedProjectAreaRegistry.getDefault().addSelectedTeamArea(this.fWizardContext.getProjectAreaHandle(), this.fWizardContext.getTeamArea());
        this.initializeBuildDefinition();
        this.openBuildDefinitionEditor(this.fWizardContext.getBuildDefinition());
        return true;
    }

    protected void displayErrorDialog(String title, String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    protected void logException(Exception exception) {
        BuildUIPlugin.log(exception);
    }

    private void openBuildDefinitionEditor(IBuildDefinition buildDefinition) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                this.openBuildDefinition(buildDefinition, page);
            }
            catch (PartInitException exception) {
                this.logException((Exception)((Object)exception));
            }
        }
    }

    protected void openBuildDefinition(IBuildDefinition buildDefinition, IWorkbenchPage page) throws PartInitException {
        BuildDefinitionEditorInput input = new BuildDefinitionEditorInput(buildDefinition, this.fWizardContext.getTeamArea(), this.fWizardContext.getTeamRepository(), true);
        page.openEditor((IEditorInput)input, "com.ibm.team.build.ui.editors.buildDefinitionEditor");
    }

    private void initializeBuildDefinition() throws IllegalArgumentException {
        IBuildDefinition buildDefinition = null;
        if (this.fWizardContext.isExistingBuildDefinition()) {
            buildDefinition = this.fWizardContext.getExistingBuildDefinition().copyDefinition();
            buildDefinition.setId(this.fWizardContext.getSuggestedBuildName());
            buildDefinition.setTeamArea((ITeamAreaHandle)this.fWizardContext.getTeamArea());
            this.fWizardContext.setBuildDefinition(buildDefinition);
        } else {
            IBuildConfigurationElement element;
            IBuildProperty property2;
            buildDefinition = this.fWizardContext.getBuildDefinition();
            buildDefinition.setIgnoreWarnings(true);
            buildDefinition.setTeamArea((ITeamAreaHandle)this.fWizardContext.getTeamArea());
            List<IBuildProperty> genericProperties = this.fWizardContext.getGenericProperties();
            for (IBuildProperty property2 : genericProperties) {
                buildDefinition.getProperties().add(property2);
            }
            for (String elementId : this.fWizardContext.getSelectedUnspecifiedElementIds()) {
                element = BuildConfigurationRegistry.getInstance().getBuildConfigurationElement(elementId);
                buildDefinition.initializeConfiguration(element);
            }
            for (String elementId : this.fWizardContext.getSelectedPreBuildElementIds()) {
                element = BuildConfigurationRegistry.getInstance().getBuildConfigurationElement(elementId);
                buildDefinition.initializeConfiguration(element);
            }
            for (String elementId : this.fWizardContext.getSelectedBuildElementIds()) {
                element = BuildConfigurationRegistry.getInstance().getBuildConfigurationElement(elementId);
                buildDefinition.initializeConfiguration(element);
            }
            for (String elementId : this.fWizardContext.getSelectedPostBuildElementIds()) {
                element = BuildConfigurationRegistry.getInstance().getBuildConfigurationElement(elementId);
                buildDefinition.initializeConfiguration(element);
            }
            property2 = buildDefinition.getProperty("com.ibm.team.build.internal.template.id");
            if (property2 == null) {
                property2 = BuildItemFactory.createBuildProperty();
                property2.setGenericEditAllowed(false);
                property2.setName("com.ibm.team.build.internal.template.id");
                buildDefinition.getProperties().add(property2);
            }
            property2.setValue(this.fWizardContext.getBuildTemplate().getId());
        }
    }

    protected String getBundleLocation(String pluginId) throws IOException {
        Bundle bundle = Platform.getBundle((String)pluginId);
        URL entry = bundle.getEntry("/");
        URL resolvedUrl = FileLocator.resolve((URL)entry);
        Path path = new Path(resolvedUrl.getPath());
        path = path.removeTrailingSeparator();
        return path.toOSString();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        if (object instanceof DomainSubtreeRoot) {
            DomainSubtreeRoot root = (DomainSubtreeRoot)object;
            Object category = root.getCategoryElement();
            if (category instanceof IProjectAreaHandle || category instanceof ITeamArea) {
                if (category instanceof ITeamArea) {
                    category = ((ITeamArea)category).getProjectArea();
                }
                IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)category;
                this.fWizardContext.setProjectAreaHandle(projectAreaHandle);
                this.fWizardContext.setTeamRepository((ITeamRepository)projectAreaHandle.getOrigin());
            }
        } else if (object instanceof IProjectAreaHandle) {
            IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)object;
            this.fWizardContext.setProjectAreaHandle(projectAreaHandle);
            this.fWizardContext.setTeamRepository((ITeamRepository)projectAreaHandle.getOrigin());
        } else if (object instanceof ITeamArea) {
            ITeamArea teamArea = (ITeamArea)object;
            this.fWizardContext.setProjectAreaHandle(teamArea.getProjectArea());
            this.fWizardContext.setTeamArea(teamArea);
            this.fWizardContext.setTeamRepository((ITeamRepository)teamArea.getOrigin());
        } else if (object instanceof ITeamRepository) {
            this.fWizardContext.setTeamRepository((ITeamRepository)object);
        } else if (object instanceof IItemHandle) {
            IItemHandle itemHandle = (IItemHandle)object;
            this.fWizardContext.setTeamRepository((ITeamRepository)itemHandle.getOrigin());
        }
    }

    public void addPages() {
        if (this.fWizardContext.getTeamRepository() == null) {
            ITeamRepository[] teamRepositories = this.getTeamRepositories();
            if (teamRepositories.length > 0) {
                this.addPage(this.getRepositorySelectionPage());
                this.addPage(this.getRepositoryCreationPage());
            } else {
                this.addPage(this.getRepositoryCreationPage());
            }
        }
        this.addPage((IWizardPage)this.getTeamAreaSelectionPage());
        this.addPage((IWizardPage)this.getBuildTemplateSelectionPage());
        this.addPage((IWizardPage)this.getPreBuildConfigPage());
        this.addPage((IWizardPage)this.getPostBuildConfigPage());
        this.addPage((IWizardPage)this.getAdditionalConfigPage());
    }

    protected ITeamRepository[] getTeamRepositories() {
        return TeamPlatform.getTeamRepositoryService().getTeamRepositories();
    }

    protected IWizardPage getRepositorySelectionPage() {
        if (this.fRepositorySelectionPage == null) {
            this.fRepositorySelectionPage = new RepositorySelectionPage(Messages.NewTeamBuildWizard_REPOSITORY_SELECTION_PAGE_TITLE, Messages.NewTeamBuildWizard_REPOSITORY_SELECTION_PAGE_DESCRIPTION);
        }
        return this.fRepositorySelectionPage;
    }

    protected IWizardPage getRepositoryCreationPage() {
        if (this.fRepositoryCreationPage == null) {
            this.fRepositoryCreationPage = new RepositoryCreationPage(Messages.NewTeamBuildWizard_REPOSITORY_SELECTION_PAGE_TITLE, Messages.NewTeamBuildWizard_REPOSITORY_CREATION_PAGE_DESCRIPTION);
        }
        return this.fRepositoryCreationPage;
    }

    protected TeamAreaSelectionPage getTeamAreaSelectionPage() {
        if (this.fTeamAreaSelectionPage == null) {
            this.fTeamAreaSelectionPage = new TeamAreaSelectionPage(this.fWizardContext);
        }
        return this.fTeamAreaSelectionPage;
    }

    protected BuildTemplateSelectionPage getBuildTemplateSelectionPage() {
        if (this.fBuildTemplateSelectionPage == null) {
            this.fBuildTemplateSelectionPage = new BuildTemplateSelectionPage(this.fWizardContext);
        }
        return this.fBuildTemplateSelectionPage;
    }

    protected PreBuildPage getPreBuildConfigPage() {
        if (this.fPreBuildPage == null) {
            this.fPreBuildPage = new PreBuildPage(Messages.NewBuildDefinitionWizard_PRE_BUILD_TITLE, this.fWizardContext);
        }
        return this.fPreBuildPage;
    }

    protected PostBuildPage getPostBuildConfigPage() {
        if (this.fPostBuildPage == null) {
            this.fPostBuildPage = new PostBuildPage(Messages.NewBuildDefinitionWizard_POST_BUILD_TITLE, this.fWizardContext);
        }
        return this.fPostBuildPage;
    }

    protected AdditionalConfigPage getAdditionalConfigPage() {
        if (this.fAdditionalConfigPage == null) {
            this.fAdditionalConfigPage = new AdditionalConfigPage(Messages.NewBuildDefinitionWizard_ADDITIONAL_TITLE, this.fWizardContext);
        }
        return this.fAdditionalConfigPage;
    }

    public boolean canFinish() {
        if (this.fWizardContext.getTeamRepository() != null && this.fWizardContext.getTeamRepository().loggedIn()) {
            if (this.fWizardContext.getExistingBuildDefinition() != null) {
                return true;
            }
            int selectedConfigElementCount = this.fWizardContext.getSelectedPreBuildElementIds().size() + this.fWizardContext.getSelectedBuildElementIds().size() + this.fWizardContext.getSelectedPostBuildElementIds().size() + this.fWizardContext.getSelectedUnspecifiedElementIds().size();
            if (selectedConfigElementCount == 0) {
                return false;
            }
            return super.canFinish();
        }
        return false;
    }

    protected ITeamRepository getSelectedRepository(RepositorySelectionPage page) {
        return page.getTeamRepository();
    }

    protected ITeamRepository createRepository(RepositoryCreationPage page) {
        return page.createRepository();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fRepositorySelectionPage) {
            ITeamRepository teamRepository = this.getSelectedRepository(this.fRepositorySelectionPage);
            if (teamRepository == null) {
                return this.getRepositoryCreationPage();
            }
            this.fWizardContext.setTeamRepository(teamRepository);
            return this.getTeamAreaSelectionPage();
        }
        if (page == this.fRepositoryCreationPage) {
            ITeamRepository teamRepository = this.createRepository(this.fRepositoryCreationPage);
            if (teamRepository != null) {
                this.fWizardContext.setTeamRepository(teamRepository);
                return this.getTeamAreaSelectionPage();
            }
            return page;
        }
        return super.getNextPage(page);
    }
}

