/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.wizards.builddefinition;

import com.ibm.team.build.common.builddefinition.IBuildDefinitionTemplate;
import com.ibm.team.build.internal.ui.editors.builddefinition.ConfigurationEditingControl;
import com.ibm.team.build.internal.ui.editors.builddefinition.IConfigurationListener;
import com.ibm.team.build.internal.ui.wizards.builddefinition.WizardContext;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationPage
extends WizardPage {
    protected final WizardContext fWizardContext;
    protected IBuildDefinitionTemplate fBuildTemplate;
    private List<String> fAvailableElementIds;
    private List<String> fSelectedElementIds;
    private boolean fAllowReordering;
    protected ConfigurationEditingControl fConfigurationControl;

    public ConfigurationPage(String title, WizardContext context, boolean allowReordering) {
        super(ConfigurationPage.class.getName());
        this.setTitle(title);
        this.fWizardContext = context;
        this.fAllowReordering = allowReordering;
    }

    protected abstract String getPageDescription(IBuildDefinitionTemplate var1);

    protected abstract List<String> getAvailableElementIds();

    protected abstract List<String> getSelectedElementIds();

    public void createControl(Composite parent) {
        this.fConfigurationControl = new ConfigurationEditingControl(parent, this.fAllowReordering);
        this.fConfigurationControl.addListener(this.getConfigurationListener());
        this.setControl((Control)this.fConfigurationControl.getControl());
        Dialog.applyDialogFont((Control)this.fConfigurationControl.getControl());
    }

    private IConfigurationListener getConfigurationListener() {
        return new IConfigurationListener(){

            public void configurationChanged() {
                ConfigurationPage.this.getContainer().updateButtons();
            }
        };
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.setPageComplete(true);
        if (this.fBuildTemplate != this.fWizardContext.getBuildTemplate()) {
            this.fAvailableElementIds = this.getAvailableElementIds();
            this.fSelectedElementIds = this.getSelectedElementIds();
            this.fBuildTemplate = this.fWizardContext.getBuildTemplate();
            this.setDescription(this.getPageDescription(this.fBuildTemplate));
            this.fConfigurationControl.initialize(this.fAvailableElementIds, this.fSelectedElementIds);
        }
        if (visible) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpId());
        }
    }

    public abstract String getHelpId();
}

