/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialog;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class RequestBuildAction
extends Action {
    private final ISelectionProvider fSelectionProvider;
    private final Shell fShell;

    public RequestBuildAction(ISelectionProvider selectionProvider, Shell shell, boolean showIcon) {
        ValidationHelper.validateNotNull((String)"shell", (Object)shell);
        this.fSelectionProvider = selectionProvider;
        this.fShell = shell;
        this.setText(this.getActionText());
        this.setToolTipText(this.getActionText());
        if (showIcon) {
            this.setImageDescriptor(BuildUIPlugin.getImageDescriptor("icons/elcl16/rquebuild.gif"));
        }
        this.setEnabled(true);
    }

    protected String getActionText() {
        return BuildUIQueryMessages.BuildQueryView_ActionText_RequestBuild;
    }

    public void run() {
        IBuildDefinition buildDefinition = null;
        IStructuredSelection selection = this.getSelection();
        if (selection.getFirstElement() instanceof BuildQueryRow) {
            BuildQueryRow buildQueryRow = (BuildQueryRow)selection.getFirstElement();
            buildDefinition = buildQueryRow.getBuildDefinition();
        }
        RequestBuildDialog dialog = this.createDialog(this.getShell(), buildDefinition);
        dialog.open();
    }

    protected IStructuredSelection getSelection() {
        if (this.fSelectionProvider == null) {
            return StructuredSelection.EMPTY;
        }
        ISelection selection = this.fSelectionProvider.getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    protected Shell getShell() {
        return this.fShell;
    }

    protected RequestBuildDialog createDialog(Shell shell, IBuildDefinition buildDefinition) {
        return new RequestBuildDialog(shell, (IBuildDefinitionHandle)buildDefinition);
    }
}

