/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryForBuildQueue;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildQueryByContributorTeamAreas;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DefaultQueryControl {
    public static final String TEAM_ARTIFACTS_VIEW = "com.ibm.team.process.rcp.ui.teamArtifactsNavigator";
    private BuildQueryView fBuildQueryView;
    protected List<Link> fQueryLinks = new ArrayList<Link>();
    protected Composite fContentContainer;

    public void create(Composite parent, IWorkbenchSite site, BuildQueryView buildQueryView) {
        this.fBuildQueryView = buildQueryView;
        this.fContentContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.fContentContainer.setLayout((Layout)layout);
        this.fContentContainer.setBackground(this.fContentContainer.getDisplay().getSystemColor(1));
        Link label = new Link(this.fContentContainer, 0);
        label.setText(BuildUIQueryMessages.DefaultQueryControl_DEFAULT_QUERY_SUMMARY);
        label.setBackground(this.fContentContainer.getBackground());
        label.addSelectionListener(this.getTeamArtifactsLinkSelectionListener(site));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        this.addLinks();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fContentContainer, "com.ibm.team.build.ui.view_builds");
    }

    protected SelectionListener getTeamArtifactsLinkSelectionListener(final IWorkbenchSite site) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    site.getWorkbenchWindow().getActivePage().showView(DefaultQueryControl.TEAM_ARTIFACTS_VIEW);
                }
                catch (PartInitException exception) {
                    BuildUIPlugin.log(exception);
                }
            }
        };
    }

    protected ITeamRepository[] getTeamRepositories() {
        return TeamPlatform.getTeamRepositoryService().getTeamRepositories();
    }

    private void addLinks() {
        Link link;
        String repositoryName;
        String queryName;
        ITeamRepository teamRepository;
        ITeamRepository[] teamRepositories;
        ITeamRepository[] iTeamRepositoryArray = teamRepositories = this.getTeamRepositories();
        int n = teamRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            teamRepository = iTeamRepositoryArray[n2];
            BuildQueryByContributorTeamAreas query = new BuildQueryByContributorTeamAreas(BuildUIQueryMessages.BuildQueryView_MY_BUILDS, teamRepository.loggedInContributor(), teamRepository);
            queryName = BuildUIQueryMessages.DefaultQueryControl_DEFAULT_QUERY_TEAMS;
            if (teamRepositories.length > 1) {
                repositoryName = teamRepository.getName();
                if (repositoryName == null) {
                    repositoryName = teamRepository.getRepositoryURI();
                }
                queryName = NLS.bind((String)BuildUIQueryMessages.DefaultQueryControl_DEFAULT_QUERY_TEAMS_FOR_REPOSITORY, (Object)repositoryName);
            }
            link = this.createQueryLink(this.fContentContainer, queryName, query);
            link.setToolTipText(BuildUIQueryMessages.DefaultQueryControl_DEFAULT_QUERY_TEAMS_TOOLTIP);
            this.fQueryLinks.add(link);
            ++n2;
        }
        iTeamRepositoryArray = teamRepositories;
        n = teamRepositories.length;
        n2 = 0;
        while (n2 < n) {
            teamRepository = iTeamRepositoryArray[n2];
            BuildQueryForBuildQueue buildQueueQuery = new BuildQueryForBuildQueue(BuildUIQueryMessages.BuildQueryView_BUILD_QUEUE_ALL_CONNECTED_PROJECT_AREAS, BuildUIQueryMessages.BuildQueryView_BUILD_QUEUE_ALL_CONNECTED_PROJECT_AREAS, AdaptableBuildQueryRow.Factory, null, teamRepository);
            queryName = BuildUIQueryMessages.DefaultQueryControl_DEFAULT_QUERY_QUEUE;
            if (teamRepositories.length > 1) {
                repositoryName = teamRepository.getName();
                if (repositoryName == null) {
                    repositoryName = teamRepository.getRepositoryURI();
                }
                queryName = NLS.bind((String)BuildUIQueryMessages.DefaultQueryControl_DEFAULT_QUERY_QUEUE_FOR_REPOSITORY, (Object)repositoryName);
            }
            link = this.createQueryLink(this.fContentContainer, queryName, buildQueueQuery);
            link.setToolTipText(BuildUIQueryMessages.DefaultQueryControl_DEFAULT_QUERY_QUEUE_TOOLTIP);
            this.fQueryLinks.add(link);
            this.fContentContainer.layout(true);
            ++n2;
        }
    }

    private Link createQueryLink(Composite parent, String linkText, BuildQuery buildQuery) {
        Link link = new Link(parent, 0);
        link.setBackground(parent.getBackground());
        link.setText(linkText);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)link);
        link.addSelectionListener(this.getQueryLinkSelectionListener(buildQuery));
        return link;
    }

    protected SelectionListener getQueryLinkSelectionListener(final BuildQuery buildQuery) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultQueryControl.this.fBuildQueryView.runQuery(buildQuery);
            }
        };
    }

    public void updateQueryLinks() {
        if (this.fContentContainer != null && !this.fContentContainer.isDisposed()) {
            for (Link link : this.fQueryLinks) {
                link.dispose();
            }
            this.fQueryLinks.clear();
            this.addLinks();
        }
    }

    public void dispose() {
        if (this.fContentContainer != null) {
            if (!this.fContentContainer.isDisposed()) {
                this.fContentContainer.dispose();
            }
            this.fContentContainer = null;
        }
    }
}

