/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumn;
import com.ibm.team.build.internal.ui.views.query.BuildQueryRowComparator;
import java.util.LinkedList;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class BuildQueryViewerComparator
extends ViewerComparator {
    protected final TableViewer fViewer;
    protected final LinkedList<BuildQueryRowComparator> fComparators;

    public BuildQueryViewerComparator(TableViewer viewer) {
        ValidationHelper.validateNotNull((String)"viewer", (Object)viewer);
        this.fViewer = viewer;
        this.fComparators = new LinkedList();
    }

    protected void promoteComparatorFor(BuildQueryColumn compareColumn, boolean clearExistingComparators) {
        ValidationHelper.validateNotNull((String)"compareColumn", (Object)compareColumn);
        if (clearExistingComparators) {
            this.fComparators.clear();
        }
        if (!this.fComparators.isEmpty() && this.fComparators.getFirst().getBuildQueryColumn() == compareColumn) {
            this.fComparators.getFirst().toggleReverseComparison();
        } else {
            BuildQueryRowComparator existingComparator = null;
            for (BuildQueryRowComparator comparator : this.fComparators) {
                if (comparator.getBuildQueryColumn() != compareColumn) continue;
                existingComparator = comparator;
                break;
            }
            if (existingComparator == null) {
                this.fComparators.addFirst(new BuildQueryRowComparator(compareColumn));
            } else {
                this.fComparators.remove(existingComparator);
                this.fComparators.addFirst(existingComparator);
            }
        }
    }

    protected void indicatePrimarySortColumn() {
        if (!this.fComparators.isEmpty()) {
            BuildQueryRowComparator primaryComparator = this.fComparators.getFirst();
            Table table = this.fViewer.getTable();
            TableColumn column = primaryComparator.getBuildQueryColumn().getTableColumn();
            table.setSortColumn(column);
            if (primaryComparator.isReverseComparison()) {
                table.setSortDirection(1024);
            } else {
                table.setSortDirection(128);
            }
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        for (BuildQueryRowComparator comparator : this.fComparators) {
            int comparison = comparator.compare(e1, e2);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    public BuildQueryRowComparator[] getRowComparators() {
        return this.fComparators.toArray(new BuildQueryRowComparator[this.fComparators.size()]);
    }
}

