/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.actions.CopyBuildResultActionDelegate;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryColumnKind;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumn;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumnLabelProvider;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumnRegistry;
import com.ibm.team.build.internal.ui.views.query.BuildQueryContentProvider;
import com.ibm.team.build.internal.ui.views.query.BuildQueryDisplayPreferences;
import com.ibm.team.build.internal.ui.views.query.BuildQueryDisplayPreferencesManager;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewColumnListener;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewColumnSelectionMenu;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewContextMenuListener;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewDragSupport;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewDropdownMenuCreator;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewHistory;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewInput;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewerComparator;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import com.ibm.team.build.internal.ui.views.query.BuildsViewTooltipSupport;
import com.ibm.team.build.internal.ui.views.query.DefaultQueryControl;
import com.ibm.team.build.internal.ui.views.query.ProjectAreaConnectionControl;
import com.ibm.team.build.internal.ui.views.query.RequestBuildAction;
import com.ibm.team.build.internal.ui.views.query.RunBuildQueryAction;
import com.ibm.team.build.ui.BuildUI;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildQueryView
extends ViewPart
implements IConnectedProjectAreaRegistryListener {
    public static final String BUILD_QUERY_VIEW_DEFINITIONS_PREFERENCE_KEY = "build.query.view.build.definitions";
    private static final String CONTEXT_MENU_ID = "com.ibm.team.build.ui.queryViewContextMenu";
    private TableViewer fTableViewer;
    private BuildQueryContentProvider fContentProvider;
    private Composite fBuildResultsTable;
    protected ProjectAreaConnectionControl fProjectAreaConnectionControl;
    protected DefaultQueryControl fDefaultQueryControl;
    protected IAction fRequestBuildAction;
    private IActionDelegate fCopyAction;
    private IAction fRefreshAction;
    private IAction fCancelAction;
    private BuildQueryViewDropdownMenuCreator.History fHistoryMenuCreator;
    protected BuildQueryViewDropdownMenuCreator.MyBuilds fMyBuildsMenuCreator;
    protected BuildQueryViewDropdownMenuCreator.BuildQueue fBuildQueueMenuCreator;
    private final BuildQueryColumnRegistry fBuildQueryColumnRegistry = new BuildQueryColumnRegistry(this);
    private final BuildQueryViewColumnListener fColumnListener = new BuildQueryViewColumnListener(this);
    private final BuildQueryViewHistory fBuildQueryViewHistory = new BuildQueryViewHistory();
    private BuildQueryDisplayPreferences fBuildQueryDisplayPreferences;
    private List<IProjectAreaHandle> fConnectedProjectAreas = new ArrayList<IProjectAreaHandle>();
    private RunBuildQueryAction fCurrentRunBuildQueryAction = null;
    private boolean fBuildQueryActionCanceled;
    private boolean fDisposed;
    private Composite fViewContentParent;
    private IMenuListener fViewDropDownMenuListener;

    public TableViewer getViewer() {
        return this.fTableViewer;
    }

    public Shell getShell() {
        return this.getSite().getShell();
    }

    protected BuildQueryColumnRegistry getColumnRegistry() {
        return this.fBuildQueryColumnRegistry;
    }

    protected BuildQueryViewColumnListener getColumnListener() {
        return this.fColumnListener;
    }

    private static BuildQueryView showView(IWorkbenchPage page) {
        try {
            return (BuildQueryView)page.showView("com.ibm.team.build.internal.ui.views.query.BuildQueryView");
        }
        catch (PartInitException exception) {
            BuildUIPlugin.log(exception);
            return null;
        }
    }

    public static void displayQuery(BuildQuery query, IWorkbenchPage page) {
        BuildQueryView view = BuildQueryView.showView(page);
        if (view != null) {
            view.runQuery(query);
        }
    }

    public void runQuery(final BuildQuery buildQuery) {
        if (buildQuery == null) {
            return;
        }
        RunBuildQueryAction action = new RunBuildQueryAction(this){

            public BuildQuery getBuildQuery() {
                return buildQuery;
            }
        };
        action.run();
    }

    public boolean isRunBuildQueryActionInProgress() {
        return this.fCurrentRunBuildQueryAction != null;
    }

    protected boolean isBuildQueryActionCanceled() {
        return this.fBuildQueryActionCanceled || this.fDisposed;
    }

    protected synchronized boolean startRunBuildQueryAction(RunBuildQueryAction runBuildQueryAction) {
        if (this.fCurrentRunBuildQueryAction != null) {
            return false;
        }
        this.fCurrentRunBuildQueryAction = runBuildQueryAction;
        this.enableRunBuildQueryActions(true);
        BuildQueryViewInput input = this.getInput();
        if (input != null) {
            input.detachResultRecordListener();
        }
        return true;
    }

    protected void finishRunBuildQueryAction() {
        BuildQueryViewInput input;
        this.fCurrentRunBuildQueryAction = null;
        this.enableRunBuildQueryActions(false);
        this.fBuildQueryActionCanceled = false;
        if (this.getCurrentQuery() != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (!BuildQueryView.this.fDisposed && BuildQueryView.this.fTableViewer != null) {
                        BuildQueryView.this.updateSortColumns(BuildQueryView.this.getCurrentQuery());
                    }
                }
            });
        }
        if ((input = this.getInput()) != null) {
            input.attachResultRecordListener();
        }
    }

    protected void enableRunBuildQueryActions(boolean enabled) {
        if (this.fCancelAction != null) {
            this.fCancelAction.setEnabled(enabled);
        }
    }

    protected void addBuildQueryViewHistoryEntry(BuildQuery buildQuery) {
        ValidationHelper.validateNotNull((String)"buildQuery", (Object)buildQuery);
        this.fBuildQueryViewHistory.addEntry(buildQuery);
        String tooltipText = NLS.bind((String)BuildUIQueryMessages.BuildQueryView_ToolbarActionTooltip_RerunBuildQuery, (Object)buildQuery.getName());
        if (this.fHistoryMenuCreator != null) {
            this.fHistoryMenuCreator.setToolTipText(tooltipText);
        }
    }

    protected BuildQueryViewHistory getBuildQueryViewHistory() {
        return this.fBuildQueryViewHistory;
    }

    protected List<IProjectAreaHandle> getConnectedProjectAreas() {
        return this.fConnectedProjectAreas;
    }

    public void createPartControl(Composite parent) {
        this.fViewContentParent = parent;
        this.initConnectedProjectAreas();
        ConnectedProjectAreaRegistry.getDefault().addListener((IConnectedProjectAreaRegistryListener)this);
        if (this.getConnectedProjectAreas().isEmpty()) {
            this.showProjectAreaConnectionControl();
        } else {
            this.showDefaultQueryControl();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fViewContentParent, "com.ibm.team.build.ui.view_builds");
        parent.layout(true);
    }

    protected void showBuildResultsTable() {
        if (this.fDefaultQueryControl != null) {
            this.fDefaultQueryControl.dispose();
            this.fDefaultQueryControl = null;
        }
        if (this.fProjectAreaConnectionControl != null) {
            this.fProjectAreaConnectionControl.dispose();
            this.fProjectAreaConnectionControl = null;
        }
        this.fTableViewer = new TableViewer(this.fViewContentParent, 268501762);
        this.fContentProvider = new BuildQueryContentProvider();
        this.fTableViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTableViewer.setUseHashlookup(true);
        Table table = this.fTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        new BuildsViewTooltipSupport(table);
        new BuildQueryViewDragSupport(this.fTableViewer);
        this.initToolbarActions();
        this.initContextMenuActions();
        this.initGlobalActions();
        this.initMenuActions();
        this.fTableViewer.addOpenListener((IOpenListener)new OpenListener());
        BuildQueryViewerComparator viewerComparator = new BuildQueryViewerComparator(this.fTableViewer);
        this.fTableViewer.setComparator((ViewerComparator)viewerComparator);
        this.fBuildResultsTable = this.fTableViewer.getTable();
        this.setToolBarActionsEnabled(true);
        this.fViewContentParent.layout(true);
    }

    protected void showProjectAreaConnectionControl() {
        if (this.fDefaultQueryControl != null) {
            this.fDefaultQueryControl.dispose();
            this.fDefaultQueryControl = null;
        }
        if (this.fBuildResultsTable != null) {
            IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
            menuManager.removeAll();
            menuManager.removeMenuListener(this.fViewDropDownMenuListener);
            this.getViewSite().getActionBars().updateActionBars();
            this.fBuildResultsTable.dispose();
            this.fBuildResultsTable = null;
            this.fTableViewer = null;
        }
        this.setContentDescription(BuildUIQueryMessages.BuildQueryView_no_input);
        this.fProjectAreaConnectionControl = new ProjectAreaConnectionControl();
        this.fProjectAreaConnectionControl.create(this.fViewContentParent);
    }

    private void showDefaultQueryControl() {
        if (this.fProjectAreaConnectionControl != null) {
            this.fProjectAreaConnectionControl.dispose();
            this.fProjectAreaConnectionControl = null;
        }
        this.setContentDescription(BuildUIQueryMessages.BuildQueryView_no_input);
        this.fDefaultQueryControl = new DefaultQueryControl();
        this.fDefaultQueryControl.create(this.fViewContentParent, (IWorkbenchSite)this.getViewSite(), this);
        this.initToolbarActions();
    }

    private void initConnectedProjectAreas() {
        this.fConnectedProjectAreas.clear();
        List projectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null);
        this.fConnectedProjectAreas.addAll(projectAreas);
    }

    private void setToolBarActionsEnabled(boolean enabled) {
        this.fMyBuildsMenuCreator.setEnabled(enabled);
        this.fBuildQueueMenuCreator.setEnabled(enabled);
        this.fHistoryMenuCreator.setEnabled(enabled);
        this.fRefreshAction.setEnabled(enabled);
        this.fRequestBuildAction.setEnabled(enabled);
    }

    private void initGlobalActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fCopyAction = new CopyBuildResultActionDelegate();
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action(){

            public void run() {
                BuildQueryView.this.fCopyAction.selectionChanged(null, BuildQueryView.this.fTableViewer.getSelection());
                BuildQueryView.this.fCopyAction.run((IAction)this);
            }
        });
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), this.fRefreshAction);
        bars.updateActionBars();
    }

    private void initToolbarActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.removeAll();
        if (this.fMyBuildsMenuCreator != null) {
            this.fMyBuildsMenuCreator.dispose();
        }
        this.fMyBuildsMenuCreator = new BuildQueryViewDropdownMenuCreator.MyBuilds(this);
        toolBarManager.add((IAction)this.fMyBuildsMenuCreator);
        this.fBuildQueueMenuCreator = new BuildQueryViewDropdownMenuCreator.BuildQueue(this);
        toolBarManager.add((IAction)this.fBuildQueueMenuCreator);
        this.fHistoryMenuCreator = new BuildQueryViewDropdownMenuCreator.History(this);
        toolBarManager.add((IAction)this.fHistoryMenuCreator);
        this.fRefreshAction = this.addRefreshAction(toolBarManager);
        this.fCancelAction = this.addCancelAction(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator());
        this.fRequestBuildAction = new RequestBuildAction((ISelectionProvider)this.fTableViewer, this.getShell(), true);
        this.fRequestBuildAction.setEnabled(true);
        this.fRequestBuildAction.setToolTipText(BuildUIQueryMessages.BuildQueryView_REQUEST_BUILD_ACTION_TOOLTIP);
        toolBarManager.add(this.fRequestBuildAction);
        this.getViewSite().getActionBars().updateActionBars();
    }

    private Action addRefreshAction(IToolBarManager toolBarManager) {
        Action action = new Action(){

            public void run() {
                BuildQuery query = BuildQueryView.this.fBuildQueryViewHistory.getMostRecent();
                if (query != null) {
                    BuildQueryView.this.runQuery(query);
                }
            }
        };
        action.setToolTipText(BuildUIQueryMessages.BuildQueryView_REFRESH);
        action.setImageDescriptor(BuildUIPlugin.getImageDescriptor("icons/elcl16/refresh.gif"));
        toolBarManager.add((IAction)action);
        return action;
    }

    private Action addCancelAction(IToolBarManager toolBarManager) {
        Action action = new Action(){

            public void run() {
                this.setEnabled(false);
                BuildQueryView.this.fBuildQueryActionCanceled = true;
            }
        };
        action.setToolTipText(BuildUIQueryMessages.BuildQueryView_CANCEL_ACTION_TOOLTIP);
        action.setImageDescriptor(BuildUIPlugin.getImageDescriptor("icons/elcl16/stop_bldrslt.gif"));
        if (this.isRunBuildQueryActionInProgress()) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
        toolBarManager.add((IAction)action);
        return action;
    }

    private void initContextMenuActions() {
        MenuManager contextMenuManager = new MenuManager("#PopupMenu");
        contextMenuManager.setRemoveAllWhenShown(true);
        BuildQueryViewContextMenuListener listener = new BuildQueryViewContextMenuListener(this);
        contextMenuManager.addMenuListener((IMenuListener)listener);
        Menu contextMenu = contextMenuManager.createContextMenu(this.fTableViewer.getControl());
        this.fTableViewer.getControl().setMenu(contextMenu);
        contextMenu.addMenuListener((MenuListener)listener);
        this.getSite().registerContextMenu(CONTEXT_MENU_ID, contextMenuManager, (ISelectionProvider)this.fTableViewer);
    }

    private void initMenuActions() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.setRemoveAllWhenShown(true);
        this.fViewDropDownMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new BuildQueryViewColumnSelectionMenu(BuildQueryView.this));
            }
        };
        menuManager.addMenuListener(this.fViewDropDownMenuListener);
        menuManager.add((IAction)new Action(null){});
        this.getViewSite().getActionBars().updateActionBars();
    }

    protected boolean areOpenableBuilds(BuildQueryRow[] rows) {
        BuildQueryRow[] buildQueryRowArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            BuildQueryRow row = buildQueryRowArray[n2];
            IBuildResult result = row.getBuildResult();
            if (result.getState() == BuildState.NOT_STARTED) {
                return false;
            }
            if (result.getState() == BuildState.CANCELED) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void initColumns(BuildQuery buildQuery) {
        Table table = this.fTableViewer.getTable();
        this.fColumnListener.setEnabled(false);
        List<BuildQueryColumn> buildQueryColumns = this.fBuildQueryColumnRegistry.getBuildQueryColumns();
        for (BuildQueryColumn buildQueryColumn : buildQueryColumns) {
            buildQueryColumn.disposeColumn();
        }
        if (buildQuery != null) {
            String preferencesKey = buildQuery.getDisplayPreferencesKey();
            BuildQueryDisplayPreferencesManager preferencesManager = BuildQueryDisplayPreferencesManager.getDefault();
            BuildQueryDisplayPreferences preferences = preferencesManager.getPreferences(preferencesKey);
            for (Class<? extends BuildQueryColumn> buildQueryColumnType : preferences.getBuildQueryColumnOrder()) {
                BuildQueryColumn buildQueryColumn = this.fBuildQueryColumnRegistry.getBuildQueryColumn(buildQueryColumnType);
                buildQueryColumn.setVisible(preferences.isBuildQueryColumnVisible(buildQueryColumnType));
                if (!buildQueryColumn.isVisible()) continue;
                TableColumn tableColumn = buildQueryColumn.createTableColumn(table, preferences);
                TableViewerColumn tableViewerColumn = new TableViewerColumn(this.fTableViewer, tableColumn);
                tableViewerColumn.setLabelProvider((CellLabelProvider)new BuildQueryColumnLabelProvider(buildQueryColumn));
            }
        }
        this.fColumnListener.setEnabled(true);
    }

    private void updateSortColumns(BuildQuery buildQuery) {
        BuildQueryViewerComparator viewerComparator = (BuildQueryViewerComparator)this.fTableViewer.getComparator();
        BuildQueryColumnKind[] defaultSortColumns = buildQuery.getDefaultSortColumns();
        if (defaultSortColumns != null) {
            boolean firstColumn = true;
            int i = 0;
            while (i < defaultSortColumns.length) {
                BuildQueryColumn column = this.getBuildQueryColumn(defaultSortColumns[i]);
                if (column != null) {
                    if (firstColumn) {
                        viewerComparator.promoteComparatorFor(column, true);
                        firstColumn = false;
                    } else {
                        viewerComparator.promoteComparatorFor(column, false);
                    }
                }
                ++i;
            }
            if (!firstColumn) {
                viewerComparator.indicatePrimarySortColumn();
            }
        }
    }

    protected BuildQueryColumn getBuildQueryColumn(BuildQueryColumnKind buildQueryColumnKind) {
        List<BuildQueryColumn> buildQueryColumns = this.fBuildQueryColumnRegistry.getBuildQueryColumns();
        for (BuildQueryColumn buildQueryColumn : buildQueryColumns) {
            if (buildQueryColumnKind != buildQueryColumn.getKind()) continue;
            return buildQueryColumn;
        }
        return null;
    }

    protected void openSelectedBuilds(BuildQueryRow[] rows) {
        ValidationHelper.validateNotNull((String)"rows", (Object[])rows);
        int i = 0;
        while (i < rows.length) {
            BuildQueryRow row = rows[i];
            BuildUI.getDefault().open((IBuildResultHandle)row.getBuildResult(), row.getTeamRepository(), this.getSite().getPage());
            ++i;
        }
    }

    protected BuildQueryRow[] getSelectedRows() {
        ISelection sel = this.getViewer().getSelection();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)sel;
            BuildQueryRow[] rows = new BuildQueryRow[ssel.size()];
            int index = 0;
            Iterator i = ssel.iterator();
            while (i.hasNext()) {
                rows[index++] = (BuildQueryRow)i.next();
            }
            return rows;
        }
        return new BuildQueryRow[0];
    }

    protected BuildQueryDisplayPreferences getPreferences() {
        return this.fBuildQueryDisplayPreferences;
    }

    protected boolean setPreferences(BuildQuery buildQuery) {
        BuildQueryDisplayPreferences oldPreferences = this.fBuildQueryDisplayPreferences;
        if (buildQuery == null) {
            this.fBuildQueryDisplayPreferences = null;
        } else {
            String preferencesKey = buildQuery.getDisplayPreferencesKey();
            this.fBuildQueryDisplayPreferences = this.lookupBuildQueryDisplayPreferences(preferencesKey);
        }
        return oldPreferences != this.fBuildQueryDisplayPreferences;
    }

    protected BuildQueryDisplayPreferences lookupBuildQueryDisplayPreferences(String preferencesKey) {
        BuildQueryDisplayPreferencesManager preferencesManager = BuildQueryDisplayPreferencesManager.getDefault();
        return preferencesManager.getPreferences(preferencesKey);
    }

    public BuildQuery getCurrentQuery() {
        BuildQueryViewInput input = this.getInput();
        if (input == null || input.getBuildQueryResult() == null) {
            return null;
        }
        return input.getBuildQueryResult().getBuildQuery();
    }

    protected IWorkbenchSiteProgressService getProgressService() {
        return (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
    }

    protected BuildQueryViewInput getInput() {
        if (this.fTableViewer == null) {
            return null;
        }
        return (BuildQueryViewInput)this.fTableViewer.getInput();
    }

    protected void setInput(final BuildQueryViewInput input) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (BuildQueryView.this.fViewContentParent != null && !BuildQueryView.this.fViewContentParent.isDisposed()) {
                    if (input == null) {
                        BuildQueryView.this.setContentDescription(BuildUIQueryMessages.BuildQueryView_no_input);
                    } else {
                        BuildQueryView.this.setContentDescription(input.getDescription());
                        if (input.getBuildQueryResult() != null) {
                            BuildQuery buildQuery = input.getBuildQueryResult().getBuildQuery();
                            boolean preferencesChanged = BuildQueryView.this.setPreferences(buildQuery);
                            if (BuildQueryView.this.fBuildResultsTable == null) {
                                BuildQueryView.this.showBuildResultsTable();
                                BuildQueryView.this.initColumns(buildQuery);
                            } else if (preferencesChanged) {
                                BuildQueryView.this.initColumns(buildQuery);
                            }
                        } else if (BuildQueryView.this.fDefaultQueryControl != null) {
                            BuildQueryView.this.fDefaultQueryControl.dispose();
                            BuildQueryView.this.fDefaultQueryControl = null;
                        }
                    }
                    if (BuildQueryView.this.fTableViewer != null) {
                        BuildQueryView.this.fTableViewer.getTable().setSortDirection(0);
                        BuildQueryView.this.fTableViewer.setItemCount(0);
                        BuildQueryView.this.fTableViewer.setSelection((ISelection)new StructuredSelection());
                        BuildQueryView.this.fTableViewer.setInput((Object)input);
                    }
                }
            }
        });
    }

    protected void updateBuildQueryViewLabelAndRowCount(final String label, final int rowCount) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (BuildQueryView.this.fViewContentParent != null && !BuildQueryView.this.fViewContentParent.isDisposed()) {
                    BuildQueryView.this.setContentDescription(label);
                    BuildQueryView.this.fTableViewer.setItemCount(rowCount);
                }
            }
        });
    }

    protected void refreshViewer() {
        TableViewer viewer = this.getViewer();
        if (viewer != null) {
            viewer.refresh();
        }
    }

    public void setFocus() {
        TableViewer viewer = this.getViewer();
        if (viewer != null && !viewer.getTable().isDisposed()) {
            viewer.getTable().setFocus();
        }
    }

    public void dispose() {
        this.fDisposed = true;
        this.fContentProvider = null;
        this.fTableViewer = null;
        this.fViewContentParent = null;
        if (this.fMyBuildsMenuCreator != null) {
            this.fMyBuildsMenuCreator.dispose();
            this.fMyBuildsMenuCreator = null;
        }
        ConnectedProjectAreaRegistry.getDefault().removeListener((IConnectedProjectAreaRegistryListener)this);
        super.dispose();
    }

    public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
        this.initConnectedProjectAreas();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                BuildQueryView.this.handleProjectAreasChanged();
            }
        });
    }

    protected void handleProjectAreasChanged() {
        if (this.fViewContentParent != null && !this.fViewContentParent.isDisposed()) {
            if (this.fProjectAreaConnectionControl != null) {
                if (this.getConnectedProjectAreas().size() > 0) {
                    this.showDefaultQueryControl();
                }
            } else if (this.fDefaultQueryControl != null) {
                if (this.getConnectedProjectAreas().size() > 0) {
                    this.fDefaultQueryControl.updateQueryLinks();
                } else {
                    this.showProjectAreaConnectionControl();
                }
            } else if (this.fBuildResultsTable != null && this.getConnectedProjectAreas().size() == 0) {
                this.showProjectAreaConnectionControl();
                this.setToolBarActionsEnabled(false);
            }
            this.fViewContentParent.layout(true);
        }
    }

    public class OpenListener
    implements IOpenListener {
        public void open(OpenEvent event) {
            BuildQueryRow[] rows = BuildQueryView.this.getSelectedRows();
            if (BuildQueryView.this.areOpenableBuilds(rows)) {
                BuildQueryView.this.openSelectedBuilds(rows);
            }
        }
    }
}

