/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumn;
import java.util.Comparator;

public class BuildQueryRowComparator
implements Comparator {
    private final BuildQueryColumn fBuildQueryColumn;
    private boolean fReverseComparison;

    public BuildQueryRowComparator(BuildQueryColumn buildQueryColumn) {
        ValidationHelper.validateNotNull((String)"buildQueryColumn", (Object)buildQueryColumn);
        this.fBuildQueryColumn = buildQueryColumn;
        this.fReverseComparison = false;
    }

    public BuildQueryColumn getBuildQueryColumn() {
        return this.fBuildQueryColumn;
    }

    public boolean isReverseComparison() {
        return this.fReverseComparison;
    }

    public void toggleReverseComparison() {
        this.fReverseComparison = !this.fReverseComparison;
    }

    public int compare(Object e1, Object e2) {
        BuildQueryRow row1 = null;
        BuildQueryRow row2 = null;
        if (!(e1 instanceof BuildQueryRow) || !(e2 instanceof BuildQueryRow)) {
            return 0;
        }
        row1 = (BuildQueryRow)e1;
        row2 = (BuildQueryRow)e2;
        long row1ComparisonLong = this.fBuildQueryColumn.getComparisonLong(row1);
        long row2ComparisonLong = this.fBuildQueryColumn.getComparisonLong(row2);
        if (row1ComparisonLong != row2ComparisonLong) {
            Long l1 = new Long(row1ComparisonLong);
            Long l2 = new Long(row2ComparisonLong);
            if (!this.isReverseComparison()) {
                return l1.compareTo(l2);
            }
            return l2.compareTo(l1);
        }
        String row1ComparisonString = this.fBuildQueryColumn.getComparisonString(row1);
        String row2ComparisonString = this.fBuildQueryColumn.getComparisonString(row2);
        if (row1ComparisonString == null || row2ComparisonString == null) {
            return 0;
        }
        if (!this.isReverseComparison()) {
            return row1ComparisonString.compareTo(row2ComparisonString);
        }
        return row2ComparisonString.compareTo(row1ComparisonString);
    }
}

