/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.common.helper.BuildActivityHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildCompositeImageRegistry;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.TimeFormatHelper;
import com.ibm.team.build.internal.ui.query.BuildQueryColumnKind;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildQueryDisplayPreferences;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewerComparator;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public abstract class BuildQueryColumn {
    private final String fColumnLabel;
    private final String fColumnSizingText;
    private final String fColumnDescription;
    private final int fTextAlign;
    private BuildQueryView fBuildQueryView;
    private TableColumn fTableColumn;
    private boolean fIsVisible = true;

    public BuildQueryColumn(String columnLabel, String columnSizingText, String columnDescription) {
        ValidationHelper.validateNotNull((String)"columnLabel", (Object)columnLabel);
        this.fColumnLabel = columnLabel;
        this.fColumnSizingText = columnSizingText;
        this.fColumnDescription = columnDescription;
        this.fTextAlign = 16384;
    }

    protected void initBuildQueryView(BuildQueryView buildQueryView) {
        ValidationHelper.validateNotNull((String)"buildQueryView", (Object)((Object)buildQueryView));
        this.fBuildQueryView = buildQueryView;
    }

    public abstract BuildQueryColumnKind getKind();

    public String getColumnLabel() {
        return this.fColumnLabel;
    }

    public boolean showColumnLabel() {
        return true;
    }

    public String getColumnDescription() {
        return this.fColumnDescription;
    }

    public String getColumnSizingText() {
        return this.fColumnSizingText;
    }

    protected TableColumn createTableColumn(Table table, BuildQueryDisplayPreferences preferences) {
        if (this.fTableColumn != null) {
            return this.fTableColumn;
        }
        this.fTableColumn = new TableColumn(table, this.fTextAlign);
        this.fTableColumn.setData((Object)this);
        if (this.showColumnLabel()) {
            this.fTableColumn.setText(this.fColumnLabel);
        }
        String tooltip = this.fColumnDescription != null ? this.fColumnDescription : this.fColumnLabel;
        this.fTableColumn.setToolTipText(tooltip);
        this.fTableColumn.setMoveable(true);
        int width = preferences.getBuildQueryColumnWidth(this.getClass());
        if (width <= 0) {
            if (this.getColumnSizingText() == null) {
                width = 20;
            } else {
                GC gc = new GC((Drawable)table);
                String paddedText = "   " + this.getColumnSizingText() + "  ";
                width = gc.textExtent((String)paddedText).x;
                gc.dispose();
            }
        }
        this.fTableColumn.setWidth(width);
        this.fTableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewer viewer;
                if (!BuildQueryColumn.this.fBuildQueryView.isRunBuildQueryActionInProgress() && (viewer = BuildQueryColumn.this.fBuildQueryView.getViewer()) != null) {
                    BuildQueryViewerComparator viewerComparator = (BuildQueryViewerComparator)viewer.getComparator();
                    viewerComparator.promoteComparatorFor(BuildQueryColumn.this, false);
                    viewerComparator.indicatePrimarySortColumn();
                    BuildQueryColumn.this.fBuildQueryView.getInput().sort(viewerComparator.getRowComparators());
                    viewer.refresh();
                }
            }
        });
        this.fTableColumn.addControlListener((ControlListener)this.fBuildQueryView.getColumnListener());
        return this.fTableColumn;
    }

    protected void disposeColumn() {
        if (this.fTableColumn != null) {
            this.fTableColumn.dispose();
            this.fTableColumn = null;
        }
    }

    protected TableColumn getTableColumn() {
        return this.fTableColumn;
    }

    protected boolean isVisible() {
        return this.fIsVisible;
    }

    protected void setVisible(boolean isVisible) {
        this.fIsVisible = isVisible;
    }

    public String getRowText(BuildQueryRow row) {
        return null;
    }

    public boolean useFullBoundsForTooltip() {
        return true;
    }

    public String getRowTooltipText(BuildQueryRow row) {
        String rowText = this.getRowText(row);
        if ("".equals(rowText)) {
            rowText = null;
        }
        return rowText;
    }

    public Image getRowImage(BuildQueryRow row) {
        return null;
    }

    public long getComparisonLong(BuildQueryRow row) {
        return 0L;
    }

    public final String getComparisonString(BuildQueryRow row) {
        String rowText = this.getRowText(row);
        if (rowText != null) {
            return rowText;
        }
        String rowTooltipText = this.getRowTooltipText(row);
        if (rowTooltipText != null) {
            return rowTooltipText;
        }
        return "";
    }

    protected static class BuildDefinition
    extends BuildQueryColumn {
        public BuildDefinition() {
            super(BuildUIQueryMessages.BuildQueryColumn_Column_BuildDefinition, BuildUIQueryMessages.BuildQueryColumn_Column_BuildDefinition_SizingText, BuildUIQueryMessages.BuildQueryColumn_Column_BuildDefinition_Description);
        }

        public BuildQueryColumnKind getKind() {
            return BuildQueryColumnKind.BuildDefinition;
        }

        public String getRowText(BuildQueryRow row) {
            IBuildDefinition definition = row.getBuildDefinition();
            String text = null;
            text = definition != null ? (row.getBuildResult().isPersonalBuild() ? NLS.bind((String)BuildUIQueryMessages.BuildQueryColumn_DEFINITION_PERSONAL_BUILD, (Object)definition.getId(), (Object)row.getBuildRequestorName()) : definition.getId()) : BuildUIQueryMessages.BuildQueryColumn_Column_BuildDefinition_Missing;
            return text;
        }
    }

    protected static class BuildEngineId
    extends BuildQueryColumn {
        public BuildEngineId() {
            super(BuildUIQueryMessages.BuildQueryColumn_Column_BuildEngineId, BuildUIQueryMessages.BuildQueryColumn_Column_BuildEngineId_SizingText, BuildUIQueryMessages.BuildQueryColumn_Column_BuildEngineId_Description);
        }

        public BuildQueryColumnKind getKind() {
            return BuildQueryColumnKind.BuildEngineId;
        }

        public String getRowText(BuildQueryRow row) {
            IBuildResult buildResult = row.getBuildResult();
            if (buildResult.getState() == BuildState.IN_PROGRESS) {
                return row.getBuildEngineId();
            }
            if (buildResult.getState() == BuildState.COMPLETED) {
                return row.getBuildEngineId();
            }
            if (buildResult.getState() == BuildState.INCOMPLETE) {
                return row.getBuildEngineId();
            }
            return BuildUIQueryMessages.BuildQueryColumn_cell_value_not_applicable;
        }
    }

    protected static class CompletionTime
    extends BuildQueryColumn {
        public CompletionTime() {
            super(BuildUIQueryMessages.BuildQueryColumn_Column_CompletionTime, BuildUIQueryMessages.BuildQueryColumn_Column_CompletionTime_SizingText, BuildUIQueryMessages.BuildQueryColumn_Column_CompletionTime_Description);
        }

        public BuildQueryColumnKind getKind() {
            return BuildQueryColumnKind.CompletionTime;
        }

        public long getComparisonLong(BuildQueryRow row) {
            return this.getCompletionTime(row);
        }

        public String getRowText(BuildQueryRow row) {
            IBuildResult buildResult = row.getBuildResult();
            long completionTime = this.getCompletionTime(row);
            Timestamp completionTimestamp = new Timestamp(completionTime);
            if (buildResult.getState() == BuildState.COMPLETED) {
                if (completionTime == -1L) {
                    return BuildUIQueryMessages.BuildQueryColumn_CompletionTime_unknown;
                }
                return TimeFormatHelper.getDateString(completionTime);
            }
            if (buildResult.getState() == BuildState.IN_PROGRESS) {
                if (completionTime == -1L) {
                    return BuildUIQueryMessages.BuildQueryColumn_CompletionTime_noEstimate;
                }
                if (completionTime > row.getReferenceTime().getTime()) {
                    String timeDif = TimeFormatHelper.getReadableTimeDif(completionTimestamp, row.getReferenceTime().getTime());
                    return NLS.bind((String)BuildUIQueryMessages.BuildQueryColumn_CompletionTime_estimate, (Object)timeDif);
                }
                String timeDif = TimeFormatHelper.getReadableTimeDif(completionTimestamp, row.getReferenceTime().getTime());
                return NLS.bind((String)BuildUIQueryMessages.BuildQueryColumn_CompletionTime_overdue, (Object)timeDif);
            }
            return BuildUIQueryMessages.BuildQueryColumn_cell_value_not_applicable;
        }

        private long getCompletionTime(BuildQueryRow row) {
            IBuildResult buildResult = row.getBuildResult();
            if (buildResult.getState() == BuildState.COMPLETED) {
                long startTime = buildResult.getBuildStartTime();
                if (startTime <= 0L) {
                    return -1L;
                }
                long timeTaken = buildResult.getBuildTimeTaken();
                if (timeTaken < 0L) {
                    return -1L;
                }
                return startTime + timeTaken;
            }
            if (buildResult.getState() == BuildState.IN_PROGRESS) {
                long startTime = buildResult.getBuildStartTime();
                if (startTime <= 0L) {
                    return -1L;
                }
                if (row.getBuildAverageData() == null) {
                    return -1L;
                }
                long averageTime = row.getBuildAverageData().getAverageBuildTimeTaken();
                return startTime + averageTime;
            }
            if (buildResult.getState() == BuildState.NOT_STARTED) {
                return Long.MAX_VALUE;
            }
            return -1L;
        }
    }

    protected static class EstimatedCompletionTime
    extends BuildQueryColumn {
        public EstimatedCompletionTime() {
            super(BuildUIQueryMessages.BuildQueryColumn_Column_EstimatedCompletionTime, BuildUIQueryMessages.BuildQueryColumn_Column_EstimatedCompletionTime_SizingText, BuildUIQueryMessages.BuildQueryColumn_Column_EstimatedCompletionTime_Description);
        }

        public BuildQueryColumnKind getKind() {
            return BuildQueryColumnKind.EstimatedCompletionTime;
        }

        public String getRowText(BuildQueryRow row) {
            long estimatedCompletionTime = this.getEstimatedCompletionTime(row);
            Timestamp estimatedCompletionTimestamp = new Timestamp(estimatedCompletionTime);
            if (estimatedCompletionTime == Long.MIN_VALUE || estimatedCompletionTime == Long.MAX_VALUE) {
                return BuildUIQueryMessages.BuildQueryColumn_cell_value_not_applicable;
            }
            if (estimatedCompletionTime == -1L) {
                return BuildUIQueryMessages.BuildQueryColumn_CompletionTime_noEstimate;
            }
            if (estimatedCompletionTime > row.getReferenceTime().getTime()) {
                String timeDif = TimeFormatHelper.getReadableTimeDif(estimatedCompletionTimestamp, row.getReferenceTime().getTime());
                return timeDif;
            }
            String timeDif = TimeFormatHelper.getReadableTimeDif(estimatedCompletionTimestamp, row.getReferenceTime().getTime());
            return NLS.bind((String)BuildUIQueryMessages.BuildQueryColumn_CompletionTime_overdue, (Object)timeDif);
        }

        public long getComparisonLong(BuildQueryRow row) {
            return this.getEstimatedCompletionTime(row);
        }

        private long getEstimatedCompletionTime(BuildQueryRow row) {
            IBuildResult buildResult = row.getBuildResult();
            if (buildResult.getState() == BuildState.NOT_STARTED) {
                return Long.MAX_VALUE;
            }
            if (buildResult.getState() == BuildState.IN_PROGRESS) {
                long startTime = buildResult.getBuildStartTime();
                if (startTime <= 0L) {
                    return -1L;
                }
                if (row.getBuildAverageData() == null) {
                    return -1L;
                }
                long averageTime = row.getBuildAverageData().getAverageBuildTimeTaken();
                return startTime + averageTime;
            }
            return Long.MIN_VALUE;
        }
    }

    protected static class Label
    extends BuildQueryColumn {
        public Label() {
            super(BuildUIQueryMessages.BuildQueryColumn_Column_Label, BuildUIQueryMessages.BuildQueryColumn_Column_Label_SizingText, BuildUIQueryMessages.BuildQueryColumn_Column_Label_Description);
        }

        public BuildQueryColumnKind getKind() {
            return BuildQueryColumnKind.Label;
        }

        public String getRowText(BuildQueryRow row) {
            IBuildResult buildResult = row.getBuildResult();
            return buildResult.getLabel();
        }
    }

    protected static class Progress
    extends BuildQueryColumn {
        public Progress() {
            super(BuildUIQueryMessages.BuildQueryColumn_Column_Progress, BuildUIQueryMessages.BuildQueryColumn_Column_Progress_SizingText, BuildUIQueryMessages.BuildQueryColumn_Column_Progress_Description);
        }

        public BuildQueryColumnKind getKind() {
            return BuildQueryColumnKind.Progress;
        }

        public String getRowText(BuildQueryRow row) {
            IBuildResult buildResult = row.getBuildResult();
            long progress = this.getProgress(row);
            if (progress == Long.MIN_VALUE || progress == Long.MAX_VALUE) {
                if (buildResult.getState() == BuildState.COMPLETED) {
                    return BuildUIQueryMessages.BuildQueryColumn_State_Completed;
                }
                if (buildResult.getState() == BuildState.INCOMPLETE) {
                    return BuildUIQueryMessages.BuildQueryColumn_State_Abandoned;
                }
                if (buildResult.getState() == BuildState.NOT_STARTED) {
                    return BuildUIQueryMessages.BuildQueryColumn_State_Pending;
                }
                if (buildResult.getState() == BuildState.CANCELED) {
                    return BuildUIQueryMessages.BuildQueryColumn_State_Canceled;
                }
                return BuildUIQueryMessages.BuildQueryColumn_cell_value_not_applicable;
            }
            String currentActivityLabel = BuildActivityHelper.getCurrentActivityText((Collection)row.getBuildResultRecord().getCurrentBuildActivities());
            if (currentActivityLabel == null) {
                currentActivityLabel = "";
            }
            if (progress == -1L) {
                if (currentActivityLabel.length() == 0) {
                    return BuildUIQueryMessages.BuildQueryColumn_Progress_noProgress;
                }
                return currentActivityLabel;
            }
            if (currentActivityLabel.length() == 0) {
                return NLS.bind((String)BuildUIQueryMessages.BuildQueryColumn_Progress_percentProgress, (Object)progress);
            }
            return NLS.bind((String)BuildUIQueryMessages.BuildQueryColumn_Progress_percentProgress_currentActivityLabel, (Object)progress, (Object)currentActivityLabel);
        }

        public long getComparisonLong(BuildQueryRow row) {
            return this.getProgress(row);
        }

        private long getProgress(BuildQueryRow row) {
            IBuildResult buildResult = row.getBuildResult();
            if (buildResult.getState() == BuildState.COMPLETED) {
                return Long.MAX_VALUE;
            }
            if (buildResult.getState() == BuildState.IN_PROGRESS) {
                return row.getBuildResultRecord().getPercentComplete();
            }
            return Long.MIN_VALUE;
        }
    }

    protected static class Requestor
    extends BuildQueryColumn {
        public Requestor() {
            super(BuildUIQueryMessages.BuildQueryColumn_Column_Requestor, BuildUIQueryMessages.BuildQueryColumn_Column_Requestor_SizingText, BuildUIQueryMessages.BuildQueryColumn_Column_Requestor_Description);
        }

        public BuildQueryColumnKind getKind() {
            return BuildQueryColumnKind.Requestor;
        }

        public String getRowText(BuildQueryRow row) {
            return row.getBuildRequestorName();
        }
    }

    protected static class StartTime
    extends BuildQueryColumn {
        public StartTime() {
            super(BuildUIQueryMessages.BuildQueryColumn_Column_StartTime, BuildUIQueryMessages.BuildQueryColumn_Column_StartTime_SizingText, BuildUIQueryMessages.BuildQueryColumn_Column_StartTime_Description);
        }

        public BuildQueryColumnKind getKind() {
            return BuildQueryColumnKind.StartTime;
        }

        public String getRowText(BuildQueryRow row) {
            long startTime = this.getStartTime(row);
            if (startTime == Long.MIN_VALUE || startTime == Long.MAX_VALUE) {
                return BuildUIQueryMessages.BuildQueryColumn_cell_value_not_applicable;
            }
            return TimeFormatHelper.getDateString(startTime);
        }

        public long getComparisonLong(BuildQueryRow row) {
            return this.getStartTime(row);
        }

        private long getStartTime(BuildQueryRow row) {
            IBuildResult buildResult = row.getBuildResult();
            if (buildResult.getState() == BuildState.NOT_STARTED) {
                return Long.MAX_VALUE;
            }
            if (buildResult.getState() == BuildState.COMPLETED) {
                return buildResult.getBuildStartTime();
            }
            if (buildResult.getState() == BuildState.IN_PROGRESS) {
                return buildResult.getBuildStartTime();
            }
            if (buildResult.getState() == BuildState.INCOMPLETE) {
                return buildResult.getBuildStartTime();
            }
            return Long.MIN_VALUE;
        }
    }

    protected static class State
    extends BuildQueryColumn {
        public State() {
            super(BuildUIQueryMessages.BuildQueryColumn_Column_State, null, BuildUIQueryMessages.BuildQueryColumn_Column_State_Description);
        }

        public BuildQueryColumnKind getKind() {
            return BuildQueryColumnKind.State;
        }

        public boolean showColumnLabel() {
            return false;
        }

        public String getRowTooltipText(BuildQueryRow row) {
            IBuildResult buildResult = row.getBuildResult();
            if (buildResult.getState() == BuildState.COMPLETED) {
                return BuildUIQueryMessages.BuildQueryColumn_State_Completed;
            }
            if (buildResult.getState() == BuildState.IN_PROGRESS) {
                return BuildUIQueryMessages.BuildQueryColumn_State_InProgress;
            }
            if (buildResult.getState() == BuildState.INCOMPLETE) {
                return BuildUIQueryMessages.BuildQueryColumn_State_Abandoned;
            }
            if (buildResult.getState() == BuildState.NOT_STARTED) {
                return BuildUIQueryMessages.BuildQueryColumn_State_Pending;
            }
            if (buildResult.getState() == BuildState.CANCELED) {
                return BuildUIQueryMessages.BuildQueryColumn_State_Canceled;
            }
            return null;
        }

        public Image getRowImage(BuildQueryRow row) {
            IBuildResult buildResult = row.getBuildResult();
            Image image = null;
            if (buildResult.getState() == BuildState.COMPLETED) {
                image = BuildUIPlugin.getImage("icons/obj16/bld_rslt.gif");
            } else if (buildResult.getState() == BuildState.IN_PROGRESS) {
                image = BuildUIPlugin.getImage("icons/obj16/rung_bld.gif");
            } else if (buildResult.getState() == BuildState.INCOMPLETE) {
                image = BuildUIPlugin.getImage("icons/obj16/bldrsltabandoned_obj.gif");
            } else if (buildResult.getState() == BuildState.CANCELED) {
                image = BuildUIPlugin.getImage("icons/obj16/build_result_obj.gif");
            } else if (buildResult.getState() == BuildState.NOT_STARTED) {
                image = BuildUIPlugin.getImage("icons/obj16/pendingblds_obj.gif");
            }
            if (buildResult.isPersonalBuild()) {
                image = BuildCompositeImageRegistry.getPersonalBuildImage(image);
            }
            return image;
        }
    }

    protected static class Status
    extends BuildQueryColumn {
        public Status() {
            super(BuildUIQueryMessages.BuildQueryColumn_Column_Status, null, BuildUIQueryMessages.BuildQueryColumn_Column_Status_Description);
        }

        public BuildQueryColumnKind getKind() {
            return BuildQueryColumnKind.Status;
        }

        public boolean showColumnLabel() {
            return false;
        }

        public String getRowTooltipText(BuildQueryRow row) {
            IBuildResult buildResult = row.getBuildResult();
            if (buildResult.getState() == BuildState.INCOMPLETE) {
                return null;
            }
            if (buildResult.getState() == BuildState.CANCELED) {
                return null;
            }
            if (buildResult.getStatus() == BuildStatus.ERROR) {
                return BuildUIQueryMessages.BuildQueryColumn_Status_Failures;
            }
            if (buildResult.getStatus() == BuildStatus.WARNING) {
                return BuildUIQueryMessages.BuildQueryColumn_Status_Warnings;
            }
            if (buildResult.getStatus() == BuildStatus.OK) {
                return BuildUIQueryMessages.BuildQueryColumn_Status_Success;
            }
            return BuildUIQueryMessages.BuildQueryColumn_Status_Success;
        }

        public Image getRowImage(BuildQueryRow row) {
            IBuildResult buildResult = row.getBuildResult();
            if (buildResult.getState() == BuildState.INCOMPLETE) {
                return null;
            }
            if (buildResult.getState() == BuildState.CANCELED) {
                return null;
            }
            if (buildResult.getState() == BuildState.NOT_STARTED) {
                return null;
            }
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            if (buildResult.getStatus() == BuildStatus.ERROR) {
                return sharedImages.getImage("IMG_OBJS_ERROR_TSK");
            }
            if (buildResult.getStatus() == BuildStatus.WARNING) {
                return sharedImages.getImage("IMG_OBJS_WARN_TSK");
            }
            if (buildResult.getStatus() == BuildStatus.OK) {
                return BuildUIPlugin.getImage("icons/obj16/completedblds_obj.gif");
            }
            return BuildUIPlugin.getImage("icons/obj16/completedblds_obj.gif");
        }
    }

    protected static class Tags
    extends BuildQueryColumn {
        private static final String fLineSeparator = System.getProperty("line.separator");

        public Tags() {
            super(BuildUIQueryMessages.BuildQueryColumn_Column_Tags, BuildUIQueryMessages.BuildQueryColumn_Column_Tags, BuildUIQueryMessages.BuildQueryColumn_Column_Tags_Description);
        }

        public BuildQueryColumnKind getKind() {
            return BuildQueryColumnKind.Tags;
        }

        public String getRowText(BuildQueryRow row) {
            return this.getText(row, BuildUIQueryMessages.BuildQueryColumn_Tags_textSeparator);
        }

        public String getRowTooltipText(BuildQueryRow row) {
            return this.getText(row, fLineSeparator);
        }

        private String getText(BuildQueryRow row, String separator) {
            String[] tags = row.getBuildResult().getParsedTags();
            Arrays.sort(tags, Collator.getInstance());
            if (tags.length == 0) {
                return null;
            }
            boolean first = true;
            StringBuffer sb = new StringBuffer();
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (first) {
                    first = false;
                } else {
                    sb.append(separator);
                }
                sb.append(tag);
                ++n2;
            }
            return sb.toString();
        }
    }

    protected static class TimeInQueue
    extends BuildQueryColumn {
        public TimeInQueue() {
            super(BuildUIQueryMessages.BuildQueryColumn_Column_TimeInQueue, BuildUIQueryMessages.BuildQueryColumn_Column_TimeInQueue_SizingText, BuildUIQueryMessages.BuildQueryColumn_Column_TimeInQueue_Description);
        }

        public BuildQueryColumnKind getKind() {
            return BuildQueryColumnKind.TimeInQueue;
        }

        public String getRowText(BuildQueryRow row) {
            long timeInQueue = this.getTimeInQueue(row);
            if (timeInQueue < 0L) {
                return BuildUIQueryMessages.BuildQueryColumn_cell_value_not_applicable;
            }
            return TimeFormatHelper.formatTime(timeInQueue);
        }

        public long getComparisonLong(BuildQueryRow row) {
            return this.getTimeInQueue(row);
        }

        private long getTimeInQueue(BuildQueryRow row) {
            Timestamp referenceTime = row.getReferenceTime();
            Timestamp requestTime = row.getRequestCreatedTime();
            if (requestTime == null) {
                return -1L;
            }
            IBuildResult buildResult = row.getBuildResult();
            if (buildResult.getState() == BuildState.NOT_STARTED) {
                return referenceTime.getTime() - requestTime.getTime();
            }
            if (buildResult.getState() == BuildState.COMPLETED) {
                return buildResult.getBuildStartTime() - requestTime.getTime();
            }
            if (buildResult.getState() == BuildState.IN_PROGRESS) {
                return buildResult.getBuildStartTime() - requestTime.getTime();
            }
            if (buildResult.getState() == BuildState.INCOMPLETE) {
                return buildResult.getBuildStartTime() - requestTime.getTime();
            }
            return -1L;
        }
    }

    protected static class TimeTaken
    extends BuildQueryColumn {
        public TimeTaken() {
            super(BuildUIQueryMessages.BuildQueryColumn_Column_TimeTaken, BuildUIQueryMessages.BuildQueryColumn_Column_TimeTaken_SizingText, BuildUIQueryMessages.BuildQueryColumn_Column_TimeTaken_Description);
        }

        public BuildQueryColumnKind getKind() {
            return BuildQueryColumnKind.TimeTaken;
        }

        public String getRowText(BuildQueryRow row) {
            long timeTaken = this.getTimeTaken(row);
            if (timeTaken == Long.MIN_VALUE) {
                return BuildUIQueryMessages.BuildQueryColumn_cell_value_not_applicable;
            }
            if (timeTaken < 0L) {
                timeTaken = 0L;
            }
            return TimeFormatHelper.formatTime(timeTaken);
        }

        public long getComparisonLong(BuildQueryRow row) {
            return this.getTimeTaken(row);
        }

        private long getTimeTaken(BuildQueryRow row) {
            IBuildResult buildResult = row.getBuildResult();
            long referenceTime = row.getReferenceTime().getTime();
            if (buildResult.getState() == BuildState.NOT_STARTED) {
                return Long.MIN_VALUE;
            }
            if (buildResult.getState() == BuildState.COMPLETED) {
                return buildResult.getBuildTimeTaken();
            }
            if (buildResult.getState() == BuildState.IN_PROGRESS) {
                return referenceTime - buildResult.getBuildStartTime();
            }
            if (buildResult.getState() == BuildState.INCOMPLETE) {
                return buildResult.getBuildTimeTaken();
            }
            return Long.MIN_VALUE;
        }
    }
}

