/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.client.iterator.IBuildResultRecordIterator;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.helper.BuildUIPreferencesHelper;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryColumnKind;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildQueryByContributorTeamAreas
extends BuildQuery {
    private IContributor fUser;

    public BuildQueryByContributorTeamAreas(String name, IContributor user, ITeamRepository teamRepository) {
        super(name, null, AdaptableBuildQueryRow.Factory, teamRepository);
        this.fUser = user;
    }

    protected IProjectAreaHandle[] getConnectedProjectAreas() {
        List projectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(this.getTeamRepository());
        return projectAreas.toArray(new IProjectAreaHandle[projectAreas.size()]);
    }

    protected IBuildResultRecordIterator getIterativeQuery(String[] buildResultProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        IBuildDefinitionStatusRecord[] records = this.getRecordClient().getBuildDefinitionStatusRecords(this.fUser, this.getConnectedProjectAreas(), monitor);
        IBuildDefinition[] definitions = null;
        if (records.length == 0) {
            definitions = new IBuildDefinition[]{(IBuildDefinition)IBuildDefinition.ITEM_TYPE.createItem()};
        } else {
            definitions = new IBuildDefinition[records.length];
            int i = 0;
            while (i < records.length) {
                definitions[i] = records[i].getBuildDefinition();
                ++i;
            }
            if (BuildUIPreferencesHelper.getBuildDefinitionPreferences("build.query.view.build.definitions").size() == 0) {
                BuildUIPreferencesHelper.storeBuildDefinitionPreferences(definitions, "build.query.view.build.definitions");
            }
        }
        return this.getRecordClient().getBuildResultRecords((IBuildDefinitionHandle[])definitions, null, buildResultProperties, monitor);
    }

    public BuildQueryColumnKind[] getDefaultSortColumns() {
        return new BuildQueryColumnKind[]{BuildQueryColumnKind.StartTime, BuildQueryColumnKind.StartTime};
    }

    public String getDescription() {
        return BuildUIQueryMessages.BuildQueryByContributorTeamAreas_QUERY_DESCRIPTION;
    }
}

