/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tooltips.support;

import com.ibm.team.jface.tooltip.TooltipSupport;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ColumnAwareTooltipSupport
extends TooltipSupport {
    private Control fControl;

    public ColumnAwareTooltipSupport(Control control, boolean isFocusable, boolean isOpenable) {
        super(control, isFocusable, isOpenable);
        this.fControl = control;
    }

    protected Object getTooltipObjectForColumn(int columnPosition, Object data) {
        return data;
    }

    protected Object mapElement(int x, int y) {
        int columnPosition = -1;
        if (this.fControl instanceof Tree) {
            columnPosition = this.mapColumn((Tree)this.fControl, x);
        } else if (this.fControl instanceof Table) {
            columnPosition = this.mapColumn((Table)this.fControl, x);
        }
        if (columnPosition == -1) {
            return null;
        }
        Object data = null;
        data = this.fControl instanceof Tree ? this.getTreeItemObject((Tree)this.fControl, columnPosition, x, y) : this.getTableItemObject((Table)this.fControl, columnPosition, x, y);
        if (data == null) {
            return null;
        }
        return this.getTooltipObjectForColumn(columnPosition, data);
    }

    protected Object getTreeItemObject(Tree tree, int columnPosition, int x, int y) {
        TreeItem item = this.getTreeItem(tree, x, y);
        if (item == null) {
            return null;
        }
        if (!this.isHoverHotspotReduced()) {
            return item.getData();
        }
        if (item.getImage(columnPosition) != null && this.isMouseOverColumnImage(item, columnPosition, x, y)) {
            return item.getData();
        }
        return null;
    }

    protected boolean isMouseOverColumnImage(TreeItem item, int columnPosition, int x, int y) {
        return item.getImageBounds(columnPosition).contains(x, y);
    }

    protected TreeItem getTreeItem(Tree tree, int x, int y) {
        return tree.getItem(new Point(x, y));
    }

    protected Object getTableItemObject(Table table, int columnPosition, int x, int y) {
        TableItem item = this.getTableItem(table, x, y);
        if (item == null) {
            return null;
        }
        if (!this.isHoverHotspotReduced()) {
            return item.getData();
        }
        if (item.getImage(columnPosition) != null && this.isMouseOverColumnImage(item, columnPosition, x, y)) {
            return item.getData();
        }
        return null;
    }

    protected boolean isMouseOverColumnImage(TableItem item, int columnPosition, int x, int y) {
        return item.getImageBounds(columnPosition).contains(x, y);
    }

    protected TableItem getTableItem(Table table, int x, int y) {
        return table.getItem(new Point(x, y));
    }

    protected int mapColumn(Table table, int x) {
        TableColumn[] columns = table.getColumns();
        int[] currentOrder = table.getColumnOrder();
        int startPos = 0;
        int i = 0;
        while (i < columns.length) {
            if (x < startPos + columns[currentOrder[i]].getWidth()) {
                return currentOrder[i];
            }
            startPos += columns[currentOrder[i]].getWidth();
            ++i;
        }
        return -1;
    }

    protected int mapColumn(Tree tree, int x) {
        TreeColumn[] columns = tree.getColumns();
        int[] currentOrder = tree.getColumnOrder();
        int startPos = 0;
        int i = 0;
        while (i < columns.length) {
            if (x < startPos + columns[currentOrder[i]].getWidth()) {
                return currentOrder[i];
            }
            startPos += columns[currentOrder[i]].getWidth();
            ++i;
        }
        return -1;
    }
}

