/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tooltips.generators;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.common.helper.BuildActivityHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.BuildResultEditorMessages;
import com.ibm.team.build.internal.ui.helper.BuildEngineTextHelper;
import com.ibm.team.build.internal.ui.helper.BuildResultTextHelper;
import com.ibm.team.build.internal.ui.helper.BuildResultTimeHelper;
import com.ibm.team.build.internal.ui.helper.BuildStateTextHelper;
import com.ibm.team.build.internal.ui.helper.ContributorHelper;
import com.ibm.team.build.internal.ui.helper.TimeFormatHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJobHelper;
import com.ibm.team.build.internal.ui.tooltips.generators.AbstractBuildHTMLGenerator;
import com.ibm.team.build.internal.ui.tooltips.generators.TooltipsGeneratorsMessages;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;

public class BuildResultRecordHTMLGenerator
extends AbstractBuildHTMLGenerator {
    private IBuildResultRecord fBuildResultRecord;
    private IBuildResult fBuildResult;

    public BuildResultRecordHTMLGenerator(IBuildResultRecord buildResultRecord) {
        ValidationHelper.validateNotNull((String)"buildResultRecord", (Object)buildResultRecord);
        this.fBuildResultRecord = buildResultRecord;
        this.fBuildResult = this.fBuildResultRecord.getBuildResult();
    }

    protected void createFocusControl(HTMLGenerator.Composite composite, IProgressMonitor monitor) {
        try {
            this.fBuildResult = this.ensureFieldsForFocus(this.fBuildResult, monitor);
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_ERROR_MESSAGE);
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, TeamBuildJobHelper.getStatusMessage(exception));
            return;
        }
        HTMLGenerator.Section section = new HTMLGenerator.Section((HTMLGenerator)this, composite, (HTMLGenerator.Control)new HTMLGenerator.Label((HTMLGenerator)this, BuildResultTextHelper.getLabel(this.fBuildResult)));
        if (this.fBuildResult.getState() == BuildState.NOT_STARTED) {
            this.createPendingRequestSection((HTMLGenerator.Composite)section);
        } else {
            this.createStatusSection((HTMLGenerator.Composite)section, this.fBuildResult, this.fBuildResultRecord);
        }
        new HTMLGenerator.LineBreak((HTMLGenerator)this, (HTMLGenerator.Composite)section);
        this.createGeneralInformationSection(section, monitor);
    }

    protected void createPendingRequestSection(HTMLGenerator.Composite parent) {
        HTMLGenerator.Section section = this.createNonIndentedSection(parent, (HTMLGenerator.Control)new HTMLGenerator.Label((HTMLGenerator)this, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_REQUEST_SECTION_TITLE));
        AbstractBuildHTMLGenerator.CustomTable table = this.createLayoutTable((HTMLGenerator.Composite)section, 2);
        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_BUILD_STATE_INTRO);
        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, BuildStateTextHelper.getText(BuildState.NOT_STARTED));
        IBuildRequest request = this.findStartRequest();
        if (request != null) {
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_REQUEST_TIME_INTRO);
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, TimeFormatHelper.getReadableTimeDif(request.getCreated()));
            this.addRequestorInfo(table);
        }
    }

    protected void addRequestorInfo(AbstractBuildHTMLGenerator.CustomTable table) {
        if (this.fBuildResultRecord.isScheduledBuild()) {
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_REQUESTOR_INTRO);
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, BuildResultTextHelper.getScheduledBuildRequestorText());
        } else {
            IContributor requestor = this.fBuildResultRecord.getRequestor();
            if (requestor != null) {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_REQUESTOR_INTRO);
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, ContributorHelper.getContributorLabelText(requestor));
            }
        }
    }

    private IBuildRequest findStartRequest() {
        IBuildRequest[] allRequests = this.fBuildResultRecord.getBuildRequests();
        int i = 0;
        while (i < allRequests.length) {
            if ("com.ibm.team.build.action.requestBuild".equals(allRequests[i].getBuildAction().getAction())) {
                return allRequests[i];
            }
            ++i;
        }
        return null;
    }

    protected void createHoverControl(HTMLGenerator.Composite composite, IProgressMonitor monitor) {
        String progressPercentString;
        try {
            this.fBuildResult = this.ensureFieldsforHover(this.fBuildResult, monitor);
        }
        catch (TeamRepositoryException exception) {
            BuildUIPlugin.log(exception);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_ERROR_MESSAGE);
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, TeamBuildJobHelper.getStatusMessage(exception));
            return;
        }
        HTMLGenerator.Section section = new HTMLGenerator.Section((HTMLGenerator)this, composite, (HTMLGenerator.Control)new HTMLGenerator.Label((HTMLGenerator)this, BuildResultTextHelper.getLabel(this.fBuildResult)));
        section.setCSSClass("outermost");
        AbstractBuildHTMLGenerator.CustomTable table = new AbstractBuildHTMLGenerator.CustomTable((HTMLGenerator.Composite)section, 2);
        table.setCSSClass("layout");
        table.setFirstRowCSSClass("first");
        table.setBorderCSSClass("borderless");
        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_BUILD_STATUS_INTRO);
        BuildState buildState = this.fBuildResult.getState();
        String headerText = buildState.equals((Object)BuildState.IN_PROGRESS) ? (!(progressPercentString = BuildResultTimeHelper.getProgressPercentString(this.fBuildResult, this.fBuildResultRecord)).equals("") ? NLS.bind((String)TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_IN_PROGRESS_STRING, (Object)progressPercentString) : BuildStateTextHelper.getText(buildState)) : BuildStateTextHelper.getText(buildState);
        HTMLGenerator.Label buildStateLabel = new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, headerText);
        if (buildState.equals((Object)BuildState.IN_PROGRESS)) {
            String lastUpdateTime;
            buildStateLabel.setImage(this.getStatusImageURL(this.fBuildResult));
            String currentActivityLabel = BuildActivityHelper.getCurrentActivityText((Collection)this.fBuildResultRecord.getCurrentBuildActivities());
            if (currentActivityLabel != null && !currentActivityLabel.equals("")) {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_CURRENT_ACTIVITY);
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, currentActivityLabel);
            }
            if ((lastUpdateTime = BuildResultTimeHelper.getLastUpdateTimeString(this.fBuildResultRecord)) != null && !lastUpdateTime.equals("")) {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_LAST_UPDATE);
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, BuildResultTimeHelper.getLastUpdateTimeString(this.fBuildResultRecord));
            }
            this.addRequestorInfo(table);
        } else {
            this.addRequestorInfo(table);
            if (buildState.equals((Object)BuildState.COMPLETED) || buildState.equals((Object)BuildState.INCOMPLETE)) {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_BUILD_ENGINE_INTRO);
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, BuildEngineTextHelper.getBuildEngineText(this.fBuildResultRecord));
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, BuildResultEditorMessages.StatusSection_DURATION);
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, BuildResultTimeHelper.getDurationString(this.fBuildResult));
                if (buildState.equals((Object)BuildState.COMPLETED)) {
                    buildStateLabel.setImage(this.getStatusImageURL(this.fBuildResult));
                }
            }
        }
    }

    private IBuildResult ensureFieldsForFocus(IBuildResult result, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(this.hasBuildTimeInformation(result) && this.hasBuildStateAndStatus(result) && this.hasModifiedTimeIfNeeded(result))) {
            ITeamRepository repository = this.getTeamRepository((IItemHandle)result);
            if (repository == null) {
                throw new TeamRepositoryException(TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_EXCEPTION_MESSAGE);
            }
            result = (IBuildResult)repository.itemManager().fetchCompleteItem((IItemHandle)result, 0, monitor);
        }
        return result;
    }

    private boolean hasModifiedTimeIfNeeded(IBuildResult result) {
        return result.getState() != BuildState.IN_PROGRESS || result.isPropertySet(IItem.MODIFIED_PROPERTY);
    }

    private boolean hasBuildTimeInformation(IBuildResult result) {
        return result.getState() == BuildState.IN_PROGRESS && result.isPropertySet(IBuildResult.PROPERTY_BUILD_START_TIME) || result.isPropertySet(IBuildResult.PROPERTY_BUILD_TIME_TAKEN);
    }

    private IBuildResult ensureFieldsforHover(IBuildResult result, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.hasBuildStateAndStatus(result)) {
            ITeamRepository repository = this.getTeamRepository((IItemHandle)result);
            if (repository == null) {
                throw new TeamRepositoryException(TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_EXCEPTION_MESSAGE);
            }
            result = (IBuildResult)repository.itemManager().fetchCompleteItem((IItemHandle)result, 0, monitor);
        }
        return result;
    }

    private boolean hasBuildStateAndStatus(IBuildResult result) {
        return result.isPropertySet(IBuildResult.PROPERTY_BUILD_STATE) && result.isPropertySet(IBuildResult.PROPERTY_BUILD_STATUS);
    }

    private void createGeneralInformationSection(HTMLGenerator.Section parent, IProgressMonitor monitor) {
        HTMLGenerator.Link link;
        HTMLGenerator.Section generalInfoSection = new HTMLGenerator.Section((HTMLGenerator)this, (HTMLGenerator.Composite)parent, (HTMLGenerator.Control)new HTMLGenerator.Label((HTMLGenerator)this, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_GENERAL_INFORMATION_SECTION_TITLE));
        generalInfoSection.setCSSClass("left");
        AbstractBuildHTMLGenerator.CustomTable table = new AbstractBuildHTMLGenerator.CustomTable((HTMLGenerator.Composite)generalInfoSection, 2);
        table.setCSSClass("nowrap");
        table.setBorderCSSClass("borderless");
        table.setFirstRowCSSClass("first");
        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_BUILD_DEFINITION_INTRO);
        ITeamRepository teamRepository = this.getTeamRepository((IItemHandle)this.fBuildResultRecord.getBuildDefinition());
        if (teamRepository != null) {
            link = this.createItemLink(table, (IItemHandle)this.fBuildResultRecord.getBuildDefinition(), teamRepository, (IProgressMonitor)this.createSubMonitor(monitor, 1));
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)link, this.fBuildResultRecord.getBuildDefinition().getId());
        } else {
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, this.fBuildResultRecord.getBuildDefinition().getId());
        }
        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_BUILD_ENGINE_INTRO);
        teamRepository = this.getTeamRepository((IItemHandle)this.fBuildResultRecord.getBuildEngine());
        if (teamRepository != null) {
            link = this.createItemLink(table, (IItemHandle)this.fBuildResultRecord.getBuildEngine(), teamRepository, (IProgressMonitor)this.createSubMonitor(monitor, 1));
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)link, BuildEngineTextHelper.getBuildEngineText(this.fBuildResultRecord));
        } else {
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, BuildEngineTextHelper.getBuildEngineText(this.fBuildResultRecord));
        }
        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_BUILD_HISTORY_INTRO);
        int count = this.fBuildResultRecord.getBuildCount();
        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, String.valueOf(count));
    }

    protected void createStatusSection(HTMLGenerator.Composite parent, IBuildResult result, IBuildResultRecord record) {
        String progressPercentString;
        BuildState buildState = result.getState();
        String headerText = buildState.equals((Object)BuildState.IN_PROGRESS) ? (!(progressPercentString = BuildResultTimeHelper.getProgressPercentString(result, this.fBuildResultRecord)).equals("") ? NLS.bind((String)TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_IN_PROGRESS_STRING, (Object)progressPercentString) : BuildStateTextHelper.getText(buildState)) : BuildStateTextHelper.getText(buildState);
        HTMLGenerator.Label buildStateLabel = new HTMLGenerator.Label((HTMLGenerator)this, headerText);
        buildStateLabel.setImage(this.getStatusImageURL(result));
        HTMLGenerator.Section statusSection1 = new HTMLGenerator.Section((HTMLGenerator)this, parent, (HTMLGenerator.Control)buildStateLabel);
        statusSection1.setCSSClass(this.getStatusCSSClass(result));
        AbstractBuildHTMLGenerator.CustomTable statusSection = new AbstractBuildHTMLGenerator.CustomTable((HTMLGenerator.Composite)statusSection1, 2);
        statusSection.setCSSClass("results");
        statusSection.setBorderCSSClass("borderless");
        statusSection.setFirstRowCSSClass("first");
        if (buildState.equals((Object)BuildState.IN_PROGRESS)) {
            String estimatedCompletion;
            String currentActivityMessage = BuildActivityHelper.getCurrentActivityText((Collection)record.getCurrentBuildActivities());
            if (!currentActivityMessage.equals("")) {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)statusSection, BuildResultEditorMessages.StatusSection_ACTIVITY_MESSAGE);
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)statusSection, currentActivityMessage);
            }
            if (!(estimatedCompletion = BuildResultTimeHelper.getEstimatedCompletionTimeString(result, this.fBuildResultRecord)).equals("")) {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)statusSection, BuildResultEditorMessages.StatusSection_ESTIMATED_COMPLETION);
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)statusSection, estimatedCompletion);
            }
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)statusSection, BuildResultEditorMessages.StatusSection_LAST_UPDATE);
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)statusSection, BuildResultTimeHelper.getLastUpdateTimeString(record));
        }
        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)statusSection, BuildResultEditorMessages.StatusSection_DURATION);
        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)statusSection, BuildResultTimeHelper.getDurationString(result));
        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)statusSection, BuildResultEditorMessages.StatusSection_STARTED_AT);
        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)statusSection, BuildResultTimeHelper.getStartTimeString(result));
        if (!buildState.equals((Object)BuildState.IN_PROGRESS)) {
            if (result.getState() == BuildState.INCOMPLETE) {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)statusSection, BuildResultEditorMessages.StatusSection_ABANDONED_BY);
                String abandonerName = TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_UNKNOWN_ABANDONER;
                IContributor abandoner = this.fBuildResultRecord.getAbandoner();
                if (abandoner != null) {
                    abandonerName = abandoner.getName();
                }
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)statusSection, NLS.bind((String)TooltipsGeneratorsMessages.BuildResultRecordHTMLGenerator_ABANDONED_AT, (Object)abandonerName, (Object)BuildResultTimeHelper.getCompletedTime(result)));
            } else {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)statusSection, BuildResultEditorMessages.StatusSection_COMPLETED_AT);
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)statusSection, BuildResultTimeHelper.getCompletedTime(result));
            }
        }
        this.addRequestorInfo(statusSection);
    }

    protected String getStatusCSSClass(IBuildResult buildResult) {
        String cssClass = buildResult.getStatus() == BuildStatus.ERROR ? "errorstatus" : (buildResult.getStatus() == BuildStatus.WARNING ? "warningstatus" : "okstatus");
        return cssClass;
    }

    protected String getStatusImageURL(IBuildResult buildResult) {
        ImageDescriptor image = BuildUIPlugin.getImageDescriptor("icons/ovr16/success_ovr.gif");
        JazzResources.registerPath((ImageDescriptor)image, (String)"com.ibm.team.build.ui", (String)"icons/ovr16/success_ovr.gif");
        if (buildResult.getState() == BuildState.INCOMPLETE) {
            image = BuildUIPlugin.getImageDescriptor("icons/obj16/abanblds_obj.gif");
            JazzResources.registerPath((ImageDescriptor)image, (String)"com.ibm.team.build.ui", (String)"icons/obj16/abanblds_obj.gif");
        } else if (buildResult.getStatus() == BuildStatus.ERROR) {
            image = BuildUIPlugin.getImageDescriptor("icons/ovr16/failed_ovr.gif");
            JazzResources.registerPath((ImageDescriptor)image, (String)"com.ibm.team.build.ui", (String)"icons/ovr16/failed_ovr.gif");
        } else if (buildResult.getStatus() == BuildStatus.WARNING) {
            image = BuildUIPlugin.getImageDescriptor("icons/ovr16/warn_ovr.gif");
            JazzResources.registerPath((ImageDescriptor)image, (String)"com.ibm.team.build.ui", (String)"icons/ovr16/warn_ovr.gif");
        }
        return JazzResources.getConformingURL((URL)JazzResources.createURL((ImageDescriptor)image));
    }
}

