/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tooltips.generators;

import com.ibm.icu.text.Collator;
import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.query.IBaseBuildResultQueryModel;
import com.ibm.team.build.internal.client.iterator.BuildResultRecordIterator;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.domain.BuildDomainContentProvider;
import com.ibm.team.build.internal.ui.domain.BuildEngineQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildEnginesNode;
import com.ibm.team.build.internal.ui.helper.BuildResultTimeHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJobHelper;
import com.ibm.team.build.internal.ui.tooltips.generators.AbstractBuildHTMLGenerator;
import com.ibm.team.build.internal.ui.tooltips.generators.DescendingBuildResultRecordComparator;
import com.ibm.team.build.internal.ui.tooltips.generators.TooltipsGeneratorsMessages;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.IString;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildEnginesNodeHTMLGenerator
extends AbstractBuildHTMLGenerator {
    private BuildEnginesNode fNode;

    public BuildEnginesNodeHTMLGenerator(BuildEnginesNode node) {
        ValidationHelper.validateNotNull((String)"node", (Object)node);
        this.fNode = node;
    }

    @Override
    protected void createHoverControl(HTMLGenerator.Composite composite, IProgressMonitor monitor) {
        HTMLGenerator.Section activeEngineSection = this.createTeaser(composite);
        AbstractBuildHTMLGenerator.CustomTable engineTable = this.createLayoutTable((HTMLGenerator.Composite)activeEngineSection, 3);
        try {
            List<BuildEngineQueryNode> nodes = this.getBuildEngineNodes(monitor);
            if (nodes.size() == 0) {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)engineTable, TooltipsGeneratorsMessages.BuildEnginesNodeHTMLGenerator_NO_ACTIVE_BUILD_ENGINES);
                this.createEmptyCell(engineTable);
                this.createEmptyCell(engineTable);
                this.createEmptyCell(engineTable);
            } else {
                for (BuildEngineQueryNode node : nodes) {
                    IBuildEngine buildEngine = node.getBuildEngineStatusRecord().getBuildEngine();
                    if (node.getBuildEngineStatusRecord().isEngineInWarningState()) {
                        HTMLGenerator.Label label = new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)engineTable, "");
                        label.setImage(this.getStatusImageURL(BuildStatus.WARNING));
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)engineTable, node.getBuildEngineStatusRecord().getBuildEngine().getId());
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)engineTable, TooltipsGeneratorsMessages.BuildEnginesNodeHTMLGenerator_WARNING);
                        continue;
                    }
                    this.createEmptyCell(engineTable);
                    new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)engineTable, node.getBuildEngineStatusRecord().getBuildEngine().getId());
                    if (buildEngine.isActive()) {
                        int numInProgressBuilds = node.getBuildEngineStatusRecord().getInProgressBuilds().length;
                        String numberOfBuildsMessage = NLS.bind((String)(numInProgressBuilds > 0 ? TooltipsGeneratorsMessages.BuildEnginesNodeHTMLGenerator_BUSY : TooltipsGeneratorsMessages.BuildEnginesNodeHTMLGenerator_IDLE), (Object)numInProgressBuilds);
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)engineTable, numberOfBuildsMessage);
                        continue;
                    }
                    new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)engineTable, TooltipsGeneratorsMessages.BuildEnginesNodeHTMLGenerator_INACTIVE);
                }
            }
        }
        catch (Exception exception) {
            BuildUIPlugin.log(exception);
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)engineTable, TooltipsGeneratorsMessages.BuildEnginesNodeHTMLGenerator_ERROR_MESSAGE);
            this.createEmptyCell(engineTable);
            this.createEmptyCell(engineTable);
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)engineTable, TeamBuildJobHelper.getStatusMessage(exception));
        }
    }

    @Override
    protected void createFocusControl(HTMLGenerator.Composite parent, IProgressMonitor monitor) {
        HTMLGenerator.Section activeEngineSection = this.createTeaser(parent);
        AbstractBuildHTMLGenerator.CustomTable table = this.createResultsTable((HTMLGenerator.Composite)activeEngineSection, 4);
        table.setBorderCSSClass("padded-right");
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            try {
                List<BuildEngineQueryNode> nodes = this.getBuildEngineNodes((IProgressMonitor)subMonitor.newChild(1));
                if (nodes.size() == 0) {
                    new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, TooltipsGeneratorsMessages.BuildEnginesNodeHTMLGenerator_NO_ACTIVE_BUILD_ENGINES);
                } else {
                    List<IBuildResultRecord> allInProgressBuilds = this.getInProgressBuildResultRecords(nodes, this.getTeamRepository((IItemHandle)nodes.get(0).getBuildEngineStatusRecord().getBuildEngine()), subMonitor.newChild(1));
                    Iterator<BuildEngineQueryNode> nodesIter = nodes.iterator();
                    subMonitor.setWorkRemaining(nodes.size() * 2);
                    while (nodesIter.hasNext()) {
                        BuildEngineQueryNode node = nodesIter.next();
                        IBuildEngine engine = node.getBuildEngineStatusRecord().getBuildEngine();
                        ITeamRepository repository = this.getTeamRepository((IItemHandle)engine);
                        List<IBuildResultRecord> inProgressBuilds = this.getInProgressBuildResultRecords(engine, allInProgressBuilds);
                        if (node.getBuildEngineStatusRecord().isEngineInWarningState()) {
                            HTMLGenerator.Label label = new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, "");
                            label.setImage(this.getStatusImageURL(BuildStatus.WARNING));
                            HTMLGenerator.Link link = this.createItemLink(table, (IItemHandle)engine, repository, (IProgressMonitor)subMonitor.newChild(1));
                            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)link, engine.getId());
                            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, TooltipsGeneratorsMessages.BuildEnginesNodeHTMLGenerator_WARNING_NO_PARENS);
                            this.createBlankCell(table);
                            continue;
                        }
                        this.createBlankCell(table);
                        HTMLGenerator.Link link = this.createItemLink(table, (IItemHandle)engine, repository, (IProgressMonitor)subMonitor.newChild(1));
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)link, engine.getId());
                        String inProgressBuildsString = !engine.isActive() ? TooltipsGeneratorsMessages.BuildEnginesNodeHTMLGenerator_INACTIVE_NO_PARENS : (inProgressBuilds.size() == 0 ? TooltipsGeneratorsMessages.BuildEnginesNodeHTMLGenerator_IDLE_NO_PARENTHESES : (inProgressBuilds.size() == 1 ? TooltipsGeneratorsMessages.BuildEnginesNodeHTMLGenerator_ONE_BUILD : NLS.bind((String)TooltipsGeneratorsMessages.BuildEnginesNodeHTMLGenerator_MULTIPLE_BUILDS, (Object)inProgressBuilds.size())));
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, inProgressBuildsString);
                        if (inProgressBuilds.size() == 0) {
                            this.createBlankCell(table);
                            continue;
                        }
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, BuildResultTimeHelper.getCompletionString(inProgressBuilds.toArray(new IBuildResultRecord[inProgressBuilds.size()])));
                    }
                }
            }
            catch (TeamRepositoryException exception) {
                BuildUIPlugin.log(exception);
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, TooltipsGeneratorsMessages.BuildEnginesNodeHTMLGenerator_ERROR_MESSAGE);
                this.createEmptyCell(table);
                this.createEmptyCell(table);
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, TeamBuildJobHelper.getStatusMessage(exception));
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected List<BuildEngineQueryNode> getBuildEngineNodes(IProgressMonitor monitor) throws TeamRepositoryException {
        List<BuildEngineQueryNode> nodes = BuildDomainContentProvider.getBuildEngineQueryNodes(this.fNode, monitor);
        final Collator collator = Collator.getInstance();
        Collections.sort(nodes, new Comparator<BuildEngineQueryNode>(){

            @Override
            public int compare(BuildEngineQueryNode o1, BuildEngineQueryNode o2) {
                return collator.compare(o1.getBuildEngineStatusRecord().getBuildEngine().getId(), o2.getBuildEngineStatusRecord().getBuildEngine().getId());
            }
        });
        return nodes;
    }

    protected List<IBuildResultRecord> getInProgressBuildResultRecords(List<BuildEngineQueryNode> engineNodes, ITeamRepository repository, SubMonitor monitor) throws TeamRepositoryException {
        monitor.setWorkRemaining(10);
        Object[] parameters = new Object[engineNodes.size() + 1];
        ITeamBuildClient buildClient = ClientFactory.getTeamBuildClient((ITeamRepository)repository);
        IBaseBuildResultQueryModel.IBuildResultQueryModel buildResultQueryModel = IBaseBuildResultQueryModel.IBuildResultQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildResultQueryModel);
        IItemHandleInputArg[] engineArgs = new IItemHandleInputArg[engineNodes.size()];
        int i = 0;
        while (i < engineNodes.size()) {
            engineArgs[i] = query.newItemHandleArg();
            parameters[i] = engineNodes.get(i).getBuildEngineStatusRecord().getBuildEngine();
            ++i;
        }
        IPredicate left = buildResultQueryModel.buildState()._eq((IString)query.newStringArg());
        IPredicate right = buildResultQueryModel.handler()._in(engineArgs);
        query.filter(left._and(right));
        query.orderByAsc((IField)buildResultQueryModel.handler().id());
        parameters[parameters.length - 1] = BuildState.IN_PROGRESS.name();
        IItemQueryPage queryPage = buildClient.queryItems(query, parameters, 512, (IProgressMonitor)monitor.newChild(1));
        BuildResultRecordIterator inProgressBuilds = new BuildResultRecordIterator(repository, queryPage, IBuildResult.PROPERTIES_VIEW_ITEM);
        LinkedList<IBuildResultRecord> inProgressRecords = new LinkedList<IBuildResultRecord>();
        monitor.setWorkRemaining(queryPage.getSize());
        while (inProgressBuilds.hasNext()) {
            IBuildResultRecord[] page = inProgressBuilds.next(512, (IProgressMonitor)monitor.newChild(1));
            int i2 = 0;
            while (i2 < page.length) {
                inProgressRecords.add(page[i2]);
                ++i2;
            }
        }
        return inProgressRecords;
    }

    protected List<IBuildResultRecord> getInProgressBuildResultRecords(IBuildEngine engine, List<IBuildResultRecord> allInProgressBuilds) {
        Iterator<IBuildResultRecord> iter = allInProgressBuilds.iterator();
        LinkedList<IBuildResultRecord> inProgressRecords = new LinkedList<IBuildResultRecord>();
        while (iter.hasNext()) {
            IBuildResultRecord buildResultRecord = iter.next();
            if (!engine.sameItemId((IItemHandle)buildResultRecord.getBuildEngine())) continue;
            inProgressRecords.add(buildResultRecord);
        }
        Collections.sort(inProgressRecords, new DescendingBuildResultRecordComparator());
        return inProgressRecords;
    }

    private HTMLGenerator.Section createTeaser(HTMLGenerator.Composite composite) {
        HTMLGenerator.Section activeEngineSection = new HTMLGenerator.Section((HTMLGenerator)this, composite, (HTMLGenerator.Control)new HTMLGenerator.Label((HTMLGenerator)this, TooltipsGeneratorsMessages.BuildEnginesNodeHTMLGenerator_ACTIVE_ENGINE_SECTION_TITLE));
        return activeEngineSection;
    }
}

