/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tooltips;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryByDefinition;
import com.ibm.team.build.internal.ui.query.BuildQueryByEngine;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.internal.ui.tooltips.AbstractBuildItemHyperlinkHandler;
import com.ibm.team.build.internal.ui.tooltips.TooltipsMessages;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class BuildQueryHyperlinkHandler
extends AbstractBuildItemHyperlinkHandler {
    private static final String QUERY_NAME_PARAMETER = "queryName=";
    private static final String BUILD_DEFINITION_PARAMETER = "buildDefinition=";
    private static final String BUILD_STATE_PARAMETER = "buildState=";
    private static final String REPOSITORY_PARAMETER = "repository=";
    private static final String BUILD_ENGINE_PARAMETER = "buildEngine=";
    private static final String PROJECT_AREA_PARAMETER = "projectArea=";
    private static final String AMPERSAND = "&";
    public static final String BY_DEFINITION_PATH = "/byDefinition";
    public static final String BY_ENGINE_PATH = "/byEngine";
    public static final String SCHEME = "com.ibm.team.build.query";

    public boolean handles(URI uri) {
        return SCHEME.equals(uri.getScheme());
    }

    private String getQueryName(String queryString) {
        String queryName = "";
        int startIndex = queryString.indexOf(QUERY_NAME_PARAMETER);
        int endIndex = queryString.indexOf(AMPERSAND, startIndex);
        if (startIndex > -1 && endIndex > 0 && startIndex + QUERY_NAME_PARAMETER.length() <= queryString.length()) {
            queryName = queryString.substring(startIndex + QUERY_NAME_PARAMETER.length(), endIndex);
        }
        return queryName;
    }

    public IStatus open2(URI uri, ContextProvider provider, IProgressMonitor monitor) {
        String path = uri.getPath();
        String queryString = uri.getQuery();
        ITeamRepository teamRepository = null;
        TeamRepositoryException teamRepositoryException = null;
        try {
            teamRepository = this.getTeamRepository(this.getRepositoryUri(queryString), monitor);
        }
        catch (TeamRepositoryException exception) {
            teamRepositoryException = exception;
        }
        if (teamRepository == null) {
            return new Status(4, BuildUIPlugin.getUniqueIdentifier(), NLS.bind((String)TooltipsMessages.BuildDefinitionQueryHyperlinkHandler_INVALID_REPOSITORY_ERROR_MESSAGE, (Object)uri.toString()), (Throwable)teamRepositoryException);
        }
        final BuildQuery query = this.getBuildQuery(path, queryString, teamRepository);
        if (query == null) {
            return new Status(4, BuildUIPlugin.getUniqueIdentifier(), NLS.bind((String)TooltipsMessages.BuildQueryByBuildDefinitionHyperlinkHandler_INVALID_PATH, (Object)uri.toString()));
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage activePage = window.getActivePage();
                BuildQueryView.displayQuery(query, activePage);
            }
        });
        return Status.OK_STATUS;
    }

    private BuildQuery getBuildQuery(String path, String queryString, ITeamRepository teamRepository) {
        String buildQueryName = this.getQueryName(queryString);
        BuildQuery query = null;
        if (BY_DEFINITION_PATH.equals(path)) {
            IBuildDefinitionHandle definitionHandle = this.getBuildDefinition(queryString);
            query = new BuildQueryByDefinition(buildQueryName, null, new BuildQueryRow.Factory(), definitionHandle, teamRepository);
        }
        if (BY_ENGINE_PATH.equals(path)) {
            IBuildEngineHandle engineHandle = this.getBuildEngine(queryString);
            IProjectAreaHandle projectAreaHandle = this.getProjectAreaHandle(queryString);
            query = new BuildQueryByEngine(buildQueryName, null, new BuildQueryRow.Factory(), engineHandle, projectAreaHandle, teamRepository);
        }
        return query;
    }

    private String getRepositoryUri(String queryString) throws TeamRepositoryException {
        int repositoryParameterIndex = queryString.indexOf(REPOSITORY_PARAMETER);
        if (repositoryParameterIndex > -1 && repositoryParameterIndex + REPOSITORY_PARAMETER.length() < queryString.length()) {
            return queryString.substring(repositoryParameterIndex + REPOSITORY_PARAMETER.length());
        }
        throw new TeamRepositoryException(TooltipsMessages.BuildDefinitionQueryHyperlinkHandler_INVALID_REPOSITORY_ADDRESS);
    }

    private IBuildDefinitionHandle getBuildDefinition(String queryString) {
        int buildDefinitionParameterIndex = queryString.indexOf(BUILD_DEFINITION_PARAMETER);
        int ampersandIndex = queryString.indexOf(AMPERSAND, buildDefinitionParameterIndex);
        String buildDefintionUUIDString = queryString.substring(buildDefinitionParameterIndex + BUILD_DEFINITION_PARAMETER.length(), ampersandIndex);
        UUID buildDefintionUUID = UUID.valueOf((String)buildDefintionUUIDString);
        return (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(buildDefintionUUID, null);
    }

    private IBuildEngineHandle getBuildEngine(String queryString) {
        int buildEngineParameterIndex = queryString.indexOf(BUILD_ENGINE_PARAMETER);
        int ampersandIndex = queryString.indexOf(AMPERSAND, buildEngineParameterIndex);
        String buildEngineUUIDString = queryString.substring(buildEngineParameterIndex + BUILD_ENGINE_PARAMETER.length(), ampersandIndex);
        UUID buildEngineUUID = UUID.valueOf((String)buildEngineUUIDString);
        return (IBuildEngineHandle)IBuildEngine.ITEM_TYPE.createItemHandle(buildEngineUUID, null);
    }

    private IProjectAreaHandle getProjectAreaHandle(String queryString) {
        int projectAreaParameterIndex = queryString.indexOf(PROJECT_AREA_PARAMETER);
        int ampersandIndex = queryString.indexOf(AMPERSAND, projectAreaParameterIndex);
        String projectAreaUUIDString = queryString.substring(projectAreaParameterIndex + PROJECT_AREA_PARAMETER.length(), ampersandIndex);
        UUID projectAreaUUID = UUID.valueOf((String)projectAreaUUIDString);
        return (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(projectAreaUUID, null);
    }

    public URIReference createHyperlink(Object object, IProgressMonitor monitor) {
        if (object instanceof BuildQuery) {
            try {
                BuildQuery query = (BuildQuery)object;
                ITeamRepository repository = query.getTeamRepository();
                if (repository != null) {
                    if (object instanceof BuildQueryByDefinition) {
                        IBuildDefinitionHandle buildDefinitionHandle = ((BuildQueryByDefinition)query).getBuildDefinitionHandles().get(0);
                        URI uri = new URI(SCHEME, null, BY_DEFINITION_PATH, QUERY_NAME_PARAMETER + query.getName() + AMPERSAND + BUILD_STATE_PARAMETER + "ALL" + AMPERSAND + BUILD_DEFINITION_PARAMETER + buildDefinitionHandle.getItemId().getUuidValue() + AMPERSAND + REPOSITORY_PARAMETER + repository.getRepositoryURI(), null);
                        return new URIReference(query.getName(), query.getDescription(), uri);
                    }
                    if (object instanceof BuildQueryByEngine) {
                        IBuildEngineHandle buildEngineHandle = ((BuildQueryByEngine)query).getBuildEngineHandle();
                        IProjectAreaHandle projectAreaHandle = ((BuildQueryByEngine)query).getProjectAreaHandle();
                        URI uri = new URI(SCHEME, null, BY_ENGINE_PATH, QUERY_NAME_PARAMETER + query.getName() + AMPERSAND + BUILD_ENGINE_PARAMETER + buildEngineHandle.getItemId().getUuidValue() + AMPERSAND + PROJECT_AREA_PARAMETER + projectAreaHandle.getItemId().getUuidValue() + AMPERSAND + REPOSITORY_PARAMETER + repository.getRepositoryURI(), null);
                        return new URIReference(query.getName(), query.getDescription(), uri);
                    }
                }
            }
            catch (URISyntaxException exception) {
                BuildUIPlugin.log(exception);
                return null;
            }
        }
        return super.createHyperlink(object, monitor);
    }
}

