/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tooltips;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.ItemNotFoundHelper;
import com.ibm.team.build.internal.ui.tooltips.AbstractBuildItemHyperlinkHandler;
import com.ibm.team.build.internal.ui.tooltips.TooltipsMessages;
import com.ibm.team.build.internal.ui.tooltips.jobs.OpenBuildDefinitionEditorJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class BuildDefinitionHyperlinkHandler
extends AbstractBuildItemHyperlinkHandler {
    public boolean links(Object object) {
        if (object instanceof IBuildDefinitionHandle) {
            return true;
        }
        return super.links(object);
    }

    public Object resolve(URI uri, ContextProvider provider) throws TeamRepositoryException {
        Location location = this.getLocationFor(uri);
        if (location == null) {
            return null;
        }
        IBuildDefinitionHandle buildDefinitionHandle = this.getBuildDefinitionHandle(location);
        if (buildDefinitionHandle == null) {
            return null;
        }
        ITeamRepository teamRepository = this.getTeamRepository(location, null);
        if (teamRepository == null) {
            return null;
        }
        return (IBuildDefinition)teamRepository.itemManager().fetchCompleteItem((IItemHandle)buildDefinitionHandle, 0, null);
    }

    public IStatus open2(URI uri, ContextProvider provider, IProgressMonitor monitor) {
        try {
            IBuildDefinition buildDefinition = this.fetchBuildDefinition(uri, monitor);
            ITeamArea teamArea = this.fetchTeamArea(buildDefinition, monitor);
            new OpenBuildDefinitionEditorJob(buildDefinition, teamArea, (ITeamRepository)buildDefinition.getOrigin(), null).schedule();
            return Status.OK_STATUS;
        }
        catch (ItemNotFoundException exception) {
            ItemNotFoundHelper.handleDeletedBuildItem((IItemHandle)exception.getData(), 4);
            return Status.OK_STATUS;
        }
        catch (TeamRepositoryException exception) {
            return new Status(4, BuildUIPlugin.getUniqueIdentifier(), 4, TooltipsMessages.BuildDefinitionHyperlinkHandler_EXCEPTION_OPENING_DEFINITION, (Throwable)exception);
        }
    }

    protected IBuildDefinition fetchBuildDefinition(URI uri, IProgressMonitor monitor) throws TeamRepositoryException {
        Location location = this.getLocationFor(uri);
        if (location == null) {
            throw new TeamRepositoryException(NLS.bind((String)TooltipsMessages.BuildDefinitionHyperlinkHandler_INVALID_URI, (Object)uri.toString()));
        }
        ITeamRepository repository = this.getTeamRepository(location, null);
        if (repository == null) {
            throw new TeamRepositoryException(NLS.bind((String)TooltipsMessages.BuildDefinitionHyperlinkHandler_NO_REPOSITORY, (Object)uri.toString()));
        }
        IBuildDefinitionHandle buildDefinitionHandle = this.getBuildDefinitionHandle(location);
        if (buildDefinitionHandle == null) {
            throw new TeamRepositoryException(NLS.bind((String)TooltipsMessages.BuildDefinitionHyperlinkHandler_NO_BUILD_DEFINITION, (Object)uri.toString()));
        }
        IBuildDefinition buildDefinition = (IBuildDefinition)repository.itemManager().fetchCompleteItem((IItemHandle)buildDefinitionHandle, 0, monitor);
        return buildDefinition;
    }

    private ITeamArea fetchTeamArea(IBuildDefinition buildDefinition, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = (ITeamRepository)buildDefinition.getOrigin();
        return (ITeamArea)repository.itemManager().fetchCompleteItem((IItemHandle)buildDefinition.getTeamArea(), 0, monitor);
    }

    public boolean handles(URI uri) {
        Location location = this.getLocationForUriNoException(uri);
        if (location == null) {
            return false;
        }
        IBuildDefinitionHandle buildDefinitionHandle = this.getBuildDefinitionHandle(location);
        return buildDefinitionHandle != null;
    }

    protected IBuildDefinitionHandle getBuildDefinitionHandle(Location location) {
        ValidationHelper.validateNotNull((String)"location", (Object)location);
        if (location.getItemHandle() instanceof IBuildDefinitionHandle) {
            return (IBuildDefinitionHandle)location.getItemHandle();
        }
        return null;
    }

    public URIReference createHyperlink(Object object, IProgressMonitor monitor) {
        ITeamRepository teamRepository;
        IBuildDefinitionHandle buildDefinitionHandle;
        URI uri;
        if (object instanceof IBuildDefinitionHandle && (uri = BuildDefinitionHyperlinkHandler.getAbsoluteURI((IItemHandle)(buildDefinitionHandle = (IBuildDefinitionHandle)object), teamRepository = (ITeamRepository)buildDefinitionHandle.getOrigin())) != null) {
            IBuildDefinition buildDefinition;
            try {
                buildDefinition = this.getBuildDefinitionForCreateHyperlink(buildDefinitionHandle, teamRepository);
            }
            catch (TeamRepositoryException exception) {
                BuildUIPlugin.log(exception);
                return null;
            }
            if (buildDefinition != null) {
                String label = buildDefinition.getId();
                String details = NLS.bind((String)TooltipsMessages.BuildDefinitionHyperlinkHandler_LINK_TEXT, (Object)buildDefinition.getId());
                return new URIReference(label, details, uri);
            }
        }
        return super.createHyperlink(object, monitor);
    }

    protected IBuildDefinition getBuildDefinitionForCreateHyperlink(IBuildDefinitionHandle buildDefinitionHandle, ITeamRepository teamRepository) throws TeamRepositoryException {
        IBuildDefinition buildDefinition;
        ValidationHelper.validateNotNull((String)"buildDefinitionHandle", (Object)buildDefinitionHandle);
        if (teamRepository == null) {
            return null;
        }
        if (buildDefinitionHandle instanceof IBuildDefinition && (buildDefinition = (IBuildDefinition)buildDefinitionHandle).isPropertySet(IBuildDefinition.PROPERTY_ID)) {
            return buildDefinition;
        }
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(IBuildDefinition.PROPERTY_ID);
        return (IBuildDefinition)teamRepository.itemManager().fetchPartialItem((IItemHandle)buildDefinitionHandle, 0, properties, null);
    }
}

