/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.teamcentral;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import org.eclipse.ui.IMemento;

public abstract class MementoValue {
    private final String fKey;

    public MementoValue(String key) {
        ValidationHelper.validateNotNull((String)"key", (Object)key);
        this.fKey = key;
    }

    protected String getMementoKey() {
        return this.fKey;
    }

    public abstract void saveState(IMemento var1);

    public abstract void loadState(IMemento var1);

    public static class Bool
    extends MementoValue {
        private final boolean fDefaultValue;
        private boolean fValue;

        public Bool(String key, boolean defaultValue) {
            super(key);
            this.fDefaultValue = defaultValue;
            this.fValue = defaultValue;
        }

        public boolean getValue() {
            return this.fValue;
        }

        public void setValue(boolean value) {
            this.fValue = value;
        }

        public void saveState(IMemento memento) {
            ValidationHelper.validateNotNull((String)"memento", (Object)memento);
            if (this.fValue != this.fDefaultValue) {
                memento.putString(this.getMementoKey(), Boolean.toString(this.fValue));
            }
        }

        public void loadState(IMemento memento) {
            ValidationHelper.validateNotNull((String)"memento", (Object)memento);
            String value = memento.getString(this.getMementoKey());
            this.fValue = value == null ? this.fDefaultValue : "true".equals(value);
        }
    }

    public static class Flag
    extends MementoValue {
        private final boolean fDefaultValue;
        private final String fFlagName;
        private boolean fValue;

        public Flag(String key, String flagName, boolean defaultValue) {
            super(key);
            ValidationHelper.validateNotNull((String)"flagName", (Object)flagName);
            this.fFlagName = flagName;
            this.fDefaultValue = defaultValue;
            this.fValue = defaultValue;
        }

        public boolean getValue() {
            return this.fValue;
        }

        public void setValue(boolean value) {
            this.fValue = value;
        }

        public void saveState(IMemento memento) {
            ValidationHelper.validateNotNull((String)"memento", (Object)memento);
            if (this.fValue != this.fDefaultValue) {
                memento.createChild(this.getMementoKey(), this.fFlagName);
            }
        }

        public void loadState(IMemento memento) {
            ValidationHelper.validateNotNull((String)"memento", (Object)memento);
            IMemento[] children = memento.getChildren(this.getMementoKey());
            if (children == null) {
                this.fValue = this.fDefaultValue;
                return;
            }
            int i = 0;
            while (i < children.length) {
                if (this.fFlagName.equals(children[i].getID())) {
                    this.fValue = !this.fDefaultValue;
                    return;
                }
                ++i;
            }
            this.fValue = this.fDefaultValue;
        }
    }

    public static class Int
    extends MementoValue {
        private final int fDefaultValue;
        private int fValue;

        public Int(String key, int defaultValue) {
            super(key);
            this.fDefaultValue = defaultValue;
            this.fValue = defaultValue;
        }

        public int getValue() {
            return this.fValue;
        }

        public void setValue(int value) {
            this.fValue = value;
        }

        public void saveState(IMemento memento) {
            ValidationHelper.validateNotNull((String)"memento", (Object)memento);
            if (this.fValue != this.fDefaultValue) {
                memento.putInteger(this.getMementoKey(), this.fValue);
            }
        }

        public void loadState(IMemento memento) {
            ValidationHelper.validateNotNull((String)"memento", (Object)memento);
            Integer value = memento.getInteger(this.getMementoKey());
            this.fValue = value == null ? this.fDefaultValue : value;
        }
    }
}

