/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.teamcentral;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.teamcentral.BuildSectionMessages;
import com.ibm.team.build.internal.ui.teamcentral.IFetchStrategy;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchSelectedBuildsStrategy
implements IFetchStrategy {
    private RepositoryToDefinitionsMap fRepositoriesToDefinitions;

    public FetchSelectedBuildsStrategy(List<IBuildDefinitionHandle> builds) throws IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"builds", builds);
        for (IBuildDefinitionHandle helper : builds) {
            if (helper != null) continue;
            throw new IllegalArgumentException(BuildSectionMessages.FetchSelectedBuildsStrategy_NULL_HANDLES);
        }
        this.fRepositoriesToDefinitions = this.getRepositoriesForDefinitions(builds);
    }

    protected RepositoryToDefinitionsMap getRepositoriesForDefinitions(List<IBuildDefinitionHandle> builds) {
        RepositoryToDefinitionsMap map = new RepositoryToDefinitionsMap();
        for (IBuildDefinitionHandle handle : builds) {
            Object originObject = handle.getOrigin();
            if (!(originObject instanceof ITeamRepository)) continue;
            map.put((ITeamRepository)originObject, handle.getItemId());
        }
        return map;
    }

    @Override
    public IBuildDefinitionStatusRecord[] fetchBuildDefinitionStatusRecords(ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        if (repository.loggedIn()) {
            List definitionIds = (List)this.fRepositoriesToDefinitions.get(repository);
            ArrayList<IBuildDefinitionHandle> handles = new ArrayList<IBuildDefinitionHandle>();
            for (UUID uuid : definitionIds) {
                handles.add((IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(uuid, null));
            }
            ITeamBuildRecordClient client = (ITeamBuildRecordClient)repository.getClientLibrary(ITeamBuildRecordClient.class);
            return client.getBuildDefinitionStatusRecords(handles.toArray(new IBuildDefinitionHandle[handles.size()]), monitor);
        }
        return new IBuildDefinitionStatusRecord[0];
    }

    @Override
    public ITeamRepository[] getTeamRepositories() {
        Set keySet = this.fRepositoriesToDefinitions.keySet();
        return keySet.toArray(new ITeamRepository[keySet.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RepositoryToDefinitionsMap
    extends HashMap<ITeamRepository, List<UUID>> {
        private static final long serialVersionUID = 3970617315170379041L;

        RepositoryToDefinitionsMap() {
        }

        @Override
        void put(ITeamRepository repository, UUID definitionUUID) {
            if (this.containsKey(repository)) {
                ((List)this.get(repository)).add(definitionUUID);
            } else {
                ArrayList<UUID> definitions = new ArrayList<UUID>();
                definitions.add(definitionUUID);
                this.put(repository, definitions);
            }
        }
    }
}

