/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tags;

import com.ibm.team.build.internal.ui.tags.TagContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TagsTextContentAdapter
extends TextContentAdapter
implements IContentProposalListener {
    private Text fControl;
    private static final String TAG_STRING_SEPARATOR = ",";
    private static final String SPACE = " ";

    public TagsTextContentAdapter(Text control) {
        this.fControl = control;
    }

    public void proposalAccepted(IContentProposal proposal) {
        if (proposal instanceof TagContentProposal) {
            TagContentProposal prop = (TagContentProposal)proposal;
            String text = this.fControl.getText();
            int cursorPosition = this.fControl.getCaretPosition();
            int currentTagStart = this.getBeginningIndexOfTag(text, cursorPosition);
            int realStart = currentTagStart + ((TagContentProposal)proposal).getBegin();
            int realEnd = currentTagStart + ((TagContentProposal)proposal).getEnd();
            String result = realStart > text.length() ? String.valueOf(text) + prop.getLabel() : String.valueOf(text.substring(0, realStart)) + prop.getLabel() + text.substring(realEnd);
            int pos = result.indexOf(prop.getLabel().toLowerCase()) + prop.getLabel().length() + 1;
            this.fControl.setText(result);
            this.fControl.setSelection(pos, pos);
        }
    }

    public int getCursorPosition(Control control) {
        Text textControl = (Text)control;
        String text = textControl.getText();
        int caretPosition = textControl.getCaretPosition();
        if (caretPosition == 0) {
            return 0;
        }
        int beginningOfTag = this.getBeginningIndexOfTag(text, caretPosition);
        return caretPosition - beginningOfTag;
    }

    public String getControlContents(Control control) {
        Text textControl = (Text)control;
        String text = textControl.getText();
        int caretPosition = textControl.getCaretPosition();
        int beginningOfTag = 0;
        if (caretPosition != 0) {
            beginningOfTag = this.getBeginningIndexOfTag(text, caretPosition);
        }
        int endOfTag = this.getEndIndexOfTag(text, caretPosition);
        return text.substring(beginningOfTag, endOfTag);
    }

    private int getEndIndexOfTag(String text, int cursorPosition) {
        String str = text.substring(cursorPosition);
        int commaIndex = str.indexOf(TAG_STRING_SEPARATOR);
        int spaceIndex = str.indexOf(SPACE);
        if (commaIndex == -1 && spaceIndex == -1) {
            return text.length();
        }
        int firstIndex = Math.min(commaIndex, spaceIndex);
        return firstIndex + cursorPosition + 1;
    }

    private int getBeginningIndexOfTag(String text, int cursorPosition) {
        String str = text.substring(0, cursorPosition);
        int lastCommaIndex = str.lastIndexOf(TAG_STRING_SEPARATOR);
        int lastSpaceIndex = str.lastIndexOf(SPACE);
        int lastIndex = Math.max(lastCommaIndex, lastSpaceIndex);
        return lastIndex + 1;
    }
}

