/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.scm;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.actions.AbstractRepositoryActionDelegate;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.internal.ui.scm.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public abstract class NewTeamEditorOnSnapshotActionDelegate
extends AbstractRepositoryActionDelegate
implements IObjectActionDelegate {
    protected IWorkbenchPart fWorkbenchPart;
    protected IStructuredSelection fSelection;

    protected abstract void openEditor(IBaselineSet var1, ITeamRepository var2, IWorkbenchPage var3);

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }

    protected ITeamRepository getRepositoryToValidate() {
        Object element = this.fSelection.getFirstElement();
        if (element instanceof BuildQueryRow) {
            BuildQueryRow row = (BuildQueryRow)element;
            return row.getTeamRepository();
        }
        return null;
    }

    protected void performAction(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        Object element = this.fSelection.getFirstElement();
        if (element instanceof IBuildResultRecord) {
            SubMonitor subMonitor;
            ITeamRepository teamRepository;
            IBuildResultRecord record = (IBuildResultRecord)element;
            IBuildResult buildResult = record.getBuildResult();
            IBuildResultContribution[] contributions = this.getBuildResultContributions((IBuildResultHandle)buildResult, teamRepository = (ITeamRepository)buildResult.getOrigin(), (IProgressMonitor)(subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)2)).newChild(1));
            if (contributions.length > 0) {
                final IBaselineSet baselineSet = this.getSnapshot((IBaselineSetHandle)contributions[0].getExtendedContribution(), teamRepository, (IProgressMonitor)subMonitor.newChild(1));
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        NewTeamEditorOnSnapshotActionDelegate.this.openEditor(baselineSet, teamRepository, NewTeamEditorOnSnapshotActionDelegate.this.fWorkbenchPart.getSite().getPage());
                    }
                });
            } else {
                subMonitor.worked(1);
                this.showWarningDialog(Messages.AbstractRepositoryActionDelegate_NO_SNAPSHOT_TITLE, this.getNoSnapshotMessage());
            }
        }
    }

    protected abstract String getNoSnapshotMessage();

    protected IBuildResultContribution[] getBuildResultContributions(IBuildResultHandle buildResultHandle, ITeamRepository teamRepository, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ITeamBuildClient buildClient = ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository);
        return buildClient.getBuildResultContributions(buildResultHandle, "buildSnapshot", progressMonitor);
    }

    protected IBaselineSet getSnapshot(IBaselineSetHandle baselineSetHandle, ITeamRepository teamRepository, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (IBaselineSet)teamRepository.itemManager().fetchCompleteItem((IItemHandle)baselineSetHandle, 0, null);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = (IStructuredSelection)selection;
    }

    protected String getConfirmationMessage() {
        return null;
    }

    protected String getJobLabel() {
        return Messages.NewTeamEditorOnSnapshotAction_JOB_LABEL;
    }
}

