/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.scm;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.common.model.query.BaseBuildResultContributionsQueryModel;
import com.ibm.team.build.internal.ui.scm.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.filesystem.ui.changes.ChangesViewUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;

public class ChangeContributionProvider
extends AbstractBuildResultContributionProvider {
    protected IBaselineSet fPreviousBuildSnapshot;
    private IBaselineSet fCurrentBuildSnapshot;
    private IBaselineSetHandle fCurrentBuildSnapshotHandle;

    public ChangeContributionProvider(FormEditor buildEditor, String id, IBuildResultContext context) {
        super(buildEditor, id, context);
    }

    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        this.fPreviousBuildSnapshot = null;
        this.fCurrentBuildSnapshot = null;
        this.fCurrentBuildSnapshotHandle = null;
        this.fetchSnapshots(monitor);
    }

    public BuildStatus getStatus() {
        return BuildStatus.INFO;
    }

    public String getSummaryText() {
        if (this.fCurrentBuildSnapshotHandle == null) {
            return Messages.ChangeContributionProvider_NO_SNAPSHOT;
        }
        if (this.fPreviousBuildSnapshot == null) {
            return Messages.ChangeContributionProvider_NO_SNAPSHOT_PREVIOUS;
        }
        return Messages.ChangeContributionProvider_OPEN_CHANGE_EXPLORER;
    }

    public boolean isSummaryLink() {
        return this.fPreviousBuildSnapshot != null && this.fCurrentBuildSnapshot != null;
    }

    public void summaryLinkActivated() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            ChangesViewUtil.compareSnapshotWithSnapshot((IWorkbenchPage)page, (ITeamRepository)((ITeamRepository)this.fCurrentBuildSnapshot.getOrigin()), (IBaselineSetHandle)this.fCurrentBuildSnapshot, (IBaselineSetHandle)this.fPreviousBuildSnapshot);
        }
    }

    private IBaselineSetHandle getSnapshot(IBuildResultContribution[] contributions, IProgressMonitor monitor) {
        if (contributions.length > 0) {
            return (IBaselineSetHandle)contributions[0].getExtendedContribution();
        }
        return null;
    }

    private void fetchSnapshots(IProgressMonitor monitor) throws TeamRepositoryException {
        IBaselineSetHandle previousBuildSnapshotHandle;
        IBuildResultContext context = this.getBuildResultContext();
        ITeamRepository repository = (ITeamRepository)context.getBuildResult().getOrigin();
        this.fCurrentBuildSnapshotHandle = this.getSnapshot(this.getContributions(), monitor);
        if (this.fCurrentBuildSnapshotHandle != null && (previousBuildSnapshotHandle = this.getPreviousSnapshot(context, monitor)) != null) {
            ArrayList<IBaselineSetHandle> snapshotHandles = new ArrayList<IBaselineSetHandle>();
            snapshotHandles.add(this.fCurrentBuildSnapshotHandle);
            snapshotHandles.add(previousBuildSnapshotHandle);
            List items = repository.itemManager().fetchCompleteItems(snapshotHandles, 0, monitor);
            this.fCurrentBuildSnapshot = (IBaselineSet)items.get(0);
            this.fPreviousBuildSnapshot = (IBaselineSet)items.get(1);
        }
    }

    private IBaselineSetHandle getPreviousSnapshot(IBuildResultContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = (ITeamRepository)context.getBuildResult().getOrigin();
        ITeamBuildClient client = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        BaseBuildResultContributionsQueryModel.BuildResultContributionsQueryModel model = BaseBuildResultContributionsQueryModel.BuildResultContributionsQueryModel.ROOT;
        IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
        query.select((ISelectionElement)model.contributions().extendedContribution().itemId());
        IPredicate isSameDefinition = model.buildResult().buildDefinition()._eq(query.newItemHandleArg());
        IPredicate isNotMe = model.buildResult()._eq(query.newItemHandleArg())._not();
        IPredicate startTimeLessEqual = model.buildResult().buildStartTime()._ltOrEq((INumeric)query.newLongArg());
        IPredicate hasSnapshot = model.contributions().extendedContributionTypeId()._eq("buildSnapshot");
        query.orderByDsc((IField)model.buildResult().buildStartTime());
        IPredicate filter = isSameDefinition._and(startTimeLessEqual)._and(hasSnapshot)._and(isNotMe);
        query.filter(filter);
        query.setResultLimit(1);
        IDataQueryPage queryPage = client.uncommittedQueryData(query, new Object[]{context.getBuildResult().getBuildDefinition(), context.getBuildResult(), context.getBuildResult().getBuildStartTime()}, 1, monitor);
        if (queryPage.getResultSize() > 0) {
            IDataRow row = queryPage.getRow(0);
            UUID snapshotUUID = row.getUUID(0);
            return (IBaselineSetHandle)IBaselineSet.ITEM_TYPE.createItemHandle(snapshotUUID, null);
        }
        return null;
    }

    public AbstractBuildResultPage getBuildResultPage() {
        return null;
    }

    public String[] getExtendedContributionIds() {
        return new String[]{"buildSnapshot"};
    }

    public String getSummaryTitle() {
        return Messages.ChangeContributionProvider_SUMMARY_TITLE;
    }
}

