/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.query;

import com.ibm.team.build.common.model.IBuildAverageData;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.helper.BuildResultTextHelper;
import com.ibm.team.build.internal.ui.helper.ContributorHelper;
import com.ibm.team.build.internal.ui.query.BuildQueryResult;
import com.ibm.team.repository.client.ITeamRepository;
import java.sql.Timestamp;

public class BuildQueryRow {
    protected final BuildQueryResult fBuildQueryResult;
    protected IBuildResultRecord fBuildResultRecord;
    private IBuildEngine fBuildEngine;

    public BuildQueryRow(BuildQueryResult buildQueryResult, IBuildResultRecord buildResultRecord) {
        ValidationHelper.validateNotNull((String)"buildQueryResult", (Object)buildQueryResult);
        ValidationHelper.validateNotNull((String)"buildResultRecord", (Object)buildResultRecord);
        this.fBuildQueryResult = buildQueryResult;
        this.fBuildResultRecord = buildResultRecord;
        this.fBuildEngine = buildResultRecord.getBuildEngine();
        this.fBuildQueryResult.addRow(this);
    }

    public IBuildResultRecord getBuildResultRecord() {
        return this.fBuildResultRecord;
    }

    public void setBuildResultRecord(IBuildResultRecord record) {
        this.fBuildResultRecord = record;
        this.fBuildEngine = this.fBuildResultRecord.getBuildEngine();
    }

    public IBuildResult getBuildResult() {
        return this.fBuildResultRecord.getBuildResult();
    }

    public Timestamp getReferenceTime() {
        return this.fBuildQueryResult.getReferenceTime();
    }

    public ITeamRepository getTeamRepository() {
        return this.fBuildQueryResult.getTeamRepository();
    }

    public IBuildDefinition getBuildDefinition() {
        return this.fBuildResultRecord.getBuildDefinition();
    }

    public IBuildRequest getBuildRequest() {
        IBuildRequest[] requests = this.fBuildResultRecord.getBuildRequests();
        if (requests.length > 0) {
            return requests[0];
        }
        return null;
    }

    public Timestamp getRequestCreatedTime() {
        if (this.getBuildRequest() == null) {
            return null;
        }
        return this.getBuildRequest().getCreated();
    }

    public String getBuildRequestorName() {
        if (this.fBuildResultRecord.getRequestor() == null) {
            return null;
        }
        if (this.fBuildResultRecord.isScheduledBuild()) {
            return BuildResultTextHelper.getScheduledBuildRequestorText();
        }
        return ContributorHelper.getContributorLabelText(this.fBuildResultRecord.getRequestor());
    }

    public IBuildEngine getBuildEngine() {
        return this.fBuildEngine;
    }

    public void setBuildEngine(IBuildEngine buildEngine) {
        this.fBuildEngine = buildEngine;
    }

    public String getBuildEngineId() {
        if (this.getBuildEngine() == null) {
            return null;
        }
        return this.getBuildEngine().getId();
    }

    public String getTags() {
        return this.getBuildResult().getTags();
    }

    public IBuildAverageData getBuildAverageData() {
        return this.fBuildResultRecord.getBuildAverageData();
    }

    public static class Factory {
        public BuildQueryRow createBuildQueryRow(BuildQueryResult buildQueryResult, IBuildResultRecord buildResultRecord) {
            return new BuildQueryRow(buildQueryResult, buildResultRecord);
        }
    }
}

