/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.query;

import com.ibm.team.build.client.iterator.IBuildResultRecordIterator;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryColumnKind;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildQueryByDefinition
extends BuildQuery {
    private List<IBuildDefinitionHandle> fBuildDefinitionHandles = new ArrayList<IBuildDefinitionHandle>();

    public BuildQueryByDefinition(String name, String description, BuildQueryRow.Factory buildQueryRowFactory, IBuildDefinitionHandle buildDefinitionHandle, ITeamRepository teamRepository) {
        super(name, description, buildQueryRowFactory, teamRepository);
        this.fBuildDefinitionHandles.add(buildDefinitionHandle);
    }

    public BuildQueryByDefinition(String name, String description, BuildQueryRow.Factory buildQueryRowFactory, List<IBuildDefinitionHandle> buildDefinitionHandles, ITeamRepository teamRepository) {
        super(name, description, buildQueryRowFactory, teamRepository);
        if (buildDefinitionHandles != null) {
            this.fBuildDefinitionHandles.addAll(buildDefinitionHandles);
        }
    }

    @Override
    protected IBuildResultRecordIterator getIterativeQuery(String[] buildResultProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        IBuildDefinitionHandle[] buildDefinitionHandles = this.fBuildDefinitionHandles.toArray(new IBuildDefinitionHandle[this.fBuildDefinitionHandles.size()]);
        if (buildDefinitionHandles.length == 0) {
            buildDefinitionHandles = new IBuildDefinitionHandle[]{(IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItem()};
        }
        return this.getRecordClient().getBuildResultRecords(buildDefinitionHandles, null, buildResultProperties, monitor);
    }

    @Override
    public BuildQueryColumnKind[] getDefaultSortColumns() {
        return new BuildQueryColumnKind[]{BuildQueryColumnKind.StartTime, BuildQueryColumnKind.StartTime};
    }

    public List<IBuildDefinitionHandle> getBuildDefinitionHandles() {
        return this.fBuildDefinitionHandles;
    }
}

