/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.listeners;

import com.ibm.team.build.internal.client.IBuildDefinitionStatusRecordListener;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Display;

public class BuildDefinitionStatusRecordListener
implements IBuildDefinitionStatusRecordListener {
    protected Map<String, BuildDefinitionQueryNode> fItemIdToNode = new HashMap<String, BuildDefinitionQueryNode>();
    protected StructuredViewer fViewer;

    public BuildDefinitionStatusRecordListener(StructuredViewer viewer, BuildDefinitionQueryNode[] nodes) {
        this.fViewer = viewer;
        BuildDefinitionQueryNode[] buildDefinitionQueryNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            BuildDefinitionQueryNode node = buildDefinitionQueryNodeArray[n2];
            this.fItemIdToNode.put(node.getBuildDefinition().getItemId().getUuidValue(), node);
            ++n2;
        }
    }

    public void recordsReceived(IBuildDefinitionStatusRecord[] records) {
        final HashSet<BuildDefinitionQueryNode> nodesToUpdate = new HashSet<BuildDefinitionQueryNode>();
        IBuildDefinitionStatusRecord[] iBuildDefinitionStatusRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildDefinitionStatusRecord record = iBuildDefinitionStatusRecordArray[n2];
            BuildDefinitionQueryNode node = this.fItemIdToNode.get(record.getBuildDefinition().getItemId().getUuidValue());
            if (node != null) {
                node.setBuildDefinition(record.getBuildDefinition());
                node.setStatus(record.getStatus());
                nodesToUpdate.add(node);
            }
            ++n2;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                BuildDefinitionStatusRecordListener.this.asyncUpdateViewer(nodesToUpdate.toArray());
            }
        });
    }

    protected void asyncUpdateViewer(Object[] nodesToUpdate) {
        if (this.fViewer.getControl() != null && !this.fViewer.getControl().isDisposed()) {
            this.fViewer.update(nodesToUpdate, null);
        }
    }
}

