/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.listeners;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.common.model.dto.DtoFactory;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.common.model.dto.impl.BuildDefinitionStatusRecordImpl;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.domain.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuildDefinitionChangeListener
implements ISharedItemChangeListener {
    private Map<String, Object> fItemIdToNodesMap = new HashMap<String, Object>();

    protected void updateControl(HashSet<IItem> itemsToAdd, HashSet<IItem> itemsToRemove, HashSet<IItem> itemsToUpdate) {
        this.addBuildDefinitions(itemsToAdd);
        this.removeBuildDefinitions(itemsToRemove);
        this.updateBuildDefinitions(itemsToUpdate);
    }

    protected void updateBuildDefinitions(HashSet<IItem> itemsToUpdate) {
        List<IBuildDefinition> buildDefinitions = this.getBuildDefinitions(itemsToUpdate);
        if (!buildDefinitions.isEmpty()) {
            ArrayList<BuildDefinitionQueryNode> nodes = new ArrayList<BuildDefinitionQueryNode>();
            for (IBuildDefinition definition : buildDefinitions) {
                BuildDefinitionQueryNode node = (BuildDefinitionQueryNode)this.getItemIdToNodesMap().get(definition.getItemId().getUuidValue());
                if (node == null) continue;
                node.setBuildDefinition(definition);
                nodes.add(node);
            }
            if (!nodes.isEmpty()) {
                this.getViewer().update(nodes.toArray(), null);
            }
        }
    }

    protected void addBuildDefinitions(HashSet<IItem> itemsToAdd) {
        List<IBuildDefinition> buildDefinitions = this.getBuildDefinitions(itemsToAdd);
        if (!buildDefinitions.isEmpty()) {
            ArrayList<BuildDefinitionQueryNode> nodes = new ArrayList<BuildDefinitionQueryNode>();
            for (IBuildDefinition definition : buildDefinitions) {
                if (this.getItemIdToNodesMap().get(definition.getItemId().getUuidValue()) != null) continue;
                IBuildDefinitionStatusRecord record = this.getBuildDefinitionStatusRecord(definition);
                BuildDefinitionQueryNode node = new BuildDefinitionQueryNode((ITeamRepository)definition.getOrigin(), record);
                nodes.add(node);
                this.getItemIdToNodesMap().put(definition.getItemId().getUuidValue(), node);
            }
            if (!nodes.isEmpty()) {
                this.addNodesToViewer(this.getParent(), nodes.toArray());
            }
        }
    }

    protected void removeBuildDefinitions(HashSet<IItem> itemsToRemove) {
        List<IBuildDefinition> buildDefinitions = this.getBuildDefinitions(itemsToRemove);
        if (!buildDefinitions.isEmpty()) {
            ArrayList<BuildDefinitionQueryNode> nodes = new ArrayList<BuildDefinitionQueryNode>();
            for (IBuildDefinition definition : buildDefinitions) {
                Object node = this.getItemIdToNodesMap().get(definition.getItemId().getUuidValue());
                if (node == null) continue;
                nodes.add((BuildDefinitionQueryNode)node);
            }
            if (!nodes.isEmpty()) {
                this.removeNodesFromViewer(this.getParent(), nodes.toArray());
            }
        }
    }

    protected List<IBuildDefinition> getBuildDefinitions(HashSet<IItem> items) {
        ArrayList<IBuildDefinition> buildDefinitions = new ArrayList<IBuildDefinition>();
        for (IItem object : items) {
            if (!(object instanceof IBuildDefinition)) continue;
            buildDefinitions.add((IBuildDefinition)object);
        }
        return buildDefinitions;
    }

    protected Map<String, Object> getItemIdToNodesMap() {
        return this.fItemIdToNodesMap;
    }

    protected IBuildDefinitionStatusRecord getBuildDefinitionStatusRecord(IBuildDefinition buildDefinition) {
        BuildDefinitionStatusRecordImpl record = (BuildDefinitionStatusRecordImpl)DtoFactory.eINSTANCE.createBuildDefinitionStatusRecord();
        record.setBuildDefinition(buildDefinition);
        return record;
    }

    protected void filterItemsToAdd(HashSet<IItem> itemsToAdd, IProgressMonitor monitor) {
        List<IBuildDefinition> buildDefinitions = this.getBuildDefinitions(itemsToAdd);
        if (!buildDefinitions.isEmpty()) {
            for (IBuildDefinition definition : buildDefinitions) {
                if (this.shouldShowDefinition(definition, monitor)) continue;
                itemsToAdd.remove(definition);
            }
        }
    }

    protected abstract boolean shouldShowDefinition(IBuildDefinition var1, IProgressMonitor var2);

    public void itemsChanged(final List events) {
        Job job = new Job(Messages.BuildDomainItemChangeListener_JOB_LABEL){

            protected IStatus run(IProgressMonitor monitor) {
                AbstractBuildDefinitionChangeListener.this.handleItemsChanged(events, monitor);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void handleItemsChanged(List events, IProgressMonitor monitor) {
        final HashSet<IItem> itemsToAdd = new HashSet<IItem>();
        final HashSet<IItem> itemsToRemove = new HashSet<IItem>();
        final HashSet<IItem> itemsToUpdate = new HashSet<IItem>();
        for (Object object : events) {
            ISharedItemChangeEvent event = (ISharedItemChangeEvent)object;
            IItem sharedItem = event.getSharedItem();
            if (event.getBeforeState() == null) {
                itemsToAdd.add(sharedItem);
                continue;
            }
            if (event.getAfterState() == null) {
                itemsToRemove.add(sharedItem);
                continue;
            }
            itemsToUpdate.add(sharedItem);
        }
        this.filterItemsToAdd(itemsToAdd, monitor);
        if (itemsToAdd.size() + itemsToRemove.size() + itemsToUpdate.size() > 0) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    AbstractBuildDefinitionChangeListener.this.updateControl(itemsToAdd, itemsToRemove, itemsToUpdate);
                }
            });
        }
    }

    protected abstract void removeNodesFromViewer(Object var1, Object[] var2);

    protected abstract void addNodesToViewer(Object var1, Object[] var2);

    public abstract StructuredViewer getViewer();

    protected abstract Object getParent();

    protected abstract IProjectAreaHandle getProjectAreaHandle();
}

