/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.junit;

import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.result.IDeferredBuildTreeNode;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.helper.WorkspaceHelper;
import com.ibm.team.build.internal.ui.junit.Messages;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.junit.launcher.JUnitLaunchShortcut;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class AbstractJUnitLaunchActionDelegate
extends ActionDelegate
implements IEditorActionDelegate {
    private String fTestClassName;
    public static final String LAUNCH_MODE_RUN = "run";
    public static final String LAUNCH_MODE_DEBUG = "debug";

    public abstract String getLaunchMode();

    public abstract JUnitLaunchShortcut getLaunchShortcut();

    public void run(IAction action) {
        try {
            IType type = this.findJavaType(this.fTestClassName);
            if (type != null) {
                JUnitLaunchShortcut shortcut = this.getLaunchShortcut();
                shortcut.launch((ISelection)new StructuredSelection((Object)type), this.getLaunchMode());
            } else {
                this.showErrorDialog(Messages.AbstractJUnitLaunchActionDelegate_ERROR_TITLE, NLS.bind((String)Messages.AbstractJUnitLaunchActionDelegate_TYPE_NOT_FOUND, (Object)this.fTestClassName), null);
            }
        }
        catch (JavaModelException exception) {
            BuildUIPlugin.log(exception);
            this.showErrorDialog(Messages.AbstractJUnitLaunchActionDelegate_ERROR_TITLE, NLS.bind((String)Messages.AbstractJUnitLaunchActionDelegate_ERROR_OPENING_TYPE, (Object)this.fTestClassName), (Exception)((Object)exception));
        }
    }

    protected IType findJavaType(String name) throws JavaModelException {
        return WorkspaceHelper.findJavaType(name);
    }

    protected void showErrorDialog(String title, String message, Exception exception) {
        BuildUIHelper.showErrorDialog(message, title, exception);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fTestClassName = this.getTestClassNameFromSelection(selection);
        if (action != null) {
            if (this.fTestClassName != null && this.fTestClassName.length() > 0) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
        }
    }

    private String getTestClassNameFromSelection(ISelection selection) {
        IStructuredSelection structuredSelection;
        Object element;
        String testClassName = null;
        if (selection instanceof IStructuredSelection && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IDeferredBuildTreeNode) {
            IDeferredBuildTreeNode node = (IDeferredBuildTreeNode)element;
            testClassName = node.getNodeName();
        }
        return testClassName;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }
}

