/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.hyperlink;

import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.helper.BuildUIHelperMessages;
import com.ibm.team.build.internal.ui.helper.WorkspaceHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorSite;

public abstract class AbstractWorkspaceFileHyperlink
implements IHyperlink {
    private final IEditorSite fEditorSite;

    public AbstractWorkspaceFileHyperlink(IEditorSite editorSite) {
        this.fEditorSite = editorSite;
    }

    public void open() {
        IFile file = this.getWorkspaceFile();
        if (file == null) {
            String errorMessage = NLS.bind((String)BuildUIHelperMessages.WorkspaceHelper_FILE_NOT_FOUND_ERROR_MESSAGE, (Object)this.getFileName());
            Exception exception = null;
            BuildUIHelper.showErrorDialog(errorMessage, BuildUIHelperMessages.WorkspaceHelper_FILE_NOT_FOUND_DIALOG_TITLE, exception);
            return;
        }
        WorkspaceHelper.openWorkspaceFile(file, this.getLineNumber(), this.fEditorSite);
    }

    public abstract IFile getWorkspaceFile();

    protected abstract String getFileName();

    public abstract int getLineNumber();
}

